<?php if ( !defined('ABSPATH') ) exit;
/*
  Template Name: User Profile
 */

if ( ! is_user_logged_in() ) {
	$redirect_to = get_permalink( TMM::get_option( 'user_login_page', TMM_APP_CARDEALER_PREFIX ) );
	if ( TMM::get_option( 'user_profile_page', TMM_APP_CARDEALER_PREFIX ) ) {
		$redirect_to .= '?redirect=' . urlencode( get_permalink( TMM::get_option( 'user_profile_page', TMM_APP_CARDEALER_PREFIX ) ) );
	}
	wp_redirect( $redirect_to, 302 );

	return;
}

	$google_maps_api_key = (TMM::get_option("api_key_google")) ? 'key=' . TMM::get_option("api_key_google") : '' ;
	$map_link = 'https://maps.googleapis.com/maps/api/js?' . $google_maps_api_key;
	wp_enqueue_script("tmm_shortcode_google_api_js", $map_link);

	wp_enqueue_script( 'app_carsealer_user_profiles', TMM_Ext_Car_Dealer::get_application_uri() . '/js/user_profile.min.js', array(
		'jquery',
		'jquery-ui-sortable'
	) );

get_header();
$profileuser = wp_get_current_user();
?>

<?php if ( is_user_logged_in() ): ?>

	<form id="user_data" name="user_data" method="post">

	<div class="form-account">

	<div class="form-heading">
		<h3><?php esc_html_e( 'Edit Your Profile', 'cardealer' ); ?></h3>
	</div>
	<!--/ .form-heading-->

	<div class="form-entry">


	<div class="form-title">
		<h5><?php esc_html_e( 'Personal Data', 'cardealer' ); ?></h5>
	</div>
	<!--/ .form-title-->

	<div class="section-options clearfix">

		<div class="row">
			<div class="col-xs-12 col-md-8">

				<div class="row">
					<div class="col-xs-6">

						<!-- First and Last Name -->
						<div class="row">
							<div class="col-xs-6">

								<p>
									<label for="first_name"><strong><?php esc_html_e( 'First Name', 'cardealer' ); ?></strong></label>
									<input id="first_name" name="first_name" type="text" value="<?php echo esc_attr( $profileuser->first_name ) ?>"/>
								</p>

							</div>
							<div class="col-xs-6">

								<p>
									<label for="last_name"><strong><?php esc_html_e( 'Last Name', 'cardealer' ); ?></strong></label>
									<input id="last_name" name="last_name" type="text" value="<?php echo esc_attr( $profileuser->last_name ) ?>"/>
								</p>

							</div>
						</div>

						<div class="row">
							<div class="col-xs-6">

								<!-- Username -->
								<p>
									<label for="user_login"><strong><?php esc_html_e( 'Username', 'cardealer' ); ?> <small>(<?php esc_html_e( 'cant be changed', 'cardealer' ); ?>)</small></strong></label>
									<input id="user_login" disabled="" type="text" value="<?php echo( esc_attr( $profileuser->user_login ) ); ?>"/>
								</p>

							</div>
							<div class="col-xs-6">

								<!-- Nickname or Company Name -->
								<p>
									<label for="nickname"><strong><?php esc_html_e( 'Company Name', 'cardealer' ); ?></strong></label>
									<input id="nickname" name="nickname" type="text" value="<?php echo esc_attr( $profileuser->nickname ) ?>"/>
								</p>

							</div>
						</div>

					</div>
					<div class="col-xs-6">

							<p class="type">
								<label for="password1"><strong><?php esc_html_e( 'New Password', 'cardealer' ); ?> <small><?php esc_html_e( 'Leave blank if you do not want to change it.', 'cardealer' ); ?></small></strong></label>
								<input id="password1" type="password" name="password1"/>
							</p>

							<p class="type">
								<label for="password2"><strong><?php esc_html_e( 'Retype Your New Password', 'cardealer' ); ?></strong></label>
								<input id="password2" type="password" name="password2"/>
							</p>

					</div>
				</div>

				<!-- Company Info -->
				<p>
					<label for="description"><strong><?php esc_html_e( 'Company Info', 'cardealer' ); ?></strong></label>
					<textarea id="description" name="description"><?php echo esc_html( $profileuser->description ) ?></textarea>
					<i class="description"><?php esc_html_e( 'Share a little biographical information to fill out your profile. This may be shown publicly.', 'cardealer' ); ?></i>
				</p>

			</div>
			<div class="col-xs-6 col-md-4">

				<!-- Display Name publicly as
				<p>
					<label for="display_name"><strong><?php esc_html_e( 'Display name publicly as', 'cardealer' ); ?></strong></label>
					<select id="display_name" name="display_name">
						<?php
						$public_display                     = array();
						$public_display['display_nickname'] = $profileuser->nickname;
						$public_display['display_username'] = $profileuser->user_login;

						if ( ! empty( $profileuser->first_name ) ) {
							$public_display['display_firstname'] = $profileuser->first_name;
						}

						if ( ! empty( $profileuser->last_name ) ) {
							$public_display['display_lastname'] = $profileuser->last_name;
						}

						if ( ! empty( $profileuser->first_name ) && ! empty( $profileuser->last_name ) ) {
							$public_display['display_firstlast'] = $profileuser->first_name . ' ' . $profileuser->last_name;
							$public_display['display_lastfirst'] = $profileuser->last_name . ' ' . $profileuser->first_name;
						}

						if ( ! in_array( $profileuser->display_name, $public_display ) ) // Only add this if it isn't duplicated elsewhere
						{
							$public_display = array( 'display_displayname' => $profileuser->display_name ) + $public_display;
						}

						$public_display = array_map( 'trim', $public_display );
						$public_display = array_unique( $public_display );

						foreach ( $public_display as $id => $item ) {
							?>
							<option <?php selected( $profileuser->display_name, $item ); ?>><?php echo esc_html( $item ) ?></option>
						<?php
						}
						?>
					</select>
				</p> -->

				<!-- Edit Logo -->
				<label for="display_name"><strong><?php esc_html_e( 'Edit Company Logo', 'cardealer' ); ?></strong><br><small><?php esc_html_e( 'Recommended dimensions: 300x225', 'cardealer' ); ?></small></label>

				<?php
				TMM_Car_Image::get_cardealer_logo_upload_template();
				?>

			</div>
		</div>

	</div>
	<!--/ .section-options-->

	<div class="form-title">
		<h5><?php esc_html_e( 'Contact Info', 'cardealer' ); ?></h5>
	</div>
	<!--/ .form-title-->

	<div class="section-options clearfix">

		<div class="row">
			<div class="col-xs-6 col-md-4">

				<!-- Contacts -->
				<p>
					<label for="phone"><strong><?php esc_html_e( 'Work Phone', 'cardealer' ); ?></strong></label>
					<input id="phone" name="phone" type="text" value="<?php echo esc_attr( $profileuser->phone ) ?>"/>
				</p>

				<p>
					<label for="mobile"><strong><?php esc_html_e( 'Cell Phone', 'cardealer' ); ?></strong></label>
					<input id="mobile" name="mobile" type="text" value="<?php echo esc_attr( $profileuser->mobile ) ?>"/>
				</p>

				<p>
					<label for="fax"><strong><?php esc_html_e( 'Fax', 'cardealer' ); ?></strong></label>
					<input id="fax" name="fax" type="text" value="<?php echo esc_attr( $profileuser->fax ) ?>"/>
				</p>

				<p>
					<label for="user_email"><strong><?php esc_html_e( 'E-mail', 'cardealer' ); ?></strong></label>
					<input id="user_email" name="user_email" type="text" value="<?php echo esc_attr( $profileuser->user_email ) ?>"/>
				</p>

				<p>
					<label for="skype"><strong><?php esc_html_e( 'Skype', 'cardealer' ); ?></strong></label>
					<input id="skype" name="skype" type="text" value="<?php echo esc_attr( $profileuser->skype ) ?>"/>
				</p>

				<p>
					<label for="user_url"><strong><?php esc_html_e( 'Company Website', 'cardealer' ); ?></strong></label>
					<input id="user_url" name="user_url" type="text" value="<?php echo esc_attr( $profileuser->user_url ) ?>"/>
				</p>

				<p>
					<label for="address"><strong><?php esc_html_e( 'Address', 'cardealer' ); ?></strong></label>
					<input id="address" name="address" type="text" value="<?php echo esc_attr( $profileuser->address ) ?>"/>
				</p>

				<p>
					<label for="address"><strong><?php esc_html_e( 'Working Hours', 'cardealer' ); ?></strong></label>
					<textarea id="working_hours" name="working_hours"><?php echo esc_attr( $profileuser->working_hours ) ?></textarea>
				</p>

			</div>
			<div class="col-xs-12 col-md-8">

		<?php if(TMM::get_option("api_key_google")) { ?>

				<div class="row set_location">

					<?php $map_data = TMM_Cardealer_User::get_user_map_data( $profileuser->data->ID ); ?>

					<div class="col-xs-12 col-md-8">

						<!-- Set Location -->
						<p>
							<label for="location_address"><strong><?php esc_html_e( 'Set Map Location', 'cardealer' ); ?></strong></label>
							<input type="text" placeholder="12 Street, Los Angeles, CA, 94101" value="<?php echo esc_attr( $map_data['location_address'] ) ?>" id="location_address" name="location_address"/>

							<a href="#" id="set_location" class="button orange"><?php esc_html_e( 'Set Location', 'cardealer' ); ?></a>
						</p>

					</div>
					<div class="col-xs-6 col-md-4">

						<!-- Show Map Checkbox -->
						<p class="feature-check no-label">
							<input type="checkbox" id="optionCheckbox"
							       class="js_option_checkbox" <?php echo( (int) @$map_data['show_map_to_visitors'] ? "checked" : "" ) ?>
							       value="<?php echo (int) $map_data['show_map_to_visitors'] ?>" name="show_map_to_visitors"/>
							<label for="optionCheckbox" class="check"><strong><?php esc_html_e( 'Show map to visitors', 'cardealer' ); ?></strong></label>
						</p>

					</div>
				</div>

				<div class="section-options clearfix">

					<!-- Google Map -->
					<div id="google_map" class="google_map" style="width: 100%; height: 326px;"></div>

				</div>
				<!--/ .section-options-->

				<div class="row">
					<div class="col-xs-6 col-md-4">

						<!-- Map Zoom -->
						<p>
							<label for="map_zoom"><strong><?php esc_html_e( 'Zoom', 'cardealer' ); ?></strong></label>
							<select name="map_zoom" id="map_zoom">
								<?php for ( $i = 1; $i <= 30; $i ++ ): ?>
									<option	value="<?php echo esc_attr( $i ) ?>" <?php echo esc_attr( $map_data['map_zoom'] == $i ? 'selected' : '' ) ?>><?php echo esc_attr( $i < 10 ? "0" . $i : $i ) ?></option>
								<?php endfor; ?>
							</select>
						</p>

					</div>
					<div class="col-xs-6 col-md-4">

						<!-- Map Latitude -->
						<p>
							<label for="map_latitude">
								<strong><?php esc_html_e( 'Latitude', 'cardealer' ); ?></strong>
							</label>
							<input type="text" value="<?php echo esc_attr( $map_data['map_latitude'] ) ?>" id="map_latitude" name="map_latitude"/><br/>
						</p>

					</div>
					<div class="col-xs-6 col-md-4">

						<!-- Map Longitude -->
						<p>
							<label for="map_longitude">
								<strong><?php esc_html_e( 'Longitude', 'cardealer' ); ?></strong>
							</label>
							<input type="text" value="<?php echo esc_attr( $map_data['map_longitude'] ) ?>" id="map_longitude" name="map_longitude"/><br/>
						</p>

					</div>
				</div>

		<?php } else { ?>

				<div class="row">
					<div class="col-md-12">

						<label><strong><?php esc_html_e( 'Set Map Location', 'cardealer' ); ?></strong></label>

					<?php
						$link_url = "https://placeholdit.imgix.net/~text?txtsize=40&txt=Please+Enter+a+Valid+Google+API+key+to+display+dealer's+location+on+map&w=712&h=326";
						echo '<img class="aligncenter" src=' . $link_url . '>';
					?>
					</div>
				</div>

		<?php } ?>

			</div>
		</div>

	</div>
	<!--/ .section-options-->

	<div class="form-title">
		<h5><?php esc_html_e( 'Email Notifications', 'cardealer' ); ?></h5>
	</div>
	<!--/ .form-title-->

	<div class="section-options clearfix">

		<div class="row">
			<div class="col-md-12">

				<?php
				$account_emails = tmm_allow_user_email($profileuser->data->ID, 'account_emails');
				$user_posts_emails = tmm_allow_user_email($profileuser->data->ID, 'user_posts_emails');
				?>

				<p class="feature-check no-label">
					<input id="account_emails" name="account_emails" type="checkbox" value="<?php echo esc_attr( $account_emails ) ?>" <?php checked($account_emails, 1) ?> class="js_option_checkbox" />
					<label for="account_emails" class="check"><strong><?php esc_html_e( 'Account changes (upgrading, purchasing featured points)', 'cardealer' ); ?></strong></label>
				</p>

				<p class="feature-check no-label">
					<input id="user_posts_emails" name="user_posts_emails" type="checkbox" value="<?php echo esc_attr( $user_posts_emails ) ?>" <?php checked($user_posts_emails, 1) ?> class="js_option_checkbox" />
					<label for="user_posts_emails" class="check"><strong><?php esc_html_e( 'Creating cars', 'cardealer' ); ?></strong></label>
				</p>

			</div>

		</div>

	</div>
	<!--/ .section-options-->

	<div class="section-options clearfix">

		<div class="clear"></div>

		<p id="update_user_errors" class="error" style="display: none"></p>

		<p id="update_user_success" class="success" style="display: none;">
			<strong><i><?php esc_html_e( 'Your Profile Data was updated successfully', 'cardealer' ); ?></i></strong>
		</p>

		<input type="submit" class="button big orange" id="update_user_profile" value="<?php esc_html_e( 'Update Profile', 'cardealer' ); ?>">

	</div>
	<!--/ .section-options-->

	</div>
	<!--/ .form-entry-->

	</div>
	<!--/ .form-account-->

	</form>

<?php endif; ?>

<?php get_footer(); ?>