<?php if ( !defined('ABSPATH') ) exit;

/*
  Template Name: Add New Car
 */

if (!is_user_logged_in()) {
	$redirect_to = get_permalink(TMM::get_option('user_login_page', TMM_APP_CARDEALER_PREFIX));
	if (TMM::get_option('user_add_new_car', TMM_APP_CARDEALER_PREFIX)) {
		$redirect_to .= '?redirect=' . urlencode(get_permalink(TMM::get_option('user_add_new_car', TMM_APP_CARDEALER_PREFIX)));
	}
	wp_redirect($redirect_to, 302);
	return;
}

wp_enqueue_style('thickbox');
get_header();
wp_enqueue_script('thememakers_car_app_add_new_car_js', TMM_Ext_Car_Dealer::get_application_uri() . '/js/add_new_car.min.js', array('jquery'), false, 1);

global $user_ID;
$user = get_userdata($user_ID);
$photo_set_hash = uniqid();

$options = TMM_Cardealer_User::get_default_user_role_options(get_current_user_id());
$user_post_count = TMM_Cardealer_User::count_users_cars(get_current_user_id());

$required_car_features = TMM::get_option('required_car_features', TMM_APP_CARDEALER_PREFIX);

if (!isset($options['max_cars'])) {
	$options['max_cars'] = 0;
}

if ( ! isset( $required_car_features['car_price_plus'] ) ) {
	$required_car_features['car_price_plus'] = '';
}

$max_desc_count = '';

if(isset($options['max_desc_count']) && $options['max_desc_count']){
	$max_desc_count = $options['max_desc_count'];
}

if(!$max_desc_count){
	$max_desc_count = TMM::get_option('car_adv_desc_signs_count', TMM_APP_CARDEALER_PREFIX);
}

if(!$max_desc_count){
	$max_desc_count = '512';
}

if ($user_post_count >= $options['max_cars'] AND ! user_can(get_current_user_id(), 'manage_options')) :
	?>

	<script>
		var car_adv_desc_signs = '';
	</script>

	<div class="form-account">

		<?php
		if (have_posts()) : while (have_posts()) :
				the_post();
				?>

				<div class="form-heading">
					<h3><?php the_title() ?></h3>
				</div>
				<!--/ .form-heading-->

				<div class="form-entry">

					<?php
					the_content();
					printf( esc_html__('You posted %d cars. To post more you should', 'cardealer'), $user_post_count);
					?>
						<?php $upgrade_status_page = TMM_Helper::get_permalink_by_lang(TMM::get_option('upgrade_status_page', TMM_APP_CARDEALER_PREFIX)); ?>
					<a type="button orange" href="<?php echo esc_url( $upgrade_status_page ) ?>">
						<?php esc_html_e('Upgrade Status', 'cardealer'); ?>
					</a>.
					<br/>
				</div>
				<?php
			endwhile;
		endif;
		?>
	</div>

<?php else: ?>

	<?php if (is_user_logged_in()): ?>

		<?php $user_cars_page = TMM_Helper::get_permalink_by_lang(TMM::get_option('user_cars_page', TMM_APP_CARDEALER_PREFIX)); ?>
		<script>
            var make, model, loc_1, loc_2, loc_3,
                makeSelectorId = '#tax_carproducer',
                modelSelectorId = '#tax_carproducer1',
                loc_1_selectorId = '#tax_carlocation1',
                loc_2_selectorId = '#tax_carlocation2',
                loc_3_selectorId = '#tax_carlocation3',
                user_cars_page = "<?php echo esc_url( $user_cars_page ) ?>",
				car_adv_desc_signs = <?php echo esc_attr( $max_desc_count ) ?>,
				locations_max_level = 3,
                locations = [0, 0, 0];

			jQuery(function() {
                make = jQuery(makeSelectorId);
                model = jQuery(modelSelectorId);
                loc_1 = jQuery(loc_1_selectorId);
                year = jQuery('#car_year');

                if (typeof jQuery.fn.select2 === 'function' && make.is('select') && loc_1.is('select')) {
                    make.select2({
                        width: '100%',
                        placeholder: '<?php esc_html_e('Select Vehicle', 'cardealer')  ?>'
                    });
                    loc_1.select2({
                        width: '100%',
                        placeholder: '<?php esc_html_e('Country', 'cardealer')  ?>'
                    });
                    year.select2({
                        width: '100%',
                        placeholder: '<?php esc_html_e('None', 'cardealer')  ?>'
                    });
                }

                if (locations_max_level >= 2) {
					draw_locations_select(loc_1.val(), 2);
					jQuery(document.body).on('change', loc_1_selectorId, function() {
						draw_locations_select(jQuery(this).val(), 2);
					});
				}

				if (locations_max_level >= 3) {
					jQuery(document.body).on('change', loc_2_selectorId, function() {
						draw_locations_select(jQuery(this).val(), 3);
					});
				}

				draw_models_select(make.val());

				jQuery(document.body).on('change', makeSelectorId, function() {
					draw_models_select(make.val());
				});

				jQuery(document.body).on('change', '#car_state', function() {
					var car_mileage = jQuery('#car_mileage');
					if (jQuery(this).val() === 'car_is_new') {
						car_mileage.val(0).prop('disabled', 'disabled').removeClass('required');
					} else {
						car_mileage.prop('disabled', false);
						if (car_mileage.data('required') === 1) {
							car_mileage.addClass('required');
						}
					}
				});
			});

			function draw_locations_select(parent_id, id) {
				var select_cont = jQuery('#tax_carlocation_container' + id);
				if (parent_id !== '') {
					select_cont.html('<div class="cardealer-spinner"><div></div><div></div><div></div><div></div><div></div></div>');
					var data = {
						action: "app_cardealer_draw_locations_select",
						name: 'car_carlocation[]',
						id: 'tax_carlocation' + id,
						hide_empty: 0,
						parent_id: parent_id,
						selected: locations[id - 1]
					};
                    jQuery.when(
                        jQuery.post(ajaxurl, data, function(responce) {
                            select_cont.html(responce);
                            if (locations_max_level >= 3) {
                                if (id == 2) {
                                    draw_locations_select(jQuery(loc_2_selectorId).val(), 3);
                                }
                            }
                        })
                    ).then(function () {
                        loc_2 = jQuery(loc_2_selectorId);
                        loc_3 = jQuery(loc_3_selectorId);

                        if (typeof jQuery.fn.select2 === 'function' && loc_2.is('select')) {
                            loc_2.select2({
                                width: '100%',
                                placeholder: '<?php esc_html_e('Region', 'cardealer')  ?>'
                            });
                            loc_3.select2({
                                width: '100%',
                                placeholder: '<?php esc_html_e('City', 'cardealer')  ?>'
                            });
                        }
                    });
				} else {
					clear_select(select_cont);
					if (id === 2) {
						clear_select(jQuery('#tax_carlocation_container3'));
					}
				}
			}

			function draw_models_select(parent_id) {
				var select_cont = jQuery('#tax_carproducer_container'),
					req = select_cont.find('select').data('required') == 1 ? 1 : 0;

				if (parent_id !== '') {
					select_cont.html('<div class="cardealer-spinner"><div></div><div></div><div></div><div></div><div></div></div>');
					var data = {
						action: "app_cardealer_draw_tax_select",
						tax: 'carproducer',
						name: 'car_taxonomies[carproducer][]',
						id: 'tax_carproducer1',
						required: req,
						args: {
							hide_empty: 0,
							parent: parent_id
						}
					};

                    jQuery.when(
                        jQuery.post(ajaxurl, data, function (response) {
                            select_cont.html(response);
                        })
                    ).then(function () {
                        model = jQuery(modelSelectorId);

                        if (typeof jQuery.fn.select2 === 'function' && model.is('select')) {
                            model.select2({
                                width: '100%',
                                placeholder: '<?php esc_html_e('Select Model', 'cardealer')  ?>'
                            });
                        }
                    });
				} else {
					clear_select(select_cont);
				}
			}

			function clear_select(select_cont) {
				var select = select_cont.find('select'),
				    default_option = select.find('option:first');
				select.attr('disabled', 'disabled').empty().append(default_option).parent().addClass('disabled');
			}
		</script>

		<form id="thememakers_car_app_add_new_car" action="/" class="search-widget">

			<input type="hidden" name="photo_set_hash" value="<?php echo esc_attr( $photo_set_hash ) ?>"/>

			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

			<div class="form-entry">

				<?php the_content();

				endwhile;
			endif; ?>

				<div class="cart-holder clearfix">

					<ul class="cart-items clearfix">

						<li class="step-now cart-title" id="head_step1">
							<h5 class="cart-title"><?php esc_html_e('Details', 'cardealer'); ?></h5>
							<span class="circle">1</span>
						</li>

						<li class="cart-title" id="head_step2">
							<h5 class="cart-title"><?php esc_html_e('Features', 'cardealer'); ?></h5>
							<span class="circle">2</span>
						</li>

						<li class="cart-title" id="head_step3">
							<h5 class="cart-title"><?php esc_html_e('Photos/Videos', 'cardealer'); ?></h5>
							<span class="circle">3</span>
						</li>

						<li class="cart-title" id="head_step4">
							<h5 class="cart-title"><?php esc_html_e('Confirm', 'cardealer'); ?></h5>
							<span class="circle">4</span>
						</li>

					</ul>
					<!--/ .cart-items-->

					<div class="cart-content step-1 thememakers_car_app_new_car_block" id="thememakers_car_app_new_car_1">

						<div class="row">
							<div class="col-md-4">

								<!-- Make and Model -->
								<p>

									<label for="tax_carproducer"><strong><?php esc_html_e('Make', 'cardealer'); ?></strong></label>

									<?php
									TMM_Helper::draw_tax_terms_select(
										'carproducer', 'car_taxonomies[carproducer][]', 'tax_carproducer', array('hide_empty' => false, 'parent' => 0), array(), $required_car_features['car_taxonomies']
									);
									?>

								</p>

								<p>
									<label for="tax_carproducer2"><strong><?php esc_html_e('Model', 'cardealer'); ?></strong></label>
									<span id="tax_carproducer_container" class="disabled">
                                        <select <?php
                                        if ($required_car_features['car_model'] == '1') {
                                            echo " data-required=1";
                                        }
                                        ?>>
                                            <option  value=""><?php esc_html_e('Select Model', 'cardealer'); ?></option>
                                        </select>
									</span>
								</p>

								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- Condition -->
										<p>
											<label for="car_state">
												<strong><?php esc_html_e('Condition', 'cardealer'); ?></strong>
											</label>
											<select <?php
											if ($required_car_features['car_state'] == '1') {
												echo " data-required=1";
											}
											?> id="car_state" name="car_state">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php
												$condition_list = tmm_get_car_condition_list();

												foreach ($condition_list as $cond_id => $cond_name) {
													echo '<option value="'.$cond_id.'">' . esc_html__( $cond_name, 'cardealer') . '</option>';
												} ?>
											</select>
										</p>

									</div>
									<div class="col-xs-8 col-sm-6">

										<!-- Body -->
										<p>
											<label for="car_body"><strong><?php esc_html_e('Body', 'cardealer'); ?></strong></label>
											<?php $car_bodies = TMM_Ext_PostType_Car::$car_options['body']; ?>

											<select <?php
											if ($required_car_features['car_body'] == '1') {
												echo " data-required=1";
											}
											?> id="car_body" name="car_body">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php foreach ($car_bodies as $body => $body_name): ?>
													<option value="<?php echo esc_attr( $body ) ?>"><?php echo esc_html__( $body_name, 'cardealer' ); ?></option>
												<?php endforeach; ?>
											</select>
										</p>

									</div>
								</div>

								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- Year of First Registration -->
										<p>
											<label for="car_year"><strong><?php esc_html_e('Year', 'cardealer'); ?></strong></label>
											<?php
											$now = (int) date("Y") + 1;
											$years = array();

											for ($i = $now; $i >= 1900; $i--) {
												$years[] = $i;
											}

											if (!isset($car_year)) {
												$car_year = 0;
											}
											?>
											<select <?php
											if ($required_car_features['car_year'] == '1') {
												echo " data-required=1";
											}
											?> id="car_year" name="car_year">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php foreach ($years as $y): ?>
													<option <?php echo($car_year == $y ? "selected" : "") ?>
														value="<?php echo esc_attr( $y ) ?>"><?php echo esc_attr( $y ) ?></option>
												<?php endforeach; ?>
											</select>
										</p>

									</div>
									<div class="col-xs-8 col-sm-6">

										<!-- Mileage -->
										<p>
											<label for="car_mileage"><strong><?php esc_html_e('Mileage', 'cardealer'); ?>
													(<?php echo tmm_get_car_mileage_unit() ?>)</strong></label>
											<input <?php
											if ($required_car_features['car_mileage'] == '1') {
												echo " data-required=1";
											}
											?> id="car_mileage" type="text" name="car_mileage">
										</p>

									</div>
								</div>

							</div>
							<div class="col-md-4">

								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- Price -->
										<p>
											<label for="car_price"><strong><?php esc_html_e('Price', 'cardealer'); ?>
													(<?php echo TMM_Ext_Car_Dealer::$default_currency['symbol'] ?>)</strong></label>
											<input id="car_price" type="text" name="car_price">
										</p>

									</div>
									<div class="col-xs-4 col-sm-6">

										<!-- Price Additional Text -->
										<p>

											<label for="car_price_plus">
												<strong><?php esc_html_e( 'Price Additional Text', 'cardealer' ); ?></strong>
											</label>

											<input <?php if ( $required_car_features['car_price_plus'] == '1' ) {
												echo " data-required=1";
											} ?> id="car_price_plus" type="text" name="car_price_plus" placeholder="<?php esc_html_e('eg: incl. VAT or Negotiable', 'cardealer'); ?>">

										</p>

									</div>
								</div>

								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- Fuel Type -->
										<p>
											<label for="car_fuel_type"><strong><?php esc_html_e('Fuel Type', 'cardealer'); ?></strong></label>
											<?php $car_fuel_types = TMM_Ext_PostType_Car::$car_options['fuel_type']; ?>

											<select <?php
											if ($required_car_features['car_fuel_type'] == '1') {
												echo " data-required=1";
											}
											?>  id="car_fuel_type" name="car_fuel_type">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php foreach ($car_fuel_types as $fuel => $fuel_name): ?>
													<option value="<?php echo esc_attr( $fuel ) ?>"><?php echo esc_html__( $fuel_name, 'cardealer' ); ?></option>
												<?php endforeach; ?>
											</select>
										</p>

									</div>
									<div class="col-xs-4 col-sm-6">

										<!-- Gearbox -->
										<p>
											<label for="car_transmission"><strong><?php esc_html_e('Gearbox', 'cardealer'); ?></strong></label>
											<?php $car_transmissions = TMM_Ext_PostType_Car::$car_options['transmission']; ?>
											<select <?php
											if ($required_car_features['car_transmission'] == '1') {
												echo " data-required=1";
											}
											?> id="car_transmission" name="car_transmission">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php foreach ($car_transmissions as $transmission => $transmission_name): ?>
													<option value="<?php echo esc_attr( $transmission ) ?>"><?php echo esc_html__( $transmission_name, 'cardealer' ); ?></option>
												<?php endforeach; ?>
											</select>
										</p>

									</div>
								</div>

								<!-- Interior Color and Exterior Color -->
								<?php
								$car_int_colors = TMM_Ext_PostType_Car::$car_options['interior_color'];
								$car_ext_colors = TMM_Ext_PostType_Car::$car_options['exterior_color'];
								?>
								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- Interior Color -->
										<p>
											<label
												for="car_interrior_color"><strong><?php esc_html_e('Interior Color', 'cardealer'); ?></strong></label>
											<select <?php
											if ($required_car_features['car_interrior_color'] == '1') {
												echo " data-required=1";
											}
											?> id="car_interrior_color" name="car_interrior_color">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php foreach ($car_int_colors as $color => $color_name): ?>
													<option value="<?php echo esc_attr( $color ) ?>"><?php echo esc_html__( $color_name, 'cardealer' ); ?></option>
												<?php endforeach; ?>
											</select>
										</p>

									</div>
									<div class="col-xs-4 col-sm-6">

										<!-- Exterior Color -->
										<p>
											<label
												for="car_exterior_color"><strong><?php esc_html_e('Exterior Color', 'cardealer'); ?></strong></label>
											<select <?php
											if ($required_car_features['car_exterior_color'] == '1') {
												echo " data-required=1";
											}
											?> id="car_exterior_color" name="car_exterior_color">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php foreach ($car_ext_colors as $color => $color_name): ?>
													<option value="<?php echo esc_attr( $color ) ?>"><?php echo esc_html__( $color_name, 'cardealer' ); ?></option>
												<?php endforeach; ?>
											</select>
										</p>

									</div>
								</div>

								<div class="row">
									<div class="col-xs-8 col-sm-6">



									</div>
									<div class="col-xs-4 col-sm-6">

										<!-- Door Count -->
										<p>
											<label for="car_doors_count"><strong><?php esc_html_e('Door Count', 'cardealer'); ?></strong></label>
											<select <?php
											if ($required_car_features['car_doors_count'] == '1') {
												echo " data-required=1";
											}
											?> id="car_doors_count" name="car_doors_count">
												<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
												<?php for ($i = TMM_Ext_PostType_Car::$car_options['min_doors_count']; $i <= TMM_Ext_PostType_Car::$car_options['max_doors_count']; $i++): ?>
													<option value="<?php echo esc_attr( $i ) ?>"><?php echo esc_attr( $i ) ?></option>
												<?php endfor; ?>
											</select>
										</p>

									</div>
								</div>

							</div>
							<div class="col-md-4">

								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- Engine Size -->
										<p>
											<label for="car_engine_size">
												<strong><?php esc_html_e('Engine Size', 'cardealer'); ?>
													(<?php echo tmm_get_car_engine_unit() ?>)</strong>
											</label>
											<input <?php
											if ($required_car_features['car_engine_size'] == '1') {
												echo " data-required=1";
											}
											?> id="car_engine_size" type="text" name="car_engine_size">
										</p>

									</div>
									<div class="col-xs-4 col-sm-6">

										<!-- Engine Info -->
										<p>
											<label
												for="car_engine_additional"><strong><?php esc_html_e('Engine Info', 'cardealer'); ?></strong></label>
											<input <?php
											if ($required_car_features['car_engine_additional'] == '1') {
												echo " data-required=1";
											}
											?> id="car_engine_additional" type="text" name="car_engine_additional" placeholder="<?php esc_html_e('eg: TDi, TSi, Li ...', 'cardealer'); ?>">
										</p>

									</div>
								</div>

								<div class="row">
									<div class="col-xs-8 col-sm-6">

										<!-- VIN -->
										<p>
											<label for="car_vin"><strong><?php esc_html_e('VIN', 'cardealer'); ?></strong></label>
											<input <?php
											if ($required_car_features['car_vin'] == '1') {
												echo " data-required=1";
											}
											?> id="car_vin" type="text" name="car_vin">
										</p>

									</div>
									<div class="col-xs-4 col-sm-6">

										<!-- # of Owners -->
										<p>
											<label for="car_owner_number"><strong><?php esc_html_e('# of owners', 'cardealer'); ?></strong></label>
											<input <?php
											if ($required_car_features['car_owner_number'] == '1') {
												echo " data-required=1";
											}
											?> id="car_owner_number" type="text" name="car_owner_number">
										</p>

									</div>
								</div>

                                <?php if (!TMM::get_option('locations_hide_location_fields', TMM_APP_CARDEALER_PREFIX)) { ?>
								<!-- Location -->
								<p>

									<label for="tax_carlocation1"><strong><?php esc_html_e('Location', 'cardealer'); ?></strong></label>

									<?php
									TMM_Ext_Car_Dealer::draw_locations_select(array(
										'required' => $required_car_features['car_carlocation'],
										'selected' => 0,
										'id' => 'tax_carlocation1',
										'name' => 'car_carlocation[]',
										'parent_id' => 0
									));
									?>

									<span id="tax_carlocation_container2">
										<select>
											<option value=""><?php esc_html_e('Region', 'cardealer'); ?></option>
										</select>
									</span>

									<span id="tax_carlocation_container3">
										<select>
											<option value=""><?php esc_html_e('City', 'cardealer'); ?></option>
										</select>
									</span>

								</p>
                                <?php } ?>

							</div>
						</div>

						<div class="section-options clearfix">

						<?php if (TMM::get_option( 'allow_custom_title', TMM_APP_CARDEALER_PREFIX ) === '1') { ?>
						<div class="row">
							<div class="col-xs-8 col-sm-6">

								<p>
									<label for="car_title"><strong><?php esc_html_e('Title', 'cardealer'); ?></strong></label>
									<input <?php
									if (isset($required_car_features['car_title']) && $required_car_features['car_title'] == '1') {
										echo " data-required=1";
									}
									?> id="car_title" type="text" name="post_title">
								</p>

							</div>
						</div>
						<?php } ?>

							<!-- Description -->
							<p>
								<label for="car_adv_desc"><strong><?php esc_html_e('Description', 'cardealer'); ?></strong> (<?php esc_html_e("signs left", 'cardealer'); ?> <span id="car_adv_desc_signs_left"><?php echo esc_html( $max_desc_count ); ?></span>)</label>
								<textarea <?php
						if ($required_car_features['car_adv_desc'] == '1') {
							echo " data-required=1";
						}
						?> name="description[desc]" id="car_adv_desc"></textarea>
							</p>

						</div>

						<a href="javascript: app_cardealer_app_add_new_car.next_block(2);void(0);" class="button orange alignright"><?php esc_html_e('Next Step', 'cardealer'); ?></a>

					</div>
					<!--/ .cart-content-->

					<div class="cart-content step-2 thememakers_car_app_new_car_block"
					     id="thememakers_car_app_new_car_2" style="display: none;">

						<?php if ( count( TMM_Ext_PostType_Car::$specifications_array ) == 0 ) { ?>

							<p class="notice">
								<?php echo is_admin() ? esc_html__( 'To add more features please create them with Data Constructor in Cars/Settings/Data Constructor', 'cardealer' ) : esc_html__( 'There is no features.', 'cardealer' ); ?>
							</p>

						<?php } ?>
						<div class="section-options clearfix">

							<?php foreach ( TMM_Ext_PostType_Car::$specifications_array as $specification_key => $block_name ) : ?>

								<div class="option">

									<div class="form-title">
										<h6><?php echo esc_html__( $block_name, 'cardealer' ); ?></h6>
									</div>

									<?php
									$attributes_array = TMM_Ext_PostType_Car::get_attribute_constructors( $specification_key );
									$i = 0;
									$attr_count = count($attributes_array);

									foreach ( $attributes_array as $key => $value ) {
										$i++;
										if ($i === 1 || ($i-1) % 4 === 0) {
											?>

											<div class="row">

											<?php
										}
										?>

												<div class="col-md-3">

												<?php

												if ( $value['type'] == 'checkbox' ) {
													?>

													<p class="feature-check">

														<input id="<?php echo esc_attr( $key ) ?>" type="checkbox" class="js_option_checkbox" value="0" name="tmm_advanced[<?php echo esc_attr( $specification_key ) ?>][<?php echo esc_attr( $key ) ?>]"/>

														<label for="<?php echo esc_attr( $key ) ?>" class="check">

															<strong><?php echo esc_html__( $value['name'], 'cardealer' ); ?></strong>
															<i class="description"> <?php echo esc_html__( $value['description'], 'cardealer' ); ?> </i>

														</label>
													</p>

													<?php
												} elseif ( $value['type'] == 'select' ) {
													?>

													<p>
														<strong><?php echo esc_html__( $value['name'], 'cardealer' ); ?></strong>
														<select id="<?php echo esc_attr( $key ) ?>" name="tmm_advanced[<?php echo esc_attr( $specification_key ) ?>][<?php echo esc_attr( $key ) ?>]">
															<option value="0"><?php esc_html_e( 'None', 'cardealer' ); ?></option>
															<?php foreach ( $value['values'] as $val_key => $val_name ) : ?>
																<option value="<?php echo esc_attr( $val_key ) ?>"><?php echo esc_html__( $val_name, 'cardealer' ); ?></option>
															<?php endforeach; ?>
														</select>

														<i class="description"> <?php echo esc_html__( $value['description'], 'cardealer' ); ?> </i>

													</p>

													<?php
												}

												?>

												</div>

										<?php

										if ($i % 4 === 0 || $i === $attr_count) {
											?>

											</div>

											<?php
										}
									}
									?>

								</div><!--/ .option-->

							<?php endforeach; ?>

						</div>
						<!--/ .section-options-->

						<a href="javascript: app_cardealer_app_add_new_car.next_block(1);void(0);" class="button orange alignleft"><?php esc_html_e( 'Prev Step', 'cardealer' ); ?></a>
						<a href="javascript: app_cardealer_app_add_new_car.next_block(3);void(0);" class="button orange alignright"><?php esc_html_e( 'Next Step', 'cardealer' ); ?></a>

					</div>
					<!--/ .cart-content-->

					<div class="cart-content step-3 thememakers_car_app_new_car_block" id="thememakers_car_app_new_car_3" style="display: none;">

						<div class="section-options clearfix">

							<?php
							$args = array(
								'is_new_car' => 1,
								'photo_set_hash' => $photo_set_hash,
								'car_cover_image' => '',
							);
							TMM_Car_Image::get_car_image_upload_template($args);
							?>

							<?php if(!isset($options['enable_video']) || $options['enable_video']){ ?>

							<div class="ad edit-form">

								<div class="edit-form__title">
									<h3><?php esc_html_e('Vehicle Videos', 'cardealer'); ?></h3>
								</div><!-- .edit-form__title -->

								<div class="edit-form__entry">
									<!-- Videos -->

									<p>
										<a class="button orange" id="add_car_video" href="#"><?php esc_html_e( 'Add video', 'cardealer' ); ?></a>
									</p>

									<ul class="cars-videos" id="cars_videos">

										<li>
											<input type="text" value="" placeholder="<?php echo esc_html( 'https://www.youtube.com, https://vimeo.com' ); ?>" name="cars_videos[]">
											<a href="#" class="remove_car_video button orange icon-trash"><?php esc_html_e( 'Remove', 'cardealer' ); ?></a>
										</li>

									</ul>

								</div>

							</div>

							<?php } ?>

						</div>
						<!--/ .section-options-->

						<a href="javascript: app_cardealer_app_add_new_car.next_block(2);void(0);" class="button orange alignleft"><?php esc_html_e( 'Prev Step', 'cardealer' ); ?></a>
						<a href="javascript: app_cardealer_app_add_new_car.next_block(4);void(0);" class="button orange alignright"><?php esc_html_e( 'Next Step', 'cardealer' ); ?></a>

					</div>
					<!--/ .cart-content-->

					<div class="cart-content step-4 thememakers_car_app_new_car_block" id="thememakers_car_app_new_car_4" style="display: none;">

						<div class="section-options clearfix">

							<p>
								<label><strong><?php esc_html_e( 'Terms and Conditions', 'cardealer' ); ?></strong></label>
								<?php echo esc_html( TMM::get_option( 'licence_text', TMM_APP_CARDEALER_PREFIX ) ) ?>
							</p>

							<p class="feature-check">
								<input type="checkbox" class="itm-checkbox" id="thememakers_car_app_new_car_agreement">
								<label class="check" for="thememakers_car_app_new_car_agreement">
									<strong><?php esc_html_e( 'I agree to the terms and conditions.', 'cardealer' ); ?></strong>
								</label>
							</p>

						</div>
						<!--/ .section-options-->

						<a href="javascript: app_cardealer_app_add_new_car.next_block(3);void(0);" class="button orange alignleft"><?php esc_html_e( 'Prev Step', 'cardealer' ); ?></a>
						<input type="submit" value="<?php esc_html_e( 'Complete Submission', 'cardealer' ); ?>" class="button orange alignright"/>

					</div>
					<!--/ .cart-content-->

				</div>
				<!--/ .cart-holder-->

			</div><!--/ .form-entry-->

		</form>

	<?php endif; ?>
<?php endif; ?>

<?php
get_footer();