<?php if ( !defined('ABSPATH') ) exit;

global $post;
$post_id = $post->ID;
if (isset($_GET['car_id'])) {
	$post_id = $_GET['car_id'];
}

$default_lang_post_id = apply_filters('tmm_wpml_original_postid', $post_id);

$carproducer_term_list = array();
$term_list_object = new GetTheTermList();
$carproducer_term_list_obj = $term_list_object->get_the_term_list($default_lang_post_id, 'carproducer', '/');
if(isset($carproducer_term_list_obj['data'][0]->term_id)){
	$carproducer_term_list[0] = $carproducer_term_list_obj['data'][0]->term_id;
}
if(isset($carproducer_term_list_obj['data'][0]->childs) && !empty($carproducer_term_list_obj['data'][0]->childs)){
	$carproducer_term_list[1] = $carproducer_term_list_obj['data'][0]->childs[0]->term_id;
}

$required_car_features = TMM::get_option('required_car_features', TMM_APP_CARDEALER_PREFIX);
$required_car_features = wp_parse_args( $required_car_features, array(
	'car_adv_desc' => '',
	'car_state' => '1',
	'car_carlocation' => '1',
	'car_taxonomies' => '1',
	'car_model' => '0',
	'car_price' => '1',
	'car_price_plus' => '0',
	'car_year' => '1',
	'car_mileage' => '1',
	'car_vin' => '1',
	'car_engine_size' => '1',
	'car_engine_additional' => '0',
	'car_owner_number' => '0',
	'car_transmission' => '1',
	'car_fuel_type' => '1',
	'car_body' => '1',
	'car_interrior_color' => '1',
	'car_exterior_color' => '1',
	'car_doors_count' => '0',
) );

$save_post = $post;
$post = get_post($post_id);
$description = get_the_excerpt();
$post = $save_post;

$options = TMM_Cardealer_User::get_default_user_role_options(get_current_user_id());
$max_desc_count = '';

if(isset($options['max_desc_count']) && $options['max_desc_count']){
	$max_desc_count = $options['max_desc_count'];
}

if(!$max_desc_count){
	$max_desc_count = TMM::get_option('car_adv_desc_signs_count', TMM_APP_CARDEALER_PREFIX);
}

if(!$max_desc_count){
	$max_desc_count = '512';
}

?>

	<script>

		jQuery(function () {
            var makeSelectorId = '#tax_carproducer',
                modelSelectorId = '#tax_carproducer1',
                loc_1_selectorId = '#tax_carlocation1',
                loc_2_selectorId = '#tax_carlocation2',
                loc_3_selectorId = '#tax_carlocation3',
                make = jQuery(makeSelectorId),
                model = jQuery(modelSelectorId),
                loc_1 = jQuery(loc_1_selectorId),
                loc_2, loc_3,
                year = jQuery('#car_year'),
                car_model = '<?php echo !empty($carproducer_term_list[1]) ? $carproducer_term_list[1] : '' ?>',
                signs_left = jQuery("#car_adv_desc_signs_left"),
				car_desc = jQuery("#car_adv_desc"),
				car_adv_desc_signs = '<?php echo esc_attr( $max_desc_count ) ?>',
				locations_max_level = 3,
				locations = [0, 0, 0];

            <?php
            if ( is_array( $car_carlocation ) ){
                foreach ($car_carlocation as $kk => $value) {
                    if ( !empty( $value ) ){ ?>
                        locations[<?php echo esc_attr( $kk ) ?>] = <?php echo esc_attr( $value ) ?>;
                    <?php
                    }
                }
            }
            ?>

            if (typeof jQuery.fn.select2 === 'function' && make.is('select') && loc_1.is('select')) {
                make.select2({
                    width: '100%',
                    placeholder: '<?php esc_html_e('Select Vehicle', 'cardealer')  ?>'
                });
                loc_1.select2({
                    width: '100%',
                    placeholder: '<?php esc_html_e('Country', 'cardealer')  ?>'
                });
                year.select2({
                    width: '100%',
                    placeholder: '<?php esc_html_e('None', 'cardealer')  ?>'
                });
            }

			if (locations_max_level >= 2) {
				draw_locations_select(loc_1.val(), 2);
				jQuery(document.body).on('change', loc_1_selectorId, function () {
					draw_locations_select(jQuery(this).val(), 2);
				});
			}

			if (locations_max_level >= 3) {
				jQuery(document.body).on('change', loc_2_selectorId, function () {
					draw_locations_select(jQuery(this).val(), 3);
				});
			}

			draw_models_select(make.val());

			jQuery(document.body).on('change', makeSelectorId, function () {
				car_model = '';
				draw_models_select(jQuery(this).val());
			});

			<?php if(!is_admin()){ ?>

			car_adv_desc_signs = parseInt(car_adv_desc_signs);
			signs_left.text(car_adv_desc_signs - car_desc.val().length);

			jQuery(document.body).on('keydown input paste', car_desc, function () {
				var desc = jQuery(this).val(),
					desc_length = desc.length;

				if (desc_length > car_adv_desc_signs) {
					desc = desc.slice(0, car_adv_desc_signs);
					jQuery(this).val(desc);
					signs_left.text(0);
				} else {
					signs_left.text(car_adv_desc_signs - desc_length);
				}
			});

			<?php } ?>

			jQuery(document.body).on('click', '#publish', function () {
				return save_edited_car();
			});

			jQuery(document.body).on('submit', '#save_edited_car', function () {
				return save_edited_car();
			});

			jQuery(document.body).on('change', '#car_state', function(){
				relate_condition_mileage(jQuery(this).val());
			});

			relate_condition_mileage(jQuery('#car_state').val());

			function relate_condition_mileage(condition){
				if(condition === 'car_is_new'){
					jQuery('#car_mileage').val(0).prop('disabled', 'disabled');
				}else{
					jQuery('#car_mileage').prop('disabled', false);
				}
			}

			function save_edited_car() {
				var items = jQuery('[data-required="1"]'),
					is_required = false,
					car_price = jQuery('#car_price'),
					car_price_val = car_price.val(),
					car_mileage = jQuery('#car_mileage'),
					car_mileage_val = car_mileage.val(),
					preview = jQuery('#frame').contents().find('.fileupload_presentation canvas');

				if(car_price_val !== ''){
					car_price_val = parseInt(car_price_val);
					car_price_val = ( isNaN(car_price_val) !== true ) ? car_price_val : '';
					car_price.val(car_price_val);
				}
				if(car_mileage_val !== ''){
					car_mileage_val = parseInt(car_mileage_val);
					car_mileage_val = ( isNaN(car_mileage_val) !== true ) ? car_mileage_val : '';
					car_mileage.val(car_mileage_val);
				}

				items.removeClass('required')
					.each(function (i) {
						var $this = jQuery(this),
							val = $this.val(),
							id = $this.attr('id');
						if (val == 'none' || val == undefined || val === '') {
							is_required = true;
							$this.addClass('required');
						}
					});

				if (preview.length > 0) {
					show_info_popup(tmm_l10n.warn_upload_images);
					return false;
				}

				if (is_required) {
					show_info_popup(tmm_l10n.required_fields);
					return false;
				}
				return true;
			}

			function draw_locations_select(parent_id, id) {
				var select_cont = jQuery('#tax_carlocation_container' + id);
				if (parent_id !== '') {
					select_cont.html('<div class="cardealer-spinner"><div></div><div></div><div></div><div></div><div></div></div>');
					var data = {
						action: "app_cardealer_draw_locations_select",
						name: 'car_carlocation[]',
						id: 'tax_carlocation' + id,
						hide_empty: 0,
						parent_id: parent_id,
						selected: locations[id - 1]
					};
					jQuery.when(
                        jQuery.post(ajaxurl, data, function (responce) {
                            select_cont.html(responce);
                            if (locations_max_level >= 3) {
                                if (id == 2) {
                                    draw_locations_select(jQuery(loc_2_selectorId).val(), 3);
                                }
                            }
                        })
                    ).then(function () {
                        loc_2 = jQuery(loc_2_selectorId);
                        loc_3 = jQuery(loc_3_selectorId);

                        if (typeof jQuery.fn.select2 === 'function' && loc_2.is('select')) {
                            loc_2.select2({
                                width: '100%',
                                placeholder: '<?php esc_html_e('Region', 'cardealer')  ?>'
                            });
                            loc_3.select2({
                                width: '100%',
                                placeholder: '<?php esc_html_e('City', 'cardealer')  ?>'
                            });
                        }
                    });
				} else {
					clear_select(select_cont);
					if (id === 2) {
						clear_select(jQuery('#tax_carlocation_container3'));
					}
				}
			}

			function draw_models_select(parent_id) {
				var select_cont = jQuery('#tax_carproducer_container'),
					req = select_cont.find('select').data('required') == 1 ? 1 : 0;

				if (parent_id !== '') {
					select_cont.html('<div class="cardealer-spinner"><div></div><div></div><div></div><div></div><div></div></div>');
					var data = {
						action: "app_cardealer_draw_tax_select",
						tax: 'carproducer',
						name: 'car_taxonomies[carproducer][]',
						id: 'tax_carproducer1',
						required: req,
						args: {
							hide_empty: 0,
							parent: parent_id
						},
						vals: []
					};

					if (car_model !== '') {
						data.vals.push(car_model);
					}

                    jQuery.when(
                        jQuery.post(ajaxurl, data, function (responce) {
                            select_cont.html(responce);
                        })
                    ).then(function () {
                        model = jQuery(modelSelectorId);

                        if (typeof jQuery.fn.select2 === 'function' && model.is('select')) {
                            model.select2({
                                width: '100%',
                                placeholder: '<?php esc_html_e('Select Model', 'cardealer')  ?>'
                            });
                        }
                    });
				} else {
					clear_select(select_cont);
				}
			}

			function clear_select(select_cont) {
				var select = select_cont.find('select'),
					default_option = select.find('option:first');
				select.attr('disabled', 'disabled').empty().append(default_option).parent().addClass('disabled');
			}

		});
	</script>

	<?php
	global $pagenow;
	if($pagenow === 'post-new.php'){
		?>
		<input type="hidden" value="1" name="tmm_new_post_saving"/>
		<?php
	}

	?>

	<input type="hidden" value="1" name="tmm_meta_saving"/>

	<?php if(!isset($options['enable_video']) || $options['enable_video']){ ?>

	<div class="ad edit-form">

		<div class="edit-form__title">
			<h3><?php esc_html_e('Vehicle Videos', 'cardealer'); ?></h3>
		</div><!-- .edit-form__title -->

		<div class="edit-form__entry">
			<!-- Videos -->
			<div class="row">
				<div class="col-md-3">

					<p>
						<a href="#" id="add_car_video" class="button orange icon-plus-squared"><?php esc_html_e('Add video', 'cardealer'); ?></a>
					</p>

				</div>
				<div class="col-md-9">

					<ul id="cars_videos" class="cars-videos clearfix">

						<?php
						if (empty($cars_videos) || empty($cars_videos[0])) {
							$cars_videos = array(0 => '');
						}
						?>

						<?php foreach ($cars_videos as $key => $value) : ?>

							<li>
								<input type="text" name="cars_videos[]" value="<?php echo esc_attr( $value ) ?>" placeholder="<?php echo esc_html( 'https://www.youtube.com, https://vimeo.com' ); ?>" />
								<a href="#" class="remove_car_video button orange icon-trash"><?php esc_html_e('Remove', 'cardealer'); ?></a>
							</li>

						<?php endforeach; ?>

					</ul>

				</div>
			</div>
		</div><!-- .edit-form__entry -->

	</div><!-- .edit-form -->

	<?php } ?>


	<div class="ad edit-form">
		<div class="edit-form__title">
			<h3><?php esc_html_e('Vehicle Make, Model, Technical Data, Location and Description', 'cardealer'); ?></h3>
		</div><!-- .edit-form__title -->

		<div class="edit-form__entry">

			<div class="row">
				<div class="col-md-4">

					<!-- Make and Model -->
					<p>

						<label for="car_carproducer">
							<strong><?php esc_html_e( 'Make', 'cardealer' ); ?></strong>
						</label>

						<?php
						TMM_Helper::draw_tax_terms_select(
							'carproducer',
							'car_taxonomies[carproducer][]',
							'tax_carproducer',
							array( 'hide_empty' => false, 'parent' => 0 ),
							$carproducer_term_list,
							$required_car_features['car_taxonomies']
						);
						?>
					</p>

					<p>
						<label for="tax_carproducer1">
							<strong><?php esc_html_e( 'Model', 'cardealer' ); ?></strong>
						</label>

						<span id="tax_carproducer_container">
							<select<?php
							if ($required_car_features['car_model'] == '1') {
								echo " data-required=1";
							}
							?> disabled>
								<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
							</select>
						</span>

					</p>

					<div class="row">
						<div class="col-md-6">

							<!-- Condition -->
							<p>
								<label for="car_state"><strong><?php esc_html_e( 'Condition', 'cardealer' ); ?></strong></label>
								<select <?php if ( $required_car_features['car_state'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_state" name="car_state">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php
									$condition_list = tmm_get_car_condition_list();
									$condition = tmm_get_car_condition($post_id, '', true);

									foreach ($condition_list as $cond_id => $cond_name) {
										echo '<option value="'.$cond_id.'"' . selected($condition, $cond_id, false) . '>' . esc_html__( $cond_name, 'cardealer') . '</option>';
									} ?>
								</select>
							</p>

						</div>
						<div class="col-md-6">

							<!-- Body -->
							<p>

								<label for="car_body">
									<strong><?php esc_html_e( 'Body', 'cardealer' ); ?></strong>
								</label>

								<?php $car_bodies = TMM_Ext_PostType_Car::$car_options['body']; ?>
								<select <?php if ( $required_car_features['car_body'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_body" name="car_body">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php foreach ( $car_bodies as $body => $body_name ): ?>
										<option <?php selected($car_body, $body); ?>
											value="<?php echo esc_attr( $body ) ?>"><?php echo esc_html__( $body_name, 'cardealer' ); ?></option>
									<?php endforeach; ?>
								</select>

							</p>

						</div>
					</div>

					<div class="row">
						<div class="col-md-6">

							<!-- Year of Registration -->
							<p>

								<label for="car_year">
									<strong><?php esc_html_e( 'Year', 'cardealer' ); ?></strong>
								</label>

								<?php
								$now   = (int) date( "Y" ) + 1;
								$years = array();
								for ( $i = $now; $i >= 1900; $i -- ) {
									$years[] = $i;
								}
								?>

								<select <?php if ( $required_car_features['car_year'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_year" name="car_year">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php foreach ( $years as $y ): ?>
										<option <?php echo( $car_year == $y ? "selected" : "" ) ?>
											value="<?php echo esc_attr( $y ) ?>"><?php echo esc_attr( $y ) ?></option>
									<?php endforeach; ?>
								</select>

							</p>

						</div>
						<div class="col-md-6">

							<!-- Mileage -->
							<p>

								<label for="car_mileage">
									<strong><?php esc_html_e( 'Mileage', 'cardealer' ); ?> (<?php echo tmm_get_car_mileage_unit() ?>)</strong>
								</label>

								<input <?php if ( $required_car_features['car_mileage'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_mileage" type="text" value="<?php echo esc_attr( $car_mileage ) ?>" name="car_mileage">

							</p>

						</div>
					</div>

				</div>
				<div class="col-md-4">

					<div class="row">
						<div class="col-md-6">

							<!-- Price -->
							<p title="<?php esc_html_e('A value of zero will be displayed as Negotiable', 'cardealer') ?>">

								<label for="car_price">
									<strong><?php esc_html_e( 'Price', 'cardealer' ); ?> <?php echo TMM_Ext_Car_Dealer::$default_currency['symbol'] ?></strong>
								</label>

								<input id="car_price" type="text" value="<?php echo esc_attr( $car_price ) ?>" name="car_price">

							</p>

							<!-- Fuel Type -->
							<p>

								<label for="car_fuel_type">
									<strong><?php esc_html_e( 'Fuel Type', 'cardealer' ); ?></strong>
								</label>

								<?php $car_fuel_types = TMM_Ext_PostType_Car::$car_options['fuel_type']; ?>
								<select <?php if ( $required_car_features['car_fuel_type'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_fuel_type" name="car_fuel_type">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php foreach ( $car_fuel_types as $fuel => $fuel_name ): ?>
										<option <?php echo( $car_fuel_type == $fuel ? "selected" : "" ) ?>
											value="<?php echo esc_attr( $fuel ) ?>"><?php echo esc_html__( $fuel_name, 'cardealer' ); ?></option>
									<?php endforeach; ?>
								</select>

							</p>

							<!-- Interior Color -->
							<p>

								<label for="car_interrior_color">
									<strong><?php esc_html_e( 'Interior Color', 'cardealer' ); ?></strong>
								</label>

								<?php
								$car_int_colors = TMM_Ext_PostType_Car::$car_options['interior_color'];
								?>
								<select <?php if ( $required_car_features['car_interrior_color'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_interrior_color" name="car_interrior_color">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php foreach ( $car_int_colors as $color => $color_name ): ?>
										<option <?php selected($color, $car_interior_color); ?>
											value="<?php echo esc_attr( $color ) ?>"><?php echo esc_html__( $color_name, 'cardealer' ); ?></option>
									<?php endforeach; ?>
								</select>

							</p>

							<!-- Door Count -->
							<p>

								<label for="car_doors_count">
									<strong><?php esc_html_e( 'Door Count', 'cardealer' ); ?></strong>
								</label>

								<select <?php if ( $required_car_features['car_doors_count'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_doors_count" name="car_doors_count">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php for ( $i = TMM_Ext_PostType_Car::$car_options['min_doors_count']; $i <= TMM_Ext_PostType_Car::$car_options['max_doors_count']; $i ++ ): ?>
										<option <?php echo( $i == $car_doors_count ? "selected" : "" ) ?>
											value="<?php echo esc_attr( $i ) ?>"><?php echo esc_attr( $i ) ?></option>
									<?php endfor; ?>
								</select>

							</p>

						</div>
						<div class="col-md-6">

							<!-- Price Additional Text -->
							<p>

								<label for="car_price_plus">
									<strong><?php esc_html_e( 'Price Additional Text', 'cardealer' ); ?></strong>
								</label>

								<input <?php if ( $required_car_features['car_price_plus'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_price_plus" type="text" name="car_price_plus" placeholder="<?php esc_html_e('eg: incl. VAT or Negotiable', 'cardealer'); ?>" value="<?php echo esc_attr( $car_price_plus ) ?>"/>

							</p>

							<!-- Gearbox -->
							<p>

								<label for="car_transmission">
									<strong><?php esc_html_e( 'Gearbox', 'cardealer' ); ?></strong>
								</label>

								<?php $car_transmissions = TMM_Ext_PostType_Car::$car_options['transmission']; ?>

								<select <?php if ( $required_car_features['car_transmission'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_transmission" name="car_transmission">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php foreach ( $car_transmissions as $transmission => $transmission_name ): ?>
										<option <?php selected($car_transmission, $transmission); ?>
											value="<?php echo esc_attr( $transmission ) ?>"><?php echo esc_html__( $transmission_name, 'cardealer' ); ?></option>
									<?php endforeach; ?>
								</select>

							</p>

							<!-- Exterior Color -->
							<p>

								<label for="car_exterior_color">
									<strong><?php esc_html_e( 'Exterior Color', 'cardealer' ); ?></strong>
								</label>

								<?php
								$car_ext_colors = TMM_Ext_PostType_Car::$car_options['exterior_color'];
								?>
								<select <?php if ( $required_car_features['car_exterior_color'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_exterior_color" name="car_exterior_color">
									<option value=""><?php esc_html_e( 'None', 'cardealer' ); ?></option>
									<?php foreach ( $car_ext_colors as $color => $color_name ): ?>
										<option <?php selected( $color, $car_exterior_color); ?>
											value="<?php echo esc_attr( $color ) ?>"><?php echo esc_html__( $color_name, 'cardealer' ); ?></option>
									<?php endforeach; ?>
								</select>

							</p>

						</div>
					</div>

				</div>
				<div class="col-md-4">

					<div class="row">
						<div class="col-md-6">

							<!-- Engine Size -->
							<p>

								<label for="car_engine_size">
									<strong><?php esc_html_e( 'Engine Size', 'cardealer' ); ?> (<?php echo tmm_get_car_engine_unit() ?>)</strong>
								</label>

								<input <?php if ( $required_car_features['car_engine_size'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_engine_size" type="text" value="<?php echo ! empty( $car_engine_size ) ? $car_engine_size : ''; ?>" name="car_engine_size">

							</p>

							<!-- VIN -->
							<p>

								<label for="car_vin">
									<strong><?php esc_html_e( 'VIN', 'cardealer' ); ?></strong>
								</label>

								<input <?php if ( $required_car_features['car_vin'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_vin" type="text" name="car_vin" value="<?php echo esc_attr( $car_vin ) ?>"/>

							</p>

						</div>
						<div class="col-md-6">

							<!-- Engine Info -->
							<p>

								<label for="car_engine_additional">
									<strong><?php esc_html_e( 'Engine Info', 'cardealer' ); ?></strong>
								</label>

								<input <?php if ( $required_car_features['car_engine_additional'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_engine_additional" type="text" value="<?php echo esc_attr( $car_engine_additional ) ?>" name="car_engine_additional" placeholder="<?php esc_html_e('eg: TDi, TSi, Li ...', 'cardealer'); ?>">

							</p>

							<!-- Number of owners -->
							<p>

								<label for="car_owner_number">
									<strong><?php esc_html_e( '# of owners', 'cardealer' ); ?></strong>
								</label>

								<input <?php if ( $required_car_features['car_owner_number'] == '1' ) {
									echo " data-required=1";
								} ?> id="car_owner_number" type="text" value="<?php echo ! empty( $car_owner_number ) ? $car_owner_number : ''; ?>" name="car_owner_number">

							</p>

						</div>
					</div>

                    <?php if (!TMM::get_option('locations_hide_location_fields', TMM_APP_CARDEALER_PREFIX)) { ?>
					<!-- Location -->
					<p>

						<label for="car_location">
							<strong><?php esc_html_e( 'Location', 'cardealer' ); ?></strong>
						</label>

						<?php
						TMM_Ext_Car_Dealer::draw_locations_select( array(
							'required'  => $required_car_features['car_carlocation'],
							'selected'  => isset( $car_carlocation[0] ) ? $car_carlocation[0] : '',
							'id'        => 'tax_carlocation1',
							'name'      => 'car_carlocation[]',
							'parent_id' => 0
						) );
						?>

						<span id="tax_carlocation_container2">
							<select>
								<option value=""><?php esc_html_e( 'Region', 'cardealer' ); ?></option>
							</select>
						</span>
						<span id="tax_carlocation_container3">
							<select>
								<option value=""><?php esc_html_e( 'City', 'cardealer' ); ?></option>
							</select>
						</span>

					</p>
                    <?php } ?>

				</div>
			</div>

			<!-- Car Make, Model and Technical Data -->
			<?php if (!is_admin()) { ?>

				<?php if (TMM::get_option( 'allow_custom_title', TMM_APP_CARDEALER_PREFIX ) === '1') { ?>
					<div class="row">
						<div class="col-xs-8 col-sm-6">

							<p>
								<label for="car_title"><strong><?php esc_html_e('Car Title', 'cardealer'); ?></strong></label>
								<input <?php
								if (isset($required_car_features['car_title']) && $required_car_features['car_title'] == '1') {
									echo " data-required=1";
								}
								?> id="car_title" type="text" name="post_title" value="<?php echo wp_kses_post( get_the_title($post_id) ) ?>">
							</p>

						</div>
					</div>
				<?php } ?>

				<p>
					<label for="car_adv_desc"><strong><?php esc_html_e('Car Description', 'cardealer'); ?></strong>
						(<?php esc_html_e("signs left", 'cardealer'); ?> <span
							id="car_adv_desc_signs_left"><?php echo esc_attr( $max_desc_count ); ?></span>)</label>
					<textarea <?php if ($required_car_features['car_adv_desc'] == '1') {
						echo " data-required=1";
					} ?> name="description[desc]" id="car_adv_desc"><?php echo esc_attr( $description ) ?></textarea>
				</p>

			<?php } ?>

		</div><!-- .edit-form__entry -->

	</div><!-- .edit-form -->



	<?php if (!empty(TMM_Ext_PostType_Car::$specifications_array)): ?>

	<div class="ad edit-form">

		<div class="edit-form__title">
			<h3><?php esc_html_e('Vehicle Features', 'cardealer'); ?></h3>
		</div><!-- .edit-form__title -->

		<div class="edit-form__entry">

		<?php foreach (TMM_Ext_PostType_Car::$specifications_array as $specification_key => $block_name) : ?>

			<h4><?php esc_html_e($block_name, 'cardealer'); ?></h4>

			<div class="edit-form restrict">

				<?php
				$attributes_array = TMM_Ext_PostType_Car::get_attribute_constructors($specification_key);
				$i = 0;
				$attr_count = count($attributes_array);

				foreach ($attributes_array as $key => $value) {
					$i++;
					if ($i === 1 || ($i-1) % 4 === 0) {
						?>

						<div class="row">

						<?php
					}
					?>
							<div class="col-md-3">

							<p>
								<?php $car_data = TMM_Ext_PostType_Car::get_car_data($post_id); ?>

								<?php if ($value['type'] == 'checkbox'): ?>
									<input
										value="<?php echo (!empty($car_data['advanced'][$specification_key][$key])) ? '1' : '0' ?>"
										name="tmm_advanced[<?php echo esc_attr( $specification_key ) ?>][<?php echo esc_attr( $key ) ?>]"
										id="<?php echo esc_attr( $key ) ?>" <?php if (!empty($car_data['advanced'][$specification_key][$key])) echo "checked" ?>
										type="checkbox" class="js_option_checkbox option_checkbox"/>
								<?php endif; ?>

								<label for="<?php echo esc_attr( $key ) ?>" <?php if ($value['type'] == 'checkbox'): ?> class="check" <?php endif; ?> >

									<strong><?php esc_html_e($value['name'], 'cardealer'); ?></strong>

									<?php if ($value['type'] == 'checkbox'): ?>
										<i class="description"> <?php esc_html_e($value['description'], 'cardealer'); ?> </i>
									<?php endif; ?>

								</label>

								<?php if ($value['type'] == 'select'): ?>

									<select
										value="<?php if (!empty($car_data['advanced'][$specification_key][$key])) echo esc_attr( $car_data['advanced'][$specification_key][$key] ) ?>"
										id="<?php echo esc_attr( $key ); ?>"
										name="tmm_advanced[<?php echo esc_attr( $specification_key ) ?>][<?php echo esc_attr( $key ) ?>]">
										<option value="0"><?php esc_html_e('None', 'cardealer'); ?></option>
										<?php foreach ($value['values'] as $val_key => $val_name) : ?>
											<option <?php if ((!empty($car_data['advanced'][$specification_key][$key])) && ($val_key == $car_data['advanced'][$specification_key][$key])) echo 'selected="selected"' ?>
												value="<?php echo esc_attr( $val_key ) ?>"><?php echo esc_html__( $val_name, 'cardealer' ); ?></option>
										<?php endforeach; ?>
									</select>

									<i class="description"> <?php esc_html_e($value['description'], 'cardealer'); ?> </i>

								<?php endif; ?>

							</p>

							</div>

					<?php

					if ($i % 4 === 0 || $i === $attr_count) {
						?>

						</div>

						<?php
					}
				}
				?>


			</div><!--/ .edit-form-->

		<?php endforeach; ?>

		</div><!-- .edit-form__entry -->

	</div><!-- .edit-form -->

	<?php endif; ?>