draw_locations_select(0, 2);

jQuery(document.body).on('click', '#add_new_country', function () {
	var addtag_fields = jQuery('.addtag_fields');
	var h2 = '<h2>'+ tmm_l10n.add_new_country +'</h2>';
	var add_new_loc = jQuery('#add_new_cars_location');
	var parent_id = 0;
	addtag_fields.find('h2').remove();
	addtag_fields.prepend(h2);
	addtag_fields.fadeIn(400);
	add_new_loc.attr('data-type', 'country');
	return false;
});

jQuery(document.body).on('click', '#add_new_state', function () {
	var addtag_fields = jQuery('.addtag_fields');
	var h2 = '<h2>'+ tmm_l10n.add_new_state +'</h2>';
	var add_new_loc = jQuery('#add_new_cars_location');
	var parent_id = jQuery('#tax_carlocation2').val();
	if (parent_id != undefined) {
		addtag_fields.find('h2').remove();
		addtag_fields.prepend(h2);
		addtag_fields.fadeIn(400);
		add_new_loc.attr('data-type', 'state');
	} else {
		show_info_popup(tmm_l10n.warning_add_country);
	}
	return false;
});

jQuery(document.body).on('click', '#add_new_city', function () {
	var addtag_fields = jQuery('.addtag_fields');
	var h2 = '<h2>'+ tmm_l10n.add_new_city +'</h2>';
	var add_new_loc = jQuery('#add_new_cars_location');
	var parent_id = jQuery('#tax_carlocation3').val();

	if (parent_id != undefined) {
		addtag_fields.find('h2').remove();
		addtag_fields.prepend(h2);
		addtag_fields.fadeIn(400);
		add_new_loc.attr('data-type', 'city');
	} else {
		show_info_popup(tmm_l10n.warning_add_state);
	}
	return false;
});

var carlocation1 = jQuery('#tax_carlocation1');
carlocation1.change(function () {
	draw_locations_select(jQuery(this).val(), 2);
});

jQuery(document.body).on('change', "#tax_carlocation2", function () {
	draw_locations_select(jQuery(this).val(), 3);
});

jQuery(document.body).on('click', '#add_new_cars_location', function () {
	var $this = jQuery(this),
		parent_id,
		type = $this.attr('data-type'),
		country_select_val = jQuery('#tax_carlocation2').val(),
		state_select_val = jQuery('#tax_carlocation3').val(),
		name = jQuery('#tag-name').val(),
		slug = jQuery('#tag-slug').val();

	if (name == '') {
		show_info_popup(tmm_l10n.lang_add_location_error1);
	} else {

		switch (type) {
			case 'state':
				if (country_select_val == '') {
					show_info_popup(tmm_l10n.lang_add_location_error2);
					return false;
				}
				parent_id = country_select_val;
				break;
			case 'city' :
				if (state_select_val == '') {
					show_info_popup(tmm_l10n.lang_add_location_error3);
					return false;
				}
				parent_id = state_select_val;
				break;
			case 'country' :
				parent_id = 0;
				break;
		}

		var data = {
			action: "add_new_cars_location",
			name: name,
			slug: slug,
			parent_id: parent_id
		};

		jQuery.post(ajaxurl, data, function (response) {
			var wrap = jQuery('#col-right .wrap');
			wrap.empty();
			response = response.replace(/wp-admin\/admin-ajax.php\?/g, "wp-admin/edit.php?post_type=car&page=tmm_cardealer_carlocation&");
			wrap.append(response);
			show_info_popup(tmm_l10n.success_location_added);
			jQuery('#tag-name').val('');
			jQuery('#tag-slug').val('');
		});
	}

	return false;
});

jQuery(document.body).on('click', '.delete-tag', function () {
	var $this = jQuery(this);
	var id = $this.data('id');
	var data = {
		action: "delete_cars_location",
		id: id
	};
	if (confirm(tmm_l10n.confirm_delete_location)) {
		jQuery.post(ajaxurl, data, function (response) {
			var wrap = jQuery('#col-right .wrap');
			wrap.empty();
			response = response.replace(/wp-admin\/admin-ajax.php\?/g, "wp-admin/edit.php?post_type=car&page=tmm_cardealer_carlocation&");
			wrap.append(response);
			show_info_popup(tmm_l10n.success_location_deleted);
		});
	}
});

jQuery(document.body).on('click', '.editinline', function () {
	var $this = jQuery(this);
	var inline_block = jQuery('#inline_edit');
	var id = $this.data('id');
	var name = $this.data('name');
	var slug = $this.data('slug');
	var current_row = jQuery('#record_' + id);
	var all_records = jQuery('#the-list tr');
	var cancel = jQuery('.tag_edit_cancel');
	var update = jQuery('.tag_edit_update');
	all_records.fadeIn(300);
	inline_block.hide().insertAfter(current_row).fadeOut().fadeIn(500);
	current_row.fadeOut(100);
	name = jQuery.trim(name);
	name = name.replace(/^—\s?/g, '').replace(/^—\s?/g, '');
	inline_block.find('input[name="name"]').val(name);
	inline_block.find('input[name="slug"]').val(slug);
	cancel.attr('data-id', id);
	update.attr('data-id', id);
});

jQuery(document.body).on('click', '.tag_edit_cancel', function () {
	var $this = jQuery(this);
	var id = $this.attr('data-id');
	var current_row = jQuery('#record_' + id);
	current_row.fadeIn(300);
	var inline_block = jQuery('#inline_edit');
	var inline_table = jQuery('#inline_edit_table');
	inline_table.append(inline_block);

});

jQuery(document.body).on('click', '.tag_edit_update', function () {
	var $this = jQuery(this);
	var id = $this.attr('data-id');
	var name = jQuery('#inline_edit input[name="name"]').attr('value');
	var slug = jQuery('#inline_edit input[name="slug"]').val();
	var data = {
		action: "update_cars_location",
		id: id,
		name: name,
		slug: slug
	};
	jQuery.post(ajaxurl, data, function (response) {
		var inline_block = jQuery('#inline_edit');
		var current_row = jQuery('#record_' + id);
		var inline_table = jQuery('#inline_edit_table');
		inline_table.append(inline_block);
		current_row.fadeIn(300);
		var wrap = jQuery('#col-right .wrap');
		wrap.empty();
		response = response.replace(/wp-admin\/admin-ajax.php\?/g, "wp-admin/edit.php?post_type=car&page=tmm_cardealer_carlocation&");
		wrap.append(response);
		show_info_popup(tmm_l10n.success_location_updated);
	});
});

jQuery(document.body).on('click', '#doaction', function () {
	do_action_delete('');
});
jQuery(document.body).on('click', '#doaction2', function () {
	do_action_delete('2');
});

function do_action_delete(k) {
	var action_name = jQuery('select[name="action' + k + '"]').val();
	var checkbox = jQuery('.check-column>input:checked');
	var ids = [];
	var count = 0;
	checkbox.each(function () {
		var $this = jQuery(this);
		ids += $this.val() + ',';
		count += 1;
	});

	if (action_name == 'delete') {
		if (confirm(tmm_l10n.confirm_delete_selected + ' ' + count + ' ' + tmm_l10n.location_q)) {
			var data = {
				action: "doaction_delete_cars_locations",
				ids: ids
			};
			jQuery.post(ajaxurl, data, function (response) {
				var wrap = jQuery('#col-right .wrap');
				wrap.empty();
				response = response.replace(/wp-admin\/admin-ajax.php\?/g, "wp-admin/edit.php?post_type=car&page=tmm_cardealer_carlocation&");
				wrap.append(response);
				show_info_popup(tmm_l10n.success_locations_deleted);
			});

		}
	}
}

function draw_locations_select(parent_id, id) {
	var locations = [0, 0, 0],
		locations_max_level = 3,
		select_cont = jQuery('#tax_carlocation_container' + id);
	if (parent_id !== '') {
		var data = {
			action: "app_cardealer_draw_locations_select",
			name: 'car_carlocation[]',
			id: 'tax_carlocation' + id,
			hide_empty: 0,
			parent_id: parent_id,
			selected: locations[id - 1]
		};
		jQuery.post(ajaxurl, data, function (responce) {
			select_cont.html(responce);
			if (locations_max_level >= 3) {
				if (id == 2) {
					draw_locations_select(jQuery('#tax_carlocation2').val(), 3);
				}
			}
		});
	} else {
		select_cont.empty();
		if (id === 2) {
			jQuery('#tax_carlocation_container3').empty();
		}
	}
}

jQuery(document.body).on('change', '#del_carlocation_select1', function () {
	draw_locations_select2(jQuery(this).val(), 2);
});

jQuery(document.body).on('change', '#del_carlocation_select2', function () {
	draw_locations_select2(jQuery(this).val(), 3);
});

jQuery(document.body).on('click', '#delete_location_button', function () {
	var country = jQuery('#del_carlocation_select1'),
		state = jQuery('#del_carlocation_select2'),
		city = jQuery('#del_carlocation_select3'),
		id = 0,
		action = '',
		name = '';

	if (city.val() != '') {
		id = city.val();
		action = 'doaction_delete_cars_locations';
		name = city.find('option').filter(':selected').text();
	} else if (state.val() != '') {
		id = state.val();
		action = 'doaction_delete_cars_state';
		name = state.find('option').filter(':selected').text();
	} else if (country.val() != '') {
		id = country.val();
		action = 'doaction_delete_cars_country';
		name = country.find('option').filter(':selected').text();
	}

	if (id != 0 && action != '' && confirm(tmm_l10n.confirm_delete_specific + ' "' + name + '" ' + tmm_l10n.location_q)) {
		show_static_info_popup(tmm_l10n.lang_loading);
		var data = {
			action: action,
			ids: id
		};
		jQuery.post(ajaxurl, data, function (response) {
			var wrap = jQuery('#col-right .wrap');
			wrap.empty();
			response = response.replace(/wp-admin\/admin-ajax.php\?/g, "wp-admin/edit.php?post_type=car&page=tmm_cardealer_carlocation&");
			wrap.append(response);
			draw_locations_select(0, 2);
			draw_locations_select2(0, 1);
			clear_select(jQuery('#del_carlocation2'));
			clear_select(jQuery('#del_carlocation3'));
			hide_static_info_popup();
			show_info_popup(tmm_l10n.success_locations_deleted);
		});

	}
});

function draw_locations_select2(parent_id, level) {
	var locations = [0, 0, 0],
		locations_max_level = 3,
		select_cont = jQuery('#del_carlocation' + level);
	if (parent_id !== '') {
		var data = {
			action: "app_cardealer_draw_locations_select",
			name: 'car_carlocation[]',
			id: 'del_carlocation_select' + level,
			hide_empty: 0,
			parent_id: parent_id,
			selected: locations[level - 1]
		};
		jQuery.post(ajaxurl, data, function (responce) {
			select_cont.html(responce);
			if (locations_max_level >= 3) {
				if (level == 2) {
					draw_locations_select2(jQuery('#del_carlocation2').val(), 3);
				}
			}
		});
	} else {
		clear_select(select_cont);
		if (level === 2) {
			clear_select(jQuery('#del_carlocation3'))
		}
	}
}

function clear_select(select_cont) {
	var select = select_cont.find('select'),
		default_option = select.find('option:first');
	select.empty().append(default_option);
}