<?php if (!defined('ABSPATH')) die('No direct access allowed');

class TMM_OptionsHelper {

	public static $sections = array();

	/*
	 * Drawing theme option for admin panel
	 */

	public static function draw_theme_option($data, $prefix = TMM_THEME_PREFIX)
	{
		$value = "";

		if (isset($data['value'])) {
			$value = $data['value'];	

		} else {
			if (!empty($data['name_type']) && $data['name_type'] == 'array') {

				$option = explode('[', $data['name']);
				$option_name = $option['0'];
				$key = $option['1'];
				$key = explode(']', $key);
				$key = $key['0'];

				$value = TMM::get_option($option_name, $prefix);

				if (!empty($value[$key])) {
					$value = $value[$key];
				}

			} else {
				$value = TMM::get_option($data['name'], $prefix);
			}
		}

		if (empty($value) && '0' != $value) {
			$value = @$data['default_value'];
		}

		switch ($data['type']) {
			case 'slider':
				?>
				<div class="option option-slider"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<?php if(!isset($data['show_title']) || $data['show_title'] == 1){ ?>
						<h4 class="option-title"><?php esc_html_e( $data['title'], 'cardealer' ) ?></h4>
					<?php } ?>
					<div class="controls">
						<input data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>" type="text"
							   name="<?php echo esc_attr( $data['name'] ) ?>" value="<?php echo esc_attr( $value ) ?>"
							   min-value="<?php echo esc_attr( $data['min'] ) ?>" max-value="<?php echo esc_attr( $data['max'] ) ?>"
							   class="ui_slider_item"/>
					</div>
					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;
			case 'text':
				?>

				<div class="option option-text"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<?php if (!isset($data['show_title']) || $data['show_title'] == 1) { ?>
						<h4 class="option-title"><?php esc_html_e( $data['title'], 'cardealer' ) ?></h4>
					<?php } ?>
					<div class="controls">
						<input data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>"
							   data-id="<?php echo esc_attr( $data['data-id'] ) ?>" type="text"
							<?php if (!empty($data['data_typecheck'])) { ?>
								data-typecheck="<?php echo esc_attr( $data['data_typecheck'] ) ?>"
							<?php } ?>
							   class="<?php echo esc_attr( $data['css_class'] ) ?>"
							   name="<?php echo esc_attr( $data['name'] ) ?>" value="<?php echo esc_attr( $value ) ?>">
					</div>
					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;
			case 'textarea':
				?>

				<div class="option option-textarea"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<textarea style="width: 99%; min-height: 150px;"
							  data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>"
							  name="<?php echo esc_attr( $data['name'] ) ?>"
							  class="<?php echo esc_attr( $data['css_class'] ) ?>"><?php echo esc_attr( $value ) ?></textarea>

					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;
			case 'select':
				?>
				<div class="option option-select"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<?php if(!isset($data['show_title']) || $data['show_title'] == 1){ ?>
						<h4 class="option-title"><?php esc_html_e( $data['title'], 'cardealer' ) ?></h4>
					<?php } ?>

					<div class="controls">
						<select data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>"
								name="<?php echo esc_attr( $data['name'] ) ?>" class="<?php echo esc_attr( $data['css_class'] ) ?>">
							<?php if (!empty($data['values'])): ?>
								<?php foreach ($data['values'] as $key => $option_text) : ?>
									<option value="<?php echo esc_attr( $key ) ?>" <?php echo wp_kses_post($value == $key ? 'selected=""' : "") ?>><?php echo esc_attr( $option_text ) ?></option>
								<?php endforeach; ?>
							<?php endif; ?>
						</select>
					</div>

					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>
				<?php
				break;
			case 'checkbox':
				?>

				<div class="option option-checkbox"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<div class="controls">
						<input data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>" type="hidden"
							   value="<?php echo wp_kses_post( ($value == '1') ? "1" : "0" ) ?>" name="<?php echo esc_attr( $data['name'] ) ?>">
						<input type="checkbox" id="<?php echo esc_attr( $data['name'] ) ?>"
							   class="option_checkbox <?php echo esc_attr( $data['css_class'] ) ?>" <?php echo wp_kses_post($value == 1 ? "checked" : "" ) ?>/>
						<label for="<?php echo esc_attr( $data['name'] ) ?>"><span></span><?php echo esc_attr( $data['title'] ) ?></label>
					</div>
					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;
			case 'color':
				?>

				<div class="option option-color"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<?php if (!isset($data['show_title']) || $data['show_title'] == 1) { ?>
						<h4 class="option-title"><?php esc_html_e( $data['title'], 'cardealer' ) ?></h4>
					<?php } ?>
					<div class="controls">
						<div class="bgpicker" style="background-color: <?php echo wp_kses_post( $value ) ?>"></div>
						<input data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>" value-index="0" type="text"
							   class="bg_hex_color text small <?php echo esc_attr( $data['css_class'] ) ?>"
							   value="<?php echo esc_attr( $value ) ?>" name="<?php echo esc_attr( $data['name'] ) ?>">

						<?php if (@$_GET['page'] == 'tmm_theme_options'): ?>
							<a href="javascript:void(0);" class="js_picker_val_back" title="Back">back</a>&nbsp;
							<a href="javascript:void(0);" class="js_picker_val_ahead" title="Forward">forward</a>&nbsp;
							<a href="javascript:void(0);" class="js_picker_val_reset" title="Reset">reset</a>
						<?php endif; ?>
					</div>
					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;

			case 'google_font_select':
                $google_fonts = TMM_HelperFonts::get_fonts_array();
				?>
				<div class="option option-select-browse"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>

					<?php if (!isset($data['show_title']) || $data['show_title'] == 1): ?>
						<h4 class="option-title"><?php esc_html_e( $data['title'], 'cardealer' ) ?></h4>
					<?php endif; ?>
					<div class="controls">
						<select data-default-value="<?php echo esc_attr( $data['default_value'] ) ?>" name="<?php echo esc_attr( $data['name'] ) ?>" class="google_font_select">

							<?php foreach ($google_fonts as $font_name => $font_text): ?>
                                <option <?php echo wp_kses_post($font_name == $value ? "selected" : "") ?> value="<?php echo esc_attr( $font_name ) ?>">
                                        <?php echo esc_attr( $font_text ) ?>
                                </option>
							<?php endforeach; ?>

						</select>
					</div>
					<div class="explain"><?php echo wp_kses_post( $data['description'] ) ?></div>
				</div>
				<?php
				break;

			case 'upload':
				?>

				<div class="option option-upload"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<div class="controls">
						<input data-default-value="" id="<?php echo esc_attr( $data['id'] ) ?>" class="middle <?php echo esc_attr( $data['css_class'] ) ?>" type="text"
							   name="<?php echo esc_attr( $data['name'] ) ?>" value="<?php echo esc_attr( $value ) ?>">
						<a class="admin-button button_upload" href="#"><?php esc_html_e('Browse', 'cardealer'); ?></a>
					</div>
					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;
			case 'upload_zip':

				?>

				<div class="option option-upload"<?php echo wp_kses_post( !empty($data['hide']) ? ' style="display:none"' : '' ) ?>>
					<div class="controls">
						<input multiple data-default-value="" id="<?php echo esc_attr( $data['id'] ) ?>" class="middle" type="file"
							   name="<?php echo esc_attr( $data['name'] ) ?>[]" value="" style="display: none" >
						<a class="admin-button button_browse_zip" href="#"><?php esc_html_e('Browse', 'cardealer'); ?></a>
						<a class="admin-button button_upload_zip" href="#"><?php esc_html_e('Upload', 'cardealer'); ?></a>
						<ul class="groups upload_zip_list"></ul>
					</div>
					<div class="explain">
						<?php echo wp_kses_post( $data['description'] ) ?>
					</div>
				</div>

				<?php
				break;

			default:
				esc_html_e( 'Option type does not exist!', 'cardealer' );
				break;
		}
		?>
		<?php if (isset($data['is_reset'])): ?>
		<script>
			tmm_options_reset_array.push("<?php echo esc_attr( $data['name'] ) ?>");
		</script>
	<?php endif; ?>
	<?php
	}

	public static function get_theme_buttons()
	{
		$buttons = array(
			'default' => esc_html__('Default Grey', 'cardealer'),
			'orange' => esc_html__('Orange', 'cardealer')
		);

		return $buttons;

	}

	public static function get_theme_image_sizes()
	{
		$data = array();

		$data['100*80'] = array();
		$data['100*80']['name'] = '100*80';
		$data['100*80']['width'] = 100;
		$data['100*80']['height'] = 80;
		$data['100*80']['crop'] = true;

		$data['125*125'] = array();
		$data['125*125']['name'] = '125*125';
		$data['125*125']['width'] = 125;
		$data['125*125']['height'] = 125;
		$data['125*125']['crop'] = true;

		$data['146*88'] = array();
		$data['146*88']['name'] = '146*88';
		$data['146*88']['width'] = 146;
		$data['146*88']['height'] = 88;
		$data['146*88']['crop'] = true;

		$data['300*183'] = array();
		$data['300*183']['name'] = '300*183';
		$data['300*183']['width'] = 300;
		$data['300*183']['height'] = 183;
		$data['300*183']['crop'] = true;

		$data['350*215'] = array();
		$data['350*215']['name'] = '350*215';
		$data['350*215']['width'] = 350;
		$data['350*215']['height'] = 215;
		$data['350*215']['crop'] = true;

		$data['200*200'] = array();
		$data['200*200']['name'] = '200*200';
		$data['200*200']['width'] = 200;
		$data['200*200']['height'] = 200;
		$data['200*200']['crop'] = true;

		$data['220*134'] = array();
		$data['220*134']['name'] = '220*134';
		$data['220*134']['width'] = 220;
		$data['220*134']['height'] = 134;
		$data['220*134']['crop'] = true;


		$data['740*420'] = array();
		$data['740*420']['name'] = '740*420';
		$data['740*420']['width'] = 740;
		$data['740*420']['height'] = 420;
		$data['740*420']['crop'] = true;

		$data['1130*420'] = array();
		$data['1130*420']['name'] = '1130*420';
		$data['1130*420']['width'] = 1130;
		$data['1130*420']['height'] = 420;
		$data['1130*420']['crop'] = true;


		return $data;
	}

	public static function get_theme_image_sizes_aliases($min_width = 0, $max_width = 0)
	{
		$sizes = self::get_theme_image_sizes();
		$result = array();

		foreach ($sizes as $key => $value) {

			//filter alias with small sizes
			if ($min_width > 0) {
				if ($value['width'] < $min_width) {
					continue;
				}
			}

			//filter alias with big sizes
			if ($max_width > 0) {
				if ($value['width'] > $max_width) {
					continue;
				}
			}

			$result[$key] = $value['name'];
		}

		//***
		$result = array('' => esc_html__('Full size', 'cardealer')) + $result;

		return $result;
	}

	public static function enqueue_script($key, $in_footer = false)
	{
		wp_enqueue_script('tmm_' . $key . '_js', false, array(), false, $in_footer);
	}

	public static function enqueue_style($key)
	{
		wp_enqueue_style('tmm_' . $key . '_css');
	}

	public static function get_contacts_placeholder_icons()
	{
		return array(
			'' => "",
			'message-form-name' => esc_html__('Name', 'cardealer'),
			'message-form-email' => esc_html__('Email', 'cardealer'),
			'message-form-url' => esc_html__('URL', 'cardealer'),
			'message-form-message' => esc_html__('Message', 'cardealer')
		);
	}

}