<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<!-- CONTENT -->
<div class="rh-container"> 
    <div class="rh-content-wrap clearfix">
	    <!-- Main Side -->
        <div class="main-side single<?php if(get_post_meta($post->ID, 'post_size', true) == 'full_post' || rehub_option('disable_post_sidebar')) : ?> full_width<?php endif; ?> clearfix">
            <div class="rh-post-wrapper">            
                <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                    <?php $expiredclass = rh_expired_or_not($post->ID, 'class');?>
                    <?php $postclasses = array('post-inner', 'post', $expiredclass);?>
                    <article <?php post_class($postclasses); ?> id="post-<?php the_ID(); ?>">
                        <!-- Title area -->
                        <div class="rh_post_layout_compact rh_post_layout_compact_dir">
                            <?php 
                                $crumb = '';
                                if( function_exists( 'yoast_breadcrumb' ) ) {
                                    $crumb = yoast_breadcrumb('<div class="breadcrumb">','</div>', false);
                                }
                                if( ! is_string( $crumb ) || $crumb === '' ) {
                                    if(rehub_option('rehub_disable_breadcrumbs') == '1' || vp_metabox('rehub_post_side.disable_parts') == '1') {echo '';}
                                    elseif (function_exists('dimox_breadcrumbs')) {
                                        dimox_breadcrumbs(); 
                                    }
                                }
                                echo ''.$crumb;  
                            ?> 
                            <div class="title_single_area">
                                <?php if(vp_metabox('rehub_post_side.show_featured_image') != '1' && has_post_thumbnail())  : ?>
                                    <div class="featured_single_left">
                                        <figure>
                                            <?php echo re_badge_create('ribbonleft'); ?>
                                            <div class="favorrightside wishonimage"><?php echo RH_get_wishlist($post->ID);?></div> 
                                            <?php $discountpercentage = get_post_meta($post->ID, 'rehub_offer_discount', true);?>       
                                            <?php if ($discountpercentage) :?>
                                                <span class="sale_tag_inwoolist"><h5><?php echo esc_html($discountpercentage);?></h5></span>
                                            <?php else :?>                                
                                                <?php 
                                                    $showimg = new WPSM_image_resizer();
                                                    $showimg->use_thumb = true;
                                                    $height_figure_single = apply_filters( 're_single_figure_height', 123 );
                                                    $showimg->height = $height_figure_single;
                                                    $showimg->crop = false;
                                                    $showimg->show_resized_image();                                    
                                                ?>
                                            <?php endif ;?>                                   
                                        </figure>                             
                                    </div>
                                <?php endif;?>
                                <div class="single_top_main">                                     
                                    <?php echo rh_expired_or_not($post->ID, 'span');?><h1 class="<?php if(rehub_option('hotmeter_disable') !='1') :?><?php echo getHotIconclass($post->ID, true); ?><?php endif ;?>"><?php the_title(); ?></h1>                                                        
                                    <div class="meta post-meta">
                                        <?php rh_post_header_meta('full', true, true, true, false);?> <span class="more-from-store-a"><?php WPSM_Postfilters::re_show_brand_tax('list');?></span>   
                                    </div>
                                    <!-- Star snippet - change to own if you need -->
                                    <?php if(vp_metabox('rehub_post.rehub_framework_post_type') == 'review'):?>
                                        <span class="stars-rate"><span style="width:<?php echo rehub_get_overall_score() * 10 ;?>%"></span></span>
                                    <?php endif;?> 
                                    <!-- END Star snippet --> 
                                    <?php 
                                    $offer_coupon_date = get_post_meta( $post->ID, 'rehub_offer_coupon_date', true );
                                    $coupon_style = $expired = ''; if(!empty($offer_coupon_date)) : ?>
                                        <?php
                                            $timestamp1 = strtotime($offer_coupon_date) + 86399;
                                            $seconds = $timestamp1 - (int)current_time('timestamp',0);
                                            $days = floor($seconds / 86400);
                                            $seconds %= 86400;
                                            if ($days > 0) {
                                                $coupon_style = '';
                                                $coupon_text = $days.' '.__('days left', 'rehub-theme');
                                            }
                                            elseif ($days == 0){
                                                $coupon_text = esc_html__('Last day', 'rehub-theme');
                                                $coupon_style = '';
                                            }
                                            else {
                                                $coupon_text = esc_html__('Expired', 'rehub-theme');
                                                $coupon_style = ' expired_coupon';
                                                $expired = '1';
                                            }
                                        ?>
                                    <?php endif ;?>                         
                                    <?php if(!empty($offer_coupon_date) && $expired !=1) {
                                        echo '<div class="gridcountdown mb20 mt0 mr0 ml0" style="width:220px">';
                                            $countdown = explode('-', $offer_coupon_date);
                                            $year = $countdown[0];
                                            $month = $countdown[1];
                                            $day  = $countdown[2];  
                                            echo wpsm_countdown(array('year'=> $year, 'month'=>$month, 'day'=>$day));
                                        echo '</div>';
                                    } ?>  
                                                                                
                                    <?php if(rehub_option('rehub_disable_share_top') =='1' || vp_metabox('rehub_post_side.disable_parts') == '1')  : ?>
                                    <?php else :?>
                                        <?php if(function_exists('rehub_social_share')):?>
                                            <div class="top_share">
                                                <div class="post_share">
                                                    <?php echo rehub_social_share('row', false, false);?>
                                                </div> 
                                            </div>
                                            <div class="clearfix"></div> 
                                        <?php endif; ?> 
                                    <?php endif; ?>                                                                                          
                                </div> 
                                <div class="single_top_corner"> 
                                    <?php rehub_generate_offerbtn('wrapperclass=block_btnblock mobile_block_btnclock');?>                                                         
                                </div> 
                            </div>
                        </div>
                        <?php if(rehub_option('rehub_single_after_title')) : ?><div class="mediad mediad_top"><?php echo do_shortcode(rehub_option('rehub_single_after_title')); ?></div><div class="clearfix"></div><?php endif; ?>     
                        <?php $no_featured_image_layout = 1;?>
                        <?php include(rh_locate_template('inc/parts/top_image.php')); ?>                                       

                        <?php if(rehub_option('rehub_single_before_post') && vp_metabox('rehub_post_side.show_banner_ads') != '1') : ?><div class="mediad mediad_before_content"><?php echo do_shortcode(rehub_option('rehub_single_before_post')); ?></div><?php endif; ?>

                        <?php the_content(); ?>

                    </article>
                    <div class="clearfix"></div>
                    <?php include(rh_locate_template('inc/post_layout/single-common-footer.php')); ?>                    
                <?php endwhile; endif; ?>
                <?php comments_template(); ?>
            </div>
		</div>	
        <!-- /Main Side -->  
        <!-- Sidebar -->
        <?php if(get_post_meta($post->ID, 'post_size', true) == 'full_post' || rehub_option('disable_post_sidebar')) : ?><?php else : ?><?php get_sidebar(); ?><?php endif; ?>
        <!-- /Sidebar -->
    </div>
</div>
<!-- /CONTENT -->     