<?php

$options = array(
'pages_options' => array(
    'type' => 'group',
    'heading' => __( 'گزینه ها' ),
    'options' => array(

    'username' => array( 'type' => 'textfield','heading' => 'نام کاربری', 'default' => 'flatsomeeir'),
    //'link' => array( 'type' => 'textfield','heading' => 'Link title', 'default' => 'Follow us on instagram'),

    'hashtag' => array( 'type' => 'textfield','heading' => 'هشتگ', 'default' => ''),
    'hashtag_media' => array(
      'type'    => 'select',
      'heading' => __( 'نوع هشتگ' ),
      'default' => 'top',
      'conditions' => 'hashtag !== ""',
      'options' => array(
        'top'    => 'برترین رسانه ها',
        'recent' => 'آخرین رسانه ها (تا 24 ساعت)'
      ),
    ),

    'photos' => array(
        'type' => 'slider',
        'heading' => 'تصویر',
        'default' => 10,
        'max' => 12,
        'min' => 3,
    ),

    'caption' => array(
          'type' => 'radio-buttons',
          'heading' => __('کپشن'),
          'default' => 'true',
          'options' => array(
              0  => array( 'title' => 'خاموش'),
              'true'  => array( 'title' => 'روشن'),
          ),
    ),

    'image_overlay' => array(
        'type'      => 'colorpicker',
        'heading'   => __( 'روکش تصویر' ),
        'default'   => '',
        'alpha'     => true,
        'format'    => 'rgb',
        'position'  => 'bottom right',
        'on_change' => array(
          'selector' => '.overlay',
          'style'    => 'background-color: {{ value }}',
        ),
    ),

    'image_hover' => array(
        'type' => 'select',
        'heading' => __( 'هاور' ),
        'default' => '',
        'options' => require( __DIR__ . '/values/image-hover.php' ),
        'on_change' => array(
            'selector' => '.instagram-image-container',
            'class' => 'image-{{ value }}'
        )
    ),
  ),
),
'layout_options' => require( __DIR__ . '/commons/repeater-options.php' ),
'layout_options_slider' => require( __DIR__ . '/commons/repeater-slider.php' ),
'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
);

// Set defaults.
$options['layout_options']['options']['columns']['default']     = '5';
$options['layout_options']['options']['col_spacing']['default'] = 'collapse';
$options['layout_options']['options']['type']['default']        = 'row';
$options['layout_options']['options']['type']['options']        = array(
  'slider' => 'Slider',
  'row'    => 'Row',
);

add_ux_builder_shortcode( 'ux_instagram_feed', array(
  'name'      => __( 'فید اینستاگرام' ),
  'category'  => __( 'Content' ),
  'thumbnail' => flatsome_ux_builder_thumbnail( 'instagram_feed' ),
  'presets'   => array(
    array(
      'name'    => __( 'پیش فرض' ),
      'content' => '[ux_instagram_feed]',
    ),
    array(
      'name'    => __( 'گرید ساده' ),
      'content' => '[ux_instagram_feed username="stylechild_no" col_spacing="small"]',
    ),
    array(
      'name'    => __( 'اسلایدر تمام عرض' ),
      'content' => '[ux_instagram_feed username="topshop" type="slider" slider_nav_color="light" width="full-width" columns="6"]',
    ),
    array(
      'name'    => __( 'اسلایدر ساده' ),
      'content' => '[ux_instagram_feed username="stylechild_no" type="slider" slider_nav_position="outside" col_spacing="small"]',
    ),
    array(
      'name'    => __( 'تمام عرض B&W' ),
      'content' => '[ux_instagram_feed username="topshop" image_hover="color" type="slider" slider_nav_color="light" width="full-width" columns="6"]',
    ),
  ),
  'options'   => $options,
) );
