<?php
/**
 * Style & Colors
 */

Flatsome_Option::add_section( 'colors', array(
	'title'       => __( 'رنگ ها', 'flatsome-admin' ),
	'panel' => 'style',
) );

Flatsome_Option::add_field( '', array(
	'type'     => 'custom',
	'settings' => 'custom_title_colors_main',
	'label'    => __( '', 'flatsome-admin' ),
	'section'  => 'colors',
    'default'     => '<div class="options-title-divider">رنگ های اصلی</div>',
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color',
	'settings'    => 'color_primary',
    'label'       => __( 'رنگ اولیه', 'flatsome-admin' ),
	'description' => __( 'Change primary color.', 'flatsome-admin' ),
	'section'     => 'colors',
	'default'     => Flatsome_Default::COLOR_PRIMARY,
	'transport'   => $transport,
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color',
	'settings'    => 'color_secondary',
	'transport'   => $transport,
    'label'       => __( 'رنگ ثانویه', 'flatsome-admin' ),
	'description' => __( 'Change secondary color.', 'flatsome-admin' ),
	'default'     => Flatsome_Default::COLOR_SECONDARY,
	'section'     => 'colors',
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color',
	'settings'    => 'color_success',
	'transport'   => $transport,
    'label'       => __( 'موفقیت', 'flatsome-admin' ),
	'description' => __( 'Change the success color. Used for global success messages.', 'flatsome-admin' ),
	'section'     => 'colors',
	'default'     => Flatsome_Default::COLOR_SUCCESS,
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color',
	'settings'    => 'color_alert',
	'transport'   => $transport,
    'label'       => __( 'هشدار', 'flatsome-admin' ),
	'description' => __( 'Change the alert color. Used for global error messages etc.', 'flatsome-admin' ),
	'section'     => 'colors',
	'default'     => Flatsome_Default::COLOR_ALERT,
) );

Flatsome_Option::add_field( '', array(
	'type'     => 'custom',
	'settings' => 'custom_title_color_type',
	'label'    => __( '', 'flatsome-admin' ),
	'section'  => 'colors',
    'default'     => '<div class="options-title-divider">نوع</div>',
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color',
	'settings'    => 'color_texts',
    'label'       => __( 'رنگ زمینه', 'flatsome-admin' ),
	'description' => __( 'Used for all normal texts.', 'flatsome-admin' ),
	'section'     => 'colors',
	'default'     => '#777',
	'transport'   => $transport,
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color',
	'settings'    => 'type_headings_color',
	'label'       => __( 'رنگ تیتر', 'flatsome-admin' ),
	'description' => __( 'Used for all headlines on white backgrounds. (H1, H2, H3 etc.)', 'flatsome-admin' ),
	'section'     => 'colors',
	'default'     => '#555',
	'transport'   => $transport,
) );

Flatsome_Option::add_field( 'option', array(
	'type'        => 'color-alpha',
	'settings'    => 'color_divider',
	'label'       => __( 'رنگ جداکننده ها', 'flatsome-admin' ),
	'description' => __( 'Used for dividers.', 'flatsome-admin' ),
	'section'     => 'colors',
) );

Flatsome_Option::add_field( '', array(
	'type'     => 'custom',
	'settings' => 'custom_title_type_links',
	'label'    => __( '', 'flatsome-admin' ),
	'section'  => 'colors',
	'default'  => '<div class="options-title-divider">لینک ها</div>',
) );

Flatsome_Option::add_field( 'option', array(
	'type'      => 'color',
	'settings'  => 'color_links',
	'label'     => __( 'رنگ لینک ها', 'flatsome-admin' ),
	'section'   => 'colors',
	'default'   => '#4e657b',
	'transport' => $transport,
) );

Flatsome_Option::add_field( 'option', array(
	'type'      => 'color',
	'settings'  => 'color_links_hover',
	'label'     => __( 'رنگ لینک ها : کاور', 'flatsome-admin' ),
	'section'   => 'colors',
	'default'   => '#111',
	'transport' => $transport,
) );

Flatsome_Option::add_field( 'option',  array(
    'type'        => 'color',
    'settings'     => 'color_widget_links',
    'label'       => __( 'رنگ لینک ابزارک ها', 'flatsome-admin' ),
    'section'     => 'colors',
    'default'     => '',
    'transport' => $transport
));

Flatsome_Option::add_field( 'option',  array(
    'type'        => 'color',
    'settings'     => 'color_widget_links_hover',
    'label'       => __( 'رنگ لینک ابزارک ها : هاور', 'flatsome-admin' ),
    'section'     => 'colors',
    'default'     => '',
    'transport' => $transport
) );

if ( is_woocommerce_activated() ) {
	Flatsome_Option::add_field( '', array(
		'type'     => 'custom',
		'settings' => 'custom_title_colors_shop',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'colors',
        'default'     => '<div class="options-title-divider">رنگ های فروشگاه</div>',
	) );

	Flatsome_Option::add_field( 'option', array(
		'type'        => 'color',
		'settings'    => 'color_checkout',
        'label'       => __( 'اضافه کردن به سبد خرید / صورتجساب', 'flatsome-admin' ),
		'description' => __( 'Change color for checkout buttons. Default is Secondary color', 'flatsome-admin' ),
		'section'     => 'colors',
		'transport'   => $transport,
	) );

	Flatsome_Option::add_field( 'option', array(
		'type'        => 'color',
		'settings'    => 'color_sale',
        'label'       => __( 'حباب فروش', 'flatsome-admin' ),
		'description' => __( 'Change color of sale bubble. Default is Secondary color', 'flatsome-admin' ),
		'section'     => 'colors',
		'transport'   => $transport,
	) );

	Flatsome_Option::add_field( 'option', array(
		'type'        => 'color',
		'settings'    => 'color_new_bubble',
        'label'       => __( 'حباب جدید', 'flatsome-admin' ),
		'description' => __( 'Change color of the "New" bubble.', 'flatsome-admin' ),
		'section'     => 'colors',
		'transport'   => $transport,
	) );

	Flatsome_Option::add_field( 'option', array(
		'type'        => 'color',
		'settings'    => 'color_review',
        'label'       => __( 'ستاره بازنگری ها', 'flatsome-admin' ),
		'description' => __( 'Change color of review stars', 'flatsome-admin' ),
		'section'     => 'colors',
		'transport'   => $transport,
	) );

	Flatsome_Option::add_field( 'option', array(
		'type'        => 'color',
		'settings'    => 'color_regular_price',
		'label'       => __( 'قیمت عادی', 'flatsome-admin' ),
		'description' => __( 'Change color of the regular price of an on sale product.', 'flatsome-admin' ),
		'section'     => 'colors',
		'transport'   => $transport,
	) );

	Flatsome_Option::add_field( 'option', array(
		'type'        => 'color',
		'settings'    => 'color_sale_price',
		'label'       => __( 'قیمت حراجی', 'flatsome-admin' ),
		'description' => __( 'Change color of the sale price.', 'flatsome-admin' ),
		'section'     => 'colors',
		'transport'   => $transport,
	) );
}
