<?php
/**
 * Newsletter Element
 */

Flatsome_Option::add_section( 'header_newsletter',
	array(
		'title' => __( 'خبرنامه', 'flatsome-admin' ),
		'panel' => 'header',
	)
);

Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_header_newsletter_layout',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'header_newsletter',
		'default'  => '<div class="options-title-divider">طرح</div>',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'radio-image',
		'settings'  => 'newsletter_icon_style',
		'label'     => __( 'استایل آیکون', 'flatsome-admin' ),
		'section'   => 'header_newsletter',
		'transport' => $transport,
		'default'   => 'plain',
		'choices'   => array(
			''              => $image_url . 'disabled.svg',
			'plain'         => $image_url . 'account-icon-plain.svg',
			'fill'          => $image_url . 'account-icon-fill.svg',
			'fill-round'    => $image_url . 'account-icon-fill-round.svg',
			'outline'       => $image_url . 'account-icon-outline.svg',
			'outline-round' => $image_url . 'account-icon-outline-round.svg',
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'text',
		'settings'  => 'header_newsletter_label',
		'label'     => __( 'برچسب', 'flatsome-admin' ),
		'section'   => 'header_newsletter',
		'transport' => $transport,
		'default'   => 'خبرنامه',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'select',
		'settings'    => 'header_newsletter_block',
		'label'       => __( 'بلاک خبرنامه', 'flatsome-admin' ),
		'description' => __( 'به جای محتوای اصلی پاپ اپ خبرنامه، یک بلاک انتخاب کنید تا به جای آن نمایش داده شود.' ),
		'section'     => 'header_newsletter',
		'default'     => false,
		'choices'     => $blocks,
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'            => 'text',
		'settings'        => 'header_newsletter_title',
		'active_callback' => array(
			array(
				'setting'  => 'header_newsletter_block',
				'operator' => '==',
				'value'    => false,
			),
		),
		'label'           => __( 'عنوان', 'flatsome-admin' ),
		'section'         => 'header_newsletter',
		'transport'       => $transport,
		'default'         => 'در خبرنامه ما عضو شوید',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'              => 'text',
		'settings'          => 'header_newsletter_sub_title',
		'active_callback'   => array(
			array(
				'setting'  => 'header_newsletter_block',
				'operator' => '==',
				'value'    => false,
			),
		),
		'label'             => __( 'تیتر کوچک', 'flatsome-admin' ),
		'section'           => 'header_newsletter',
		'transport'         => $transport,
		'sanitize_callback' => 'flatsome_custom_sanitize',
		'default'           => 'برای با خبر شدن از آخرین مقالات و محصولات ما در این خبر نامه عضو شوید.، شما می توانید این متن را تغییر داده و یا جایگزین کنید. (تم فارس)',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'              => 'text',
		'settings'          => 'header_newsletter_shortcode',
		'active_callback'   => array(
			array(
				'setting'  => 'header_newsletter_block',
				'operator' => '==',
				'value'    => false,
			),
		),
		'label'             => __( 'شورتکد فرم', 'flatsome-admin' ),
		'description'       => __( 'شورتکد را اینجا وارد کنید...', 'flatsome-admin' ),
		'section'           => 'header_newsletter',
		'sanitize_callback' => 'flatsome_custom_sanitize',
		'transport'         => $transport,
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'            => 'image',
		'settings'        => 'header_newsletter_bg',
		'active_callback' => array(
			array(
				'setting'  => 'header_newsletter_block',
				'operator' => '==',
				'value'    => false,
			),
		),
		'label'           => __( 'تصویر پس زمینه', 'flatsome-admin' ),
		'section'         => 'header_newsletter',
		'transport'       => $transport,
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'            => 'text',
		'settings'        => 'header_newsletter_height',
		'active_callback' => array(
			array(
				'setting'  => 'header_newsletter_block',
				'operator' => '==',
				'value'    => false,
			),
		),
		'label'           => __( 'ارتفاع', 'flatsome-admin' ),
		'section'         => 'header_newsletter',
		'default'         => '500px',
		'transport'       => $transport,
	)
);

Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_header_newsletter_behavior',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'header_newsletter',
		'default'  => '<div class="options-title-divider">رفتار</div>',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'checkbox',
		'settings'  => 'header_newsletter_auto_open',
		'label'     => __( 'بازشدن خودکار', 'flatsome-admin' ),
		'section'   => 'header_newsletter',
		'transport' => $transport,
		'default'   => false,
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'            => 'slider',
		'settings'        => 'header_newsletter_auto_timer',
		'active_callback' => array(
			array(
				'setting'  => 'header_newsletter_auto_open',
				'operator' => '==',
				'value'    => true,
			),
		),
		'label'           => __( 'تایمر خودکار', 'flatsome-admin' ),
		'description'     => __( 'بر میلی ثانیه (1000ms = 1sec).', 'flatsome-admin' ),
		'section'         => 'header_newsletter',
		'transport'       => $transport,
		'default'         => 3000,
		'choices'         => array(
			'min'  => 1000,
			'max'  => 300000,
			'step' => 500,
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'            => 'select',
		'settings'        => 'header_newsletter_auto_show',
		'active_callback' => array(
			array(
				'setting'  => 'header_newsletter_auto_open',
				'operator' => '==',
				'value'    => true,
			),
		),
		'label'           => __( 'نمایش خودکار', 'flatsome-admin' ),
		'section'         => 'header_newsletter',
		'transport'       => $transport,
		'default'         => 'always',
		'multiple'        => 0,
		'choices'         => array(
			'always' => __( 'همیشه', 'flatsome-admin' ),
			'once'   => __( 'یکبار', 'flatsome-admin' ),
		),
	)
);

Flatsome_Option::add_field( 'option', array(
	'type'            => 'text',
	'settings'        => 'header_newsletter_version',
	'active_callback' => array(
		array(
			'setting'  => 'header_newsletter_auto_open',
			'operator' => '==',
			'value'    => true,
		),
	),
	'label'           => __( 'نسخه', 'flatsome-admin' ),
	'description'     => __( 'نسخه را برای بازگشایی صفحه نمایش پیکربندی شده "نمایش یک بار" برای بازدید کنندگان پس از ایجاد تغییر در آن ، افزایش دهید.', 'flatsome-admin' ),
	'section'         => 'header_newsletter',
	'transport'       => $transport,
	'default'         => '1',
) );

function flatsome_refresh_header_newsletter_partials( WP_Customize_Manager $wp_customize ) {

	// Abort if selective refresh is not available.
	if ( ! isset( $wp_customize->selective_refresh ) ) {
		return;
	}

	$wp_customize->selective_refresh->add_partial( 'header-newsletter',
		array(
			'selector'            => '.header-newsletter-item',
			'container_inclusive' => true,
			'settings'            => array(
				'header_newsletter_height',
				'header_newsletter_bg',
				'header_newsletter_sub_title',
				'header_newsletter_label',
				'header_newsletter_shortcode',
				'newsletter_icon_style',
				'header_newsletter_title',
			),
			'render_callback'     => function () {
				get_template_part( 'template-parts/header/partials/element', 'newsletter' );
			},
		)
	);
}

add_action( 'customize_register', 'flatsome_refresh_header_newsletter_partials' );
