<?php

namespace Gutencon\Blocks;
defined('ABSPATH') OR exit;

class WCBox{

	protected $name = 'wcbox';

	final public static function instance(){
		static $instance = null;

		if(is_null($instance)) {
			$instance = new static();
		}

		return $instance;
	}

	protected function __construct(){
		add_action('init', array( $this, 'init_handler' ));
	}

	public function init_handler(){
		register_block_type('gutencon/'.$this->name, array(
			'attributes'      => $this->attributes,
			'render_callback' => array( $this, 'render_block' ),
			'editor_script' => 'gutencon_common_js',
			'editor_style' => 'gutencon_common_css'
		));
	}

	protected $attributes = array(
		'productId' => array(
			'type'    => 'string',
			'default' => '',
		),
		'titleColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'btnColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'btntColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'priceColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'titleTag'        => array(
			'type'    => 'string',
			'default' => 'h3',
		),
		'parseError'        => array(
			'type'    => 'string',
			'default' => '',
		),
		'parseSuccess'        => array(
			'type'    => 'string',
			'default' => '',
		),
		'loading'        => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'title' => array (
			'type' => 'string',
			'default'=> 'Product name'
		),
		'copy' => array (
			'type' => 'string',
			'default'=> 'Select Product in right panel'
		),
		'priceLabel' => array (
			'type' => 'string',
			'default'=> '10%'
		),
		'addToCartText' => array (
			'type' => 'string',
			'default'=> 'Add to cart'
		),
		'productAttributes' => array (
			'type' => 'string',
			'default'=> ''
		),
		'galleryImages' => array (
			'type' => 'array',
			'default'=> []
		),
		'userscore' => array (
			'type' => 'string',
			'default'=> '5'
		),
		'thumbnail'      => array(
			'type' => 'array',
			'default' => array(
				'url'    => '',
				'width'  => '',
				'height' => '',
				'alt'    => '',
			)
		),

	);

	public function render_block($settings = array()){
		extract($settings);

		$html   = '';
		if ( empty( $productId )) {
			return;
		}
		$html .= '<div class="c-ws-box gcp-tabs gctabs-tabs">';

		$btnstyles = ($btnColor || $btntColor) ? 'style="background-color:' . esc_attr($btnColor) . '; color:' . esc_attr($btntColor) . ';"' : '';
		$titlestyles = ($titleColor) ? 'style="color:' . esc_attr($titleColor) . ';"' : '';
		$pricestyles = ($priceColor) ? 'style="color:' . esc_attr($priceColor) . ';"' : '';


		$product = wc_get_product( $productId );
		$userscore = $product->get_average_rating();
		$thumbID = $product->get_image_id();
		$title = $product->get_title();
		$copy = $product->get_short_description();
		if ( ! empty( $copy ) ) {
			$copy = wp_trim_words($copy, 15);
		}
		if($product->get_type() =='external'){
			$woolink = $product->add_to_cart_url(); $wootarget = ' target="_blank" rel="nofollow sponsored"';
			$woolink = apply_filters('gutencon_url_filter', $woolink );
			$woolink = apply_filters('rh_post_offer_url_filter', $woolink );

		}else{
			$woolink = get_post_permalink($product->get_id()); $wootarget = '';
		}
		$priceHTML = $product->get_price_html();
		$showtabs = (!empty($productAttributes) || !empty($galleryImages)) ? true : false;
		if($showtabs) {
			$html .= '<div class="t-btn-container">';
				$html .= '<div class="t-btn active" data-name="product">'.esc_html__('Product', 'gutencon').'</div>';
				if(!empty($productAttributes)){
					$html .= '<div class="t-btn" data-name="prattributes">'.esc_html__('Specification', 'gutencon').'</div>';
				}
				if(!empty($galleryImages)){
					$html .= '<div class="t-btn" data-name="prgallery">'.esc_html__('Photos', 'gutencon').'</div>';
				}
			$html .= '</div>';
		}

		$html .= '<div class="t-panel-container">';				
			$html .= '<div class="t-panel product active"><div class="c-offer-listing">';
				$html .= '<div class="c-offer-listing-item">';
					$html .= '<div class="c-offer-listing-item__wrapper">';
						$html .= '<div class="c-offer-listing-image">';
							if ( $userscore > 0 ) {
								$html .= '<div class="c-offer-listing-score">';
									$html .= '<div class="userscore">';
										$html .= '<svg height="12" viewBox="0 0 512 512" width="12" xmlns="http://www.w3.org/2000/svg"><linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="256" x2="256" y1="512" y2="0"><stop offset="0" stop-color="#fd5900"/><stop offset="1" stop-color="#ffde00"/></linearGradient><linearGradient id="SVGID_2_" gradientUnits="userSpaceOnUse" x1="256" x2="256" y1="392.353" y2="91"><stop offset="0" stop-color="#ffe59a"/><stop offset="1" stop-color="#ffffd5"/></linearGradient><g id="Star"><g><g><circle cx="256" cy="256" fill="url(#SVGID_1_)" r="256"/></g></g><g><g><path d="m412.924 205.012c-1.765-5.43-6.458-9.388-12.108-10.209l-90.771-13.19-40.594-82.252c-2.527-5.12-7.742-8.361-13.451-8.361s-10.924 3.241-13.451 8.362l-40.594 82.252-90.771 13.19c-5.65.821-10.345 4.779-12.109 10.209s-.292 11.391 3.796 15.376l65.683 64.024-15.506 90.404c-.965 5.627 1.348 11.315 5.967 14.671 4.62 3.356 10.743 3.799 15.797 1.142l81.188-42.683 81.188 42.683c5.092 2.676 11.212 2.189 15.797-1.142 4.619-3.356 6.933-9.043 5.968-14.671l-15.506-90.404 65.682-64.024c4.088-3.986 5.559-9.947 3.795-15.377z" fill="url(#SVGID_2_)"/></g></g></g></svg>';
										$html .= esc_html( $userscore );
									$html .= '</div>';
								$html .= '</div>';
							}
							$html .= '<figure>';
								$html .= wp_get_attachment_image($thumbID, 'full');
							$html .= '</figure>';
						$html .= '</div>';
						$html .= '<div class="c-offer-listing-content">';
							$html .= '<'.esc_attr($titleTag) . ' class="c-offer-listing__title">';
								$html .= '<a href="' . esc_url( $woolink ) . '" class="gc_track_btn re_track_btn" '.$wootarget.' '.$titlestyles.'>';
									$html .= '' . esc_html( trim( $title ) ) . '';
								$html .= '</a>';
							$html .= '</' . esc_attr($titleTag) . '>';
							$html .= '<div class="c-offer-listing__copy">' .wp_kses_post( $copy ). '</div>';
						$html .= '</div>';
						$html .= '<div class="c-offer-listing-cta">';
							if ( $priceHTML ) {
								$html .= '<div class="c-offer-listing-price">';
									$html .= '<span class="rh_regular_price" '.$pricestyles.'>' . $priceHTML . '</span>';
								$html .= '	</div>';
							}
							if ( $product->add_to_cart_url()  ) {
								$html .= '<div class="priced_block priced_block--sm">';
									$html .= apply_filters( 'woocommerce_loop_add_to_cart_link',
									sprintf( '<a href="%s" data-product_id="%s" data-product_sku="%s" class="btn_offer_block gc_track_btn re_track_btn %s %s product_type_%s"%s %s %s>%s</a>',
									esc_url( $product->add_to_cart_url() ),
									esc_attr( $product->get_id() ),
									esc_attr( $product->get_sku() ),
									$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
									$product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
									esc_attr( $product->get_type() ),
									$product->get_type() =='external' ? ' target="_blank"' : '',
									$product->get_type() =='external' ? ' rel="nofollow"' : '',
									$btnstyles,
									esc_html( $product->add_to_cart_text() )
									), $product );
								$html .= '</div>';
							}
						$html .= '</div>';
					$html .= '</div>';
				$html .= '</div>';
			$html .= '</div></div>';
			if(!empty($productAttributes)){
				$html .= '<div class="t-panel prattributes" style="display:none">'.wp_kses_post($productAttributes).'</div>';
			}
			if(!empty($galleryImages)){
				$html .= '<div class="t-panel prgallery gcimglightbox" style="display:none"><div class="c-ws-box-gallery">';
					foreach($galleryImages as $gallery){
						$html .= '<div class="c-ws-box-gallery__item"><img src="'.esc_url($gallery).'" alt=""/></div>';
					}
				$html .= '</div></div>';
			}
		$html .= ' </div>';
		$html .= ' </div>';

		return $html;

	}
}

WCBox::instance();