<?php

defined('ABSPATH') or exit;

function gc_filesystem($method = 'get_content', $file_path = '', $content = '')
{
    if (empty($file_path))
        return;

    global $wp_filesystem;

    if (empty($wp_filesystem)) {
        require_once(ABSPATH . '/wp-admin/includes/file.php');
        WP_Filesystem();
    }
    if ($method == 'get_content') {
        $result = $wp_filesystem->get_contents($file_path);
        if ($result && !is_wp_error($result)) {
            return $result;
        } else {
            return;
        }
    } elseif ($method == 'put_content') {
        $result = $wp_filesystem->put_contents($file_path, $content, FS_CHMOD_FILE);
        if (!is_wp_error($result)) {
            return true;
        } else {
            return;
        }
    } else {
        return;
    }
}

function gutencon_inline_assets($name = '')
{
    $css = '';
    if ($name == 'boxfrontcss') {
        $css = '
            .gc-box{margin-bottom:30px;padding:20px;border-left:5px solid transparent;line-height:24px}.gc-box .label-info{background-color:#5bc0de;display:inline-block;margin:0 5px 10px 0;padding:3px 6px;font-size:75%;font-weight:700;color:#fff;text-align:center;white-space:nowrap;vertical-align:baseline;border-radius:.25em;line-height:14px}.gc-box.green_type{color:#3c763d;background-color:#dff0d8;border-color:#cae6be}.gc-box.blue_type{color:#31708f;background-color:#d9edf7;border-color:#bcdff1}.gc-box.red_type{color:#a94442;background-color:#f2dede;border-color:#e8c4c4}.gc-box.grey_type{background:#ddd;border-color:#ccc;color:#444}.gc-box.info_type{color:#155724;background-color:#d4edda;border-color:#c3e6cb}.gc-box.info_type svg{fill:#30a030}.gc-box.download_type{color:#004085;background-color:#cce5ff;border-color:#b8daff}.gc-box.download_type svg{fill:#3a9aff}.gc-box.update_type{color:#004458;background-color:#d9edf7;border:1px solid #bce8f1}.gc-box.notice_type{color:#856404;background-color:#fff3cd;border-color:#ffeeba}.gc-box.notice_type svg{fill:#f7a000}.gc-box.error_type{color:#721c24;background-color:#f8d7da;border-color:#f5c6cb}.gc-box.error_type svg{fill:#c70000}.gc-box.border_type{border:2px solid #ddd}.gc-box.icon_type{display:flex}.gc-box.icon_type .gc-box-icon{width:28px}.gc-box.icon_type .gc-box-text{flex-grow:1;margin:0 15px}.gc-box-text > *{margin-bottom: 20px;}
        .gc-box-text > *:last-child{margin-bottom:0}        
        ';
    } elseif ($name == 'titleboxfrontcss') {
        $css = '.gc-titlebox{margin-bottom:30px;background:#fff;line-height:24px;font-size:90%}.gc-titlebox .gc-title-inbox{display:flex;align-content:center;padding:15px;font-weight:700;font-size:110%}.gc-titlebox .gc-title-inbox svg{width:25px;margin-right:10px}.gc-titlebox .gc-title-inbox-label{flex-grow:1}.gc-titlebox .gc-titlebox-text{padding:20px}.gc-titlebox-text>*{margin-bottom:20px}.gc-titlebox-text>:last-child{margin-bottom:0}';
    } elseif ($name == 'promoboxfrontcss') {
        $css = '.gc_promobox{background:none repeat scroll 0 0 #f8f8f8;clear:both;color:#333;margin:0 0 25px 0;padding:20px;border:1px solid transparent}@media only screen and (min-width:480px){.gc_promobox{display:flex}}.gc_promobox .gc_promo_cont{flex-grow:1}.gc_promobox .gc_promo_right{margin-top:20px}@media only screen and (min-width:480px){.gc_promobox .gc_promo_right{margin-right:auto;margin-top:0}}.gc_promobox .title_promobox{font-size:20px;line-height:20px;margin:0 0 15px}.gc_promobox .text_promobox{font-size:15px}.gc_promobox .btn_offer_block{display:block;font-size:18px;line-height:20px;padding:13px 20px;background:none var(--gcbtnbg);color:var(--gcbtncolor);border-radius:4px;font-weight:700;border:none;text-decoration:none;text-align:center;box-shadow:none}';
    } elseif ($name == 'eventfrontcss') {
        $css = '.gc_eventbox{margin:0 0 25px 0;padding:20px;border:1px solid transparent}@media only screen and (min-width:480px){.gc_eventbox{display:flex}}.gc_eventbox .gc-title_event{font-size:21px;line-height:24px;margin:0 0 15px;font-weight:700}.gc_eventbox .gc-text_event{font-size:15px;line-height:24px;opacity:.9}.gc_eventbox .gc-offer{margin-bottom:20px}.gc_eventbox .gc-offer-ticket{display:inline-flex;align-items:center;vertical-align:top;text-align:center;position:relative;font-size:15px;clear:both;line-height:18px;background-color:#fa7204;color:#fff;fill:#fff;border-radius:4px}.gc_eventbox .gc-offer-ticket span{background:none transparent;border:none;text-align:left;padding:6px 10px;font-size:16px}.gc_eventbox .gc-offer-ticket svg{font-size:18px;width:45px;height:30px;margin:0 3px}.gc_eventbox .gc-event_meta{font-size:13px;margin-bottom:20px;line-height:18px;opacity:.7;clear:both}.gc_eventbox .gc-event_meta svg{width:14px;height:14px;margin:0 10px 0 0;fill:#3a68ff;vertical-align:text-bottom}.gc_eventbox .gc-event_meta>div{margin-bottom:8px}.gc_eventbox .gc-event_meta a{text-decoration:none}.gc_eventbox .gc-event_meta>div:last-child{margin-bottom:0}.gc_eventbox .gc-event_meta .gc-location-maplink{text-decoration:underline;margin:0 5px}.gc_eventbox .gc-event__image{margin-bottom:20px}.gc_eventbox .gc-event__date{opacity:.6;margin:0 20px 20px 0;float:left}@media only screen and (min-width:480px){.gc_eventbox .gc-event__image{margin-bottom:0}.gc_eventbox .gc-event__image .gc-product-image .image{width:85px;height:85px;min-width:85px}.gc_eventbox .gc-event__image img{width:100%!important;-o-object-fit:cover;object-fit:cover;height:100%!important}.gc_eventbox .gc-event__date{margin:0 20px;float:none}}.gc_eventbox .gc-event__date_date{text-transform:uppercase;font-size:30px;display:block;line-height:30px;font-weight:700}.gc_eventbox .gc-event__date_month{text-transform:uppercase;font-size:12px;display:block;line-height:14px}';
    } elseif ($name == 'gclightboxfront') {
        $css = '.popupContainer{position:fixed;left:0;bottom:0;right:0;top:0;overflow:auto; z-index:99999}.gc_eventbox .gc-event__popupContainer .popUpBackground{transition:all .3s ease-in-out;position:fixed;left:0;bottom:0;right:0;top:0}.popupContainer .popUpBackground.active{background-color:rgba(0,0,0,.9)}.popupContainer .popImage{position:relative;display:block;transition:all .3s ease-in-out;border-radius:6px;box-shadow:0 20px 25px -5px rgba(0,0,0,.15),0 10px 10px -5px rgba(0,0,0,.1)}.gcimglightbox img{cursor:pointer}';
    } elseif ($name == 'scoreboxfrontcss') {
        $css = '.gc-scorebox{display:block;margin-bottom:35px}.gc-scorebox__right{margin-top:25px}.gc-scorebox__pros{margin-bottom:35px}@media only screen and (min-width:480px){.gc-scorebox{display:flex}.gc-scorebox__left,.gc-scorebox__right{flex-grow:1;width:50%}.gc-scorebox__right{margin-left:20px;margin-top:0}.gc-scorebox__cons{margin-bottom:25px}}.gc-scorebox__cont{position:relative}.gc-scorebox__score{width:80px;border-radius:50%;background:#fff;height:80px;position:absolute;top:-58px;right:20px;justify-content:center;align-items:center;display:flex}.gc-scorebox__number{font-size:32px;font-weight:700}.gc-scorebox__wrap{box-shadow:0 20px 20px 0 rgba(69,96,127,.08)}.gc-scorebox__label{font-size:13px;line-height:18px;margin-bottom:10px}.gc-scorebox__label svg{margin-right:5px;width:14px;vertical-align:middle;height:14px;vertical-align:baseline}.gc-scorebox__cont{padding:18px}.gc-scorebox__title{font-size:21px;font-weight:700;line-height:28px;margin-bottom:15px}.gc-scorebox__button{padding:12px;text-align:center;font-weight:700;font-size:18px;line-height:22px;margin-bottom:15px;display:block!important; text-decoration:none !important}.gc-scorebox__criterias-title{font-size:16px;font-weight:700;line-height:24px;margin-bottom:15px}.gc-scorebox__list{margin:0!important;padding:0!important;list-style:none}.gc-scorebox__list-item{font-size:15px;line-height:18px;margin-bottom:15px!important;list-style:none!important;position:relative; display:flex; align-items:center}.gc-scorebox__list-item svg{width:16px;margin-right:10px;vertical-align:middle}.gc-scorebox__inner{font-size:16px; line-height:24px; margin-bottom:25px}.gc-scorebox__image img{max-height:240px; object-fit:contain}.imagefullcover img{object-fit:cover !important; margin:0; width:100%}';
    } elseif ($name == 'offerboxfrontcss') {
        $css = '.c-offer-box{margin-bottom:30px;box-sizing:border-box;}.c-offer-box .c-offer-box__wrapper{display:flex;flex-wrap:wrap}@media only screen and (min-width:768px){.c-offer-box .c-offer-box__wrapper{align-items:flex-start;flex-wrap:nowrap}}.c-offer-box .c-offer-box__column{width:100%;flex:0 0 100%;max-width:100%;margin:0 0 14px}@media only screen and (min-width:480px){.c-offer-box .c-offer-box__column{margin:0 0 20px}}@media only screen and (min-width:768px){.c-offer-box .c-offer-box__column{flex:0 0 50%;max-width:50%;padding:0 15px}}.c-offer-box .c-offer-box__column--image{max-height:500px}.c-offer-box .c-offer-box__title{margin:0 0 20px 0;font-size:24px;font-weight:700;line-height:30px}.c-offer-box .c-offer-box__title a{text-decoration:none}.c-offer-box .c-offer-box__price{font-size:28px;line-height:40px;font-weight:700;margin-bottom:10px;color:#f04057}.c-offer-box .c-offer-box__price span{min-width:30px;display:inline-block}.c-offer-box .c-offer-box__price .retail-old{min-width:1px;margin-left:10px;font-size:18px;color:#ccc;line-height:40px}.c-offer-box .c-offer-box__disclaimer{font-size:70%;line-height:15px;margin-bottom:15px;color:#009700}.c-offer-box .time_offer{font-size:10px;line-height:20px}.c-offer-box .c-offer-box__desc{margin-top:25px}.c-offer-box .c-offer-box__discount{z-index:9;width:56px;height:56px;border-radius:50%;background-color:#4d981d;font:16px/56px Arial;color:#fff;display:block;text-decoration:none!important;text-align:center;position:absolute;top:10px;left:10px}.c-offer-box .c-offer-box__rating{overflow:hidden;margin-bottom:10px;line-height:30px}.c-offer-box .c-offer-box__rating span{display:inline-block;position:relative;font-size:30px;color:#f6a123}.c-offer-box .priced_block .btn_offer_block{background:none var(--gcbtnbg);color:var(--gcbtncolor);fill:var(--gcbtncolor);border:none;text-decoration:none;outline:0;border-radius:4px;font-weight:700;position:relative;text-align:center;font-size:19px;line-height:1;padding:17px 30px;text-transform:none;display:block}.c-offer-box .gc_offer_coupon{display:flex;align-items:center;vertical-align:top;border:1px dashed green;text-align:center;position:relative;font-size:15px;clear:both;line-height:18px;background-color:#e9ffdd;color:green;border-radius:4px;margin-top:12px}.c-offer-box .gc_offer_coupon{display:flex;align-items:center;vertical-align:top;border:1px dashed green;text-align:center;position:relative;font-size:15px;clear:both;line-height:18px;background-color:#e9ffdd;color:green;border-radius:4px;margin-top:12px}.c-offer-box .gc_offer_coupon input{border:none;background-color:transparent;text-align:center;flex-grow:1;outline:0;width:100%}.c-offer-box .gc_offer_coupon:hover{border:1px dashed #000}.c-offer-box .gc_offer_coupon:hover svg{color:#000}.c-offer-box .gc_offer_coupon svg{font-size:18px;padding:6px 15px 6px 0;width:55px;fill:#007501}.c-offer-box .gc_offer_coupon span{width:100%;background:none transparent;border:none;text-align:center;padding:8px 15px;font-size:16px}.c-offer-box .gc_offer_coupon.expired_coupon{border:1px dashed grey;background:#d3d3d3;color:grey}.c-offer-box .gc_offer_coupon.expired_coupon span{text-decoration:line-through}.c-offer-box .gc_offer_coupon.expired_coupon svg{display:none}.c-offer-box__image{text-align:center}';
    } elseif ($name == 'comparisonfrontcss') {
        $css = '.comparison-table .comparison-wrapper{display:flex;flex:1;width:100%}.comparison-item{-webkit-flex:1 0 0;-ms-flex:1 0 0px;flex:1 0 0;position:relative;padding-top:0;border-top:1px solid rgba(206,206,206,.5);border-bottom:1px solid rgba(206,206,206,.5);border-right:1px solid rgba(206,206,206,.5);scroll-snap-align:start}.comparison-item.comparison-header{-webkit-flex:0 0 100px;-ms-flex:0 0 100px;flex:0 0 100px;border-left:1px solid rgba(206,206,206,.5)}.comparison-item .item-badge,.comparison-item.comparison-header{text-align:center;font-weight:600;text-transform:uppercase;font-size:13px;line-height:18px}.comparison-item .item-badge{position:absolute;top:-50px;left:-1px;right:-1px;height:50px;margin:0;padding:0 15px;background-color:#ccc;color:#fff;z-index:1;display:flex;align-items:center;justify-content:center}.comparison-item .item-header{padding:0 15px 25px;text-align:center;position:relative}.comparison-item .item-header>:last-child{margin:0}.comparison-item .item-header .item-number{position:absolute;left:20px;top:20px;font-size:15px;line-height:35px;width:35px;height:35px;font-weight:700;text-align:center;border-radius:50%;background:green;color:#fff}.comparison-item .item-title{margin-top:0;margin-bottom:0;font-weight:600;font-size:18px;line-height:1.5}.comparison-item .item-subtitle{opacity:.6;font-size:15px;line-height:22px;margin:0 0 15px}.comparison-item .product-image{padding-top:25px;display:table;width:100%;table-layout:fixed;height:185px;margin-bottom:25px}.comparison-item .product-image .image{display:table-cell;vertical-align:middle;width:100%;height:100%}.comparison-item .product-image .image img{max-height:160px;width:auto!important;height:auto!important;display:block;margin:0 auto;max-width:100%!important}.comparison-item .item-row-description{border-top:1px solid rgba(206,206,206,.5);padding:15px;font-size:inherit;line-height:1.3}.comparison-item .item-row-description .item-row-title{display:none;margin:-15px -15px 15px;padding:7px 15px;border-bottom:1px solid rgba(206,206,206,.5);font-weight:700;font-size:14px;text-transform:uppercase;text-align:center}.comparison-item .item-row-description.item-row-callout{text-align:center}.comparison-item .gc-item-btn{font-size:16px;line-height:1;padding:12px 25px;text-transform:none;display:inline-block;background:none var(--gcbtnbg);color:var(--gcbtncolor);fill:var(--gcbtncolor);border:none;text-decoration:none;outline:0;text-shadow:none;box-shadow:-1px 6px 19px rgba(0,0,0,.2);border-radius:4px}.comparison-item .gc-item-btn:hover{box-shadow:-1px 6px 13px rgba(0,0,0,.4)!important}.comparison-item .item-list{margin:0 0 20px;font-size:15px}.comparison-item .item-list-title{margin:0 0 12px}.comparison-item .item-list ul{list-style-type:none;padding:0;margin:0}.comparison-item .item-list ul li{margin:0;line-height:1.4}.comparison-item .item-list ul li::marker{display:none;color:transparent}.comparison-item .item-list ul li a{font-weight:400;font-size:15px;text-decoration:underline}.comparison-item .item-list ul li a:hover{text-decoration:none}.comparison-item .item-rating{margin-bottom:15px;margin-left:auto!important;margin-right:auto!important}.comparison-item .item-rating .item-stars-rating{display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;overflow:hidden;font-size:1.5rem;height:1.5rem;line-height:1;color:#ff5900;position:relative;margin:0 auto}.comparison-item .item-rating .item-stars-rating .item-star{overflow:hidden;width:22px;height:22px;text-align:center}.comparison-table.has-badges .comparison-item{margin-top:49px}[dir=rtl] .comparison-item.comparison-item{border-left:1px solid rgba(206,206,206,.5);border-right:0}[dir=rtl] .comparison-item.comparison-header{border-left:1px solid rgba(206,206,206,.5);border-right:1px solid rgba(206,206,206,.5);text-align:right}[dir=rtl] .comparison-item .item-rating .item-stars-rating{-webkit-flex-direction:row-reverse;-ms-flex-direction:row-reverse;flex-direction:row-reverse}.comparison-table{position:relative;display:-webkit-flex;display:-ms-flexbox;display:flex;width:100%;margin-bottom:30px}.comparison-control-next,.comparison-control-prev{display:none}.comparison-item.swiper-slide{overflow:visible}@media (max-width:767.98px){.comparison-table.slide .comparison-item .item-badge,.comparison-table.stacked .comparison-item .item-badge{position:static;margin:0 -15px}.comparison-table.overflow .comparison-wrapper{overflow-x:auto}.comparison-table.overflow .comparison-item{width:200px;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto}.comparison-table.overflow .comparison-header{width:100px;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto}.comparison-table.stacked .comparison-wrapper{-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap}.comparison-table.slide{-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap}.comparison-table.slide .comparison-wrapper{-webkit-flex-wrap:nowrap;-ms-flex-wrap:nowrap;flex-wrap:nowrap;flex:0 0 auto}.comparison-table.slide .comparison-header,.comparison-table.stacked .comparison-header{display:none}.comparison-table.slide .comparison-item,.comparison-table.stacked .comparison-item{-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto;width:100%;border-left:1px solid rgba(206,206,206,.5);margin:20px 0}.comparison-table.slide .comparison-item .item-row-description .item-row-title,.comparison-table.stacked .comparison-item .item-row-description .item-row-title{display:block;background-color:#f4f4f4;padding:10px 15px}[dir=rtl] .comparison-table.slide .comparison-item.comparison-item,[dir=rtl] .comparison-table.stacked .comparison-item.comparison-item{border-right:1px solid rgba(206,206,206,.5)}.comparison-table.slide .comarison-controls{display:block}.comparison-table.slide .comparison-control-next,.comparison-table.slide .comparison-control-prev{background:0 0!important;display:flex;z-index:3;position:absolute;top:200px;border:none;background-color:transparent;outline:0!important;font-size:2rem;width:2rem;height:2rem;line-height:1;padding:0!important;-webkit-appearance:none!important;align-items:center;justify-content:center;cursor:pointer}.comparison-control-next.swiper-button-disabled,.comparison-control-prev.swiper-button-disabled{opacity:.4}.comparison-control-next svg,.comparison-control-prev svg{display:block}.comparison-control-next svg path,.comparison-control-prev svg path{fill:#000}.comparison-control-prev{left:0}.comparison-control-next{right:0}.comparison-table.slide .comparison-control-prev{animation:lefttorightarrow 2.3s ease-in-out 0s infinite}.comparison-table.slide .comparison-control-next{animation:righttoleftarrow 2.3s ease-in-out 0s infinite}}@keyframes lefttorightarrow{0%{transform:translateX(0)}50%{transform:translateX(12px)}100%{transform:translateX(0)}}@keyframes righttoleftarrow{0%{transform:translateX(0)}50%{transform:translateX(-12px)}100%{transform:translateX(0)}}@media (min-width:768px){.comparison-wrapper{overflow-x:auto;scroll-behavior:smooth;scroll-snap-type:x mandatory}.comparison-wrapper .comparison-item{min-width:190px}}.noheadertable .comparison-header{display:none!important}.noheadertable .comparison-item:first-child{border-left:1px solid rgba(206,206,206,.5)}.noheadertable .item-row-title{display:none!important}';
    } elseif ($name == 'offerlistingfrontcss') {
        $css = '.c-offer-listing{position:relative;box-shadow:0 5px 23px rgb(188 207 219 / 35%);margin-bottom:30px}.c-offer-listing .c-offer-listing__title{margin:0 0 10px;color:#333;font-size:20px;font-weight:700;line-height:28px}.c-offer-listing .c-offer-listing__title a{text-decoration:none}.c-offer-listing .c-offer-listing__copy{line-height:20px;font-size:15px}.c-offer-listing .c-offer-listing__read-more{display:block;color:#334dfe;font-size:13px;cursor:pointer;margin-top:6px}.c-offer-listing .blockstyle,.c-offer-listing .gc_offer_coupon{display:block}.c-offer-listing .re-line-badge{font-size:11px;line-height:1;text-shadow:none;padding:5px 10px;font-weight:700;position:relative;text-transform:uppercase;display:inline-block}.c-offer-listing .btn_offer_block{margin:0 auto;display:block;font-size:18px;line-height:20px;padding:13px 20px;text-transform:uppercase;background:none var(--gcbtnbg);color:var(--gcbtncolor);border-radius:4px;font-weight:700;text-decoration:none;border:none}.c-offer-listing .gc_offer_coupon{display:flex;align-items:center;vertical-align:top;cursor:pointer;border:1px dashed green;text-align:center;position:relative;font-size:14px;clear:both;line-height:18px;background-color:#e9ffdd;color:green;border-radius:4px;margin-top:12px}.c-offer-listing .gc_offer_coupon:hover{border:1px dashed #000}.c-offer-listing .gc_offer_coupon:hover svg{color:#000}.c-offer-listing .gc_offer_coupon svg{font-size:14px;padding:6px 6px 6px 0;width:35px;fill:#007501}.c-offer-listing .time_offer{font-size:10px;line-height:20px}.c-offer-listing .gc_offer_coupon .coupon_text{width:100%;background:none transparent;border:none;text-align:center;padding:6px 15px;font-size:16px}.c-offer-listing .gc_offer_coupon.expired_coupon{border:1px dashed grey;background:#d3d3d3;color:grey}.c-offer-listing .gc_offer_coupon.expired_coupon .coupon_text{text-decoration:line-through}.c-offer-listing .gc_offer_coupon.expired_coupon svg{display:none}.c-offer-listing-item{width:100%;margin-top:20px}@media only screen and (min-width:768px){.c-offer-listing-item{margin-top:-1px}}.c-offer-listing-item:first-of-type{margin-top:0}.c-offer-listing-item .c-offer-listing-item__wrapper{border:1px solid rgba(206,206,206,.4);box-shadow:0 5px 23px rgba(188,207,219,.35);background:#fff}@media only screen and (min-width:768px){.c-offer-listing-item .c-offer-listing-item__wrapper{width:100%;display:flex;flex-wrap:wrap}}.c-offer-listing-image{position:relative;display:flex;align-items:center;width:100%;padding:15px 20px;text-align:center}@media only screen and (min-width:768px){.c-offer-listing-image{min-width:160px;max-width:160px;border-right:1px solid rgba(206,206,206,.4)}}.c-offer-listing-image figure{position:relative;display:flex;justify-content:center;align-items:center;margin:0 auto;width:100%}.c-offer-listing-image figure img{border-radius:4px}.c-offer-listing-score{z-index:2;position:absolute;top:0;right:0;margin:15px 0 0}.c-offer-listing-score .userscore{display:inline-block;padding:3px 5px;background:#fffffff5;font-size:14px;border-radius:4px;line-height:18px;box-shadow:0 2px 5px #4e4e4e0f;line-height:18px;margin:0 15px}.c-offer-listing-score .userscore svg{height:12px;width:12px}.c-offer-listing-score span{display:block;width:35px;height:35px;margin:0 10px 10px 0;background-color:#c00;color:#fff;border-radius:50%;font-size:15px;font-weight:700;line-height:35px;text-align:center}.c-offer-listing-score .score--1,.c-offer-listing-score .score--2{background-color:#940000}.c-offer-listing-score .score--5,.c-offer-listing-score .score--6{background-color:#ffac00}.c-offer-listing-score .score--7,.c-offer-listing-score .score--8{background-color:#9c0}.c-offer-listing-score .score--10,.c-offer-listing-score .score--9{background-color:#390}.c-offer-listing-content{flex-grow:1;flex-basis:0;width:100%;padding:15px 20px;text-align:center}@media only screen and (min-width:768px){.c-offer-listing-content{border-right:1px solid rgba(206,206,206,.4);text-align:inherit}}.c-offer-listing-cta{display:flex;flex-direction:column;justify-content:center;padding:15px 20px;width:100%;text-align:center}@media only screen and (min-width:768px){.c-offer-listing-cta{min-width:200px;max-width:200px}}.c-offer-listing-price{margin:0 0 8px 0;font-size:21px;font-weight:700;line-height:24px;color:#111}@media only screen and (min-width:768px){.c-offer-listing-price{font-size:18px}}.c-offer-listing-price span{display:inline-block}.c-offer-listing-price del{display:inline-block;vertical-align:top;margin-left:5px;font-size:80%;font-weight:400;color:grey;opacity:.4}.c-offer-listing-price del .amount{text-decoration:line-through}.c-offer-listing-cta .price ins{text-decoration:none}.c-offer-listing-disclaimer{padding:10px 15px;font-size:11.5px;color:grey;background-color:rgba(7,107,156,.1)}.c-ws-box-gallery{display:flex;justify-content:space-between;padding:15px}.c-ws-box-gallery__item{width:23%}.t-panel .c-offer-listing{margin:0;box-shadow:none}.t-panel-container .c-offer-listing-item .c-offer-listing-item__wrapper{border:none}';
    } elseif ($name == 'offerlistingfull') {
        $css = '.gc-offer-listing{position:relative;margin-bottom:30px}.gc-offer-listing .gc-offer-listing__title{margin:0 0 15px;color:#333;font-size:20px;font-weight:700;line-height:28px}.gc-offer-listing .gc-offer-listing__title a{text-decoration:none}.gc-offer-listing .gc-offer-listing__copy{line-height:22px;font-size:15px}.gc-offer-listing .gc-offer-listing__read-more{display:block;color:#334dfe;font-size:13px;cursor:pointer;margin-top:6px;line-height:18px}.gc-offer-listing .blockstyle,.gc-offer-listing .gc_offer_coupon{display:block}.gc-offer-listing .gc-list-badge{position:absolute;top:0;left:0;z-index:20;background-color:#334dfe;padding:7px 12px 7px 15px;line-height:16px;color:#fff}.gc-offer-listing .gc-list-badge-title{font-size:14px}.gc-offer-listing .gc-list-badge-arrow{content:"";display:block;width:0;height:0;border:15px solid #334dfe;border-top-width:30px;border-left-width:0;border-bottom-color:transparent;border-right-color:transparent;position:absolute;right:-15px;top:0}.gc-offer-listing .btn_offer_block{margin:0 auto;display:block;font-size:18px;line-height:20px;padding:13px 20px;text-transform:uppercase;background:none var(--gcbtnbg);color:var(--gcbtncolor);border-radius:4px;font-weight:700;border:none;text-decoration:none}.gc-offer-listing .gc_offer_coupon{display:flex;align-items:center;vertical-align:top;cursor:pointer;border:1px dashed green;text-align:center;position:relative;font-size:14px;clear:both;line-height:18px;background-color:#e9ffdd;color:green;border-radius:4px;margin-top:12px}.gc-offer-listing .gc_offer_coupon:hover{border:1px dashed #000}.gc-offer-listing .gc_offer_coupon:hover svg{color:#000}.gc-offer-listing .gc_offer_coupon svg{font-size:14px;padding:6px 6px 6px 0;width:35px;fill:#007501}.gc-offer-listing .gc_offer_coupon .coupon_text{width:100%;background:none transparent;border:none;text-align:center;padding:6px 15px;font-size:16px;color:green}.gc-offer-listing .gc_offer_coupon.expired_coupon{border:1px dashed grey;background:#d3d3d3;color:grey}.gc-offer-listing .gc_offer_coupon.expired_coupon .coupon_text{text-decoration:line-through}.gc-offer-listing .gc_offer_coupon.expired_coupon svg{display:none}.gc-offer-listing-item{width:100%;margin-top:20px}@media only screen and (min-width:768px){.gc-offer-listing-item{margin-top:-1px}.gc-offer-listing{box-shadow:0 5px 23px rgba(188,207,219,.35)}}.gc-offer-listing-item:first-of-type{margin-top:0}.gc-offer-listing-item .gc-offer-listing-item__wrapper{box-shadow:inset 0 0 0 1px rgba(206,206,206,.4);background:#fff}@media only screen and (min-width:768px){.gc-offer-listing-item .gc-offer-listing-item__wrapper{width:100%;display:flex;flex-wrap:nowrap}}.gc-offer-listing-image{position:relative;display:flex;align-items:center;width:100%;text-align:center}@media only screen and (min-width:768px){.gc-offer-listing-image{min-width:200px;max-width:200px;border-right:1px solid rgba(206,206,206,.4)}}.gc-offer-listing-image figure{position:relative;display:flex!important;justify-content:center;align-items:center;margin:0 auto;width:100%;height:100%;border-radius:4px}.gc-offer-listing-image img{max-height:100%;border-radius:4px;object-fit:scale-down;flex:0 0 auto;max-height:120px}.gc-offer-listing-score{display:flex;align-items:flex-start;justify-content:center;padding:0 25px 12px 25px}.gc-offer-listing-score svg{width:20px;height:20px;margin-right:6px}.gc-offer-listing-score .gc-lrating{background-color:#fff;border:2px solid #eee;margin:0 auto;text-align:center;display:block;width:120px}.gc-offer-listing-score .gc-lrating-body{font-size:24px;font-weight:700;margin:2px;padding:8px}.gc-offer-listing-score .gc-lrating-bottom{background-color:#f9f9f9;font-size:14px;margin:2px;padding:6px;text-transform:uppercase;flex-grow:1;display:none}.gc-colorrating{text-align:center;border-radius:4px;background-color:#4e4eff;color:#fff;font-weight:700;position:absolute;top:15px;right:15px;width:65px;font-size:20px;line-height:40px}.gc-offer-listing-content{flex-grow:1;flex-basis:0;width:100%}.gc-offer-listing-cta{display:flex;flex-direction:column;justify-content:flex-start;width:100%;text-align:center}@media only screen and (min-width:768px){.gc-offer-listing-cta{min-width:250px;max-width:250px}.gc-colorrating{position:static;width:90px;font-size:25px;line-height:52px}}.gc-offer-listing-price{margin:0 0 8px 0;font-size:22px;font-weight:700;line-height:24px}.gc-offer-listing-price span{display:inline-block}.gc-offer-listing-price del{display:inline-block;vertical-align:top;margin-left:5px;font-size:80%;font-weight:400;color:grey;opacity:.4}.gc-offer-listing-price del .amount{text-decoration:line-through}.gc-offer-listing-cta .price ins{text-decoration:none}.gc-offer-listing-disclaimer{padding:10px 15px;font-size:11.5px;color:grey;background-color:rgba(7,107,156,.1);line-height:22px}.gc-offer-listing-content,.gc-offer-listing-cta,.gc-offer-listing-image{padding:18px 25px}.gc-offer-listing-contwrap{display:flex;flex-grow:1;flex-direction:column}.gc-offer-listing-number{display:none}@media only screen and (min-width:768px){.gc-offer-listing-score{padding:0 25px 25px 25px;justify-content:flex-start}.gc-offer-listing-score .gc-lrating{margin:0}}@media only screen and (min-width:1200px){.gc-offer-listing-content,.gc-offer-listing-cta,.gc-offer-listing-image,.gc-offer-listing-score{padding:30px}.gc-offer-listing-contwrap{flex-direction:row}.gc-offer-listing-number{display:inline-block;height:40px;text-align:center;z-index:1;position:absolute;top:50%;left:-20px;font-size:22px;line-height:40px;width:40px;border-radius:50%;text-align:center;font-weight:700;background:#4bb866;color:#fff;margin-top:-20px}.gc-offer-listing-score .gc-lrating-bottom{display:block}.gc-offer-listing-score .gc-lrating{margin:0 auto}}.gc-listing-expand{background-color:#e9f5fd;padding:20px 30px}.gc-listing-expand-label{margin:20px 0 0 0;font-size:14px;display:inline-block;cursor:pointer;opacity:.5}';
    } elseif ($name == 'linelistfrontcss') {
        $css = '.gc-linelist .gc-linelist-item{position:relative;display:flex}.gc-linelist .gc-linelist-icon{color:#fff;position:relative;z-index:2}.gc-linelist .gc-linelist-icon span{display:block;width:32px;height:32px;border-radius:100%;line-height:32px;display:flex;text-align:center;align-items:center;justify-content:center}.gc-linelist .gc-linelist-icon svg{width:16px;height:16px;fill:#fff}.gc-linelist .gc-linelist-line{content:"";border:1px dashed rgba(206,206,206,.23);position:absolute;left:15px;height:99%;z-index:1}.gc-linelist .gc-linelist-item:last-of-type .gc-linelist-line{display:none}.gc-linelist .gc-linelist-content{padding:0 0 32px 15px;overflow:hidden;vertical-align:top}';
    } elseif ($name == 'toctopfrontcss') {
        $css = '.gc-autolist{margin:15px 0 30px 0;border:1px solid #dddddd7d;background:#fff}.gc-autolist-item{padding:15px 15px 15px 5px}.gc-autolist-number{border-radius:50%;color:#fff;float:left;height:25px;line-height:25px;margin:6px 20px 20px 15px;text-align:center;width:25px;font-weight:700;font-size:16px;background:none var(--gcbtnbg);color:var(--gcbtncolor)}.gc-autolist-title,.gc-autolist-title a{font-size:18px;line-height:14px;text-decoration:none}';
    } elseif ($name == 'versusfrontcss') {
        $css = '.gc-versus-item{display:table;width:100%;border-radius:5px;padding:5px}.gc-versus-item .title-versus{width:40%;display:table-cell;vertical-align:middle}.gc-versus-item .vs-heading{font-size:17px;line-height:32px;font-weight:700;display:block;padding:0 10px}.gc-versus-item .vs-subheading{font-size:13px;opacity:.5;line-height:20px;display:block;padding:0 10px}.gc-versus-cont{vertical-align:middle;display:table;width:100%}.gc-versus-item .vs-1-col,.gc-versus-item .vs-2-col,.gc-versus-item .vs-3-col,.gc-versus-item .vs-circle-col{text-align:center;display:table-cell;vertical-align:middle;width:273px}.gc-versus-item .vs-circle-col{width:40px}.gc-versus-item .vs-circle{font-weight:700;font-family:Arial;font-size:16px;border-radius:20px;height:40px;width:40px;display:block;text-align:center;line-height:40px;background:#e9e9e9;margin:0 10px;color:#111}.gc-versus-item .vs-greyscale{-webkit-filter:grayscale(100%);filter:grayscale(100%);opacity:.6}.gc-versus-item .vs-image{max-width:80px;max-height:80px;margin:5px 0}.gc-versus-item .vs-conttext{font-weight:700;color:#529d16;font-size:16px}.gc-versus-item .vs-tick svg{width:25px;fill:#4fb200;height:25px;vertical-align:middle}.gc-versus-item .vs-times svg{width:17px;height:17px;fill:#c00;vertical-align:middle}@media (max-width:500px){.gc-versus-item{display:block;margin-bottom:18px}.gc-versus-item .title-versus{margin:6px 5px 12px 5px;display:block;width:100%;text-align:center}.gc-versus-item .vs-heading{font-size:15px}.gc-versus-item .vs-subheading{font-size:12px}.gc-versus-cont{width:100%}.gc-versus-item .vs-image{margin:10px 0;max-width:50px}}';
    } elseif ($name == 'gctabsfront') {
        $css = '.gcp-tabs *{box-sizing: border-box !important}.t-btn-container{display:flex;flex-direction:row;width:100%;align-items:center;margin-bottom:-1px;flex-wrap:wrap}.t-btn-container .t-btn{background-origin: border-box;list-style:none;display:inline-flex;align-items:center;margin:0;padding:7px 18px;cursor:pointer;position:relative;transition:all .4s ease-in-out}.t-btn-container .t-btn .tabsubtitle{font-size:70%;opacity:.7}.gctabs-tabs .t-btn-container .t-btn{border:1px solid transparent;border-top-width:2px}.gctabs-tabs .t-btn-container .t-btn.active{border-color:rgba(206,206,206,.4);border-bottom-color:#fff;border-top-color:var(--gcbtnbg);background-color:#fff;color:#333}.t-panel-container .t-panel{opacity:0;overflow:hidden;display:none}.t-panel-container .t-panel.active{opacity:1;display:block!important}.t-panel-container{margin-bottom:25px;overflow:hidden}.gctabs-tabs .t-panel-container{border:1px solid rgba(206,206,206,.4);background-color:#fff}.t-btn-container ul{margin:0!important;padding:0!important}.gctabs-underline .t-btn-container .t-btn:after{position:absolute;bottom:0;left:0;content:"";height:3px;width:0;transition:width .5s,left .5s,right .5s;background:var(--gcbtnbg)}.gctabs-underline .t-btn-container .t-btn.active:after{width:100%;left:0;right:0}.gctabs-pills .t-btn-container .t-btn{margin:0 10px;border:1px solid transparent}.gctabs-vertical{display:flex}.gctabs-vertical .t-btn-container{display:block;width:150px}.gctabs-vertical .t-btn-container .t-btn{margin-bottom:10px;width:150px}.gctabs-vertical .t-panel-container{flex-grow:1}.gc-alignleft{justify-content:flex-start}.gc-alignright{justify-content:flex-end}.gc-aligncenter{justify-content:center}.t-btn-container .t-btn .gc-image{flex-grow:inherit;margin:0 10px 0 0}.t-btn-container .t-btn img{margin:0;height:25px;min-width:auto}@keyframes gcwidthleftright{0%{width:0%}100%{width:100%}}@keyframes gcslidefromtop{0%{transform:translateY(-10px);opacity:0}100%{transform:translateY(0);opacity:1}}@media (max-width:768px){.tabscroll .t-btn-container{overflow-x:scroll;flex-wrap:nowrap;scroll-behavior:smooth;scroll-snap-type:x mandatory;width: 100% !important;white-space: nowrap;}.tabscroll .t-btn-container .t-btn{scroll-snap-align:start;white-space:nowrap;width: auto !important;margin-right: 10px;}.tabscroll .t-btn-container .t-btn.active{box-shadow:none!important}}@media(max-width:768px){.gctabs-vertical{display:block !important}.gctabs-vertical .t-panel-container{margin-top:25px}}';
    } elseif ($name == 'accordionfrontcss') {
        $css = '.gc-accordion{margin-bottom:25px}.gc-accordion .gc-accordion-item{margin:10px 0 0}.gc-accordion .gc-accordion-item.gcclose .gc-accordion-item__content{display:none}.gc-accordion .gc-accordion-item.gcopen .gc-accordion-item__title .gciconafter{transform:rotate(0)}.gc-accordion .gc-accordion-item:first-of-type{margin-top:0}.gc-accordion .gc-accordion-item__heading{outline:0;text-decoration:none;font-weight:400 !important;font-size:15px !important;line-height:21px !important;margin:0 !important;padding:15px !important;}.gc-accordion .gc-accordion-item__title{z-index:1;position:relative;display:block;margin:0;background:none #f9f9f9;border:1px solid #ddd;cursor:pointer;transition:all .3s ease-in-out}.gc-accordion .gc-accordion-item__title span.iconfortoggle{display:block;position:absolute;height:14px;width:14px;right:20px;top:18px}.gc-accordion .gc-accordion-item__title span.iconfortoggle .gciconbefore{content:"";width:14px;height:3px;border-radius:2px;background-color:#111;position:absolute;top:6px}.gc-accordion .gc-accordion-item__title span.iconfortoggle .gciconafter{content:"";width:14px;height:3px;border-radius:2px;background-color:#111;position:absolute;top:6px;transform:rotate(90deg);transition:all .3s ease-in-out}.gc-accordion .gc-accordion-item__title:hover{background:none #eee}.gc-accordion .gc-accordion-item__content{z-index:0;position:relative;padding:15px;border:1px solid #ddd;border-top:none;background:#fff}.gc-accordion .gc-accordion-item__content.stuckMoveDownOpacity{-webkit-animation:stuckMoveDownOpacity .6s;animation:stuckMoveDownOpacity .6s}.gc-accordion .gc-accordion-item__text{font-size:16px;font-weight:400;line-height:1.75}@keyframes stuckMoveDownOpacity{0%{transform:translateY(-15px);opacity:0}100%{transform:translateY(0);opacity:1}}';
    } elseif ($name == 'reviewboxfrontcss') {
        $css = '.gc-review-box{padding:18px;margin-bottom:25px;background:#fff;box-shadow:0 2px 20px rgba(0,0,0,.08);overflow:hidden}@media only screen and (min-width:768px){.gc-review-box{padding:30px}}.gc-review-box .review-top{overflow:hidden;float:none;width:100%}.gc-review-box .overall-score{width:100px;margin:0 20px 10px 0;float:left;background:#e43917;text-align:center}.gc-review-box .overall{display:block;padding:8px 0;font-size:52px;line-height:1;color:#fff}.gc-review-box .overall-text{display:block;padding:6px 0;font-weight:700;font-size:11px;text-transform:uppercase;background:#111;color:#fff}.gc-review-box .review-header{display:block;margin-bottom:9px;font-size:26px;font-weight:700;line-height:32px}.gc-review-box .review-text p{margin:0}.gc-review-box .review-criteria{margin-top:20px;padding:40px 0 0 0;border-top:1px dashed #eee;border-bottom:1px dashed #eee;transition:.4s linear;transition-property:width,background-color}.gc-review-box .rate-bar{position:relative;display:block;width:100%;margin-bottom:34px;background:#ddd;height:14px;transition:.4s linear;transition-property:width,background-color;border-radius:5px}.gc-review-box .rate-bar-title{position:absolute;top:-21px;left:0;font-size:14px}.gc-review-box .rate-bar-title span{display:block;min-width:140px;height:18px;line-height:18px}.gc-review-box .rate-bar-title span[data-rich-text-placeholder]{position:absolute;top:0;left:0}.gc-review-box .rate-bar-bar{width:0;height:14px;background:#e43917;border-radius:5px}.gc-review-box .rate-bar-percent{position:absolute;top:-21px;right:0;height:18px;font-size:14px;font-weight:700;line-height:18px}.gc-cons-pros{overflow:hidden;margin-top:20px}.gc-cons-pros__col{width:100%;float:none;margin-right:0;margin-bottom:20px}@media only screen and (min-width:768px){.gc-cons-pros__col{position:relative;float:left;width:48%;margin-right:4%;margin-bottom:5px}}.gc-cons-pros__col:last-of-type{margin-bottom:0}@media only screen and (min-width:768px){.gc-cons-pros__col:last-of-type{margin-right:0;clear:right}}@media only screen and (min-width:768px){.gc-cons-pros__col--full{width:100%;margin-right:0;margin-bottom:0;float:none}}.gc-cons-pros__title{margin:0 0 15px 0;font-size:19px;font-weight:700;line-height:1.2}.gc-cons-pros__title--pros{color:#58c649}.gc-cons-pros__title--cons{color:#f24f4f}.gc-cons-pros__list{margin:0 0 15px 0!important;padding:0!important;list-style:none!important}@media only screen and (min-width:768px){.gc-cons-pros__list{margin:0}}.gc-cons-pros__item{list-style:none !important;margin:0 0 12px 0!important;position:relative;padding-right:30px;font-size:16px;line-height:20px}.gc-pros__item svg{height:20px;width:20px;margin:0 10px 6px 0;vertical-align:text-top}.gc-cons__item svg{height:16px;width:16px;margin:0 10px 6px 0;vertical-align:middle}';
    } elseif ($name == 'numberheadingfrontcss') {
        $css = '.gc-numhead{align-items:center;display:flex;flex-wrap:wrap;margin-bottom:30px}@media only screen and (min-width:480px){.gc-numhead{flex-wrap:nowrap}}.gc-numhead__title{margin:0!important}.gc-numhead__sub{line-height:20px;margin-top:5px;opacity:.5}.gc-numhead__circle{border:3px solid #111;border-radius:50%;box-sizing:content-box;display:inline-block;font-size:23px;font-weight:700;height:40px;line-height:40px;margin-right:19px;min-width:40px;text-align:center;width:40px}.gc-numhead__position{color:#d3d3d3;font-size:70px;font-weight:700;line-height:1;margin-right:19px}.gc-numhead__position span{line-height:.78}.gc-numhead__position span:after{content:"."}.gc-numhead__logo{margin-left:auto;margin-top:18px;width:100%}@media only screen and (min-width:480px){.gc-numhead__logo{margin-top:0;width:auto}}.gc-numhead__logo img{max-height:60px;width:auto!important}.gc-numhead__logo-cont{display:inline-block;max-height:60px;max-width:150px}.gc-numhead__mcenter{display:block;text-align:center}@media only screen and (min-width:480px){.gc-numhead__mcenter{display:flex;text-align:inherit}}.gc-numhead__mcenter .gc-numhead__circle{margin-bottom:15px;margin-right:0}@media only screen and (min-width:480px){.gc-numhead__mcenter .gc-numhead__circle{margin-bottom:0;margin-right:19px}}.gc-numhead__mcenter .gc-numhead__position{margin-bottom:15px;margin-right:0}@media only screen and (min-width:480px){.gc-numhead__mcenter .gc-numhead__position{margin-bottom:0;margin-right:19px}}';
    } elseif ($name == 'prosboxfrontcss') {
        $css = '.gc-prcs-box{overflow:visible}@media only screen and (min-width:768px){.gc-prcs-box{display:flex}}.gc-prcs-box__col{width:100%;float:none;margin-right:0;margin-bottom:20px;background-color:#fff}@media only screen and (min-width:768px){.gc-prcs-box__col{position:relative;float:left;width:48%;margin-right:4%}}@media only screen and (min-width:768px){.gc-prcs-box__col:last-of-type{margin-right:0;clear:right}}.gc-prcs-box__title{margin:0 0 10px 0;font-size:19px;font-weight:700;line-height:1.2;padding:20px;color:#fff;fill:#fff}.gc-prcs-box__title--pros{background:#58c649}.gc-prcs-box__title--cons{background:#f24f4f}.gc-prcs-box__title svg{width:20px;margin-right:10px}.gc-prcs-box__list{margin:0!important;padding:20px!important;list-style:none!important}.gc-prcs-box__item{list-style:none!important;margin:0 0 15px 0!important;position:relative;padding-right:30px;font-size:16px;line-height:20px}.gc-prcs-box .gcbox-pros__item>svg{height:20px;width:20px;margin:0 10px 6px 0;vertical-align:text-top}.gc-prcs-box .gcbox-cons__item>svg{height:16px;width:16px;margin:0 10px 6px 0;vertical-align:middle}';
    } elseif ($name == 'howtofrontcss') {
        $css = '.gc-howto{margin:45px 0 30px 0;border:3px solid #e7e4df;border-top:none;position:relative;counter-reset:gchowto}.gc-howto__heading{font-size:19px;font-weight:700;line-height:20px;padding:0 15px;text-transform:uppercase}.gc-howto__title{display:flex;align-items:center;position:absolute;width:100%;top:-10px;height:22px}.gc-howto__line{flex-grow:1;height:3px;background-color:#e7e4df}.gc-howto__description{padding:35px 25px 25px 25px}.gc-howtoitem__step{position:relative;counter-increment:gchowto;padding:18px 25px}.gc-howtoitem__heading{font-weight:700;font-size:20px;line-height:24px;margin:0 0 25px 0;padding:0 0 0 50px;position:relative}.gc-howtoitem__heading:before{content:counter(gchowto);color:#fcd000;font-size:1.5rem;font-weight:700;position:absolute;--size:32px;line-height:var(--size);width:var(--size);height:var(--size);top:-5px;left:0;background:#000;border-radius:50%;text-align:center}.gc-howtoitem__content{font-size:16px;line-height:24px}';
    } elseif ($name == 'gc-video') {
        $css = '.gc-video{position:relative;margin-bottom:30px;max-width:100%}.gc-video.vimeo:not(.alignwide):not(.alignfull),.gc-video.youtube:not(.alignwide):not(.alignfull){width:100%!important;height:auto!important}.gc-video-wrapper{position:relative;height:inherit}.gc-video-wrapper:before{content:"";display:block;padding-top:56.25%}.gc-video-header{text-align:center}.gc-video-header .gc-video-header-title{font-size:24px;line-height:1.3;font-weight:700;margin:0 0 15px}.gc-video-header .gc-video-header-description{font-size:16px;line-height:1.5;margin:0 0 25px}.gc-video .gc-video-element,.gc-video .gc-video-element iframe{position:absolute;left:0;top:0;width:100%;height:100%;object-fit:cover;border:0}.gc-video .gc-video-element{object-fit:contain}.gc-video .video-container{position:absolute;left:0;top:0;width:100%;height:100%;padding:0;margin:0}.gc-video .video-container iframe{display:block;height:100%;width:100%}.gc-video-overlay{position:absolute;left:0;top:0;width:100%;height:100%;z-index:3;background-color:rgba(0,0,0,.1);background-size:cover;background-position:center;background-repeat:no-repeat;cursor:pointer}.gc-video-overlay .gc-play-icon{position:absolute;left:50%;top:50%;transform:translate(-50%,-50%);transition:all .3s ease;opacity:.8;z-index:3;width:32px;height:44px;border-radius:50%;padding:18px 20px 18px 28px;box-sizing:content-box}.gc-video-overlay .gc-play-icon span{display:block;position:relative;z-index:3;width:0;height:0;border-left:32px solid #fff;border-top:22px solid transparent;border-bottom:22px solid transparent}.gc-video-overlay .gc-play-icon:after{animation-delay:.5s}.gc-video-overlay .gc-overlay-color{position:absolute;left:0;top:0;width:100%;height:100%}.gc-video-overlay:hover .gc-play-icon{opacity:1}.gc-video-popup .slbContentOuter{width:100%;max-width:1000px}.gc-video-popup .slbContentOuter .slbContent:before{content:"";display:block;padding-top:56.25%}.gc-video-popup .slbContentOuter .slbContent .video-container,.gc-video-popup .slbContentOuter .slbContent iframe,.gc-video-popup .slbContentOuter .slbContent video{position:absolute;left:0;top:0;width:100%;height:100%;object-fit:cover}.gc-video-popup .slbCloseBtn{font-size:30px;width:40px;height:40px;line-height:40px;right:0;top:-50px}@keyframes pulsevideobutton{0%{transform:scale(.5);opacity:0}50%{opacity:1}100%{transform:scale(1.2);opacity:0}}';
    } elseif ($name == 'gccountdowncss') {
        $css = '.gc-countdownwrap{display:flex;align-items:center}.gc-countdownwrap .gc-countdown{display:flex;text-align:center}.gc-countdownwrap .gc-countdown__item{margin:0 .5rem;padding:10px 15px;border-radius:9px;background-color:#c3cfe2;color:#f5f7fa;display:flex;justify-content:center;font-family:Helvetica,sans-serif;font-size:80px;align-items:center}.gc-countdownwrap .gc-countdown__colon{display:flex;flex-direction:column;justify-content:space-evenly;padding:0 0 20px 0}.gc-countdownwrap .gc-countdown__colon-item{width:1rem;height:1rem;background-color:#f5f7fa;border-radius:50%}';
    }
    elseif ($name == 'gccountdowncss') {
        $css = '.gc-countdownwrap{display:flex;align-items:center}.gc-countdownwrap .gc-countdown{display:flex;text-align:center}.gc-countdownwrap .gc-countdown__item{margin:0 .5rem;padding:10px 15px;border-radius:9px;background-color:#c3cfe2;color:#f5f7fa;display:flex;justify-content:center;font-family:Helvetica,sans-serif;font-size:80px;align-items:center}.gc-countdownwrap .gc-countdown__colon{display:flex;flex-direction:column;justify-content:space-evenly;padding:0 0 20px 0}.gc-countdownwrap .gc-countdown__colon-item{width:1rem;height:1rem;background-color:#f5f7fa;border-radius:50%}';
    } elseif ($name == 'gccountercss') {
        $css = '.gc-counterwrap {display: flex;align-items: center;}
        .gc-counterwrap .gc-counterdiv {display: flex;text-align: center;flex-direction: column;}
        .gc-counterwrap .gc-counterdiv .gc-counter {display: flex;justify-content: center;align-items: center;}';
    } elseif ($name == 'gcaligncss') {
        $css = '.gc-alignleft{justify-content:flex-start}.gc-alignright{justify-content:flex-end}.gc-aligncenter{justify-content:center}';
    } elseif ($name == 'gccontenttogglercss') {
        $css = '.gc-toggler-open{height:auto !important}.gc-toggler-open .gc-tgl-show, .gc-toggler-open .gc-tgl-grad{display:none !important}.gc-toggler-open .gc-tgl-hide{display:block !important}.gc-tgl-show, .gc-tgl-hide{cursor:pointer}.gc-contenttoggler *{box-sizing: border-box !important}.gc-toggler-wrapper{overflow: hidden;transition: all 0.5s ease; padding-bottom: 35px; margin-bottom:30px;box-sizing: content-box !important;position: relative;}.gc-toggler-wrapper p:last-of-type {margin-bottom: 0;}';
    }elseif($name == 'swiperfrontcss'){
        $css = gc_filesystem('get_content', GUTENCON_PLUGIN_URL.'assets/swiper/swiper-bundle.min.css');
    }elseif($name == 'gcgutslidercss'){
        $css = gc_filesystem('get_content', GUTENCON_PLUGIN_URL.'assets/slider/slider.css');
    }

    return $css;
}
