<?php
if (!defined('ABSPATH')) {
	wp_die();
}
echo '<style>
.wrap{background:white;max-width: 900px;margin: 2.5em auto;border: 1px solid #dbdde2;box-shadow: 0 10px 20px #ececec; text-align:center}
.wrap .notice, .wrap .error{display:none}
.wrap h2{font-size:2em; margin-bottom:1em; font-weight:bold}
.gc-introtext{font-size:15px; margin: 0 auto 50px auto; padding: 0 50px}
.gc-intro-form{margin-bottom:50px;display: flex;justify-content: center; overflow:hidden}
.wrap h1{text-align: left;padding: 15px 20px;margin: -1px -1px 10px -1px;font-size: 13px;font-weight: bold;text-transform: uppercase;box-shadow: 0 3px 8px rgb(0 0 0 / 5%);}
.gc-padd {padding:25px}
.gc-intro-form input {padding: 10px 15px;width: 30%;margin-right: 20px;float: left;}
.gc-intro-form .button-large{font-size:17px; font-weight: bold}
.gc-intro-wrapper{padding: 30px; border: 1px solid #eee}
.gc-intro-wrapper p{font-size:15px;  margin: 0 0 1em 0}
.gc-intro-wrapper p.about-description{font-size:18px}
</style>';
$gc_options = get_option('GC_Key');
$cc_username = isset($gc_options['cc_username']) ? $gc_options['cc_username'] : '';
$cc_purchase_code = isset($gc_options['cc_purchase_code']) ? $gc_options['cc_purchase_code'] : '';

require_once('lhelper.php');
// Create a new LicenseBoxAPI helper class.
$lbapi = new GCLicenseBoxAPI();

// Performs background license check, pass TRUE as 1st parameter to perform periodic verifications only.
$registeredlicense = false;
if ($cc_username && $cc_purchase_code) {
	$lb_verify_res = $lbapi->verify_license(true, sanitize_text_field($cc_purchase_code), sanitize_text_field($cc_username));
	if (!empty($lb_verify_res['status'])) {
		$registeredlicense = true;
	}
}

$lb_deactivate_res = $activationmessage = $deactivationmessage = $lb_activate_res = null;

if (!empty($_POST['client_name']) && !empty($_POST['license_code'])) {
	check_admin_referer('lb_update_license', 'lb_update_license_sec');
	$licode = sanitize_text_field(trim($_POST['license_code']));
	$liuser = sanitize_text_field(trim($_POST['client_name']));
	$lb_verify_res = $lbapi->verify_license(false, $licode, $liuser);

	if (empty($lb_verify_res['status'])) {
		$lb_activate_res = $lbapi->activate_license($licode, $liuser, false);
	}

	if (!empty($lb_activate_res['status']) || !empty($lb_verify_res['status'])) {
		$gc_options = array('cc_username' => $liuser, 'cc_purchase_code' => $licode);
		update_option('GC_Key', $gc_options);
		$cc_username = $liuser;
		$cc_purchase_code = $licode;
		$registeredlicense = true;
	} else {
		$activationmessage = $lb_activate_res['message'];
		$registeredlicense = false;
	}
}
if (!empty($_POST['lb_deactivate'])) {
	if (empty($cc_purchase_code)) {
		$cc_purchase_code = trim($_POST['deactivate_license_code']);
	}
	if (empty($cc_username)) {
		$cc_username = trim($_POST['deactivate_client_name']);
	}
	check_admin_referer('lb_deactivate_license', 'lb_deactivate_license_sec');
	$lb_deactivate_res = $lbapi->deactivate_license(sanitize_text_field($cc_purchase_code), sanitize_text_field($cc_username));
	if (!empty($lb_deactivate_res['status'])) {
		delete_option('GC_Key');
		$cc_purchase_code = $cc_username = '';
		$registeredlicense = false;
	} else {
		$deactivationmessage = $lb_deactivate_res['message'];
	}
}
echo '<div class="wrap"><h1>' . esc_html__('Register your copy', 'gutencon') . '</h1><div class="gc-padd">';
?>
<h2><?php esc_html_e('Welcome to Gutencon', 'gutencon'); ?></h2>
<p class="gc-introtext">
	<?php if ($registeredlicense == true) : ?>
	<?php esc_html_e("Plugin is registered on your site! ", "gutencon"); ?>
	<?php if (!function_exists('envato_market')) : ?>
		<?php esc_html_e("If you need automatic updates of all your Envato plugins, install and activate Envato Market plugin from ", "gutencon"); ?>
		<a href="<?php echo admin_url('admin.php?page=gutenconbonus'); ?>"><?php esc_html_e("Bonus Section", "gutencon"); ?></a>. <?php esc_html_e("If you have broken styles of blocks on your site, disable conditional style loading in global settings of plugin", "gutencon"); ?>

	<?php endif; ?>
<?php else : ?>
	<?php esc_html_e("Please, activate your license to get support, updates, ready presets and bonus addons", "gutencon"); ?>
	<a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-" target="_blank"><?php esc_html_e("How to find purchase code", "gutencon"); ?></a>
<?php endif; ?>
</p>
<div class="gc-intro-wrapper">
	<?php if (!$registeredlicense) : ?>
		<?php if (!empty($deactivationmessage)) : ?>
			<p style="color: red; clear:both"><?php echo esc_attr($deactivationmessage); ?></p>
		<?php endif; ?>
		<?php if (!empty($activationmessage)) : ?>
			<p style="color: red; clear:both"><?php echo esc_attr($activationmessage); ?></p>
			<?php if (stripos($activationmessage, 'License is already active on maximum') === 0 && $licode && $liuser) : ?>
				<style>
					.gc-activate-form {
						display: none;
					}
				</style>
				<p>
					<span><strong style="color:red"><?php esc_html_e("One license can be active only on one site.", "gutencon"); ?></strong><br><?php esc_html_e("You can use extension packs to add more sites. After purchase, please, use this", "gutencon"); ?> <a href="https://wpsoul.com/extended-license-request/" target="_blank"><?php esc_html_e('Request form', 'gutencon'); ?></a> <?php esc_html_e("and provide list of purchased licenses which you want to extend. Please, note that all your purchased licenses must be activated on sites before sending request for bonus pack.", "gutencon"); ?></span><br>
				</p>
				<div style=" margin-top:20px; border-radius:15px; display:flex; text-align:left">
					<div style="border:1px solid #eee; padding:15px 12px;flex-grow:1;">
						<a href="https://codecanyon.net/item/gutencon-marketing-and-seo-booster-listing-and-review-builder-for-gutenberg/32621214" target="_blank" style="color:#444; text-decoration:none">
							<div style="float: left;margin-bottom: 5px;margin-right: 14px;"><svg enable-background="new 0 0 24 24" height="40" viewBox="0 0 24 24" width="40" xmlns="http://www.w3.org/2000/svg" fill="#ff9800">
									<path d="m22.5 12h-21c-.827 0-1.5-.673-1.5-1.5v-4c0-.827.673-1.5 1.5-1.5h21c.827 0 1.5.673 1.5 1.5v4c0 .827-.673 1.5-1.5 1.5zm-21-6c-.275 0-.5.224-.5.5v4c0 .276.225.5.5.5h21c.275 0 .5-.224.5-.5v-4c0-.276-.225-.5-.5-.5z" />
									<path d="m19.5 24h-15c-1.379 0-2.5-1.122-2.5-2.5v-10c0-.276.224-.5.5-.5s.5.224.5.5v10c0 .827.673 1.5 1.5 1.5h15c.827 0 1.5-.673 1.5-1.5v-10c0-.276.224-.5.5-.5s.5.224.5.5v10c0 1.378-1.121 2.5-2.5 2.5z" />
									<path d="m12 24c-.276 0-.5-.224-.5-.5v-12c0-.276.224-.5.5-.5s.5.224.5.5v12c0 .276-.224.5-.5.5z" />
									<path d="m12 6c-.036 0-.072-.004-.108-.012-.63-.14-3.817-.879-4.659-1.721-.473-.471-.733-1.099-.733-1.767s.26-1.296.732-1.768c.975-.975 2.561-.975 3.535 0 .842.841 1.581 4.029 1.721 4.66.037.167-.014.341-.135.461-.094.095-.222.147-.353.147zm-3-4.999c-.384 0-.769.146-1.061.438-.283.284-.439.66-.439 1.061s.156.777.439 1.061c.389.389 2.015.914 3.385 1.264-.351-1.37-.875-2.996-1.264-3.385-.291-.293-.676-.439-1.06-.439z" />
									<path d="m12 6c-.131 0-.259-.052-.354-.146-.121-.121-.172-.295-.135-.461.14-.631.879-3.818 1.721-4.66.975-.976 2.561-.974 3.535 0 .473.471.733 1.099.733 1.767s-.26 1.296-.732 1.768c-.842.842-4.029 1.581-4.659 1.721-.037.007-.073.011-.109.011zm3-4.999c-.384 0-.769.146-1.061.438-.389.389-.913 2.015-1.264 3.385 1.37-.35 2.996-.875 3.385-1.264.284-.283.44-.659.44-1.06s-.156-.777-.439-1.061c-.292-.292-.677-.438-1.061-.438zm-1.414.085h.01z" />
								</svg></div>
							<div style="font-size:18px;font-weight:bold">Buy 2 licenses</div>
							<div style="font-size:15px; margin-top:8px;">and Get <strong style="color:#8234e4">5</strong> allowed sites</div>
						</a>
					</div>
					<div style="border:1px solid #eee; padding:15px 12px;flex-grow:1;margin:0 15px">
						<a href="https://codecanyon.net/item/gutencon-marketing-and-seo-booster-listing-and-review-builder-for-gutenberg/32621214" target="_blank" style="color:#444; text-decoration:none">
							<div style="float: left;font-size: 40px;margin-bottom: 5px;margin-right: 14px;color: #ff9800;"><svg fill="#ff9800" height="40" viewBox="0 0 512.019 512.019" width="40" xmlns="http://www.w3.org/2000/svg">
									<g>
										<g>
											<g>
												<path d="m484.534 89.03c-1.158-12.986-11.863-22.779-24.901-22.779h-64.68v-9.532h1.259c9.236 0 16.75-7.514 16.75-16.749v-23.221c0-9.235-7.514-16.749-16.75-16.749h-190.37c-4.142 0-7.5 3.357-7.5 7.5s3.358 7.5 7.5 7.5h190.37c.965 0 1.75.784 1.75 1.749v23.221c0 .965-.785 1.749-1.75 1.749h-280.406c-.965 0-1.75-.784-1.75-1.749v-23.221c0-.965.785-1.749 1.75-1.749h54.871c4.142 0 7.5-3.357 7.5-7.5s-3.358-7.5-7.5-7.5h-54.871c-9.236 0-16.75 7.514-16.75 16.749v23.221c0 9.235 7.514 16.749 16.75 16.749h1.259v9.532h-64.68c-13.038 0-23.743 9.793-24.901 22.779-.152 1.698-3.522 42.121 13.031 86.891 15.145 40.962 49.891 93.264 129.501 113.79 12.816 10.126 27.45 18.05 43.327 23.185l3.775 6.231c7.135 11.779 10.906 25.704 10.906 40.269 0 8.897-1.418 17.589-4.214 25.832l-5.242 15.448h-17.441c-17.898 0-32.46 14.562-32.46 32.461v15.711h-27.296c-7.703 0-13.97 6.268-13.97 13.971v35.23c0 7.703 6.267 13.97 13.97 13.97h229.277c7.703 0 13.97-6.267 13.97-13.97v-35.23c0-7.703-6.267-13.971-13.97-13.971h-27.296v-15.711c0-17.899-14.562-32.461-32.46-32.461h-17.441l-5.242-15.448c-2.797-8.242-4.215-16.934-4.215-25.832 0-14.564 3.771-28.489 10.906-40.269l3.775-6.231c15.877-5.135 30.51-13.058 43.327-23.185 79.61-20.526 114.356-72.828 129.501-113.79 16.553-44.77 13.183-85.192 13.031-86.891zm-364.692 119.324c-13.984-13.092-24.697-29.333-32.024-48.69-5.091-13.45-8.423-28.053-9.906-43.413h39.153v64.412c0 9.48.959 18.74 2.777 27.691zm-65.257-37.634c-15.395-41.638-12.299-78.796-12.16-80.357.463-5.194 4.745-9.111 9.96-9.111h64.68v20h-39.774c-4.052 0-7.94 1.717-10.668 4.711-2.731 2.998-4.081 7.034-3.704 11.074 1.579 16.923 5.236 33.052 10.87 47.938 11.127 29.398 29.138 52.353 53.792 68.695 4.851 11.708 11.258 22.614 18.964 32.459-54.338-22.523-79.929-62.871-91.96-95.409zm315.033 293.128v33.171h-227.218v-33.171zm-58.726-48.172c9.627 0 17.46 7.833 17.46 17.461v15.711h-144.685v-15.711c0-9.628 7.833-17.461 17.46-17.461zm-36.887-25.628 3.606 10.628h-43.205l3.607-10.629c3.324-9.799 5.01-20.111 5.01-30.651 0-14.753-3.297-28.996-9.567-41.629 7.343 1.204 14.874 1.84 22.553 1.84 7.678 0 15.21-.636 22.552-1.84-6.27 12.633-9.567 26.876-9.567 41.629.001 10.541 1.686 20.853 5.011 30.652zm-17.996-85.442c-68.343 0-123.944-55.601-123.944-123.943v-123.944h247.888v123.944c0 68.343-55.601 123.943-123.944 123.943zm201.425-133.886c-12.031 32.539-37.623 72.891-91.964 95.414 7.72-9.863 14.137-20.79 18.992-32.522 21.169-14.057 37.472-32.989 48.698-56.695 1.773-3.743.175-8.216-3.568-9.988-3.742-1.772-8.214-.176-9.988 3.568-6.95 14.677-16.116 27.322-27.434 37.903 1.824-8.965 2.785-18.24 2.785-27.736v-64.412h39.153c-.746 7.717-1.986 15.37-3.687 22.758-.929 4.037 1.59 8.063 5.627 8.991 4.033.934 8.062-1.589 8.991-5.626 1.894-8.229 3.26-16.754 4.062-25.338.377-4.04-.973-8.076-3.704-11.074-2.728-2.994-6.616-4.711-10.668-4.711h-39.774v-20h64.68c5.215 0 9.497 3.917 9.96 9.112.137 1.56 3.233 38.718-12.161 80.356z" />
												<path d="m305.328 145.663-21.506-3.125c-.937-.137-1.746-.725-2.165-1.573l-9.618-19.488c-3.033-6.146-9.175-9.964-16.029-9.964s-12.996 3.818-16.029 9.964l-9.618 19.488c-.419.849-1.228 1.437-2.165 1.573l-21.506 3.125c-6.783.985-12.312 5.646-14.43 12.165s-.385 13.54 4.523 18.325l15.562 15.168c.678.661.987 1.612.827 2.546l-3.674 21.42c-1.159 6.755 1.566 13.453 7.111 17.482 5.544 4.027 12.758 4.55 18.826 1.361l19.235-10.113c.838-.441 1.838-.441 2.676 0l19.236 10.113c2.639 1.387 5.494 2.072 8.334 2.072 3.691 0 7.358-1.157 10.491-3.434 5.545-4.029 8.27-10.728 7.111-17.482l-3.674-21.42c-.16-.934.149-1.885.827-2.545l15.563-15.17c4.908-4.784 6.641-11.806 4.523-18.324s-7.649-11.179-14.431-12.164zm-.563 19.748-15.563 15.17c-4.213 4.107-6.135 10.021-5.141 15.821l3.674 21.42c.263 1.533-.604 2.42-1.144 2.813-.539.393-1.651.945-3.028.219l-19.236-10.113c-2.604-1.369-5.461-2.054-8.318-2.054s-5.714.685-8.318 2.054l-19.235 10.113c-1.376.725-2.488.173-3.029-.219-.54-.393-1.406-1.279-1.144-2.813l3.674-21.42c.995-5.8-.927-11.714-5.141-15.822l-15.562-15.168c-1.114-1.086-.935-2.313-.728-2.948.206-.635.782-1.733 2.321-1.957l21.506-3.125c5.824-.847 10.855-4.502 13.459-9.778l9.618-19.488c.688-1.395 1.911-1.603 2.578-1.603s1.89.208 2.578 1.603l9.618 19.488c2.604 5.276 7.635 8.932 13.459 9.778l21.507 3.125c1.539.224 2.115 1.322 2.321 1.957.208.635.387 1.862-.726 2.947z" />
											</g>
										</g>
									</g>
								</svg></div>
							<div style="font-size:18px;font-weight:bold">Buy 3 licenses</div>
							<div style="font-size:15px; margin-top:8px">and Get <strong style="color:#8234e4">15</strong> allowed sites</div>
						</a>
					</div>
					<div style="border:1px solid #eee; padding:15px 12px;flex-grow:1;">
						<a href="https://codecanyon.net/item/gutencon-marketing-and-seo-booster-listing-and-review-builder-for-gutenberg/32621214" target="_blank" style="color:#444; text-decoration:none">
							<div style="float: left;margin-bottom: 5px;margin-right: 14px;"><svg height="40px" viewBox="0 -83 436.90667 436" width="40px" xmlns="http://www.w3.org/2000/svg" fill="#ff9800">
									<path d="m368.640625 214.855469h-300.375c-2.917969 0-5.511719-1.855469-6.457031-4.613281l-44.902344-130.964844c-1.21875-3.570313.679688-7.449219 4.246094-8.675782 1.09375-.371093 2.234375-.464843 3.292968-.277343 2.46875.144531 4.769532 1.636719 5.835938 4.058593 5.550781 12.605469 25.296875 53.300782 48.332031 53.300782.285157 0 .574219-.007813.867188-.023438 13.894531-.617187 35.625-16.652344 60.246093-89.496094.941407-2.773437 3.539063-4.640624 6.464844-4.640624 2.929688 0 5.527344 1.867187 6.46875 4.640624 8.40625 24.839844 36.582032 89.117188 65.839844 89.117188.078125 0 .152344-.003906.234375-.003906 13.871094-.167969 35.199219-15.734375 58.039063-88.960938.894531-2.855468 3.53125-4.792968 6.519531-4.792968h.066406c3.015625.03125 5.652344 2.03125 6.488281 4.925781 6.980469 24.039062 31.738282 87.003906 62.105469 89.632812 17.742187 1.460938 37.414063-18.617187 56.835937-58.277343 1.578126-3.238282 5.414063-4.695313 8.746094-3.308594 3.324219 1.378906 5.011719 5.105468 3.847656 8.519531l-46.28125 135.226563c-.949218 2.761718-3.542968 4.613281-6.460937 4.613281zm-295.5-13.652344h290.617187l26.746094-78.148437c-12.925781 13.679687-26.050781 19.78125-39.738281 18.632812-33.632813-2.925781-56.710937-51.390625-67.441406-79.878906-18.953125 52.90625-40.113281 78.832031-64.433594 79.117187-.132813 0-.257813.007813-.390625.007813-33.988281 0-60.226562-52.105469-72.113281-80.847656-20.28125 53.519531-42.046875 80.128906-66.300781 81.214843-12.433594.480469-23.261719-5.714843-32.585938-14.90625zm0 0" />
									<path d="m368.640625 269.46875h-300.375c-3.773437 0-6.824219-3.054688-6.824219-6.828125v-54.613281c0-3.773438 3.050782-6.824219 6.824219-6.824219s6.828125 3.050781 6.828125 6.824219v47.789062h286.71875v-47.789062c0-3.773438 3.054688-6.824219 6.828125-6.824219s6.824219 3.050781 6.824219 6.824219v54.613281c0 3.773437-3.050782 6.828125-6.824219 6.828125zm0 0" />
									<path d="m149.011719 47.175781c-12.878907 0-23.359375-10.480469-23.359375-23.363281 0-12.878906 10.480468-23.359375 23.359375-23.359375 12.882812 0 23.363281 10.484375 23.363281 23.363281s-10.480469 23.359375-23.363281 23.359375zm0-33.066406c-5.351563 0-9.707031 4.355469-9.707031 9.707031 0 5.355469 4.355468 9.707032 9.707031 9.707032 5.355469 0 9.707031-4.355469 9.707031-9.707032 0-5.355468-4.351562-9.707031-9.707031-9.707031zm0 0" />
									<path d="m281.277344 47.175781c-12.878906 0-23.359375-10.480469-23.359375-23.363281 0-12.878906 10.480469-23.359375 23.359375-23.359375 12.882812 0 23.363281 10.484375 23.363281 23.363281s-10.480469 23.359375-23.363281 23.359375zm0-33.066406c-5.351563 0-9.707032 4.355469-9.707032 9.707031 0 5.355469 4.355469 9.707032 9.707032 9.707032 5.355468 0 9.710937-4.351563 9.710937-9.707032 0-5.351562-4.355469-9.707031-9.710937-9.707031zm0 0" />
									<path d="m413.546875 80.242188c-12.882813 0-23.363281-10.480469-23.363281-23.359376 0-12.878906 10.480468-23.359374 23.363281-23.359374 12.878906 0 23.359375 10.480468 23.359375 23.359374 0 12.878907-10.480469 23.359376-23.359375 23.359376zm0-33.066407c-5.355469 0-9.707031 4.351563-9.707031 9.707031 0 5.355469 4.351562 9.707032 9.707031 9.707032 5.351563 0 9.707031-4.351563 9.707031-9.707032 0-5.355468-4.355468-9.707031-9.707031-9.707031zm0 0" />
									<path d="m23.359375 80.242188c-12.878906 0-23.359375-10.480469-23.359375-23.359376 0-12.878906 10.480469-23.359374 23.359375-23.359374 12.882813 0 23.363281 10.480468 23.363281 23.359374 0 12.878907-10.484375 23.359376-23.363281 23.359376zm0-33.066407c-5.351563 0-9.707031 4.351563-9.707031 9.707031 0 5.355469 4.355468 9.707032 9.707031 9.707032 5.355469 0 9.710937-4.351563 9.710937-9.707032 0-5.355468-4.355468-9.707031-9.710937-9.707031zm0 0" />
								</svg></div>
							<div style="font-size:18px;font-weight:bold">Buy Extended</div>
							<div style="font-size:15px; margin-top:8px;">and Get <strong style="color:#8234e4">100</strong> allowed sites</div>
						</a>
					</div>
				</div>
				<p style="clear:both;color:green"><?php esc_html_e("You can use form below to deactivate your license on all of your existed activated sites.", "gutencon"); ?>  </p>
				<div class="gc-intro-form">
					<form action="" method="post">
						<?php wp_nonce_field('lb_deactivate_license', 'lb_deactivate_license_sec'); ?>

						<input type="text" name="deactivate_client_name" size="50" placeholder="<?php esc_html_e("Codecanyon Username", "gutencon"); ?>" required value="<?php echo esc_attr($cc_username); ?>">
						<input type="text" name="deactivate_license_code" size="50" placeholder="<?php esc_html_e("Enter Codecanyon Purchase Code", "gutencon"); ?>" required value="<?php echo esc_attr($cc_purchase_code); ?>">
						<input type="hidden" name="lb_deactivate" value="yes">
						<input type="submit" value="<?php esc_html_e("Deactivate", "gutencon"); ?>" class="button button-large button-primary gc-large-button">
					</form>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		<div class="gc-intro-form gc-activate-form">
			<form action="" method="post">
				<?php wp_nonce_field('lb_update_license', 'lb_update_license_sec'); ?>
				<input type="text" name="client_name" size="50" placeholder="<?php esc_html_e("Codecanyon Username", "gutencon"); ?>" required value="<?php echo esc_attr($cc_username); ?>">
				<input type="text" name="license_code" size="50" placeholder="<?php esc_html_e("Enter Codecanyon Purchase Code", "gutencon"); ?>" required value="<?php echo esc_attr($cc_purchase_code); ?>">
				<input type="submit" value="<?php esc_html_e("Submit", "gutencon"); ?>" class="button button-large button-primary gc-large-button">
			</form>
		</div>
	<?php else : ?>
		<?php if (!empty($deactivationmessage)) : ?>
			<p style="color: red; clear:both"><?php echo esc_attr($deactivationmessage); ?></p>
		<?php endif; ?>
		<p class="about-description"><span class="dashicons dashicons-yes"></span><?php esc_html_e("Registration Complete! You have full access to plugin data now.", "gutencon"); ?></p>
		<div class="clear"></div>
		<p><?php esc_html_e("Next license is Active - ", "gutencon"); ?><span style="color: green"><?php echo esc_attr($cc_purchase_code); ?></span></p>
		<p>
			<span><strong style="color:red"><?php esc_html_e("One license can be active only on one site.", "gutencon"); ?></strong><br><?php esc_html_e("You can use extension packs to add more sites. After purchase, please, use this", "gutencon"); ?> <a href="https://wpsoul.com/extended-license-request/" target="_blank"><?php esc_html_e('Request form', 'gutencon'); ?></a> <?php esc_html_e("and provide list of purchased licenses which you want to extend. Please, note that all your purchased licenses must be activated on sites before sending request for bonus pack.", "gutencon"); ?></span><br>
		</p>
		<div style=" margin-top:40px; border-radius:15px; display:flex; text-align: left">
			<div style="border:1px solid #eee; padding:15px 12px;flex-grow:1;">
				<a href="https://codecanyon.net/item/gutencon-marketing-and-seo-booster-listing-and-review-builder-for-gutenberg/32621214" target="_blank" style="color:#444; text-decoration:none">
					<div style="float: left;font-size: 40px;margin-bottom: 5px;margin-right: 14px;color: #ff9800;"><svg enable-background="new 0 0 24 24" height="40" viewBox="0 0 24 24" width="40" xmlns="http://www.w3.org/2000/svg" fill="#ff9800">
							<path d="m22.5 12h-21c-.827 0-1.5-.673-1.5-1.5v-4c0-.827.673-1.5 1.5-1.5h21c.827 0 1.5.673 1.5 1.5v4c0 .827-.673 1.5-1.5 1.5zm-21-6c-.275 0-.5.224-.5.5v4c0 .276.225.5.5.5h21c.275 0 .5-.224.5-.5v-4c0-.276-.225-.5-.5-.5z" />
							<path d="m19.5 24h-15c-1.379 0-2.5-1.122-2.5-2.5v-10c0-.276.224-.5.5-.5s.5.224.5.5v10c0 .827.673 1.5 1.5 1.5h15c.827 0 1.5-.673 1.5-1.5v-10c0-.276.224-.5.5-.5s.5.224.5.5v10c0 1.378-1.121 2.5-2.5 2.5z" />
							<path d="m12 24c-.276 0-.5-.224-.5-.5v-12c0-.276.224-.5.5-.5s.5.224.5.5v12c0 .276-.224.5-.5.5z" />
							<path d="m12 6c-.036 0-.072-.004-.108-.012-.63-.14-3.817-.879-4.659-1.721-.473-.471-.733-1.099-.733-1.767s.26-1.296.732-1.768c.975-.975 2.561-.975 3.535 0 .842.841 1.581 4.029 1.721 4.66.037.167-.014.341-.135.461-.094.095-.222.147-.353.147zm-3-4.999c-.384 0-.769.146-1.061.438-.283.284-.439.66-.439 1.061s.156.777.439 1.061c.389.389 2.015.914 3.385 1.264-.351-1.37-.875-2.996-1.264-3.385-.291-.293-.676-.439-1.06-.439z" />
							<path d="m12 6c-.131 0-.259-.052-.354-.146-.121-.121-.172-.295-.135-.461.14-.631.879-3.818 1.721-4.66.975-.976 2.561-.974 3.535 0 .473.471.733 1.099.733 1.767s-.26 1.296-.732 1.768c-.842.842-4.029 1.581-4.659 1.721-.037.007-.073.011-.109.011zm3-4.999c-.384 0-.769.146-1.061.438-.389.389-.913 2.015-1.264 3.385 1.37-.35 2.996-.875 3.385-1.264.284-.283.44-.659.44-1.06s-.156-.777-.439-1.061c-.292-.292-.677-.438-1.061-.438zm-1.414.085h.01z" />
						</svg></div>
					<div style="font-size:18px;font-weight:bold">Buy 2 licenses</div>
					<div style="font-size:15px; margin-top:8px;">and Get <strong style="color:#8234e4">5</strong> allowed sites</div>
				</a>
			</div>
			<div style="border:1px solid #eee; padding:15px 12px;flex-grow:1;margin:0 15px">
				<a href="https://codecanyon.net/item/gutencon-marketing-and-seo-booster-listing-and-review-builder-for-gutenberg/32621214" target="_blank" style="color:#444; text-decoration:none">
					<div style="float: left;font-size: 40px;margin-bottom: 5px;margin-right: 14px;color: #ff9800;"><svg height="40" fill="#ff9800" viewBox="0 0 512.019 512.019" width="40" xmlns="http://www.w3.org/2000/svg">
							<g>
								<g>
									<g>
										<path d="m484.534 89.03c-1.158-12.986-11.863-22.779-24.901-22.779h-64.68v-9.532h1.259c9.236 0 16.75-7.514 16.75-16.749v-23.221c0-9.235-7.514-16.749-16.75-16.749h-190.37c-4.142 0-7.5 3.357-7.5 7.5s3.358 7.5 7.5 7.5h190.37c.965 0 1.75.784 1.75 1.749v23.221c0 .965-.785 1.749-1.75 1.749h-280.406c-.965 0-1.75-.784-1.75-1.749v-23.221c0-.965.785-1.749 1.75-1.749h54.871c4.142 0 7.5-3.357 7.5-7.5s-3.358-7.5-7.5-7.5h-54.871c-9.236 0-16.75 7.514-16.75 16.749v23.221c0 9.235 7.514 16.749 16.75 16.749h1.259v9.532h-64.68c-13.038 0-23.743 9.793-24.901 22.779-.152 1.698-3.522 42.121 13.031 86.891 15.145 40.962 49.891 93.264 129.501 113.79 12.816 10.126 27.45 18.05 43.327 23.185l3.775 6.231c7.135 11.779 10.906 25.704 10.906 40.269 0 8.897-1.418 17.589-4.214 25.832l-5.242 15.448h-17.441c-17.898 0-32.46 14.562-32.46 32.461v15.711h-27.296c-7.703 0-13.97 6.268-13.97 13.971v35.23c0 7.703 6.267 13.97 13.97 13.97h229.277c7.703 0 13.97-6.267 13.97-13.97v-35.23c0-7.703-6.267-13.971-13.97-13.971h-27.296v-15.711c0-17.899-14.562-32.461-32.46-32.461h-17.441l-5.242-15.448c-2.797-8.242-4.215-16.934-4.215-25.832 0-14.564 3.771-28.489 10.906-40.269l3.775-6.231c15.877-5.135 30.51-13.058 43.327-23.185 79.61-20.526 114.356-72.828 129.501-113.79 16.553-44.77 13.183-85.192 13.031-86.891zm-364.692 119.324c-13.984-13.092-24.697-29.333-32.024-48.69-5.091-13.45-8.423-28.053-9.906-43.413h39.153v64.412c0 9.48.959 18.74 2.777 27.691zm-65.257-37.634c-15.395-41.638-12.299-78.796-12.16-80.357.463-5.194 4.745-9.111 9.96-9.111h64.68v20h-39.774c-4.052 0-7.94 1.717-10.668 4.711-2.731 2.998-4.081 7.034-3.704 11.074 1.579 16.923 5.236 33.052 10.87 47.938 11.127 29.398 29.138 52.353 53.792 68.695 4.851 11.708 11.258 22.614 18.964 32.459-54.338-22.523-79.929-62.871-91.96-95.409zm315.033 293.128v33.171h-227.218v-33.171zm-58.726-48.172c9.627 0 17.46 7.833 17.46 17.461v15.711h-144.685v-15.711c0-9.628 7.833-17.461 17.46-17.461zm-36.887-25.628 3.606 10.628h-43.205l3.607-10.629c3.324-9.799 5.01-20.111 5.01-30.651 0-14.753-3.297-28.996-9.567-41.629 7.343 1.204 14.874 1.84 22.553 1.84 7.678 0 15.21-.636 22.552-1.84-6.27 12.633-9.567 26.876-9.567 41.629.001 10.541 1.686 20.853 5.011 30.652zm-17.996-85.442c-68.343 0-123.944-55.601-123.944-123.943v-123.944h247.888v123.944c0 68.343-55.601 123.943-123.944 123.943zm201.425-133.886c-12.031 32.539-37.623 72.891-91.964 95.414 7.72-9.863 14.137-20.79 18.992-32.522 21.169-14.057 37.472-32.989 48.698-56.695 1.773-3.743.175-8.216-3.568-9.988-3.742-1.772-8.214-.176-9.988 3.568-6.95 14.677-16.116 27.322-27.434 37.903 1.824-8.965 2.785-18.24 2.785-27.736v-64.412h39.153c-.746 7.717-1.986 15.37-3.687 22.758-.929 4.037 1.59 8.063 5.627 8.991 4.033.934 8.062-1.589 8.991-5.626 1.894-8.229 3.26-16.754 4.062-25.338.377-4.04-.973-8.076-3.704-11.074-2.728-2.994-6.616-4.711-10.668-4.711h-39.774v-20h64.68c5.215 0 9.497 3.917 9.96 9.112.137 1.56 3.233 38.718-12.161 80.356z" />
										<path d="m305.328 145.663-21.506-3.125c-.937-.137-1.746-.725-2.165-1.573l-9.618-19.488c-3.033-6.146-9.175-9.964-16.029-9.964s-12.996 3.818-16.029 9.964l-9.618 19.488c-.419.849-1.228 1.437-2.165 1.573l-21.506 3.125c-6.783.985-12.312 5.646-14.43 12.165s-.385 13.54 4.523 18.325l15.562 15.168c.678.661.987 1.612.827 2.546l-3.674 21.42c-1.159 6.755 1.566 13.453 7.111 17.482 5.544 4.027 12.758 4.55 18.826 1.361l19.235-10.113c.838-.441 1.838-.441 2.676 0l19.236 10.113c2.639 1.387 5.494 2.072 8.334 2.072 3.691 0 7.358-1.157 10.491-3.434 5.545-4.029 8.27-10.728 7.111-17.482l-3.674-21.42c-.16-.934.149-1.885.827-2.545l15.563-15.17c4.908-4.784 6.641-11.806 4.523-18.324s-7.649-11.179-14.431-12.164zm-.563 19.748-15.563 15.17c-4.213 4.107-6.135 10.021-5.141 15.821l3.674 21.42c.263 1.533-.604 2.42-1.144 2.813-.539.393-1.651.945-3.028.219l-19.236-10.113c-2.604-1.369-5.461-2.054-8.318-2.054s-5.714.685-8.318 2.054l-19.235 10.113c-1.376.725-2.488.173-3.029-.219-.54-.393-1.406-1.279-1.144-2.813l3.674-21.42c.995-5.8-.927-11.714-5.141-15.822l-15.562-15.168c-1.114-1.086-.935-2.313-.728-2.948.206-.635.782-1.733 2.321-1.957l21.506-3.125c5.824-.847 10.855-4.502 13.459-9.778l9.618-19.488c.688-1.395 1.911-1.603 2.578-1.603s1.89.208 2.578 1.603l9.618 19.488c2.604 5.276 7.635 8.932 13.459 9.778l21.507 3.125c1.539.224 2.115 1.322 2.321 1.957.208.635.387 1.862-.726 2.947z" />
									</g>
								</g>
							</g>
						</svg></div>
					<div style="font-size:18px;font-weight:bold">Buy 3 licenses</div>
					<div style="font-size:15px; margin-top:8px">and Get <strong style="color:#8234e4">15</strong> allowed sites</div>
				</a>
			</div>
			<div style="border:1px solid #eee; padding:15px 12px;flex-grow:1;">
				<a href="https://codecanyon.net/item/gutencon-marketing-and-seo-booster-listing-and-review-builder-for-gutenberg/32621214" target="_blank" style="color:#444; text-decoration:none">
					<div style="float: left;margin-bottom: 5px;margin-right: 14px;"><svg height="40px" viewBox="0 -83 436.90667 436" width="40px" xmlns="http://www.w3.org/2000/svg" fill="#ff9800">
							<path d="m368.640625 214.855469h-300.375c-2.917969 0-5.511719-1.855469-6.457031-4.613281l-44.902344-130.964844c-1.21875-3.570313.679688-7.449219 4.246094-8.675782 1.09375-.371093 2.234375-.464843 3.292968-.277343 2.46875.144531 4.769532 1.636719 5.835938 4.058593 5.550781 12.605469 25.296875 53.300782 48.332031 53.300782.285157 0 .574219-.007813.867188-.023438 13.894531-.617187 35.625-16.652344 60.246093-89.496094.941407-2.773437 3.539063-4.640624 6.464844-4.640624 2.929688 0 5.527344 1.867187 6.46875 4.640624 8.40625 24.839844 36.582032 89.117188 65.839844 89.117188.078125 0 .152344-.003906.234375-.003906 13.871094-.167969 35.199219-15.734375 58.039063-88.960938.894531-2.855468 3.53125-4.792968 6.519531-4.792968h.066406c3.015625.03125 5.652344 2.03125 6.488281 4.925781 6.980469 24.039062 31.738282 87.003906 62.105469 89.632812 17.742187 1.460938 37.414063-18.617187 56.835937-58.277343 1.578126-3.238282 5.414063-4.695313 8.746094-3.308594 3.324219 1.378906 5.011719 5.105468 3.847656 8.519531l-46.28125 135.226563c-.949218 2.761718-3.542968 4.613281-6.460937 4.613281zm-295.5-13.652344h290.617187l26.746094-78.148437c-12.925781 13.679687-26.050781 19.78125-39.738281 18.632812-33.632813-2.925781-56.710937-51.390625-67.441406-79.878906-18.953125 52.90625-40.113281 78.832031-64.433594 79.117187-.132813 0-.257813.007813-.390625.007813-33.988281 0-60.226562-52.105469-72.113281-80.847656-20.28125 53.519531-42.046875 80.128906-66.300781 81.214843-12.433594.480469-23.261719-5.714843-32.585938-14.90625zm0 0" />
							<path d="m368.640625 269.46875h-300.375c-3.773437 0-6.824219-3.054688-6.824219-6.828125v-54.613281c0-3.773438 3.050782-6.824219 6.824219-6.824219s6.828125 3.050781 6.828125 6.824219v47.789062h286.71875v-47.789062c0-3.773438 3.054688-6.824219 6.828125-6.824219s6.824219 3.050781 6.824219 6.824219v54.613281c0 3.773437-3.050782 6.828125-6.824219 6.828125zm0 0" />
							<path d="m149.011719 47.175781c-12.878907 0-23.359375-10.480469-23.359375-23.363281 0-12.878906 10.480468-23.359375 23.359375-23.359375 12.882812 0 23.363281 10.484375 23.363281 23.363281s-10.480469 23.359375-23.363281 23.359375zm0-33.066406c-5.351563 0-9.707031 4.355469-9.707031 9.707031 0 5.355469 4.355468 9.707032 9.707031 9.707032 5.355469 0 9.707031-4.355469 9.707031-9.707032 0-5.355468-4.351562-9.707031-9.707031-9.707031zm0 0" />
							<path d="m281.277344 47.175781c-12.878906 0-23.359375-10.480469-23.359375-23.363281 0-12.878906 10.480469-23.359375 23.359375-23.359375 12.882812 0 23.363281 10.484375 23.363281 23.363281s-10.480469 23.359375-23.363281 23.359375zm0-33.066406c-5.351563 0-9.707032 4.355469-9.707032 9.707031 0 5.355469 4.355469 9.707032 9.707032 9.707032 5.355468 0 9.710937-4.351563 9.710937-9.707032 0-5.351562-4.355469-9.707031-9.710937-9.707031zm0 0" />
							<path d="m413.546875 80.242188c-12.882813 0-23.363281-10.480469-23.363281-23.359376 0-12.878906 10.480468-23.359374 23.363281-23.359374 12.878906 0 23.359375 10.480468 23.359375 23.359374 0 12.878907-10.480469 23.359376-23.359375 23.359376zm0-33.066407c-5.355469 0-9.707031 4.351563-9.707031 9.707031 0 5.355469 4.351562 9.707032 9.707031 9.707032 5.351563 0 9.707031-4.351563 9.707031-9.707032 0-5.355468-4.355468-9.707031-9.707031-9.707031zm0 0" />
							<path d="m23.359375 80.242188c-12.878906 0-23.359375-10.480469-23.359375-23.359376 0-12.878906 10.480469-23.359374 23.359375-23.359374 12.882813 0 23.363281 10.480468 23.363281 23.359374 0 12.878907-10.484375 23.359376-23.363281 23.359376zm0-33.066407c-5.351563 0-9.707031 4.351563-9.707031 9.707031 0 5.355469 4.355468 9.707032 9.707031 9.707032 5.355469 0 9.710937-4.351563 9.710937-9.707032 0-5.355468-4.355468-9.707031-9.710937-9.707031zm0 0" />
						</svg></div>
					<div style="font-size:18px;font-weight:bold">Buy Extended</div>
					<div style="font-size:15px; margin-top:8px;">and Get <strong style="color:#8234e4">100</strong> allowed sites</div>
				</a>
			</div>
		</div>
	<?php endif ?>
</div>


</div>
</div>