<?php
/**
 *  Copyright 2014 Taxamo, Ltd.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * $model.description$
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 *
 */
class Input_transaction_line {

  static $swaggerTypes = array(
      'custom_fields' => 'array[custom_fields]',
      'custom_id' => 'string',
      'product_type' => 'string',
      'quantity' => 'number',
      'unit_price' => 'number',
      'unit_of_measure' => 'string',
      'total_amount' => 'number',
      'tax_rate' => 'number',
      'line_key' => 'string',
      'amount' => 'number',
      'informative' => 'bool',
      'description' => 'string',
      'product_code' => 'string',
      'supply_date' => 'string',
      'tax_name' => 'string'

    );

  /**
  * Custom fields, stored as key-value pairs. This property is not processed and used mostly with Taxamo-built helpers.
  */
  public $custom_fields; // array[custom_fields]
  /**
  * Custom id, provided by ecommerce software.
  */
  public $custom_id; // string
  /**
  * Product type, according to dictionary /dictionaries/product_types. 
  */
  public $product_type; // string
  /**
  * Quantity Defaults to 1.
  */
  public $quantity; // number
  /**
  * Unit price.
  */
  public $unit_price; // number
  /**
  * Unit of measure.
  */
  public $unit_of_measure; // string
  /**
  * Total amount. Required if amount is not provided.
  */
  public $total_amount; // number
  /**
  * Tax rate, calculated by taxamo. Can be overwritten when informative field is true.
  */
  public $tax_rate; // number
  /**
  * Generated line key.
  */
  public $line_key; // string
  /**
  * Amount. Required if total amount is not provided.
  */
  public $amount; // number
  /**
  * If the line is provided for informative purposes. Such line can have :tax-rate and/or :tax-name - if not, API will calculate missing values according to product type and country of residence.
  */
  public $informative; // bool
  /**
  * Line contents description.
  */
  public $description; // string
  /**
  * Internal product code, used for invoicing for example.
  */
  public $product_code; // string
  /**
  * Date of supply in yyyy-MM-dd format.
  */
  public $supply_date; // string
  /**
  * Tax name, calculated by taxamo.  Can be overwritten when informative field is true.
  */
  public $tax_name; // string
  }

