<?php
/**
 * Custom - Results Page.
 * @version 1.0
 * @author Eyal Fitoussi
 */
?>
<?php
$disable_filters = vp_metabox('rehub_top_table.top_review_filter_disable');
$image_width = vp_metabox('rehub_top_table.image_width');    
$image_height = vp_metabox('rehub_top_table.image_height'); 
$disable_crop = vp_metabox('rehub_top_table.disable_crop');             
$order_choose = vp_metabox('rehub_top_table.top_review_choose');
$rating_circle = vp_metabox('rehub_top_table.top_review_circle');
$module_width = vp_metabox('rehub_top_table.top_review_width');
$module_pagination = vp_metabox('rehub_top_table.top_review_pagination');
$module_field_sorting = vp_metabox('rehub_top_table.top_review_field_sort');
$module_order = vp_metabox('rehub_top_table.top_review_order');
$first_column_enable = vp_metabox('rehub_top_table.first_column_enable');
$first_column_rank = vp_metabox('rehub_top_table.first_column_rank');
$last_column_enable = vp_metabox('rehub_top_table.last_column_enable');
$first_column_name = (vp_metabox('rehub_top_table.first_column_name') !='') ? esc_html(vp_metabox('rehub_top_table.first_column_name')) : esc_html__('Product', 'rehub-theme') ;
$last_column_name = (vp_metabox('rehub_top_table.last_column_name') !='') ? esc_html(vp_metabox('rehub_top_table.last_column_name')) : '' ;
$affiliate_link = vp_metabox('rehub_top_table.first_column_link');
$rows = vp_metabox('rehub_top_table.columncontents');  //Get the rows 

?>
<!--  Main results wrapper - wraps the paginations, map and results -->
<div class="gmw-results-wrapper gmw-pt-results-wrapper-table <?php echo esc_attr( $gmw['prefix'] ); ?>" data-id="<?php absint( $gmw['ID'] ); ?>" data-prefix="<?php echo esc_attr( $gmw['prefix'] ); ?>">	

	<?php if ( $gmw_form->has_locations() ) : ?>
	
		<?php do_action( 'gmw_search_results_start', $gmw ); ?>
		
        <div class="geo-pagination">
        	<!-- results message -->
            <div class="pag-count floatleft tabletblockdisplay">
                <?php gmw_results_message( $gmw, false ); ?>
            </div>

            <!-- per page -->
            <?php gmw_per_page( $gmw ); ?>
            <!-- pagination -->
            <div class="pagination-links tabletblockdisplay" id="member-dir-pag-top">
                <?php gmw_pagination( $gmw ); ?>
            </div>
        </div>
        <div class="clear"></div>
			
	    <?php gmw_results_map( $gmw ); ?>
		
		<div class="clear"></div>
		
		<?php do_action( 'gmw_search_results_before_loop', $gmw ); ?>
		
		<!--  Results wrapper -->
		<div class="gmw-posts-wrapper">
			<div class="rh-top-table">
	            <?php if ($image_width || $image_height):?>
	                <style scoped>.rh-top-table .top_rating_item figure > a img{max-height: <?php echo ''.$image_height;?>px; max-width: <?php echo ''.$image_width;?>px;}.rh-top-table .top_rating_item figure > a, .rh-top-table .top_rating_item figure{height: auto;width: auto; border:none;}</style>
	            <?php endif;?>
	            <?php $sortable_col = ($disable_filters !=1) ? ' data-tablesaw-sortable-col' : '';?>
	            <?php $sortable_switch = ($disable_filters !=1) ? ' data-tablesaw-sortable-switch' : '';?>
				<?php wp_enqueue_script('tablesorter'); wp_enqueue_style('tabletoggle'); ?>
		        <table data-tablesaw-sortable<?php echo ''.$sortable_switch; ?> class="tablesaw top_table_block<?php if ($module_width =='1') : ?> full_width_rating<?php else :?> with_sidebar_rating<?php endif;?> tablesorter" cellspacing="0">	
			        <thead> 
				        <tr class="top_rating_heading">
				            <?php if ($first_column_enable):?><th class="product_col_name" data-tablesaw-priority="persist"><?php echo ''.$first_column_name; ?></th><?php endif;?>
				            <?php if (!empty ($rows)) {
				                $nameid=0;                       
				                foreach ($rows as $row) {                       
				                $col_name = (!empty($rows[$nameid]['column_name'])) ? $rows[$nameid]['column_name'] : '';
				                echo '<th class="col_name"'.$sortable_col.' data-tablesaw-priority="1">'.esc_html($col_name).'</th>';
				                $nameid++;
				                } 
				            }
				            ?>
				            <?php if ($last_column_enable):?><th class="buttons_col_name"<?php echo ''.$sortable_col; ?> data-tablesaw-priority="1"><?php echo ''.$last_column_name; ?></th><?php endif;?>                      
				        </tr>
			        </thead>
			        <tbody>

					<!--  this is where wp_query loop begins -->
					<?php $i=0; while ( $gmw_query->have_posts() ) : $gmw_query->the_post();$i ++ ?>
			            <tr class="top_rating_item" id='rank_<?php echo (int)$i?>'>
			                <?php if ($first_column_enable):?>
			                    <td class="product_image_col"><?php echo re_badge_create('tablelabel'); ?>
			                        <figure>   
			                            <?php if (!is_paged() && $first_column_rank) :?><span class="rank_count"><?php if (($i) == '1') :?><i class="far fa-trophy-alt"></i><?php else:?><?php echo (int)$i?><?php endif ?></span><?php endif ?>                                                                   
			                            <?php $link_on_thumb = ($affiliate_link =='1') ? rehub_create_affiliate_link() : get_the_permalink(); ?>
			                            <?php $link_on_thumb_target = ($affiliate_link =='1') ? ' class="re_track_btn btn_offer_block" target="_blank" rel="nofollow sponsored"' : '' ; ?>
	                                        <a href="<?php echo esc_url($link_on_thumb);?>"<?php echo ''.$link_on_thumb_target;?>>
	                                            <?php 
	                                            $showimg = new WPSM_image_resizer();
	                                            $showimg->use_thumb = true;
	                                            if(!$image_height) $image_height = 120;
	                                            $showimg->height =  $image_height;
	                                            if($image_width) {
	                                                $showimg->width =  $image_width;
	                                            }
	                                            if($disable_crop) {
	                                                $showimg->crop = false;
	                                            }else{
	                                                $showimg->crop = true;
	                                            }                                        
	                                            
	                                            $showimg->show_resized_image();                                    
	                                            ?>                                                                  
	                                        </a>
			                        </figure>
			                    </td>
			                <?php endif;?>
			                <?php 
			                if (!empty ($rows)) {
			                    $pbid=0;                       
			                    foreach ($rows as $row) {
			                    $centered = ($row['column_center']== '1') ? ' centered_content' : '' ;
			                    echo '<td class="column_'.$pbid.' column_content'.$centered.'">';
			                    echo do_shortcode(wp_kses_post($row['column_html']));                       
			                    $element = $row['column_type'];
	                                if ($element == 'meta_value') {
	                                    include(rh_locate_template('inc/top/metacolumn.php'));
	                                } else if ($element == 'taxonomy_value') {
	                                        include(rh_locate_template('inc/top/taxonomyrow.php'));
	                                } else if ($element == 'woo_attribute') {
	                                    include(rh_locate_template('inc/top/wooattribute.php'));                 
	                                } else if ($element == 'review_function') {
	                                    include(rh_locate_template('inc/top/reviewcolumn.php'));
	                                } else if ($element == 'user_review_function') {
	                                    include(rh_locate_template('inc/top/userreviewcolumn.php')); 
	                                } else if ($element == 'woo_review') {
	                                    include(rh_locate_template('inc/top/wooreviewrow.php'));
	                                } else if ($element == 'woo_btn') {
	                                    include(rh_locate_template('inc/top/woobtn.php')); 
	                                } else if ($element == 'woo_vendor') {
	                                    include(rh_locate_template('inc/top/woovendor.php'));                        
	                                } else if ($element == 'static_user_review_function') {
	                                    include(rh_locate_template('inc/top/staticuserreviewcolumn.php'));
	                                } else {
	                                    
	                                };
			                    echo '</td>';
			                    $pbid++;
			                    } 
			                }
			                ?>
			                <?php if ($last_column_enable):?>
			                    <td class="buttons_col">
	                                <?php if ('product' == get_post_type(get_the_ID())):?>
	                                    <?php include(rh_locate_template('inc/top/woobtn.php'));?>
	                                <?php else:?>
	                            	   <?php rehub_create_btn('') ;?>
	                                <?php endif ;?>                                
			                    </td>
			                <?php endif ;?>
			            </tr>
					<?php endwhile; ?>
					<!--  end of the loop -->

			        </tbody>
		    	</table>
	    	</div>
		
		</div> <!--  results wrapper -->    
		
		<?php do_action( 'gmw_search_results_after_loop' , $gmw ); ?>
	
	<?php else : ?>

        <div class="gmw-no-results">
            
            <?php do_action( 'gmw_no_results_start', $gmw ); ?>

            <?php gmw_no_results_message( $gmw ); ?>
            
            <?php do_action( 'gmw_no_results_end', $gmw ); ?> 

        </div>

    <?php endif; ?>		
	
	
</div> <!-- output wrapper -->
