<?php if( !defined('FW') ) die('Forbidden');
 
$options = array(
    'music_upload_option' => array(
        'type' => 'box',
        'title' => __('تنظیمات آپلود موسیقی', 'miraculous'),
        'options' => array(
            'mp3_full_songs' => array(
                'type'  => 'upload',
                'fw-storage' => array(
                    'type' => 'post-meta',
                    'post-meta' => 'fw_option:mp3_full_songs',
                ),
                'label' => __('آهنگ کامل Mp3 ', 'miraculous'),
                'desc'  => __('برای کاربران ویژه', 'miraculous'),
                'files_ext' => array( 'mp3' ),
                'extra_mime_types' => array( 'audio/x-aiff, aif aiff' )
            ),
            'music_extranal_url'  => array(
                    'type'  => 'text',
                    'value' => '',
                    'label' => __('آدرس موسیقی خارجی Mp3 ', 'miraculous'),
                    'desc'  => __('آدرس موسیقی خارجی Mp3 ', 'miraculous'),
                    ),
        ),
    ),
    'music_option' => array(
        'type' => 'box',
        'title' => __('تنطیمات موسیقی', 'miraculous'),
        'options' => array(
            'music_type_options' => array(
                'type'  => 'multi-picker',
                'label' => false,
                'desc'  => false,       
                'picker' => array(
                    'music_type' => array(
                                    'type'  => 'radio',
                                    'fw-storage' => array(
                                        'type' => 'post-meta',
                                        'post-meta' => 'fw_option:music_type',
                                    ),
                                    'value' => 'free',
                                    'label' => __('موسیقی', 'miraculous'),
                                    'choices' => array( 
                                        'free' => __('Free', 'miraculous'),
                                        'premium' => __('Premium', 'miraculous'),
                                    ),
                                    // Display choices inline instead of list
                                    'inline' => true,
                                ),
                ), 
                    'choices' => array(
                            'premium' => array(
                                'single_music_price'  => array(
                                        'type'  => 'text',
                                        'value' => '',
                                        'label' => __('قیمت', 'miraculous'),
                                        'desc'  => __('قیمت را وارد کنید.', 'miraculous'),
                                ),
                            ),
                        ),
                    'show_borders' => false,     
            ),
            'music_artists' => array(
                'type'  => 'select-multiple',
                'fw-storage' => array(
                    'type' => 'post-meta',
                    'post-meta' => 'fw_option:music_artists',
                ),
                'label' => __('نام هنرمند', 'miraculous'),
                'desc'  => __('هنرمندان را انتخاب کنید که میخواهید برای این موسیقی اختصاص دهید.', 'miraculous'),
                'choices' => miraculous_get_all_artists_name_for_album_post(),
            ),
            'music_release_date' => array(
                'type'  => 'date-picker',
                'label' => __('تاریخ انتشار', 'miraculous'),
                'monday-first' => true, // The week will begin with Monday; for Sunday, set to false
                'min-date' => "01-01-1900", 
                'max-date' => null, 
            ),
            'post-sidebar' => array(
                'label'   => esc_html__( 'موقعیت سایدبار مطلب', 'miraculous' ),
                'type'    => 'image-picker',
                'value'   => 'full',
                'desc'    => esc_html__( 'محتوا اصلی و ترتیب نوار کناری را انتخاب کنید. بین 1، 2 یا 3 ستون را انتخاب کنید.',
                    'miraculous' ),
                'choices' => array(
                    'full' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/1c.png'
                        ),
                    ),
                    'left' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/2cl.png'
                        ),
                    ),
                    'right' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/2cr.png'
                        ),
                    ),
                ),
            ),
            'post_breadcrumbs_switch' => array( 
                'type'  => 'switch',
                'value' => 'on',
                'label' => esc_html__('نشانگر فعال/غیرفعال', 'miraculous'),
                    'left-choice' => array(
                        'value' => 'off',
                        'label' => esc_html__('خاموش', 'miraculous'),
                    ),
                        'right-choice' => array(
                        'value' => 'on',
                        'label' => esc_html__('روشن', 'miraculous'),
                    ),
            ),
            'post_bgimages_switch' => array( 
                'type'  => 'switch',
                'value' => 'on',
                'label' => esc_html__('تصویر پس زمینه فعال / غیر فعال ', 'miraculous'),
                    'left-choice' => array(
                        'value' => 'off',
                        'label' => esc_html__('خاموش', 'miraculous'),
                    ),
                        'right-choice' => array(
                        'value' => 'on',
                        'label' => esc_html__('روشن', 'miraculous'),
                    ),
            ),
            'single_bg_images'  => array(
                'type'  => 'upload',
                'value' => '',
                'images_only' => true,
                'label' => __('تصویر پس زمینه', 'miraculous'),
                'desc'  => __('آپلود تصویر پس زمینه', 'miraculous'),
                ),
        ),
    ),
);