<?php if( !defined('FW') ) die('Forbidden');

$options = array(
    'main' => array(
        'type' => 'box',
        'title' => __('تنظیمات هنرمند', 'miraculous'),
        'options' => array(
            'artist_born_date' => array(
                'type'  => 'date-picker',
                'label' => __('تاریخ تولد', 'miraculous'),
                'help'  => __('Help tip', 'miraculous'),
                'monday-first' => true, // The week will begin with Monday; for Sunday, set to false
                'min-date' => "01-01-1920", 
                'max-date' => date('d-m-Y'), 
            ),
            'artist_born_place' => array(
                'type'  => 'text',
                'label' => __('محل تولد', 'miraculous'),
                'help'  => __('Help tip', 'miraculous'),
            ),
            'post-sidebar' => array(
                'label'   => esc_html__( 'موقعیت نوار کناری مطلب', 'miraculous' ),
                'type'    => 'image-picker',
                'value'   => 'full',
                'desc'    => esc_html__( 'محتوا اصلی و ترتیب نوار کناری را انتخاب کنید. بین 1، 2 یا 3 ستون را انتخاب کنید.',
                    'miraculous' ),
                'choices' => array(
                    'full' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/1c.png'
                        ),
                    ),
                    'left' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/2cl.png'
                        ),
                    ),
                    'right' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/2cr.png'
                        ),
                    ),
                ),
            ),
            'post_breadcrumbs_switch' => array( 
                'type'  => 'switch',
                'value' => 'on',
                'label' => esc_html__('نشانگر فعال / غیر فعال ', 'miraculous'),
                    'left-choice' => array(
                        'value' => 'off',
                        'label' => esc_html__('خاموش', 'miraculous'),
                    ),
                        'right-choice' => array(
                        'value' => 'on',
                        'label' => esc_html__('روشن', 'miraculous'),
                    ),
            ),
            'post_bgimages_switch' => array( 
                'type'  => 'switch',
                'value' => 'on',
                'label' => esc_html__('تصویر پس زمینه فعال / غیر فعال ', 'miraculous'),
                    'left-choice' => array(
                        'value' => 'off',
                        'label' => esc_html__('خاموش', 'miraculous'),
                    ),
                        'right-choice' => array(
                        'value' => 'on',
                        'label' => esc_html__('روشن', 'miraculous'),
                    ),
            ),
            'single_bg_images'  => array(
                'type'  => 'upload',
                'value' => '',
                'images_only' => true,
                'label' => __('تصویر پس زمینه', 'miraculous'),
                'desc'  => __('آپلود تصویر پس زمینه', 'miraculous'),
                ),
        ),
    ),
);