<?php if( !defined('FW') ) die('Forbidden');

$options = array(
    'album_options' => array(
        'type' => 'box',
        'title' => __('تنظیمات آلبوم', 'miraculous'),
        'options' => array(
            'album_type' => array(
                'type'  => 'radio',
                'fw-storage' => array(
                    'type' => 'post-meta',
                    'post-meta' => 'fw_option:album_type',
                ),
                'value' => 'free',
                'label' => __('آلبوم', 'miraculous'),
                'choices' => array( 
                    'free' => __('Free', 'miraculous'),
                    'premium' => __('Premium', 'miraculous'),
                ),
                // Display choices inline instead of list
                'inline' => true,
            ),
            'album_songs' => array(
                'type'  => 'select-multiple',
                'label' => __('نام آهنگ', 'miraculous'),
                'desc'  => __('انتخاب آهنگ هایی که می خواهید برای این آلبوم اختصاص دهید.', 'miraculous'),
                'help'  => __('Help tip', 'miraculous'),
                'choices' => miraculous_get_all_songs_name_for_album_post(),
            ),
            'album_artists' => array(
                'type'  => 'select-multiple',
                'label' => __('نام هنرمند', 'miraculous'),
                'desc'  => __('هنرمندانی را انتخاب کنید که میخواهید برای این آلبوم اختصاص دهید.', 'miraculous'),
                'help'  => __('Help tip', 'miraculous'),
                'choices' => miraculous_get_all_artists_name_for_album_post(),
            ),
            'album_release_date' => array(
                'type'  => 'date-picker',
                'label' => __('تاریخ انتشار', 'miraculous'),
                'help'  => __('Help tip', 'miraculous'),
                'monday-first' => true, // The week will begin with Monday; for Sunday, set to false
                'min-date' => date('d-m-Y'), 
                'max-date' => null, 
            ),
            'album_company_name' => array(
                'type' => 'text',
                'label' => __('نام شرکت', 'miraculous'),
                'help'  => __('Help tip', 'miraculous'),
            ),
            'post-sidebar' => array(
                'label'   => esc_html__( 'موقعیت سایدبار مطلب', 'miraculous' ),
                'type'    => 'image-picker',
                'value'   => 'full',
                'desc'    => esc_html__( 'محتوا اصلی و ترتیب نوار کناری را انتخاب کنید. بین 1، 2 یا 3 ستون را انتخاب کنید.',
                    'miraculous' ),
                'choices' => array(
                    'full' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/1c.png'
                        ),
                    ),
                    'left' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/2cl.png'
                        ),
                    ),
                    'right' => array(
                        'small' => array(
                            'height' => 50,
                            'src'    => get_template_directory_uri() . '/assets/images/2cr.png'
                        ),
                    ),
                ),
            ),
            'post_breadcrumbs_switch' => array( 
                'type'  => 'switch',
                'value' => 'on',
                'label' => esc_html__('نشانگر فعال/غیرفعال', 'miraculous'),
                    'left-choice' => array(
                        'value' => 'off',
                        'label' => esc_html__('خاموش', 'miraculous'),
                    ),
                        'right-choice' => array(
                        'value' => 'on',
                        'label' => esc_html__('روشن', 'miraculous'),
                    ),
            ),
            'post_bgimages_switch' => array( 
                'type'  => 'switch',
                'value' => 'on',
                'label' => esc_html__('تصویر پس زمینه فعال / غیر فعال ', 'miraculous'),
                    'left-choice' => array(
                        'value' => 'off',
                        'label' => esc_html__('خاموش', 'miraculous'),
                    ),
                        'right-choice' => array(
                        'value' => 'on',
                        'label' => esc_html__('روشن', 'miraculous'),
                    ),
            ),
            'single_bg_images'  => array(
                'type'  => 'upload',
                'value' => '',
                'images_only' => true,
                'label' => __('تصویر پس زمینه', 'miraculous'),
                'desc'  => __('آپلود تصویر پس زمینه', 'miraculous'),
                ),
        ),
    ),
);