<?php
/**
 * miraculous class of ajax function
 */

class Miraculous_Ajax_Call{

  public function __construct() {

     /* */

	}
 
   public function init(){

		add_action( 'wp_ajax_miraculous_create_new_user_playlist', array( $this, 'miraculous_create_new_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_create_new_user_playlist', array( $this, 'miraculous_create_new_user_playlist' ), 10 );



		add_action( 'wp_ajax_miraculous_user_login_form', array( $this, 'miraculous_user_login_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_login_form', array( $this, 'miraculous_user_login_form' ), 10 );



		add_action( 'wp_ajax_miraculous_user_register_form', array( $this, 'miraculous_user_register_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_register_form', array( $this, 'miraculous_user_register_form' ), 10 );



		add_action( 'wp_ajax_miraculous_user_update_form', array( $this, 'miraculous_user_update_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_update_form', array( $this, 'miraculous_user_update_form' ), 10 );



		add_action( 'wp_ajax_miraculous_user_newsletter_form', array( $this, 'miraculous_user_newsletter_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_newsletter_form', array( $this, 'miraculous_user_newsletter_form' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_songs_list', array( $this, 'miraculous_add_in_favourites_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_songs_list', array( $this, 'miraculous_add_in_favourites_songs_list' ), 10 );



		add_action( 'wp_ajax_miraculous_remove_from_favourites_songs_list', array( $this, 'miraculous_remove_from_favourites_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_favourites_songs_list', array( $this, 'miraculous_remove_from_favourites_songs_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_albums_list', array( $this, 'miraculous_add_in_favourites_albums_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_albums_list', array( $this, 'miraculous_add_in_favourites_albums_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_radios_list', array( $this, 'miraculous_add_in_favourites_radios_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_radios_list', array( $this, 'miraculous_add_in_favourites_radios_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_artists_list', array( $this, 'miraculous_add_in_favourites_artists_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_artists_list', array( $this, 'miraculous_add_in_favourites_artists_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_music_in_user_playlist', array( $this, 'miraculous_add_music_in_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_music_in_user_playlist', array( $this, 'miraculous_add_music_in_user_playlist' ), 10 );



		add_action( 'wp_ajax_miraculous_filter_music_language', array( $this, 'miraculous_filter_music_language' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_filter_music_language', array( $this, 'miraculous_filter_music_language' ), 10 );



		add_action( 'wp_ajax_miraculous_user_music_upload', array( $this, 'miraculous_user_music_upload' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_music_upload', array( $this, 'miraculous_user_music_upload' ), 10 );



		add_action( 'wp_ajax_miraculous_music_download', array( $this, 'miraculous_music_download' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_music_download', array( $this, 'miraculous_music_download' ), 10 );


		add_action( 'wp_ajax_miraculous_remove_from_premium_songs_list', array( $this, 'miraculous_remove_from_premium_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_premium_songs_list', array( $this, 'miraculous_remove_from_premium_songs_list' ), 10 );


		add_action( 'wp_ajax_miraculous_remove_from_free_songs_list', array( $this, 'miraculous_remove_from_free_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_free_songs_list', array( $this, 'miraculous_remove_from_free_songs_list' ), 10 );


		add_action( 'wp_ajax_miraculous_remove_from_user_playlist_songs_list', array( $this, 'miraculous_remove_from_user_playlist_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_user_playlist_songs_list', array( $this, 'miraculous_remove_from_user_playlist_songs_list' ), 10 );


		add_action( 'wp_ajax_miraculous_add_to_queue_action', array( $this, 'miraculous_add_to_queue_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_to_queue_action', array( $this, 'miraculous_add_to_queue_action' ), 10 );

		add_action( 'wp_ajax_miraculous_play_all_music_action', array( $this, 'miraculous_play_all_music_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_play_all_music_action', array( $this, 'miraculous_play_all_music_action' ), 10 );
		
		add_action( 'wp_ajax_miraculous_remove_user_playlist', array( $this, 'miraculous_remove_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_user_playlist', array( $this, 'miraculous_remove_user_playlist' ), 10 );
		
		add_action( 'wp_ajax_miraculous_play_user_playlist', array( $this, 'miraculous_play_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_play_user_playlist', array( $this, 'miraculous_play_user_playlist' ), 10 );

		add_action( 'wp_ajax_miraculous_user_queue_data_action', array( $this, 'miraculous_user_queue_data_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_queue_data_action', array( $this, 'miraculous_user_queue_data_action' ), 10 );

		add_action( 'wp_ajax_miraculous_user_load_queue_data_action', array( $this, 'miraculous_user_load_queue_data_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_load_queue_data_action', array( $this, 'miraculous_user_load_queue_data_action' ), 10 );

		add_action( 'wp_ajax_miraculous_play_single_music_action', array( $this, 'miraculous_play_single_music_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_play_single_music_action', array( $this, 'miraculous_play_single_music_action' ), 10 );

		add_action( 'wp_ajax_miraculous_remove_history_music_action', array( $this, 'miraculous_remove_history_music_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_history_music_action', array( $this, 'miraculous_remove_history_music_action' ), 10 );
		
	}

    public function miraculous_create_new_user_playlist(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['playlistname']) && $userid) {

		    $p_name = str_replace(' ', '-', $_POST['playlistname']);

		    $key_prefix = "miraculous_playlist_".$userid."_".$p_name;

		    if( get_user_meta($userid, $key_prefix, true) ){

		        $message['status'] = esc_html__('خطا','miraculous');

		        $message['msg'] = esc_html__('لیست پخش قبلا با این نام ایجاد شده است.','miraculous');

		    }else{

		        add_user_meta($userid, $key_prefix, '');

		        $message['status'] = esc_html__('موفقیت','miraculous');

		        $message['msg'] = esc_html__('لیست پخش با موفقیت ایجاد شد.','miraculous');

		    }

		    echo json_encode($message);

		    die();

		}



		$message['status'] = esc_html__('خطا','miraculous');

		$message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

		echo json_encode($message);

		die();

	}
	
	
	
	public function miraculous_remove_user_playlist(){
	    $message = array();

		$userid = get_current_user_id();

		if (isset($_POST['playlist']) && $userid) {

	    	$playlist_key = 'miraculous_playlist_'.$userid.'_'.$_POST['playlist']; 
            
            $del = delete_user_meta($userid, $playlist_key);
            if($del){
                $message['status'] = esc_html__('موفقیت','miraculous');
		        $message['msg'] = esc_html__('حذف شده به صورت موفقیت آمیز','miraculous');
            }else{
                $message['status'] = esc_html__('خطا','miraculous');
		        $message['msg'] = esc_html__('چیزی اشتباه شد.','miraculous');
            }
	    	echo json_encode($message);
	    	die();

		}

		$message['status'] = esc_html__('خطا','miraculous');
		$message['msg'] = esc_html__('چیزی اشتباه شد.','miraculous');

		echo json_encode($message);

		die();
	}

	public function miraculous_user_login_form(){

		if( isset($_POST['username']) && isset($_POST['password']) ) {



			extract($_POST);



			if($rem_check) {

				$rem = true;

			}else{

				$rem = false;

			}



			if( is_user_logged_in() ) {

				$data = array('status' => 'false', 'msg' => 'شما قبلا وارد شده اید!');

			}else{

				$creds = array();

				$creds['user_login'] = $username;

				$creds['user_password'] = $password;

				$creds['remember'] = $rem;

				$user = wp_signon( $creds, false );

				if ( is_wp_error($user) ) {

					$error = esc_html__('جزئیات ورود نادرست.', 'miraculous');

					$data = array('status' => 'false', 'msg' => $error);

				}else{

					$url = site_url();

					$data = array('status' => 'true', 'msg' => 'ورود موفقیت آمیز', 'redirect_uri' => $url);

				}

			}



			echo json_encode($data);

			die();

		}

		$data = array('status' => 'false', 'msg' => 'چیزی اشتباه شد لطفا دوباره تلاش کنید.');

		echo json_encode($data);

		die();

	}



	public function miraculous_user_register_form() {

		$error = array();

		if( isset($_POST['username']) && isset($_POST['full_name']) && isset($_POST['useremail']) && isset($_POST['password']) && isset($_POST['confirmpass']) ) {

			extract($_POST);



		    if( ! validate_username($username) ) {
		    	$error['erroruser'] = "* نام کاربری معتبر نیست فقط از حروف کوچک استفاده کنید!";
		    }

		    if( username_exists($username) ) {
		    	$error['erroruser'] = "* نام کاربری در حال حاضر وجود دارد!";
		    }

		    if( email_exists($useremail) ) {
		    	$error['erroremail'] = "* ایمیل در حال حاضر وجود دارد!"; 
		    }

		    if( empty($error) ) {
				$userdata = array(

					'user_login' => $username,

					'user_pass' => $password,

					'first_name' => $full_name,

					'user_email' => $useremail

				);

		    	$user_id = wp_insert_user( $userdata );

		    	//On success

		    	if ( ! is_wp_error( $user_id ) ) {

					$data = array('status' => 'true', 'msg' => 'شما با موفقیت ثبت نام کردید لطفا وارد شوید');

					echo json_encode($data);

		    	}else{

			        $data = array('status' => 'false', 'msg' => 'چیزی اشتباه شد لطفا دوباره تلاش کنید.');
			        echo json_encode($data);
		    	}

		    }else{

				$error['status'] = 'false';
				echo json_encode($error);

		    }
			die();
		}

	}

	public function miraculous_user_update_form() {

		$error = array();

		if( isset($_POST['username']) && isset($_POST['useremail']) && isset($_POST['userid']) ) {

	    	extract($_POST);
	    	$current_user = wp_get_current_user();

		    if( $current_user->user_email != trim($useremail) ) {

		        if( email_exists($useremail) ) {

		            $error['status'] = 'false';

		            $error['msg'] = "ایمیل در حال حاضر وجود دارد!";

		        }

		    }

		    $full_name = explode(' ', $username);

		    $first_name = $full_name[0];

		    unset($full_name[0]);

		    $last_name = implode(' ', $full_name);



		    if( empty($error) ) {



		        if( isset($password) && isset($confpassword) && $password != '' && $confpassword != '' ) {

		            $userdata = array(

		              'ID' => $userid,

		              'user_pass' => $password,

		              'first_name' => $first_name,

		              'last_name' => $last_name,

		              'user_email' => $useremail,

		              'display_name' => $username

		            );

		        }else{

		            $userdata = array(

		              'ID' => $userid,

		              'first_name' => $first_name,

		              'last_name' => $last_name,

		              'user_email' => $useremail,

		              'display_name' => $username

		            );

		        }



		        $user_id = wp_update_user( $userdata );

		        //On success

		        if ( ! is_wp_error( $user_id ) ) {

		            update_user_meta($user_id, 'user_profile_img', $profile_img);

		            $data = array('status' => 'true', 'msg' => 'پروفایل به صورت موفقیت آمیز به روز شد');

		            echo json_encode($data);

		        }else{

		        $data = array('status' => 'false', 'msg' => 'چیزی اشتباه شد لطفا دوباره تلاش کنید.');

		            echo json_encode($data);

		        }

		      

		    }else{

		    	echo json_encode($error);

		    }



		    die();

		}



	}



	public function miraculous_user_newsletter_form() {



		$message = array();

		if(isset($_POST['ns_email'])){



	    	$fname = $_POST['ns_name'];

	    	$email = $_POST['ns_email'];



	    	if(!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL) === false){

				// MailChimp API credentials

				$apiKey = '';

				$listID = '';

	        	if( function_exists('fw_get_db_settings_option') ) {

		        	$apiKey = fw_get_db_settings_option( 'mailchimp_api_key' );

		        	$listID = fw_get_db_settings_option( 'mailchimp_list_id' );

	        	}

	         

				// MailChimp API URL

				$memberID = md5(strtolower($email));

				$dataCenter = substr($apiKey,strpos($apiKey,'-')+1);

				$url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listID . '/members/' . $memberID;

	          

				// member information

				$json = json_encode([

					'email_address' => $email,

					'status'        => 'subscribed',

					'merge_fields'  => [

						'FNAME'     => $fname

					]

				]);

	          

				// send a HTTP POST request with curl

				$ch = curl_init($url);

				curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);

				curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				curl_setopt($ch, CURLOPT_TIMEOUT, 10);

				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');

				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

				curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

				$result = curl_exec($ch);

				$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

				curl_close($ch);

	          

	        	// store the status message based on response code

	        	if ($httpCode == 200) {

	            	$message['msg'] = esc_html__('شما با موفقیت ثبت نام نمودید.','miraculous');

	            	$message['status'] = esc_html__('موفقیت','miraculous');

	        	} else {

	            	switch ($httpCode) {

	                  	case 214:

	                    	$msg = esc_html__('شما قبلا عضو شده اید.','miraculous');

	                    	$message['status'] = esc_html__('موفقیت','miraculous');

	                    	break;

	                  	default:

	                    	$msg = esc_html__('برخی از مشکلات رخ داده است، لطفا دوباره امتحان کنید.','miraculous');

	                    	$message['status'] = esc_html__('خطا','miraculous');

	                    	break;

	            	}

	              $message['msg'] = $msg;

	        	}

	    	}else{

	        	$message['msg'] = esc_html__('لطفا آدرس ایمیل را وارد کنید.','miraculous');

	        	$message['status'] = esc_html__('خطا','miraculous');

	    	}



	    	echo json_encode($message);

	    	die();

		}



		$message['msg'] = esc_html__('لطفا آدرس ایمیل را وارد کنید.','miraculous');

		$message['status'] = esc_html__('خطا','miraculous');

		echo json_encode($message);



		die();

	}



	public function miraculous_add_in_favourites_songs_list() {

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

			$songs = array();

			$songs[] = $_POST['songid'];

			$music_id = get_user_meta($userid, 'favourites_songs_lists'.$userid, true);

		    if( $music_id ) {

		    	if( in_array($_POST['songid'], $music_id) ) {
                    $key = array_search($_POST['songid'], $music_id); 
	        		unset($music_id[$key]);
	        		$new_arr = array_values($music_id);
	        		update_user_meta($userid, 'favourites_songs_lists'.$userid, $new_arr);
	        		
			        $message['status'] = esc_html__('موفقیت','miraculous');
                    $message['action'] = esc_html__('حذف شده','miraculous');
			        $message['msg'] = esc_html__('با موفقیت حذف شد','miraculous');

		      	}else{
			        $new_arr = array_merge($music_id, $songs);
			        update_user_meta($userid, 'favourites_songs_lists'.$userid, $new_arr);

			        $message['status'] = esc_html__('موفقیت','miraculous');
                    $message['action'] = esc_html__('اضافه شد','miraculous');
			        $message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');
		      	}

		    }else{

				update_user_meta($userid, 'favourites_songs_lists'.$userid, $songs);

				$message['status'] = esc_html__('موفقیت','miraculous');

				$message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

		    }



		    echo json_encode($message);

		    die();

		}



		$message['status'] = esc_html__('خطا','miraculous');

		$message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

		echo json_encode($message);

		die();

	}



	public function miraculous_remove_from_favourites_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();



	    	$songs[] = $_POST['songid'];

	    	$music_id = get_user_meta($userid, 'favourites_songs_lists'.$userid, true);



	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 



	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'favourites_songs_lists'.$userid, $new_arr);



	        		$message['status'] = 'success';

	        		$message['msg'] = 'Removed successfully';

	      		}

	    	}



	    	echo json_encode($message);

	    	die();

		}



		$message['status'] = esc_html__('خطا','miraculous');

		$message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

		echo json_encode($message);

		die();

	}


	public function miraculous_add_in_favourites_albums_list(){

	    $message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['albumid']) && $userid) {

	        $albums = array();

	        $albums[] = $_POST['albumid'];

	        $album_id = get_user_meta($userid, 'favourites_albums_lists'.$userid, true);

	    	if( $album_id ) {

	        	if( in_array($_POST['albumid'], $album_id) ) {
	        	    $key = array_search($_POST['albumid'], $album_id); 

	        		unset($album_id[$key]);
	        		$new_arr = array_values($album_id);

	        		update_user_meta($userid, 'favourites_albums_lists'.$userid, $new_arr);

	          		$message['status'] = esc_html__('موفقیت','miraculous');
	          		$message['action'] = esc_html__('حذف شده','miraculous');
	          		$message['msg'] = esc_html__('با موفقیت حذف شد','miraculous');

	        	}else{

		          	$new_arr = array_merge($album_id, $albums);

		          	update_user_meta($userid, 'favourites_albums_lists'.$userid, $new_arr);

		          	$message['status'] = esc_html__('موفقیت','miraculous');
                    $message['action'] = esc_html__('اضافه شده','miraculous');
		          	$message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	        	}

	      	}else{

		        update_user_meta($userid, 'favourites_albums_lists'.$userid, $albums);

		        $message['status'] =esc_html__('موفقیت','miraculous');

		        $message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	      	}



		    echo json_encode($message);

		    die();

	    }



	    $message['status'] = esc_html__('خطا','miraculous');

	    $message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

	    echo json_encode($message);

	    die();

	}

	public function miraculous_add_in_favourites_radios_list(){
		$message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['radioid']) && $userid) {

	        $radios = array();

	        $radios[] = $_POST['radioid'];

	        $radio_id = get_user_meta($userid, 'favourites_radios_lists'.$userid, true);



	    	if( $radio_id ) {

	        	if( in_array($_POST['radioid'], $radio_id) ) {

	          		$key = array_search($_POST['radioid'], $radio_id); 

	        		unset($radio_id[$key]);
	        		$new_arr = array_values($radio_id);

	        		update_user_meta($userid, 'favourites_radios_lists'.$userid, $new_arr);

	          		$message['status'] = esc_html__('موفقیت','miraculous');
	          		$message['action'] = esc_html__('حذف شده','miraculous');
	          		$message['msg'] = esc_html__('با موفقیت حذف شد','miraculous');

	        	}else{

		          	$new_arr = array_merge($radio_id, $radios);

		          	update_user_meta($userid, 'favourites_radios_lists'.$userid, $new_arr);

		          	$message['status'] = esc_html__('موفقیت','miraculous');

		          	$message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	        	}


	      	}else{

		        update_user_meta($userid, 'favourites_radios_lists'.$userid, $radios);

		        $message['status'] = esc_html__('موفقیت','miraculous');

		        $message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	      	}

		    echo json_encode($message);

		    die();

	    }



	    $message['status'] = esc_html__('خطا','miraculous');

	    $message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

	    echo json_encode($message);

	    die();
	}

	public function miraculous_add_in_favourites_artists_list(){

	    $message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['artistid']) && $userid) {

	        $artists = array();



	        $artists[] = $_POST['artistid'];

	        $artist_id = get_user_meta($userid, 'favourites_artists_lists'.$userid, true);



	      	if( $artist_id ) {

	        	if( in_array($_POST['artistid'], $artist_id) ) {

		          	$key = array_search($_POST['artistid'], $artist_id); 

	        		unset($artist_id[$key]);
	        		$new_arr = array_values($artist_id);

	        		update_user_meta($userid, 'favourites_artists_lists'.$userid, $new_arr);

	          		$message['status'] = esc_html__('success','miraculous');
	          		$message['action'] = esc_html__('removed','miraculous');
	          		$message['msg'] = esc_html__('Removed successfully','miraculous');

	        	}else{

		          	$new_arr = array_merge($artist_id, $artists);

		          	update_user_meta($userid, 'favourites_artists_lists'.$userid, $new_arr);

		          	$message['status'] = esc_html__('موفقیت','miraculous');

		          	$message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	        	}

	        

	      	}else{

		        update_user_meta($userid, 'favourites_artists_lists'.$userid, $artists);

		        $message['status'] = esc_html__('موفقیت','miraculous');

		        $message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	      	}



	      	echo json_encode($message);

	      	die();

	    }



	    $message['status'] = esc_html__('خطا','miraculous');

	    $message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

	    echo json_encode($message);

	    die();

	}



	public function miraculous_add_music_in_user_playlist(){

	    $message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['musicid']) && isset($_POST['key']) && $userid) {

	        $songs = array();

	        $key = $_POST['key'];

	        $songs[] = $_POST['musicid'];

	        $music_id = get_user_meta($userid, $key, true);



	        if( $music_id ) {

	          	if( in_array($_POST['musicid'], $music_id) ) {

		            $message['status'] = esc_html__('موفقیت','miraculous');

		            $message['msg'] =esc_html__('قبلا اضافه شده','miraculous');

	          	}else{

		            $new_arr = array_merge($music_id, $songs);

		            update_user_meta($userid, $key, $new_arr);

		            $message['status'] = esc_html__('موفقیت','miraculous');

		            $message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	          	}

	          

	        }else{

	          	update_user_meta($userid, $key, $songs);

	          	$message['status'] = esc_html__('موفقیت','miraculous');

	          	$message['msg'] = esc_html__('با موفقیت اضافه شد','miraculous');

	        }



	        echo json_encode($message);

	        die();

	    }



	    $message['status'] = esc_html__('خطا','miraculous');

	    $message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

	    echo json_encode($message);

	    die();

	}



	public function miraculous_filter_music_language() {



	    if( isset($_POST['filter_lang']) ) {



	        if( is_user_logged_in() ){

	            $user_id = get_current_user_id();



	            if( $_POST['filter_lang'] != '' ){

	                $lang_data = explode(',', $_POST['filter_lang']);

	                update_option('language_filter_ids_'.$user_id, $lang_data);

	                echo site_url();

	            }else{

	                update_option('language_filter_ids_'.$user_id, $lang_data);

	                echo site_url();

	            }

	        }else{

	            if( $_POST['filter_lang'] != '' ) {

	                $cookie_name = "lang_filter";

	                $cookie_value = $_POST['filter_lang'];

	                setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day



	                echo site_url();

	            }else{

	                $cookie_name = "lang_filter";

	                $cookie_value = $_POST['filter_lang'];

	                setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day



	                echo site_url();

	            }

	        }



	    }



	    die();

	}



	public function miraculous_user_music_upload(){

        $miraculous_theme_data = '';
        if (function_exists('fw_get_db_settings_option')):  
          $miraculous_theme_data = fw_get_db_settings_option();     
        endif; 
        $track_page = '';
        if(!empty($miraculous_theme_data['user_blog_page'])):
            $track_page = get_the_permalink( $miraculous_theme_data['user_blog_page'] );
        endif;

		$data = array('status' => 'false', 'msg' => 'Something went Wrong.');

		if( isset($_POST['mp3_url']) ){

		    extract($_POST);

		    $artist_arr = array();

		    $user_id = get_current_user_id();

		    $lang_arr = array( $language_id );

		    if($language_id){

		        $m_args = array(

		            'post_type' => 'ms-music',

		            'post_title' => $track_name,

		            'post_author' => $user_id,

		            'post_status' => $privacy

		      );

		    }else{

		      	$m_args = array(

					'post_type' => 'ms-music',

					'post_title' => $track_name,

					'post_author' => $user_id,

					'post_status' => $privacy

		    	);

		    }



	    	$music_id =  wp_insert_post($m_args);

	    	if($music_id){

				$artist_arr[] = $_POST['artists_name'];

				$new_full_track = array('attachment_id' => $track_mp3_id, 'url' => $mp3_url);

				update_post_meta($music_id, 'music_added_by', $user_id);

				update_post_meta($music_id, 'fw_option:mp3_full_songs', $new_full_track);

				update_post_meta($music_id, 'mp3_full_songs', $full_track);

				update_post_meta($music_id, 'fw_option:music_artists', $artist_arr);

				update_post_meta($music_id, 'fw_option:music_type', 'free');

	    		if($music_image){

	        		set_post_thumbnail( $music_id, $attachimage_id );
	        		wp_set_post_terms( $music_id, $lang_arr, 'language' );

	      		}

	      		global $wpdb;

	      		$pmt_tbl = $wpdb->prefix . 'ms_payments'; 

	      		$query = $wpdb->get_row( "SELECT * FROM `$pmt_tbl` WHERE user_id = $user_id AND expiretime > '$today'" );

	      		if($query->remains_upload > 0){

		          	$wpdb->update( 

		            	$pmt_tbl, 

			            array( 

			              'remains_upload' => $query->remains_upload-1

			            ), 

		            	array( 'ID' => $query->id ), 

			            array( 

			              '%d'

			            ), 

		            	array( '%d' ) 

		          	);

	      		}

	      		$data = array('status' => 'true', 'msg' => 'آپلود شده به صورت موفقیت آمیز.', 'track_page' => $track_page);

	    	}else{

	      		$data = array('status' => 'false', 'msg' => 'چیزی اشتباه شد.');

	    	}

	    	echo json_encode($data);

	    	die();

		}

	  	echo json_encode($data);

	  	die();

	}



	public function miraculous_music_download(){

	    $message = array();
	    global $wpdb;
	    $userid = get_current_user_id();
	    $miraculous_theme_data = '';
        if (function_exists('fw_get_db_settings_option')):  
          $miraculous_theme_data = fw_get_db_settings_option();     
        endif; 
        $pricing_plan_page = '';
        if(!empty($miraculous_theme_data['user_pricing_plan_page'])):
            $pricing_plan_page = get_the_permalink( $miraculous_theme_data['user_pricing_plan_page'] );
        endif;
        
        if($userid == 0){
            $message = array('status' => 'false', 'msg' => 'شما نیاز به ورود به سیستم دارید.', 'plan_page' => '');
	        echo json_encode($message);
	        die();
        }

	    if( isset($_POST['musicid']) && $userid ){

	    	$music_type = get_post_meta($_POST['musicid'], 'fw_option:music_type', true);

	    	$songs = array();

	    	$songs[] = $_POST['musicid'];
	    	$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
	    	
	    	if(empty($mpurl)):
	    	    $mpurl = get_post_meta($_POST['musicid'], 'fw_option:music_extranal_url', true);
	       endif;
    		$title = get_the_title( $_POST['musicid'] );
    		$mp3url = '';
    		if($mpurl) {
    			$mp3url = $mpurl['url'];
    		}

	    	if($music_type == 'free'){
	    		$key = 'free_downloaded_songs_by_user_'.$userid;
	    		$music_id = get_user_meta($userid, $key, true);

		    	if( $music_id ) {

		        	if( in_array($_POST['musicid'], $music_id) ) {

		          	$message['status'] = esc_html__('موفقیت','miraculous');

		          	$message['msg'] = esc_html__('قبلا دانلود شده است','miraculous');
		          	$message['mp3_uri'] = $mp3url;
		          	$message['mp3_name'] = $title;

		        	}else{

			          	$new_arr = array_merge($music_id, $songs);

			          	update_user_meta($userid, $key, $new_arr);

			          	$message['status'] = esc_html__('موفقیت','miraculous');

			          	$message['msg'] = esc_html__('با موفقیت دانلود شد','miraculous');
			          	$message['mp3_uri'] = $mp3url;
		          		$message['mp3_name'] = $title;

		        	}

		      	}else{

			        update_user_meta($userid, $key, $songs);

			        $message['status'] = esc_html__('موفقیت','miraculous');

			        $message['msg'] = esc_html__('با موفقیت دانلود شد','miraculous');
			        $message['mp3_uri'] = $mp3url;
		          	$message['mp3_name'] = $title;

		      	}
	    	}else{
	    		$pmt_tbl = $wpdb->prefix . 'ms_payments'; 
	    		$query = $wpdb->get_row( "SELECT * FROM `$pmt_tbl` WHERE user_id = $userid AND expiretime > '$today' AND remains_download > 0" );
	    		if(!empty($query)){
	    			$key = 'premium_downloaded_songs_by_user_'.$userid;
		    		$music_id = get_user_meta($userid, $key, true);

			    	if( $music_id ) {

			        	if( in_array($_POST['musicid'], $music_id) ) {

			          	$message['status'] = esc_html__('موفقیت','miraculous');

			          	$message['msg'] = esc_html__('قبلا دانلود شده است','miraculous');
			          	$message['mp3_uri'] = $mp3url;
		          		$message['mp3_name'] = $title;

			        	}else{

				          	$new_arr = array_merge($music_id, $songs);

				          	update_user_meta($userid, $key, $new_arr);

				          	$message['status'] = esc_html__('موفقیت','miraculous');

				          	$message['msg'] = esc_html__('با موفقیت دانلود شد','miraculous');
				          	$message['mp3_uri'] = $mp3url;
		          			$message['mp3_name'] = $title;

	          		      	$wpdb->update( 

	          	            	$pmt_tbl, 

	          		            array( 

	          		              'remains_download' => $query->remains_download-1

	          		            ), 

	          	            	array( 'ID' => $query->id ), 

	          		            array( 

	          		              '%d'

	          		            ), 

	          	            	array( '%d' ) 

	          	          	);

			        	}

			      	}else{

				        update_user_meta($userid, $key, $songs);

				        $message['status'] = esc_html__('موفقیت','miraculous');

				        $message['msg'] = esc_html__('با موفقیت دانلود شد','miraculous');
				        $message['mp3_uri'] = $mp3url;
		          		$message['mp3_name'] = $title;

	        	      	$wpdb->update( 

	                    	$pmt_tbl, 

	        	            array( 

	        	              'remains_download' => $query->remains_download-1

	        	            ), 

	                    	array( 'ID' => $query->id ), 

	        	            array( 

	        	              '%d'

	        	            ), 

	                    	array( '%d' ) 

	                  	);

			      	}

	    		}else{
	    			$message['status'] = esc_html__('نادرست','miraculous');

			        $message['msg'] = esc_html__('شما باید طرح خریداری کنید','miraculous');
			        $message['plan_page'] = $pricing_plan_page;
	    		}
	    	}

	      	echo json_encode($message);

	      	die();
	        
	    }

	    $message = array('status' => 'false', 'msg' => 'شما باید وارد شوید یا باید طرحی خریداری کنید.', 'plan_page' => $pricing_plan_page);

	    echo json_encode($message);

	    die();

	}

	public function miraculous_remove_from_premium_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();

	    	$songs[] = $_POST['songid'];

	    	$music_id = get_user_meta($userid, 'premium_downloaded_songs_by_user_'.$userid, true);

	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 



	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'premium_downloaded_songs_by_user_'.$userid, $new_arr);



	        		$message['status'] = esc_html__('موفقیت','miraculous');

	        		$message['msg'] = esc_html__('با موفقیت حذف شد','miraculous');

	      		}

	    	}



	    	echo json_encode($message);

	    	die();

		}



		$message['status'] = esc_html__('خطا','miraculous');

		$message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید.','miraculous');

		echo json_encode($message);

		die();

	}

	public function miraculous_remove_from_free_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();



	    	$songs[] = $_POST['songid'];

	    	$music_id = get_user_meta($userid, 'free_downloaded_songs_by_user_'.$userid, true);



	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 



	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'free_downloaded_songs_by_user_'.$userid, $new_arr);



	        		$message['status'] = esc_html__('موفقیت','miraculous');

	        		$message['msg'] = esc_html__('با موفقیت حذف شد','miraculous');

	      		}

	    	}



	    	echo json_encode($message);

	    	die();

		}



		$message['status'] = 'error';

		$message['msg'] = 'شما نیاز به ورود به سیستم دارید.';

		echo json_encode($message);

		die();

	}

	public function miraculous_remove_from_user_playlist_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && isset($_POST['playlist']) && $userid) {

	    	$songs = array();



	    	$songs[] = $_POST['songid'];
	    	$playlist_key = 'miraculous_playlist_'.$userid.'_'.$_POST['playlist']; 

	    	$music_id = get_user_meta($userid, $playlist_key, true);



	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 



	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, $playlist_key, $new_arr);



	        		$message['status'] = 'success';

	        		$message['msg'] = 'با موفقیت حذف شد';

	      		}

	    	}



	    	echo json_encode($message);

	    	die();

		}



		$message['status'] = esc_html__('خطا','miraculous');

		$message['msg'] = esc_html__('شما نیاز به ورود به سیستم دارید','miraculous');

		echo json_encode($message);

		die();

	}

	function miraculous_add_to_queue_action(){

		$return_arr = array('status' => 'false', 'msg' => 'موزیکی ندارید');
		if( isset($_POST['musicid']) && isset($_POST['musictype']) ){
			$attach_meta = array();
			$queue_arr = array();

			if($_POST['musictype'] == 'album'){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['album_artists']):
		    		foreach ($ms_album_post_meta_option['album_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['album_songs'])){

			    	foreach ($ms_album_post_meta_option['album_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
			    		if(function_exists( 'fw_get_db_post_option' )):	
                          $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);

			    		$share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri); 

			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}
			
			if($_POST['musictype'] == 'radio'){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['radio_artists']):
		    		foreach ($ms_album_post_meta_option['radio_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['radio_songs'])){

			    	foreach ($ms_album_post_meta_option['radio_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
			    		if(function_exists( 'fw_get_db_post_option' )):	
                         $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);

			    		$share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri);

			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}

			if($_POST['musictype'] == 'artist'){
				$ms_artist_post_meta_option = '';
				if( function_exists('fw_get_db_post_option') ):
				   $ms_artist_post_meta_option = fw_get_db_post_option();
				endif;
				$m_args = array('post_type' => 'ms-music', 
				                'numberposts' => -1);
				$artists = $_POST['musicid'];
				$music_posts = get_posts($m_args);
				$art = false;
				$i = 1;
				if(!empty($music_posts)){
					foreach ($music_posts as $music_post) {
						$artists_ids = get_post_meta($music_post->ID, 'fw_option:music_artists', true);
						if( $artists_ids && in_array($artists, $artists_ids) ){
							$mpurl = get_post_meta($music_post->ID, 'fw_option:mp3_full_songs', true);
						if(function_exists( 'fw_get_db_post_option' )):	
                            $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
							$image_uri = get_the_post_thumbnail_url ( $music_post->ID );
							$title = get_the_title($music_post->ID);
							$artists_name = array();
							foreach ($artists_ids as $artists_id) {
							    $artists_name[] = get_the_title($artists_id);
							}
							$artists_n = implode(', ', $artists_name);
							$share_uri = get_the_permalink($music_post->ID);

							$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $music_post->ID, 'share_uri' => $share_uri); 
						}
					}
					if(!empty($queue_arr)){
						echo json_encode($queue_arr);
						die();
					}else{
						echo json_encode($return_arr);
						die();
					}
				}
			}

			if($_POST['musictype'] == 'music'){
				$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
			    if(function_exists( 'fw_get_db_post_option' )):	
                    $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                endif;
				if(!empty($mpurl['url'])):
					$mp3url = $mpurl['url'];
				else:
				   $mp3url = '';
				   if(!empty($miraclous_post_data['music_extranal_url'])):
				      $mp3url = $miraclous_post_data['music_extranal_url'];
				   endif;
				endif;
				$artists_ids = get_post_meta($_POST['musicid'], 'fw_option:music_artists', true);
				$artists_name = array();
				if($artists_ids){
					foreach ($artists_ids as $artists_id) {
					    $artists_name[] = get_the_title($artists_id);
					}
				}
				$image_uri = get_the_post_thumbnail_url ( $_POST['musicid'] );
				$title = get_the_title($_POST['musicid']);
				$artists_n = implode(', ', $artists_name);
				$share_uri = get_the_permalink($_POST['musicid']);
				
				$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 

				if(!empty($queue_arr)){
					echo json_encode($queue_arr);
					die();
				}else{
					echo json_encode($return_arr);
					die();
				}
			}

		}
		echo json_encode($return_arr);
		die();
	}

	function miraculous_play_all_music_action(){
		$return_arr = array('status' => 'false', 'msg' => 'چیزی اشتباه شد.');
		$userid = get_current_user_id();
		if( isset($_POST['musicid']) && isset($_POST['musictype']) ){
			$attach_meta = array();
			$queue_arr = array();

			if($_POST['musictype'] == 'album'){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['album_artists']):
		    		foreach ($ms_album_post_meta_option['album_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['album_songs'])){
                    $m = 1;
			    	foreach ($ms_album_post_meta_option['album_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
			    		if(function_exists( 'fw_get_db_post_option' )):	
                            $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else: 
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);

			    		$share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri); 
			    		$songs = array();
			    		$songs[] = $music_id;

			    		if($userid && $m == 1){
			    			$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
			    			if( $hsmusic_id ) {

			    				if( in_array($music_id, $hsmusic_id) ) {

			    			  	}else{
			    			        $new_arr = array_merge($hsmusic_id, $songs);
			    			        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
			    			  	}

			    			}else{
			    				update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
			    			}
	
			    		}
                        $m++;
			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}

			if($_POST['musictype'] == 'radio'){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['radio_artists']):
		    		foreach ($ms_album_post_meta_option['radio_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['radio_songs'])){
                    $m = 1;
			    	foreach ($ms_album_post_meta_option['radio_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
    			    	if(function_exists( 'fw_get_db_post_option' )):	
                         $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                         endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);

			    		$share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri); 
			    		$songs = array();
			    		$songs[] = $music_id;

			    		if($userid && $m == 1){
			    			$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
			    			if( $hsmusic_id ) {

			    				if( in_array($music_id, $hsmusic_id) ) {

			    			  	}else{
			    			        $new_arr = array_merge($hsmusic_id, $songs);
			    			        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
			    			  	}

			    			}else{
			    				update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
			    			}
			    			
			    		}
                        $m++;
			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	//print_r($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}

			if($_POST['musictype'] == 'artist'){
				$ms_artist_post_meta_option = '';
				if( function_exists('fw_get_db_post_option') ):
				   $ms_artist_post_meta_option = fw_get_db_post_option();
				endif;
				$m_args = array('post_type' => 'ms-music', 
				                'numberposts' => -1);
				$artists = $_POST['musicid'];
				$music_posts = get_posts($m_args);
				$art = false;
				$i = 1;
				if(!empty($music_posts)){ $m = 1;
					foreach ($music_posts as $music_post) {
						$artists_ids = get_post_meta($music_post->ID, 'fw_option:music_artists', true);
						if( $artists_ids && in_array($artists, $artists_ids) ){
							$mpurl = get_post_meta($music_post->ID, 'fw_option:mp3_full_songs', true);
							if(function_exists( 'fw_get_db_post_option' )):	
                               $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                            endif;
            				if(!empty($mpurl['url'])):
            					$mp3url = $mpurl['url'];
            				else:
            				$mp3url = '';
            			      if(!empty($miraclous_post_data['music_extranal_url'])):
            			      $mp3url = $miraclous_post_data['music_extranal_url'];
            				 endif;
            				endif;
							$image_uri = get_the_post_thumbnail_url ( $music_post->ID );
							$title = get_the_title($music_post->ID);
							$artists_name = array();
							foreach ($artists_ids as $artists_id) {
							    $artists_name[] = get_the_title($artists_id);
							}
							$artists_n = implode(', ', $artists_name);
							$share_uri = get_the_permalink($music_post->ID);

							$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $music_post->ID, 'share_uri' => $share_uri); 
							$songs = array();
							$songs[] = $music_post->ID;

							if($userid && $m == 1){
								$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
								if( $hsmusic_id ) {

									if( in_array($music_post->ID, $hsmusic_id) ) {

								  	}else{
								        $new_arr = array_merge($hsmusic_id, $songs);
								        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
								  	}

								}else{
									update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
								}
								
							}
						}
						$m++;
					}
					if(!empty($queue_arr)){
						echo json_encode($queue_arr);
						//print_r($queue_arr);
						die();
					}else{
						echo json_encode($return_arr);
						die();
					}
				}
			}

			if($_POST['musictype'] == 'music'){
				$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
				if(function_exists( 'fw_get_db_post_option' )):	
                    $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                endif;
				if(!empty($mpurl['url'])):
					$mp3url = $mpurl['url'];
				else:
				   $mp3url = '';
				   if(!empty($miraclous_post_data['music_extranal_url'])):
				      $mp3url = $miraclous_post_data['music_extranal_url'];
				   endif;
				endif;
				$artists_ids = get_post_meta($_POST['musicid'], 'fw_option:music_artists', true);
				$artists_name = array();
				if($artists_ids){
					foreach ($artists_ids as $artists_id) {
					    $artists_name[] = get_the_title($artists_id);
					}
				}
				$image_uri = get_the_post_thumbnail_url ( $_POST['musicid'] );
				$title = get_the_title($_POST['musicid']);
				$artists_n = implode(', ', $artists_name);
				$share_uri = get_the_permalink($_POST['musicid']);
				$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 

				$songs = array();
				$songs[] = $_POST['musicid'];

				if($userid){
					$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
					if( $hsmusic_id ) {

						if( in_array($_POST['musicid'], $hsmusic_id) ) {

					  	}else{
					        $new_arr = array_merge($hsmusic_id, $songs);
					        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
					  	}

					}else{
						update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
					}
				}

				if(!empty($queue_arr)){
					echo json_encode($queue_arr);
					//print_r($queue_arr);
					die();
				}else{
					echo json_encode($return_arr);
					die();
				}
			}

		}
		echo json_encode($return_arr);
		die();
	}
	
	public function miraculous_play_user_playlist(){
	    $return_arr = array('status' => 'false', 'msg' => 'لیست پخش خالی است.');
		$userid = get_current_user_id();
		
		if (isset($_POST['playlist']) && $userid) {
            $queue_arr = array();
            if($_POST['playlist'] == 'ms_favourite'){
                $playlist_key = 'favourites_songs_lists'.$userid;
            }else{
                $playlist_key = 'miraculous_playlist_'.$userid.'_'.$_POST['playlist']; 
            }
            
            $musicsids = get_user_meta($userid, $playlist_key, true);
            if($musicsids){
                $sg_args = array('post_type' => 'ms-music',
                                'post__in' => $musicsids,
                            );
                $music_posts = new WP_Query( $sg_args );
                if($music_posts->have_posts()): 
                    while ( $music_posts->have_posts() ) : $music_posts->the_post();
                    
                    $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                    if($mpurl) {
                        $mp3url = $mpurl['url'];
                    }
                    $artists_ids = get_post_meta(get_the_id(), 'fw_option:music_artists', true);
				    $artists_name = array();
				    if($artists_ids){
					    foreach ($artists_ids as $artists_id) {
					        $artists_name[] = get_the_title($artists_id);
					    }
				    }
                    $image_uri = get_the_post_thumbnail_url ();
                    $title = get_the_title();
				    $artists_n = implode(', ', $artists_name);
				    $share_uri = get_the_permalink();
				    $queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 
				    
                    endwhile;
                    
                endif;
                
            }
            if(!empty($queue_arr)){
				echo json_encode($queue_arr);
				die();
			}else{
				echo json_encode($return_arr);
				die();
			}
	    	echo json_encode($message);
	    	die();

		}
	    echo json_encode($message);
	    die();
	}

	public function miraculous_user_queue_data_action(){
		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['musiclist']) && $userid) {

	    	$queue_data = 'miraculous_queue_data_'.$userid; 
            
            $rst = update_user_meta($userid, $queue_data, $_POST['musiclist']);
            if($rst){
                $message['status'] = 'success';
		        $message['msg'] = 'با موفقیت ذخیره شد';
            }else{
                $message['status'] = 'false';
		        $message['msg'] = 'چیزی اشتباه شد.';
            }
	    	echo json_encode($message);
	    	die();

		}

		$message['status'] = esc_html__('نادرست','miraculous');
		$message['msg'] = esc_html__('چیزی اشتباه شد.','miraculous');

		echo json_encode($message);

		die();
	}

	public function miraculous_user_load_queue_data_action(){
		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['musiclist'])) {

	    	$queue_data = 'miraculous_queue_data_'.$userid; 
            
            $rst = get_user_meta($userid, $queue_data, true);
            if($rst){
                $message['status'] = 'success';
		        $message['msg'] = 'Added Successfully';
		        $message['queue_data'] = $rst;
		        echo json_encode($message);
    			die();
            }else{
                $sg_args = array('post_type' => 'ms-music',
                                            	'orderby'   => 'rand',
                    							'posts_per_page' => 1, 
                                            );
    		    $queue_arr = array();
                $music_posts = new WP_Query( $sg_args );
                if($music_posts->have_posts()): 
                    while ( $music_posts->have_posts() ) : $music_posts->the_post();
                    
                    $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                    if($mpurl) {
                        $mp3url = $mpurl['url'];
                    }
                    $artists_ids = get_post_meta(get_the_id(), 'fw_option:music_artists', true);
    			    $artists_name = array();
    			    if($artists_ids){
    				    foreach ($artists_ids as $artists_id) {
    				        $artists_name[] = get_the_title($artists_id);
    				    }
    			    }
                    $image_uri = get_the_post_thumbnail_url ();
                    $title = get_the_title();
                    $musicid = get_the_id();
    			    $artists_n = implode(', ', $artists_name);
    			    $share_uri = get_the_permalink();
    			    $queue_arr = array('status' => 'default', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $musicid, 'share_uri' => $share_uri); 
    			    
                    endwhile;
                    
                endif;

                if(!empty($queue_arr)){
    				echo json_encode($queue_arr);
    				die();
    			}
            }

		}

		$message['status'] = esc_html__('نادرست','miraculous');
		$message['msg'] = esc_html__('چیزی اشتباه شد.','miraculous');

		echo json_encode($message);

		die();
	}

	public function miraculous_play_single_music_action(){
		$return_arr = array('status' => 'false', 'msg' => 'چیزی اشتباه شد.');
		$userid = get_current_user_id();
		$queue_arr = array();

		if(isset($_POST['musicid']) && $_POST['musicid'] != ''){
			$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
			if($mpurl) {
				$mp3url = $mpurl['url'];
			}
			$artists_ids = get_post_meta($_POST['musicid'], 'fw_option:music_artists', true);
			$artists_name = array();
			if($artists_ids){
				foreach ($artists_ids as $artists_id) {
				    $artists_name[] = get_the_title($artists_id);
				}
			}
			$image_uri = get_the_post_thumbnail_url ( $_POST['musicid'] );
			$title = get_the_title($_POST['musicid']);
			$artists_n = implode(', ', $artists_name);
			$share_uri = get_the_permalink($_POST['musicid']);
			$queue_arr = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 

			$songs = array();
			$songs[] = $_POST['musicid'];

			if($userid){
				$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
				if( $hsmusic_id ) {

					if( in_array($_POST['musicid'], $hsmusic_id) ) {

				  	}else{
				        $new_arr = array_merge($hsmusic_id, $songs);
				        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
				  	}

				}else{
					update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
				}
			}

			if(!empty($queue_arr)){
				echo json_encode($queue_arr);
				die();
			}else{
				echo json_encode($return_arr);
				die();
			}
		}

		echo json_encode($return_arr);
		die();

	}

	public function miraculous_remove_history_music_action(){
		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();

	    	$songs[] = $_POST['songid'];

	    	$music_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);

	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 

	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);

	        		$message['status'] = esc_html__('موفقیت','miraculous');

	                $message['msg'] = esc_html__('با موفقیت حذف شد','miraculous');

	      		}

	    	}

	    	echo json_encode($message);
	    	die();

		}

		$message['status'] = esc_html__('خطا','miraculous');

		$message['msg'] = esc_html__('چیزی اشتباه شد.','miraculous');

		echo json_encode($message);

		die();
	}

}

$Miraculous_Ajax = new Miraculous_Ajax_Call();

$Miraculous_Ajax->init();

?>