<?php if (!defined('FW')) die('Forbidden');
$history_heading = $mpurl ='';
if(!empty($atts['history_heading'])):
 $history_heading = $atts['history_heading'];
endif;
$number_limits = 15;
if(!empty($atts['number_limits'])):
 $number_limits = $atts['number_limits'];
endif;

$more_img = get_template_directory_uri().'/assets/images/svg/more.svg';
$play_img = get_template_directory_uri().'/assets/images/svg/play.svg';

$userid = get_current_user_id();
$music_ids = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);

$fav_music_ids = '';
if($userid){
    $fav_music_ids = get_user_meta($userid, 'favourites_songs_lists'.$userid, true);
}else{
    ?>
    <script>
        $(document).ready(function(){
           $("#myModal1").modal("show");
        });
    </script>
    <?php
}

if($music_ids && $userid):

	$sg_args = array('post_type' => 'ms-music',
	                'posts_per_page' => $number_limits,
	                'orderby' => 'date',
            		'order'   => 'DESC',
            		'suppress_filters' => true,
	                'post__in' => $music_ids,
	                );
	$music_posts = new WP_Query( $sg_args );
	$list_type = 'music';

if( $music_posts->have_posts() ): ?>
<!-- Top Artist Section -->
<div class="ms_top_artist">
		    <div class="container-fluid">
		        <div class="row">
		            <div class="col-lg-12">
		                <div class="ms_heading">
		                    <h1><?php echo esc_html( $history_heading ); ?></h1>
		                </div>
		            </div>
		            <?php while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
		                <div class="col-lg-2">
		                    <div class="ms_rcnt_box marger_bottom30">
		                        <div class="ms_rcnt_box_img">
		                            <?php the_post_thumbnail( 'large' ); ?>
		                            <div class="ms_main_overlay">
		                                <div class="ms_box_overlay"></div>
		                                <div class="ms_more_icon">
		                                    <img src="<?php echo esc_url($more_img); ?>" alt="<?php esc_attr_e('More', 'miraculous'); ?>">
		                                </div>
		                                <?php $attach_meta = array();
		                                    $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                            if(!empty($music_extranal_url)):
                                            	$mpurl = $music_extranal_url;
                                            else:
                                            	$mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                            endif;
		                                    if($mpurl) {
		                                        $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
		                                    }
		                                    $image_uri = get_the_post_thumbnail_url ( get_the_id() );
		                                    $fav_class = 'icon_fav';
                                            if(!empty($fav_music_ids)){
                                                if( in_array(get_the_id(), $fav_music_ids) ) {
                    			                    $fav_class = 'icon_fav_add';
                    		      	            }
                                            } ?>
		                                <ul class="more_option">
		                                    <li>
											  <a href="javascript:;" class="favourite_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('مورد علاقه', 'miraculous'); ?></a>
											</li>
		                                    <li>
											  <a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr(get_the_id()); ?>" data-musictype="<?php esc_attr($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف پخش', 'miraculous'); ?>
											  </a>
											</li>
		                                    <li>
											 <a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('الان دانلود کنید', 'miraculous'); ?>
											 </a>
											</li>
		                                    <li>
											  <a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span>
											  <?php esc_html_e('افزودن به لیست پخش', 'miraculous'); ?>
											  </a>
											</li>
		                                    <li>
											  <a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span>
											  <?php esc_html_e('اشتراک گذاری', 'miraculous'); ?>
											  </a>
											</li>
		                                    <li>
											  <a href="javascript:;" class="ms_remove_history_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_close"></span></span>
											  <?php esc_html_e('حذف', 'miraculous'); ?>
											  </a>
										    </li>
		                                </ul>
		                                <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($list_type); ?>">
		                                    <img src="<?php echo esc_url($play_img); ?>" alt="<?php  esc_attr_e('Play', 'miraculous'); ?>">
		                                </div>
		                            </div>
		                        </div>
		                        <div class="ms_rcnt_box_text">
		                            <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
		                            <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
		                            foreach ($artists_ids as $artists_id) {
		                                 $artists_name[] = get_the_title($artists_id);
		                             } ?>
		                            <p><?php echo implode(', ', $artists_name); ?></p>
		                        </div>
		                    </div>
		                </div>
		            <?php endwhile; ?>
		            <?php wp_reset_postdata(); ?>
		        </div>
		    </div>
		</div>
 <?php endif;
endif;