<?php if (!defined('FW')) die('Forbidden');

$profile_heading = '';
if(!empty($atts['profile_heading'])):
  $profile_heading = $atts['profile_heading'];
endif;
$img_preview = get_template_directory_uri().'/assets/images/pro_img.png';
$user_id = get_current_user_id();
if( $user_id ):
$name = get_the_author_meta('display_name', $user_id);
$email = get_the_author_meta('user_email', $user_id);
?>
<div class="ms_profile_wrapper">
    <h1><?php echo esc_html($profile_heading); ?></h1>
    <div class="ms_profile_box">
        <form id="ms_profile_edit" method="post">
            <div class="ms_pro_img img_edit_plus">
                <?php $img_src = get_user_meta($user_id, 'user_profile_img', true); 
                if($img_src) { ?>
                    <img src="<?php echo esc_url($img_src); ?>" alt="<?php esc_attr_e('img preview', 'miraculous'); ?>" id="img-preview" class="img-fluid">
                <?php }else{ ?>
                    <img src="<?php echo esc_url($img_preview); ?>" alt="<?php esc_attr_e('img preview', 'miraculous'); ?>" id="img-preview" class="img-fluid">
                <?php }
                ?>
                <div class="pro_img_overlay">
                    <i class="fa_icon edit_icon"></i>
                </div>
            </div>
            <div class="ms_pro_form">
                <div class="form-group">
                    <label><?php esc_html_e('نام شما *', 'miraculous'); ?></label>
                    <input type="text" class="form-control" id="ed_username" value="<?php echo esc_attr($name); ?>">
                </div>
                <div class="form-group">
                    <label><?php esc_html_e('ایمیل شما *', 'miraculous'); ?></label>
                    <input type="text" class="form-control" id="ed_useremail" value="<?php echo esc_attr($email); ?>">
                </div>
                <div class="pro-change-form-btn text-center">
                    <a href="javascript:;" class="ms_btn change_pass"><?php esc_html_e('تغییر رمز عبور', 'miraculous'); ?></a>
                </div>
                <div class="change_password_slide">
                    <div class="form-group">
                        <label><?php esc_html_e('رمز عبور جدید *', 'miraculous'); ?></label>
                        <input type="password" placeholder="<?php esc_attr_e('******','miraculous'); ?>" id="ed_password" class="form-control">
                    </div>
                    <div class="form-group">
                        <label><?php esc_html_e('تایید رمز عبور *', 'miraculous'); ?></label>
                        <input type="password" placeholder="<?php esc_attr_e('******','miraculous'); ?>" id="ed_confpassword" class="form-control">
                    </div>
                </div>
                <div class="pro-form-btn text-center marger_top15">
                    <input type="hidden" id="image-url" value="">
                    <input type="hidden" id="cur_user_id" value="<?php echo esc_attr($user_id); ?>">
                    <input type="submit" id="ms_profile_update" class="ms_btn" value="ذخیره">
                    <button class="hst_loader"><i class="fa fa-circle-o-notch fa-spin"></i> 
					<?php esc_html_e('بارگذاری', 'miraculous'); ?></button>
                    <input type="reset" class="ms_btn reset_form" value="تنظیم مجدد">
                </div>
            </div>
        </form>
     </div>
</div>
<?php endif; ?> 