<?php if (!defined('FW')) die('Forbidden');
$sg_label = $mpurl = '';
if(!empty($atts['music_label'])):
    $sg_label = $atts['music_label'];
endif;
$sg_style = 'abstyle1';
if(!empty($atts['music_style'])):
    $sg_style = $atts['music_style'];
endif;
$sg_download = '';
if(!empty($atts['music_downloadable'])):
    $sg_download = $atts['music_downloadable'];
endif;
$sg_music_types = '';
if(!empty($atts['music_types'])):
    $sg_music_types = $atts['music_types'];
endif;
$sg_number = 12;
if(!empty($atts['music_number'])):
    $sg_number = $atts['music_number'];
endif;

$music_song_view = '';
if(!empty($atts['music_song_view'])):
  $music_song_view = $atts['music_song_view'];
endif;

$music_song_dowenload = '';
if(!empty($atts['music_song_dowenload'])):
  $music_song_dowenload = $atts['music_song_dowenload'];
endif;

$list_type = 'music';
$more_img = get_template_directory_uri().'/assets/images/svg/more.svg';
$play_img = get_template_directory_uri().'/assets/images/svg/play.svg';
$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
  $miraculous_theme_data = fw_get_db_settings_option();     
endif; 
$currency = '';
if(!empty($miraculous_theme_data['paypal_currency']) && function_exists('miraculous_currency_symbol')):
    $currency = miraculous_currency_symbol( $miraculous_theme_data['paypal_currency'] );
endif;

$user_id = get_current_user_id();
$lang_data = get_option('language_filter_ids_'.$user_id);

$fav_music_ids = '';
if($user_id){
    $fav_music_ids = get_user_meta($user_id, 'favourites_songs_lists'.$user_id, true);
}

if( is_user_logged_in() && $lang_data ){
    
    $sg_args = array('post_type' => 'ms-music',
                'posts_per_page' => $sg_number,
                'meta_key' => 'fw_option:music_type',
                'meta_value' => $sg_download,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'music-type',
                            'terms' => $sg_music_types
                        ),
                        array(
                            'taxonomy' => 'language',
                            'terms' => $lang_data
                        )
                    )
                );
}elseif ( isset($_COOKIE['lang_filter']) ) {
     $lang_data = explode(',', $_COOKIE['lang_filter']);
     $sg_args = array('post_type' => 'ms-music',
                'posts_per_page' => $sg_number,
                'meta_key' => 'fw_option:music_type',
                'meta_value' => $sg_download,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'music-type',
                            'terms' => $sg_music_types
                        ),
                        array(
                            'taxonomy' => 'language',
                            'terms' => $lang_data
                        )
                    )
                );
}else{
    $sg_args = array('post_type' => 'ms-music',
                'posts_per_page' => $sg_number,
                'meta_key' => 'fw_option:music_type',
                'meta_value' => $sg_download,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'music-type',
                            'terms' => $sg_music_types
                        )
                    )
                );
}

// the query
$music_posts = new WP_Query( $sg_args );
if( $music_posts->have_posts() ): 
if( $sg_style == 'abstyle1' ): ?>
<div class="ms_fea_album_slider">
    <div class="ms_heading">
        <h1><?php echo esc_html( $sg_label ); ?></h1>
    </div>
    <div class="ms_relative_inner">
        <div class="ms_feature_slider swiper-container swiper-container-horizontal">
            <div class="swiper-wrapper">
                <?php
                $i=0; 
                while ( $music_posts->have_posts() ) : $music_posts->the_post();
                ?>
                <div class="swiper-slide<?php echo ($i==0) ? ' swiper-slide-active' : '';?>" data-swiper-slide-index="<?php echo _e($i); ?>">
                        <div class="ms_rcnt_box">
                            <div class="ms_rcnt_box_img">
                                <?php the_post_thumbnail( 'large' ); ?>
                                <div class="ms_main_overlay">
                                    <div class="ms_box_overlay"></div>
                                    <div class="ms_more_icon">
                                        <img src="<?php echo esc_url($more_img); ?>" alt="<?php echo esc_attr('More', 'miraculous'); ?>">
                                    </div>
                                    <?php $attach_meta = array();
                                        $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                        if(!empty($music_extranal_url)):
                                           $mpurl = $music_extranal_url;
                                        else:
                                           $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                        endif;
                                        if($mpurl) {
                                            $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                                        }
                                        $image_uri = get_the_post_thumbnail_url ( get_the_id() );
                                        $fav_class = 'icon_fav';
                                        if(!empty($fav_music_ids)){
                                            if( in_array(get_the_id(), $fav_music_ids) ) {
                			                    $fav_class = 'icon_fav_add';
                		      	            }
                                        } ?>
                                    <ul class="more_option">
                                        <li><a href="javascript:;" class="favourite_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('موردعلاقه ها', 'miraculous'); ?></a></li>
                                        <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف', 'miraculous'); ?></a></li>
                                        <li><a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('دانلود', 'miraculous'); ?></a></li>
                                        <li><a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span><?php esc_html_e('افزودن به لیست پخش', 'miraculous'); ?></a></li>
                                        <li><a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('اشتراک گذاری', 'miraculous'); ?></a></li>
                                    </ul>
                                    <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>">
                                        <img src="<?php echo esc_url($play_img); ?>" alt="<?php  esc_attr_e('play', 'miraculous'); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="ms_rcnt_box_text">
                                <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                                foreach ($artists_ids as $artists_id) {
                                     $artists_name[] = get_the_title($artists_id);
                                 } ?>
                                <p><?php echo implode(', ', $artists_name); ?></p>
                            </div>
                        </div>
                    </div>

                <?php $i++; endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>

            <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
            <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>

        </div>
        <!-- Add Arrows -->
        <div class="swiper-button-next1 slider_nav_next" tabindex="0" role="button" aria-label="<?php esc_attr_e('Next slide','miraculous'); ?>"></div>
        <div class="swiper-button-prev1 slider_nav_prev" tabindex="0" role="button" aria-label="<?php esc_attr_e('Previous slide','miraculous'); ?>"></div>
    </div>
</div>
<?php endif; 
if( $sg_style == 'abstyle3' ): ?>
<!----Top Artist Section---->
<div class="ms_top_artist">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="ms_heading">
                    <h1><?php echo esc_html( $sg_label ); ?></h1>
                </div>
            </div>
            <?php while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
                <div class="col-lg-2">
                    <div class="ms_rcnt_box marger_bottom30">
                        <div class="ms_rcnt_box_img">
                            <?php the_post_thumbnail( 'large' ); ?>
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                <div class="ms_more_icon">
                                    <img src="<?php echo esc_url($more_img); ?>" alt="<?php echo esc_attr__('More', 'miraculous'); ?>">
                                </div>
                                <?php $attach_meta = array();
                                    $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                    if(!empty($music_extranal_url)):
                                        $mpurl = $music_extranal_url;
                                    else:
                                        $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                    endif;
                                    if($mpurl) {
                                        $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                                    }
                                    $image_uri = get_the_post_thumbnail_url ( get_the_id() );
                                    $fav_class = 'icon_fav';
                                    if(!empty($fav_music_ids)){
                                        if( in_array(get_the_id(), $fav_music_ids) ) {
            			                    $fav_class = 'icon_fav_add';
            		      	            }
                                    } ?>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="favourite_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('موردعلاقه ها', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('دانلود', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span><?php esc_html_e('افزودن به لیست پخش', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('اشتراک گذری', 'miraculous'); ?></a></li>
                                </ul>
                                <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>">
                                    <img src="<?php echo esc_url($play_img); ?>" alt="<?php echo esc_attr('Play', 'miraculous'); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                            <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                            foreach ($artists_ids as $artists_id) {
                                 $artists_name[] = get_the_title($artists_id);
                             } ?>
                            <p><?php echo implode(', ', $artists_name); ?></p>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</div>
<?php endif; 
if( $sg_style == 'abstyle2' ): ?>
<!-- Weekly Top 15 -->
<div class="ms_weekly_wrapper ms_free_music">
    <div class="ms_weekly_inner">
        <div class="row">
            <div class="col-lg-12">
                <div class="ms_heading">
                    <h1><?php echo esc_html( $sg_label ); ?></h1>
                </div>
            </div>
            <?php 
			$i=01; $n = $music_posts->found_posts; $rm = $n%3;
			while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="ms_weekly_box">
                        <div class="weekly_left">
						   <span class="w_top_no">
                                <?php echo (strlen($i) <2) ? '0'.$i : $i; ?>
                            </span> 
                            <div class="w_top_song">
							  <div class="w_tp_song_img">
                                    <?php the_post_thumbnail( 'thumbnail' ); ?>
                                    <div class="ms_song_overlay">
                                    </div>
                                    <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>">
                                        <img src="<?php echo esc_url($play_img); ?>" alt="<?php echo esc_attr('Play', 'miraculous'); ?>">
                                    </div>
                                </div>
                                <div class="w_tp_song_name">
                                    <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                    <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                                    foreach ($artists_ids as $artists_id) {
                                         $artists_name[] = get_the_title($artists_id);
                                     } ?>
                                    <p><?php echo implode(', ', $artists_name); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php $attach_meta = array(); $music_price = '';
                            $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                            if(!empty($music_extranal_url)):
                                $mpurl = $music_extranal_url;
                            else:
                                $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                            endif;
                            if($mpurl) {
                                $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                            }
                            $image_uri = get_the_post_thumbnail_url ( get_the_id() );
                            if(!empty($miraculous_theme_data['miraculous_layout']) && $miraculous_theme_data['miraculous_layout'] == '2'):
                                $more_img = get_template_directory_uri().'/assets/images/svg/more1.svg';
                            endif;
                            if(function_exists('fw_get_db_post_option')){
                                $music_price_arr = fw_get_db_post_option(get_the_id(), 'music_type_options');
                                if( !empty( $music_price_arr['premium']['single_music_price'] ) ){
                                    $music_price = $music_price_arr['premium']['single_music_price'];
                                }
                            } 
                            ?>
                        <div class="weekly_right">
                            <span class="w_song_time"><?php echo (isset($attach_meta['length_formatted'])) ? $attach_meta['length_formatted'] : "0.00"; ?></span>
                            <span class="ms_more_icon" data-other="1">
                                <img src="<?php echo esc_url($more_img); ?>" alt="<?php echo esc_attr('More', 'miraculous'); ?>">                                
                            </span>
                            <span class="w_song_dwnload ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>">
                                <i class="ms_icon1 dwnload_icon"></i>
                                <?php 
                                if($music_song_dowenload == 'on'):
                                if(function_exists('miraculous_song_dowenload_counter')):
                                  miraculous_song_dowenload_counter(get_the_id());
                                endif;
                                endif;
                                ?>
                            </span>
                            <span class="w_song_dwnload ">
                            <?php
                            if($music_song_view == 'on'):
                            if(function_exists('miraculous_song_view_counter')):
                                miraculous_song_view_counter(get_the_id());
                            endif; 
                            endif;
                            ?>
                            </span>
                        </div>
                        <?php
                        $fav_class = 'icon_fav';
                        if(!empty($fav_music_ids)){
                            if(in_array(get_the_id(), $fav_music_ids) ) {
			                    $fav_class = 'icon_fav_add';
		      	            }
                        }
                        ?>
                        <ul class="more_option">
                            <li><a href="javascript:;" class="favourite_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('موردعلاقه ها', 'miraculous'); ?></a></li>
                            <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف', 'miraculous'); ?></a></li>
                            <li><a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('دانلود', 'miraculous'); ?></a></li>
                            <li><a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span><?php esc_html_e('افزودن به لیست پخش', 'miraculous'); ?></a></li>
                            <li><a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('اشتراک گذاری', 'miraculous'); ?></a></li>
                        </ul>
                    </div>
                    <?php if($rm == 0){
                        if($i > $n-3){
                            
                        }else{
                            echo '<div class="ms_divider"></div>';
                        }
                        }elseif($rm == 2 && $i > $n-2){
                            
                        }elseif($rm == 1 && $i > $n-1){
                            
                        }else{
                            echo '<div class="ms_divider"></div>';
                        }
                    ?>
                </div>
            <?php $i++;
			endwhile; 
            wp_reset_postdata(); ?>
        </div>
    </div>
</div>
<?php endif; 
if( $sg_style == 'abstyle4' ): ?>
<!-- New Releases Section Start -->
<div class="ms_releases_wrapper">
    <div class="ms_heading">
        <h1><?php echo esc_html( $sg_label ); ?></h1>
    </div>
    <div class="ms_release_slider swiper-container">
        <div class="ms_divider"></div>
        <div class="swiper-wrapper">
            <?php while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
                <div class="swiper-slide">
                    <div class="ms_release_box">
                        <div class="w_top_song">
                            <span class="slider_dot"></span>
                            <div class="w_tp_song_img">
                                <?php the_post_thumbnail( 'thumbnail' ); ?>
                                <div class="ms_song_overlay">
                                </div>
                                <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>">
                                    <img src="<?php echo esc_url($play_img); ?>" alt="<?php echo esc_attr('play', 'miraculous'); ?>">
                                </div>
                            </div>
                            <div class="w_tp_song_name">
                                <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                                foreach ($artists_ids as $artists_id) {
                                     $artists_name[] = get_the_title($artists_id);
                                 } ?>
                                <p><?php echo implode(', ', $artists_name); ?></p>
                            </div>
                        </div>
                        <?php $attach_meta = array();
                            $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                            if(!empty($music_extranal_url)):
                                $mpurl = $music_extranal_url;
                            else:
                                $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                            endif;
                            if($mpurl) {
                                $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                            }
                            ?>
                        <div class="weekly_right">
                            <span class="w_song_time"><?php echo (isset($attach_meta['length_formatted'])) ? $attach_meta['length_formatted'] : "0.00"; ?></span>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
    <!-- Add Arrows -->
    <div class="swiper-button-next2 slider_nav_next"></div>
    <div class="swiper-button-prev2 slider_nav_prev"></div>
</div>
<?php endif;
endif; ?>