<?php if (!defined('FW')) die('Forbidden');
$heading = '';
if(!empty($atts['manage_plan_heading'])):
  $heading = $atts['manage_plan_heading'];
endif;
$priceplan = '';
if(!empty($atts['priceplan_switch'])):
  $priceplan = $atts['priceplan_switch'];
endif;
$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
    $miraculous_theme_data = fw_get_db_settings_option();     
endif; 
$currency = '';
if(!empty($miraculous_theme_data['paypal_currency'])):
    $currency = $miraculous_theme_data['paypal_currency'];
endif;

$submit_url = plugins_url().'/miraculouscore/paypal/payments.php';

$ms_args = array('post_type' => 'ms-plans',
                'numberposts' => -1,
                'order' => 'ASC'
                );
$music_plans = new WP_Query( $ms_args );
$current_user = wp_get_current_user();

?>
<div class="ms_account_wrapper">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h2><?php esc_html_e($heading); ?></h2>
                <div class="ms_heading">
                    <h1><?php esc_html_e('طرح های اشتراک','miraculous'); ?></h1>
                </div>
            </div>
            <?php
            if( $music_plans->have_posts() ):
  			$i = 1; 
			while ( $music_plans->have_posts() ) : $music_plans->the_post();
			?>
            <div class="col-lg-4">
                 <div class="ms_plan_box <?php echo $i==2 ? 'paln_active' : ''; ?>">
                    <div class="ms_plan_header">
                        <div class="ms_plan_img">
                            <?php the_post_thumbnail( 'thumbnail' ); ?>
                        </div>
                    </div>
                    <h3 class="plan_heading"><?php the_title(); ?></h3>
                    <div class="plan_price">
					<div class="plan_dolar">
					<sup><?php
					    if(function_exists('miraculous_currency_symbol')){
                            echo miraculous_currency_symbol($currency);
                        }
					?></sup>
					<?php echo get_post_meta(get_the_id(), 'fw_option:plan_price', true); ?></div>
					</div>
                    <ul>
                       <li><?php printf( __('دانلود ماهانه - %s آهنگ ', 'miraculous'), get_post_meta(get_the_id(), 'fw_option:plan_monthly_downloads', true) ); ?></li>
                        <li><?php printf( __('اعتبار طرح - %s ماه', 'miraculous'), get_post_meta(get_the_id(), 'fw_option:plan_validity', true) ); ?></li>
                    </ul>
                    <div class="ms_plan_btn">
                        <?php if( !empty($current_user) && $current_user->ID ){ ?>
                            <form class="paypal" action="<?php echo esc_url($submit_url); ?>" method="post">
                                <input type="hidden" name="cmd" value="_xclick" />
                                <input type="hidden" name="lc" value="UK" />
                                <input type="hidden" name="first_name" value="<?php echo esc_attr($current_user->user_firstname); ?>" />
                                <input type="hidden" name="last_name" value="<?php echo esc_attr($current_user->user_lastname); ?>" />
                                <input type="hidden" name="payer_email" value="<?php echo esc_attr($current_user->user_email); ?>" />
                                <input type="hidden" name="user_id" value="<?php echo esc_attr($current_user->ID); ?>" />
                                <input type="hidden" name="item_number" value="<?php echo esc_attr(get_the_id()); ?>" / >
                                <input type="hidden" name="item_name" value="<?php the_title_attribute(); ?>" / >
                                <input type="submit" name="submit" class="ms_btn" value="<?php    esc_attr_e('پرداخت آنلاین', 'miraculous'); ?>"/>
                            </form>
                        <?php }else{ ?>
							<a href="javascript:;" class="ms_btn" data-toggle="modal" data-target="#myModal1"><?php esc_html_e('الان بخرید', 'miraculous'); ?></a>
                        <?php } ?>
                        
                    </div>
                </div>
                </div>  
            <?php  $i++; endwhile; ?>
            <?php wp_reset_postdata();
            endif; ?>
        </div>
        <?php 
		if( !empty($current_user) && $current_user->ID ):
          if($priceplan =='on'):
		?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="ms_acc_overview">
                        <div class="ms_heading">
                            <h1><?php esc_html_e('بررسی اجمالی حساب','miraculous'); ?></h1>
                        </div>
                        <?php   
                        global $wpdb;
                        $pmt_tbl = $wpdb->prefix . 'ms_payments'; 
                        $today = date('Y-m-d H:i:s');
                        $query = $wpdb->get_results( "SELECT * FROM `$pmt_tbl` WHERE user_id = $current_user->ID AND expiretime > '$today'" );
                        if($query): ?>
                            <div class="ms_acc_ovrview_list">
                                <?php $i=1; foreach($query as $row): ?>
                                    <ul>
                                        <?php 
                                        $start = date_create($today);
                                        $end = date_create($row->expiretime);
                                        $days_between = date_diff($start, $end); ?>
                                        <li><?php printf( __('طرح اشتراک شما <span>- %s</span>', 'miraculous'), get_the_title($row->itemid) ); ?></li>
                                        <li><?php printf( __('مبلغ پرداختی <span>- &#36;%s</span>', 'miraculous'), $row->payment_amount ); ?></li>
                                        <li><?php printf( __('اعتبار در پایان مییابد در <span>- %s روز</span>', 'miraculous'), $days_between->format("%a") ); ?></li>
                                        <li><?php printf( __('دانلود باقی مانده <span>- %s آهنگ</span>'), $row->remains_upload ); ?></li>
                                    </ul>
                                    <?php if($i == 1){ ?>
                                        <form class="paypal" action="<?php echo esc_url($submit_url); ?>" method="post">
                                            <input type="hidden" name="cmd" value="_xclick" />
                                            <input type="hidden" name="lc" value="UK" />
                                            <input type="hidden" name="first_name" value="<?php echo esc_attr($current_user->user_firstname); ?>" />
                                            <input type="hidden" name="last_name" value="<?php echo esc_attr($current_user->user_lastname); ?>" />
                                            <input type="hidden" name="payer_email" value="<?php echo esc_attr($current_user->user_email); ?>" />
                                        <input type="hidden" name="user_id" value="<?php echo esc_attr($current_user->ID); ?>" />
                                            <input type="hidden" name="item_number" value="<?php echo esc_attr($row->itemid); ?>" / >
                                            <input type="hidden" name="item_name" value="<?php echo the_title_attribute($row->itemid); ?>" / >
                                        <input type="submit" name="submit" class="ms_btn" value="<?php esc_attr_e('بازخوانی کردن', 'miraculous'); ?>"/>
                                        </form>
                                    <?php } ?>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div>
                            <?php 
                            esc_html_e('شما هیچ طرحی را قبول نکرده اید', 'miraculous'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php 
		  endif;
		endif; ?>

    </div>
</div> 