<?php if (!defined('FW')) die('Forbidden');

$ar_label = '';
if(!empty($atts['artists_label'])):
  $ar_label = $atts['artists_label'];
else:
  $ar_label = esc_html__('Artists','miraculous');
endif;

$ar_style = '';
if(!empty($atts['artists_style'])):
 $ar_style = $atts['artists_style'];
else:
 $ar_style = esc_html__('arstyle1','miraculous');
endif;
 
$ar_type = '';
if(!empty($atts['artists_type'])):
 $ar_type = $atts['artists_type'];
endif;

$ar_number = '';
if(!empty($atts['artists_number'])):
 $ar_number = $atts['artists_number'];
else:
 $ar_number = 12;
endif;

$musictype = 'artist';
$list_type = 'music';
$more_icone = get_template_directory_uri().'/assets/images/svg/more.svg';
$play_icone = get_template_directory_uri().'/assets/images/svg/play.svg';
$user_id = get_current_user_id();
$lang_data = get_option('language_filter_ids_'.$user_id);

if( is_user_logged_in() && $lang_data ){
    $ar_args = array('post_type' => 'ms-artists',
                    'posts_per_page' => $ar_number,
                    'tax_query' => array(
                            array(
                                'taxonomy' => 'artist-type',
                                'terms' => $ar_type
                            ),
                            array(
                                'taxonomy' => 'language',
                                'terms' => $lang_data
                            )
                        )
                    );

}elseif( isset($_COOKIE['lang_filter']) ) {
    $lang_data = explode(',', $_COOKIE['lang_filter']);
    $ar_args = array('post_type' => 'ms-artists',
                    'posts_per_page' => $ar_number,
                    'tax_query' => array(
                            array(
                                'taxonomy' => 'artist-type',
                                'terms' => $ar_type
                            ),
                            array(
                                'taxonomy' => 'language',
                                'terms' => $lang_data
                            )
                        )
                    );

}else{
    $ar_args = array('post_type' => 'ms-artists',
                    'posts_per_page' => $ar_number,
                    'tax_query' => array(
                            array(
                                'taxonomy' => 'artist-type',
                                'terms' => $ar_type
                            )
                        )
                    );

}
$artist_posts = new WP_Query($ar_args);

if( $artist_posts->have_posts() ): 

    if( $ar_style == 'arstyle1' ):
    ?>
    <div class="ms_featured_slider">
       <?php if(!empty($ar_label)): ?>
        <div class="ms_heading">
            <h1><?php echo esc_html($ar_label); ?></h1>
            <span class="veiw_all">
    		</span>
        </div>
    	<?php endif; ?>
        <div class="ms_relative_inner">
            <div class="ms_feature_slider swiper-container swiper-container-horizontal">
                <div class="swiper-wrapper">
                    <?php 
    				$i=0; 
    				while ( $artist_posts->have_posts() ) : $artist_posts->the_post();
    				?>
                    <div class="swiper-slide<?php echo ($i==0) ? ' swiper-slide-active' : '';?>" data-swiper-slide-index="<?php echo _e($i); ?>">
                            <div class="ms_rcnt_box">
                                <div class="ms_rcnt_box_img">
                                    <?php the_post_thumbnail( 'large' ); ?>
                                    <div class="ms_main_overlay">
                                        <div class="ms_box_overlay"></div>
    									<?php if(!empty($more_icone)): ?>
                                        <div class="ms_more_icon">
                                            <img src="<?php echo esc_url($more_icone); ?>" alt="<?php esc_attr_e('more icone','miraculous'); ?>">
                                        </div>
    									<?php endif;
                                            $fav_class = 'icon_fav';
                                            if(function_exists('miraculous_get_favourite_div_class')){
                                                $fav_class = miraculous_get_favourite_div_class(get_the_id(), $musictype);
                                            }
                                        ?>
                                        <ul class="more_option">
                                            <li>
    										<a href="javascript:;" class="favourite_artist" data-artistid="<?php echo esc_attr(get_the_id()); ?>">
    										<span class="opt_icon">
    										<span class="icon <?php echo esc_attr($fav_class); ?>"></span>
    										</span><?php esc_html_e('Favourites','miraculous'); ?>
    										</a>
    										</li>
                                            <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php printf($musictype); ?>">
    										<span class="opt_icon">
    										<span class="icon icon_queue"></span>
    										</span><?php esc_html_e('Add To Queue','miraculous'); ?>
    										</a>
    										</li>
                                            <li><a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon">
    										<span class="icon icon_share"></span></span>
    										<?php esc_html_e('Share','miraculous'); ?></a></li>
                                        </ul>
    									<?php if(!empty($play_icone)):?>
                                        <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php printf($musictype); ?>">
                                            <img src="<?php echo esc_url($play_icone); ?>" alt="<?php esc_attr_e('play icone','miraculous'); ?>">
                                        </div>
    									<?php endif; ?>
                                    </div>
                                </div>
                                <div class="ms_rcnt_box_text">
                                    <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                </div>
                            </div>
                        </div>
                    <?php 
    				$i++; 
    				endwhile; 
                    wp_reset_postdata(); 
    				?>
                </div>
                <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
            </div>
            <div class="swiper-button-next1 slider_nav_next" tabindex="0" role="button" aria-label="<?php esc_attr_e('Next slide','miraculous'); ?>"></div>
            <div class="swiper-button-prev1 slider_nav_prev" tabindex="0" role="button" aria-label="<?php esc_attr_e('Previous slide','miraculous'); ?>"></div>
        </div>
    </div>
    <?php else: ?>
        <div class="ms_top_artist">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
        			<?php if(!empty($ar_label)): ?>
                        <div class="ms_heading">
                            <h1><?php echo esc_html($ar_label); ?></h1>
                        </div>
        			<?php endif; ?>
                    </div>
                    <?php while ( $artist_posts->have_posts() ) : $artist_posts->the_post(); ?>
                        <div class="col-lg-2">
                            <div class="ms_rcnt_box marger_bottom30">
                                <div class="ms_rcnt_box_img">
                                    <?php the_post_thumbnail( 'large' ); ?>
                                    <div class="ms_main_overlay">
                                        <div class="ms_box_overlay"></div>
        								<?php if(!empty($more_icone)): ?>
                                        <div class="ms_more_icon">
                                            <img src="<?php echo esc_url($more_icone); ?>" alt="<?php esc_attr_e('more icone','miraculous'); ?>">
                                        </div>
        								<?php endif; 
                                            $fav_class = 'icon_fav';
                                            if(function_exists('miraculous_get_favourite_div_class')){
                                                $fav_class = miraculous_get_favourite_div_class(get_the_id(), $musictype);
                                            }
                                        ?>
                                        <ul class="more_option">
                                            <li>
        									<a href="javascript:;" class="favourite_artist" data-artistid="<?php echo esc_attr(get_the_id()); ?>">
        									<span class="opt_icon">
        									<span class="icon <?php echo esc_attr($fav_class); ?>"></span>
        									</span>
        									<?php esc_html_e('Favourites','miraculous'); ?>
        									</a>
        									</li>
                                            <li>
        									 <a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php printf($musictype); ?>">
        									 <span class="opt_icon">
        									 <span class="icon icon_queue"></span>
        									 </span>
        									 <?php esc_html_e('Add To Queue','miraculous'); ?>
        									 </a>
        									 </li>
                                            <li>
        									 <a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>">
        									 <span class="opt_icon">
        									   <span class="icon icon_share"></span>
        									 </span>
        									 <?php esc_html_e('Share','miraculous'); ?>
        									 </a>
											</li>
                                        </ul>
        								<?php if(!empty($play_icone)): ?>
                                        <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php printf($musictype); ?>">
                                            <img src="<?php echo esc_url($play_icone); ?>" alt="<?php esc_attr_e('play icone','miraculous');?>">
                                        </div>
        								<?php endif; ?>
                                    </div>
                                </div>
                                <div class="ms_rcnt_box_text">
                                    <h3><a href="<?php echo esc_url(get_the_permalink()); ?>">
        							<?php the_title(); ?></a>
									</h3>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
<?php endif;
endif;  