<?php if (!defined('FW')) die('Forbidden');
$ar_label = '';
if(!empty($atts['albums_label'])):
  $ar_label = $atts['albums_label'];
endif;
$ar_style = 'abstyle1';
if(!empty($atts['albums_style'])):
  $ar_style = $atts['albums_style'];
endif;
$ar_download = '';
if(!empty($atts['album_downloadable'])):
  $ar_download = $atts['album_downloadable'];
endif;
$ar_type = '';
if(!empty($atts['albums_type'])):
  $ar_type = $atts['albums_type'];
endif;
$ar_number = 12;
if(!empty($atts['albums_number'])):
  $ar_number = $atts['albums_number'];
endif;
$musictype = 'album';
$list_type = 'music';
$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
  $miraculous_theme_data = fw_get_db_settings_option();     
endif;
$currency = '';
if(!empty($miraculous_theme_data['paypal_currency']) && function_exists('miraculous_currency_symbol')):
    $currency = miraculous_currency_symbol( $miraculous_theme_data['paypal_currency'] );
endif;
        
$user_id = get_current_user_id();
$lang_data = get_option('language_filter_ids_'.$user_id);
$fav_album_ids = '';
if($user_id){
    $fav_album_ids = get_user_meta($user_id, 'favourites_albums_lists'.$user_id, true);
}
$play_icon = get_template_directory_uri().'/assets/images/svg/play.svg';
$more_icon = get_template_directory_uri().'/assets/images/svg/more.svg';
if( is_user_logged_in() && $lang_data ){

    $ar_args = array('post_type' => 'ms-albums',
                'posts_per_page' => $ar_number,
                'meta_key' => 'fw_option:album_type',
                'meta_value' => $ar_download,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'album-type',
                            'terms' => $ar_type
                        ),
                        array(
                            'taxonomy' => 'language',
                            'terms' => $lang_data
                        )
                    )
                );

}elseif ( isset($_COOKIE['lang_filter']) ) {
    $lang_data = explode(',', $_COOKIE['lang_filter']);

    $ar_args = array('post_type' => 'ms-albums',
                'posts_per_page' => $ar_number,
                'meta_key' => 'fw_option:album_type',
                'meta_value' => $ar_download,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'album-type',
                            'terms' => $ar_type
                        ),
                        array(
                            'taxonomy' => 'language',
                            'terms' => $lang_data
                        )
                    )
                );
}else{
    $ar_args = array('post_type' => 'ms-albums',
                'posts_per_page' => $ar_number,
                'meta_key' => 'fw_option:album_type',
                'meta_value' => $ar_download,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'album-type',
                            'terms' => $ar_type
                        )
                    )
                );
}

$album_posts = new WP_Query( $ar_args );

if( $album_posts->have_posts() ): 

    if( $ar_style == 'abstyle1' ): ?>
        <div class="ms_fea_album_slider">
            <div class="ms_heading">
                <h1><?php echo esc_html( $ar_label ); ?></h1>
            </div>
            <div class="ms_relative_inner">
                <div class="ms_slider<?php esc_attr_e($ar_type); ?> swiper-container swiper-container-horizontal" data-type="<?php esc_attr_e($ar_type); ?>">
                    <div class="swiper-wrapper">
                        <?php $i=0;
						while ( $album_posts->have_posts() ) : $album_posts->the_post(); ?>
                        <div class="swiper-slide<?php echo ($i==0) ? ' swiper-slide-active' : '';?>" data-swiper-slide-index="<?php echo _e($i); ?>">
                                <div class="ms_rcnt_box">
                                    <div class="ms_rcnt_box_img">
                                        <?php the_post_thumbnail( 'large' ); ?>
                                        <div class="ms_main_overlay">
                                            <div class="ms_box_overlay"></div>
                                            <?php if(!empty($more_icon)): ?>
                                            <div class="ms_more_icon">
                                                <img src="<?php echo esc_url($more_icon); ?>" alt="<?php esc_attr_e('More Icone','miraculous'); ?>">
                                            </div>
                                            <?php endif;
                                                $fav_class = 'icon_fav';
                                                if(!empty($fav_album_ids)){
                                                    if( in_array(get_the_id(), $fav_album_ids) ) {
                        			                    $fav_class = 'icon_fav_add';
                        		      	            }
                                                } 
                                            ?>
                                            <ul class="more_option">
                                                <li>
                                                    <a href="javascript:;" class="favourite_albums" data-albumid="<?php echo esc_attr(get_the_id()); ?>">
                                                    <span class="opt_icon">
                                                    <span class="icon <?php echo esc_attr($fav_class); ?>"></span></span>
                                                    <?php esc_html_e('موردعلاقه ','miraculous'); ?>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>">
                                                    <span class="opt_icon">
                                                    <span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف پخش','miraculous'); ?>
                                                    </a>
                                                </li>
                                                <li>
                                                 <a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('اشتراک گذاری','miraculous'); ?>
                                                </a>
                                                </li>
                                            </ul>
                                            <?php if(!empty($play_icon)): ?>
                                                <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>">
                                                    <img src="<?php echo esc_url($play_icon); ?>" alt="<?php esc_attr_e('آیکن پخش','miraculous'); ?>">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="ms_rcnt_box_text">
                                        <h3><a href="<?php echo esc_url(get_the_permalink()); ?>">
                                        <?php the_title(); ?></a></h3>
                                        <?php
                                        $artists_name = array(); 
                                        $artists_ids = fw_get_db_post_option(get_the_id(), 'album_artists'); 
                                        foreach ($artists_ids as $artists_id) {
                                             $artists_name[] = get_the_title($artists_id);
                                         } ?>
                                        <p><?php echo implode(', ', $artists_name); ?></p>
                                    </div>
                                </div>
                            </div>
                         <?php 
                         $i++;
                         endwhile;
                         wp_reset_postdata();
                         ?>
                    </div>
                    <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                    <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                 </div>
                <div class="swiper-button-next<?php esc_attr_e($ar_type); ?> slider_nav_next" tabindex="0" role="button" aria-label="<?php esc_attr_e('Next slide','miraculous'); ?>"></div>
                <div class="swiper-button-prev<?php esc_attr_e($ar_type); ?> slider_nav_prev" tabindex="0" role="button" aria-label="<?php esc_attr_e('Previous slide','miraculous'); ?>"></div>
            </div>
        </div>
    <?php endif;

    if( $ar_style == 'abstyle2' ): ?>
        <div class="ms_top_artist">
            <div class="container-fluid">
                <div class="row">
                <?php if(!empty($ar_label)): ?>
                    <div class="col-lg-12">
                        <div class="ms_heading">
                          <h1><?php echo esc_html($ar_label); ?></h1>
                        </div>
                    </div>
                <?php endif;
                     while ( $album_posts->have_posts() ) : $album_posts->the_post(); ?>
                        <div class="col-lg-2">
                            <div class="ms_rcnt_box marger_bottom30">
                                <div class="ms_rcnt_box_img">
                                    <?php the_post_thumbnail( 'large' ); ?>
                                    <div class="ms_main_overlay">
                                        <div class="ms_box_overlay"></div>
                                        <?php if(!empty($more_icon)): ?>
                                            <div class="ms_more_icon">
                                                <img src="<?php echo esc_url($more_icon); ?>" alt="<?php  esc_attr_e('more image','miraculous'); ?>">
                                            </div>
                                        <?php endif;
                                        $fav_class = 'icon_fav';
                                            if(!empty($fav_album_ids)){
                                                if( in_array(get_the_id(), $fav_album_ids) ) {
                    			                    $fav_class = 'icon_fav_add';
                    		      	            }
                                            }
                                            ?>
                                        <ul class="more_option">
                                            <li>
                                                <a href="javascript:;" class="favourite_albums" data-albumid="<?php echo esc_attr(get_the_id()); ?>">
                                                <span class="opt_icon">
                                                <span class="icon <?php echo esc_attr($fav_class); ?>"></span></span>
                                                <?php esc_html_e('موردعلاقه','miraculous'); ?></a>
                                            </li>
                                            <li>
                                               <a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف پخش','miraculous'); ?></a>
                                            </li>
                                            <li>
                                              <a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('اشتراک گذاری','miraculous'); ?>
                                              </a>
                                            </li>
                                        </ul>
                                        <?php if(!empty($play_icon)): ?>
                                            <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>">
                                              <img src="<?php echo esc_url($play_icon); ?>" alt="<?php esc_attr_e('play icone','miraculous'); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="ms_rcnt_box_text">
                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'album_artists'); 
                                    foreach ($artists_ids as $artists_id) {
                                         $artists_name[] = get_the_title($artists_id);
                                     } ?>
                                    <p><?php echo implode(',', $artists_name); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    <?php endif;

    if( $ar_style == 'abstyle3' ): ?>
        <div class="ms_weekly_wrapper">
                    <div class="ms_weekly_inner">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="ms_heading">
                                    <h1><?php echo esc_html($ar_label); ?></h1>
                                </div>
                            </div>
                        <?php $i=1; $n = $album_posts->found_posts; $rm = $n%3;
                        if(!empty($miraculous_theme_data['miraculous_layout']) && $miraculous_theme_data['miraculous_layout'] == '2'):
                            $more_icon = get_template_directory_uri().'/assets/images/svg/more1.svg';
                        endif;
                        while ( $album_posts->have_posts() ) : $album_posts->the_post(); 
                        ?>
                        <div class="col-lg-4 col-md-6">
                                    <div class="ms_weekly_box">
                                        <div class="weekly_left">
                                            <span class="w_top_no">
                                                <?php echo (strlen($i) <2) ? '0'.$i : $i; ?>
                                            </span>
                                            <div class="w_top_song">
                                                <div class="w_tp_song_img">
                                                    <?php the_post_thumbnail( 'thumbnail' ); ?>
                                                    <div class="ms_song_overlay"></div>
                                                    <?php if(!empty($play_icon)): ?>
                                                    <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>">
                                                        <img src="<?php echo esc_url($play_icon); ?>" alt="<?php esc_attr_e('play image','miraculous');?>">
                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="w_tp_song_name">
                                                    <h3><a href="<?php esc_url(the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                                    <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'album_artists'); 
                                                    foreach ($artists_ids as $artists_id) {
                                                         $artists_name[] = get_the_title($artists_id);
                                                     } ?>
                                                    <p><?php echo implode(', ', $artists_name); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="weekly_right">
                                            <span class="w_song_time">
                                            <?php if(function_exists('miraculous_total_album_length')){
                                                echo miraculous_total_album_length(get_the_id());
                                            } ?></span>
                                            <?php if(!empty($more_icon)): ?>
                                                <span class="ms_more_icon" data-other="1">
                                                    <img src="<?php echo esc_url($more_icon); ?>" alt="<?php esc_attr_e('more image','miraculous');?>">
                                                </span>
                                            <?php endif; ?>
                                        </div> 
                                        <?php
                                            $fav_class = 'icon_fav';
                                            if(!empty($fav_album_ids)){
                                                if( in_array(get_the_id(), $fav_album_ids) ) {
                                                    $fav_class = 'icon_fav_add';
                                                }
                                            } 
                                        ?>
                                        <ul class="more_option">
                                            <li>
                                                <a href="javascript:;" class="favourite_albums" data-albumid="<?php echo esc_attr(get_the_id()); ?>">
                                                <span class="opt_icon">
                                                <span class="icon <?php echo esc_attr($fav_class); ?>"></span></span>
                                                <?php esc_html_e('موردعلاقه','miraculous'); ?>
                                                </a>
                                            </li>
                                            <li>
                                              <a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('افزودن به صف پخش','miraculous'); ?>
                                              </a>
                                            </li>
                                            <li>
                                                <a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>">
                                                    <span class="opt_icon">
                                                     <span class="icon icon_share"></span>
                                                    </span>
                                                    <?php esc_html_e('اشتراک گذاری','miraculous'); ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    
                                    <?php if($rm == 0){
                                        if($i > $n-3){
                                            
                                        }else{
                                            echo '<div class="ms_divider"></div>';
                                        }
                                    }elseif($rm == 2 && $i > $n-2){
                                        
                                    }elseif($rm == 1 && $i > $n-1){
                                        
                                    }else{
                                        echo '<div class="ms_divider"></div>';
                                    }
                                    ?>
                                </div>
                             <?php 
                              $i++; 
                              endwhile;
                              wp_reset_postdata();
                            ?>
                        </div>
                    </div>
                </div>
    <?php endif;
   if( $ar_style == 'abstyle4' ): ?>
        <div class="ms_releases_wrapper">
            <div class="ms_heading">
                <h1><?php echo esc_html($ar_label); ?></h1>
                <span class="veiw_all">
                </span>
            </div>
            <div class="ms_release_slider swiper-container">
                <div class="ms_divider"></div>
                <div class="swiper-wrapper">
                    <?php while ( $album_posts->have_posts() ) : $album_posts->the_post(); ?>
                        <div class="swiper-slide">
                            <div class="ms_release_box">
                                <div class="w_top_song">
                                    <span class="slider_dot"></span>
                                    <div class="w_tp_song_img">
                                        <?php the_post_thumbnail( 'thumbnail' ); ?>
                                        <div class="ms_song_overlay"></div>
                                        <?php if(!empty($play_icon)): ?>
                                            <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($musictype); ?>">
                                                <img src="<?php echo esc_url($play_icon); ?>" alt="<?php esc_attr_e('play icone','miraculous'); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="w_tp_song_name">
                                        <h3>
										<a href="<?php echo esc_url(get_the_permalink()); ?>">
                                        <?php the_title(); ?></a>
                                        </h3>
                                        <?php 
                                        $artists_name = array();
                                        $artists_ids = fw_get_db_post_option(get_the_id(), 'album_artists'); 
                                        foreach ($artists_ids as $artists_id) {
                                             $artists_name[] = get_the_title($artists_id);
                                         } 
                                        ?>
                                        <p><?php echo implode(', ', $artists_name); ?></p>
                                    </div>
                                </div>
                                <div class="weekly_right">
                                    <span class="w_song_time"><?php if(function_exists('miraculous_total_album_length')){
                                        echo miraculous_total_album_length(get_the_id());
                                    } ?></span>
                                </div>
                            </div>
                        </div>
                     <?php 
                     endwhile;
                     wp_reset_postdata();
                    ?>
                </div>
            </div>
            <div class="swiper-button-next2 slider_nav_next"></div>
            <div class="swiper-button-prev2 slider_nav_prev"></div>
        </div>
    <?php endif;
endif;