<?php
add_action( 'init', 'miraculous_music_register_post_type' );
/**
 * Register a music post type.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_post_type
 */
function miraculous_music_register_post_type() {
	$m_labels = array(
		'name'               => _x( 'آهنگ ها', 'miraculous' ),
		'singular_name'      => _x( 'آهنگ', 'miraculous' ),
		'menu_name'          => _x( 'آهنگ ها', 'admin menu', 'miraculous' ),
		'name_admin_bar'     => _x( 'آهنگ', 'add new on admin bar', 'miraculous' ),
		'add_new'            => _x( 'افزودن جدید', 'music', 'miraculous' ),
		'add_new_item'       => __( 'افزودن آهنگ جدید', 'miraculous' ),
		'new_item'           => __( 'آهنگ جدید', 'miraculous' ),
		'edit_item'          => __( 'ویرایش آهنگ', 'miraculous' ),
		'view_item'          => __( 'مشاهده آهنگ', 'miraculous' ),
		'all_items'          => __( 'همه آهنگ ها', 'miraculous' ),
		'search_items'       => __( 'جستجو آهنگ ها', 'miraculous' ),
		'parent_item_colon'  => __( 'آهنگ های اصلی:', 'miraculous' ),
		'not_found'          => __( 'آهنگی پیدا نشد.', 'miraculous' ),
		'not_found_in_trash' => __( 'هیچ آهنگی در زباله دان وجود ندارد.', 'miraculous' )
	);

	$mp_args = array(
		'labels'             => $m_labels,
        'description'        => __( 'Description.', 'miraculous' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'ms-music' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'          => 'dashicons-media-audio',
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);

	$arp_labels = array(
		'name'               => _x( 'هنرمندان', 'miraculous' ),
		'singular_name'      => _x( 'هنرمندان', 'miraculous' ),
		'menu_name'          => _x( 'هنرمندان', 'admin menu', 'miraculous' ),
		'name_admin_bar'     => _x( 'هنرمندان', 'add new on admin bar', 'miraculous' ),
		'add_new'            => _x( 'افزودن جدید', 'Artist', 'miraculous' ),
		'add_new_item'       => __( 'افزودن هنرمند جدید', 'miraculous' ),
		'new_item'           => __( 'هنرمند جدید', 'miraculous' ),
		'edit_item'          => __( 'ویرایش هنرمند', 'miraculous' ),
		'view_item'          => __( 'مشاهده هنرمند', 'miraculous' ),
		'all_items'          => __( 'همه هنرمندان', 'miraculous' ),
		'search_items'       => __( 'جستجو هنرمندان', 'miraculous' ),
		'parent_item_colon'  => __( 'هنرمندان اصلی:', 'miraculous' ),
		'not_found'          => __( 'هنرمندی یافت نشد.', 'miraculous' ),
		'not_found_in_trash' => __( 'هنرمندی در زباله دان یافت نشد.', 'miraculous' )
	);

	$arp_args = array(
		'labels'             => $arp_labels,
        'description'        => __( 'Description.', 'miraculous' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'ms-artists' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'          => 'dashicons-microphone',
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'comments' )
	);

	$alp_labels = array(
		'name'               => _x( 'آلبوم ها', 'miraculous' ),
		'singular_name'      => _x( 'آلبوم', 'miraculous' ),
		'menu_name'          => _x( 'آلبوم ها', 'admin menu', 'miraculous' ),
		'name_admin_bar'     => _x( 'آلبوم', 'add new on admin bar', 'miraculous' ),
		'add_new'            => _x( 'افزودن جدید', 'Album', 'miraculous' ),
		'add_new_item'       => __( 'افزودن آلبوم جدید', 'miraculous' ),
		'new_item'           => __( 'آلبوم جدید', 'miraculous' ),
		'edit_item'          => __( 'ویرایش آلبوم', 'miraculous' ),
		'view_item'          => __( 'مشاهده آلبوم', 'miraculous' ),
		'all_items'          => __( 'همه آلبوم ها', 'miraculous' ),
		'search_items'       => __( 'جستجو آلبوم ها', 'miraculous' ),
		'parent_item_colon'  => __( 'آلبوم های اصلی:', 'miraculous' ),
		'not_found'          => __( 'هیچ آلبومی یافت نشد.', 'miraculous' ),
		'not_found_in_trash' => __( 'هیچ آلبومی در زباله دان وجود ندارد.', 'miraculous' )
	);

	$alp_args = array(
		'labels'             => $alp_labels,
        'description'        => __( 'Description.', 'miraculous' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'ms-albums' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'          => 'dashicons-album',
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'comments' )
	);

	$rd_labels = array(
		'name'               => _x( 'رادیوها', 'miraculous' ),
		'singular_name'      => _x( 'رادیو', 'miraculous' ),
		'menu_name'          => _x( 'رادیوها', 'admin menu', 'miraculous' ),
		'name_admin_bar'     => _x( 'رادیو', 'add new on admin bar', 'miraculous' ),
		'add_new'            => _x( 'افزودن جدید', 'Radio', 'miraculous' ),
		'add_new_item'       => __( 'افزودن رادیو جدید', 'miraculous' ),
		'new_item'           => __( 'رادیو جدید', 'miraculous' ),
		'edit_item'          => __( 'ویرایش رادیو', 'miraculous' ),
		'view_item'          => __( 'مشاهده رادیو', 'miraculous' ),
		'all_items'          => __( 'همه رادیو ها', 'miraculous' ),
		'search_items'       => __( 'جستجو رادیو', 'miraculous' ),
		'parent_item_colon'  => __( 'رادیوهای اصلی:', 'miraculous' ),
		'not_found'          => __( 'هیچ رادیویی یافت نشد.', 'miraculous' ),
		'not_found_in_trash' => __( 'هیچ رادیویی در زباله دان یافت نشد.', 'miraculous' )
	);

	$rd_args = array(
		'labels'             => $rd_labels,
        'description'        => __( 'Description.', 'miraculous' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'ms-radios' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'          => 'dashicons-media-interactive',
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'comments' )
	);

	$pl_labels = array(
		'name'               => _x( 'طرح ها', 'miraculous' ),
		'singular_name'      => _x( 'طرح', 'miraculous' ),
		'menu_name'          => _x( 'طرح ها', 'admin menu', 'miraculous' ),
		'name_admin_bar'     => _x( 'طرح', 'add new on admin bar', 'miraculous' ),
		'add_new'            => _x( 'افزودن جدید', 'Plan', 'miraculous' ),
		'add_new_item'       => __( 'افزودن طرح جدید', 'miraculous' ),
		'new_item'           => __( 'طرح جدید', 'miraculous' ),
		'edit_item'          => __( 'ویرایش طرح', 'miraculous' ),
		'view_item'          => __( 'مشاهده طرح', 'miraculous' ),
		'all_items'          => __( 'همه طرح ها', 'miraculous' ),
		'search_items'       => __( 'جستجو طرح ها', 'miraculous' ),
		'parent_item_colon'  => __( 'طرح های اصلی :', 'miraculous' ),
		'not_found'          => __( 'هیچ طرح یافت نشد.', 'miraculous' ),
		'not_found_in_trash' => __( 'هیچ طرحی در زباله دان یافت نشد.', 'miraculous' )
	);

	$pl_args = array(
		'labels'             => $pl_labels,
        'description'        => __( 'Description.', 'miraculous' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'ms-plans' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'          => 'dashicons-products',
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail' )
	);

	register_post_type( 'ms-music', $mp_args );
	register_post_type( 'ms-artists', $arp_args );
	register_post_type( 'ms-albums', $alp_args );
	register_post_type( 'ms-radios', $rd_args );
	register_post_type( 'ms-plans', $pl_args );

	// Add new taxonomy, make it hierarchical (like categories)
		$gen_labels = array(
			'name'              => _x( 'دسته ها', 'miraculous' ),
			'singular_name'     => _x( 'دسته', 'miraculous' ),
			'search_items'      => __( 'جستجو دسته', 'miraculous' ),
			'all_items'         => __( 'همه دسته ها', 'miraculous' ),
			'parent_item'       => __( 'دسته اصلی', 'miraculous' ),
			'parent_item_colon' => __( 'دسته اصلی:', 'miraculous' ),
			'edit_item'         => __( 'ویرایش دسته', 'miraculous' ),
			'update_item'       => __( 'بروزرسانی دسته', 'miraculous' ),
			'add_new_item'      => __( 'افزودن دسته جدید', 'miraculous' ),
			'new_item_name'     => __( 'نام دسته جدید', 'miraculous' ),
			'menu_name'         => __( 'دسته ها', 'miraculous' ),
		);

		$gen_args = array(
			'hierarchical'      => true,
			'labels'            => $gen_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'genre' ),
		);

	/* Add new taxonomy, make it hierarchical (like categories) */
		$lan_labels = array(
			'name'              => _x( 'زبان ها', 'miraculous' ),
			'singular_name'     => _x( 'زبان ها', 'miraculous' ),
			'search_items'      => __( 'جستجو زبان ها', 'miraculous' ),
			'all_items'         => __( 'همه زبان ها', 'miraculous' ),
			'parent_item'       => __( 'زبان اصلی', 'miraculous' ),
			'parent_item_colon' => __( 'زبان اصلی:', 'miraculous' ),
			'edit_item'         => __( 'ویرایش زبان', 'miraculous' ),
			'update_item'       => __( 'بروزرسانی زبان', 'miraculous' ),
			'add_new_item'      => __( 'افزودن زبان جدید', 'miraculous' ),
			'new_item_name'     => __( 'نام زبان جدید', 'miraculous' ),
			'menu_name'         => __( 'زبان', 'miraculous' ),
		);

		$lan_args = array(
			'hierarchical'      => true,
			'labels'            => $lan_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'language' ),
		);

	/* Add new taxonomy, make it hierarchical (like categories) */
		$arty_labels = array(
			'name'              => _x( 'انواع هنرمندان', 'miraculous' ),
			'singular_name'     => _x( 'انواع هنرمندان', 'miraculous' ),
			'search_items'      => __( 'جستجو انواع هنرمندان', 'miraculous' ),
			'all_items'         => __( 'همه انواع هنرمندان', 'miraculous' ),
			'parent_item'       => __( 'نوع هنرمند اصلی', 'miraculous' ),
			'parent_item_colon' => __( 'نوع هنرمند اصلی:', 'miraculous' ),
			'edit_item'         => __( 'ویرایش نوع هنرمند', 'miraculous' ),
			'update_item'       => __( 'بروز رسانی نوع هنرمند', 'miraculous' ),
			'add_new_item'      => __( 'افزودن نوع جدید هنرمند', 'miraculous' ),
			'new_item_name'     => __( 'نام نوع جدید هنرمند', 'miraculous' ),
			'menu_name'         => __( 'انواع هنرمندان', 'miraculous' ),
		);

		$arty_args = array(
			'hierarchical'      => true,
			'labels'            => $arty_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'artist-type' ),
		);

	/* Add new taxonomy, make it hierarchical (like categories) */
		$alty_labels = array(
			'name'              => _x( 'انواع آلبوم', 'miraculous' ),
			'singular_name'     => _x( 'انواع آلبوم', 'miraculous' ),
			'search_items'      => __( 'جستجو انواع آلبوم', 'miraculous' ),
			'all_items'         => __( 'همه انواع آلبوم', 'miraculous' ),
			'parent_item'       => __( 'نوع آلبوم اصلی', 'miraculous' ),
			'parent_item_colon' => __( 'نوع آلبوم اصلی:', 'miraculous' ),
			'edit_item'         => __( 'ویرایش نوع آلبوم', 'miraculous' ),
			'update_item'       => __( 'بروز رسانی نوع آلبوم', 'miraculous' ),
			'add_new_item'      => __( 'افزودن نوع آلبوم جدید', 'miraculous' ),
			'new_item_name'     => __( 'نام نوع جدید آلبوم', 'miraculous' ),
			'menu_name'         => __( 'نوع آلبوم', 'miraculous' ),
		);

		$alty_args = array(
			'hierarchical'      => true,
			'labels'            => $alty_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'album-type' ),
		);

	/* Add new taxonomy, make it hierarchical (like categories) */
		$mty_labels = array(
			'name'              => _x( 'انواع آهنگ', 'miraculous' ),
			'singular_name'     => _x( 'انواع آهنگ', 'miraculous' ),
			'search_items'      => __( 'جستجو انواع آهنگ', 'miraculous' ),
			'all_items'         => __( 'همه انواع آهنگ', 'miraculous' ),
			'parent_item'       => __( 'نوع آهنگ اصلی', 'miraculous' ),
			'parent_item_colon' => __( 'نوع آهنگ اصلی:', 'miraculous' ),
			'edit_item'         => __( 'ویرایش نوع آهنگ', 'miraculous' ),
			'update_item'       => __( 'بروز رسانی نوع آهنگ', 'miraculous' ),
			'add_new_item'      => __( 'افزودن نوع جدید آهنگ ', 'miraculous' ),
			'new_item_name'     => __( 'نام نوع جدید آهنگ ', 'miraculous' ),
			'menu_name'         => __( 'نوع آهنگ', 'miraculous' ),
		);

		$mty_args = array(
			'hierarchical'      => true,
			'labels'            => $mty_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'music-type' ),
		);

	/* Add new taxonomy, make it hierarchical (like categories) */
		$rdtax_labels = array(
			'name'              => _x( 'انواع رادیو', 'miraculous' ),
			'singular_name'     => _x( 'نوع رادیو', 'miraculous' ),
			'search_items'      => __( 'جستجو انواع رادیو', 'miraculous' ),
			'all_items'         => __( 'همه انواع رادیو', 'miraculous' ),
			'parent_item'       => __( 'نوع رادیو اصلی', 'miraculous' ),
			'parent_item_colon' => __( 'نوع رادیو اصلی:', 'miraculous' ),
			'edit_item'         => __( 'ویرایش نوع رادیو', 'miraculous' ),
			'update_item'       => __( 'بروز رسانی نوع رادیو', 'miraculous' ),
			'add_new_item'      => __( 'افزودن نوع جدید رادیو', 'miraculous' ),
			'new_item_name'     => __( 'نام نوع جدید رادیو', 'miraculous' ),
			'menu_name'         => __( 'نوع رادیو', 'miraculous' ),
		);

		$rdtax_args = array(
			'hierarchical'      => true,
			'labels'            => $rdtax_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'radio-type' ),
		);


		register_taxonomy( 'genre', array( 'ms-music', 'ms-artists', 'ms-albums', 'ms-radios' ), $gen_args );
		register_taxonomy( 'language', array( 'ms-music', 'ms-artists', 'ms-albums', 'ms-radios' ), $lan_args );
		register_taxonomy( 'music-type', array( 'ms-music' ), $mty_args );
		register_taxonomy( 'artist-type', array( 'ms-artists' ), $arty_args );
		register_taxonomy( 'album-type', array( 'ms-albums' ), $alty_args );
		register_taxonomy( 'radio-type', array( 'ms-radios' ), $rdtax_args );
}


function miraculous_music_save_meta_box_fields( $post_id ) {
	global $post;

	if ( is_admin() && current_user_can( 'manage_options' )  ) {
	      
		$post_type = get_post_type($post_id);

		extract($_POST);

		if( defined('FW') && isset($fw_options) && function_exists('fw_get_db_post_option')){
			if( $post_type == "ms-artists" ) {
				update_post_meta($post_id, 'artists_type', $fw_options['artists_type']);
			}

			if( $post_type == "ms-albums" ) {
				update_post_meta($post_id, 'album_type', $fw_options['album_type']);
				update_post_meta($post_id, 'album_artists', $fw_options['album_artists']);
			}

			if( $post_type == "ms-radios" ) {
				update_post_meta($post_id, 'radio_artists', $fw_options['radio_artists']);
			}

			if( $post_type == "ms-music" ) {
				update_post_meta($post_id, 'fw_option:music_type', $fw_options['music_type_options']['music_type']);
			}
		}
	}

}
add_action( 'save_post', 'miraculous_music_save_meta_box_fields' );


/* Add the custom columns to the artist post type: */
add_filter( 'manage_ms-music_posts_columns', 'miraculous_set_custom_artist_name_columns' );
function miraculous_set_custom_artist_name_columns($columns) {
	if(function_exists('fw_get_db_post_option')){
		# Insert at offset 3
		$offset = 3;
		$columns = array_slice($columns, 0, $offset, true) +
		            array('artists_name' => 'Artists Name') +
		            array_slice($columns, $offset, NULL, true);
	}

    return $columns;
}

/* Add the data to the custom columns for the book post type: */
add_action( 'manage_ms-music_posts_custom_column' , 'miraculous_custom_artist_name_columns_value', 10, 2 );
function miraculous_custom_artist_name_columns_value( $column, $post_id ) {
	if(function_exists('fw_get_db_post_option')){
		switch ( $column ) {

		    case 'artists_name' :
		    	$artists_name = array();
		        $artists_ids = fw_get_db_post_option($post_id, 'music_artists');
		        if( empty($artists_ids) ) {
		        	echo __('—', 'miraculous');
		        }else {
		        	foreach ($artists_ids as $artists_id) {
		                $artists_name[] = get_the_title($artists_id);
		            }
		            echo implode(',', $artists_name);
		        }
		        break;
		}
	}
    
}
?>