<?php
/**
 * Enqueue Google Web Fonts.
 */
function pixzlo_theme_default_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */ 
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'pixzlo' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Poppins:400,300&amp;subset=latin' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
function pixzlo_enqueue_google_web_fonts() {
	wp_enqueue_style( 'google-fonts', pixzlo_theme_default_fonts_url(), array(), null, 'all' );
}
function pixzlo_default_theme_options(){
	$cur_theme = wp_get_theme();	
	if ( $cur_theme->get( 'Name' ) == 'Pixzlo' || $cur_theme->get( 'Name' ) == 'Pixzlo Child' ){
		$input_val = pixzlo_default_theme_values();
		$pixzlo_options = json_decode( $input_val, true );
		update_option( 'pixzlo_options', $pixzlo_options );
		pixzlo_save_theme_options();
	}
}
if ( ! class_exists( 'PixzloRedux' ) ) {
	add_action( 'wp_enqueue_scripts', 'pixzlo_enqueue_google_web_fonts' );
	add_action("after_switch_theme", "pixzlo_default_theme_options", 10);
}
function pixzlo_default_theme_values(){
	$theme_opt_def =  '{"last_tab":"","page-layout":"wide","site-width":{"width":"1170px","units":"px"},"page-content-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"page-loader":"yes","page-loader-img":{"url":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/page-loader.gif","id":"2229","height":"60","width":"60","thumbnail":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/page-loader.gif"},"infinite-loader-img":{"url":"","id":"","height":"","width":"","thumbnail":""},"logo":{"url":"","id":"","height":"","width":"","thumbnail":""},"logo-height":{"height":"","units":"px"},"sticky-logo":{"url":"","id":"","height":"","width":"","thumbnail":""},"sticky-logo-height":{"height":"","units":"px"},"mobile-logo":{"url":"","id":"","height":"","width":"","thumbnail":""},"mobile-logo-height":{"height":"","units":"px"},"mailchimp-api":"","google-api":"","comments-type":"wp","comments-like":"0","comments-share":"0","fb-developer-key":"","fb-comments-number":"5","fb-comments-width":{"width":"500px","units":"px"},"smooth-opt":"0","scroll-time":"600","scroll-distance":"40","pixzlo_grid_large":{"width":"440px","height":"260px","units":"px"},"pixzlo_grid_medium":{"width":"370px","height":"324px","units":"px"},"pixzlo_grid_small":{"width":"220px","height":"130px","units":"px"},"pixzlo_team_medium":{"width":"500px","height":"667px","units":"px"},"rtl":"0","header-ads-text":"","header-ads-md":"yes","header-ads-sm":"yes","header-ads-xs":"yes","footer-ads-text":"","footer-ads-md":"yes","footer-ads-sm":"yes","footer-ads-xs":"yes","sidebar-ads-text":"","sidebar-ads-md":"yes","sidebar-ads-sm":"yes","sidebar-ads-xs":"yes","artical-top-ads-text":"","artical-top-ads-md":"yes","artical-top-ads-sm":"yes","artical-top-ads-xs":"yes","artical-inline-ads-text":"","artical-inline-ads-md":"yes","artical-inline-ads-sm":"yes","artical-inline-ads-xs":"yes","artical-bottom-ads-text":"","artical-bottom-ads-md":"yes","artical-bottom-ads-sm":"yes","artical-bottom-ads-xs":"yes","custom1-ads-text":"","custom1-ads-md":"yes","custom1-ads-sm":"yes","custom1-ads-xs":"yes","custom2-ads-text":"","custom2-ads-md":"yes","custom2-ads-sm":"yes","custom2-ads-xs":"yes","custom3-ads-text":"","custom3-ads-md":"yes","custom3-ads-sm":"yes","custom3-ads-xs":"yes","custom4-ads-text":"","custom4-ads-md":"yes","custom4-ads-sm":"yes","custom4-ads-xs":"yes","custom5-ads-text":"","custom5-ads-md":"yes","custom5-ads-sm":"yes","custom5-ads-xs":"yes","theme-color":"#eb2f5b","secondary-color":"#1e4398","theme-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"body-background":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"body-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"","font-size":"14px","line-height":"28px","letter-spacing":"","color":"#555555"},"h1-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"60px","line-height":"68px","letter-spacing":"","color":""},"h2-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"42px","line-height":"50px","letter-spacing":"","color":""},"h3-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"35px","line-height":"43px","letter-spacing":"","color":""},"h4-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"28px","line-height":"36px","letter-spacing":"","color":""},"h5-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"24px","line-height":"32px","letter-spacing":"","color":""},"h6-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"20px","line-height":"30px","letter-spacing":"","color":""},"widgets-title":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"latin","text-align":"","font-size":"22px","line-height":"32px","letter-spacing":"","color":""},"widgets-content":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"latin","text-align":"inherit","font-size":"14px","line-height":"26px","letter-spacing":"","color":""},"header-layout":"wide","header-type":"default","header-background":{"background-color":"#ffffff","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"header-items":{"Normal":{"placebo":"placebo"},"Sticky":{"placebo":"placebo","header-nav":"Nav Bar"},"disabled":{"placebo":"placebo","header-logo":"Logo Section","header-topbar":"Top Bar"}},"header-phone-text":" 88 01682648101","header-address-text":"No. 12, Wales street, Australia.","header-email-text":"info@yoursite.com","header-slider-position":"bottom","header-absolute":"0","sticky-part":"1","sticky-part-scrollup":"0","mainmenu-menutype":"advanced","menu-tag":"1","menu-tag-hot-text":"Hot","menu-tag-hot-bg":"#ff0000","menu-tag-new-text":"New","menu-tag-new-bg":"#3940ff","menu-tag-trend-text":"Trend","menu-tag-trend-bg":"#7d0fcc","main-menu-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","letter-spacing":"","color":""},"secondary-menu":"0","secondary-menu-type":"right-overlay","secondary-menu-space-width":{"width":"350px","units":"px"},"secondary-space-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","line-height":"20px","letter-spacing":"","color":""},"secondary-space-link-color":{"regular":"","hover":"","active":""},"secondary-space-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"secondary-space-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"secondary-space-background":{"background-color":"#ececec","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"dropdown-menu-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"16px","line-height":"24px","letter-spacing":"","color":""},"dropdown-menu-background":{"color":"","alpha":"","rgba":""},"dropdown-menu-link-color":{"regular":"#333333","hover":"#eb2f5b","active":"#eb2f5b"},"dropdown-menu-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"header-top-sliding-switch":"0","header-top-sliding-device":["desktop","tab"],"header-top-sliding-cols":"3","header-top-sliding-sidebar-1":"","header-top-sliding-sidebar-2":"","header-top-sliding-sidebar-3":"","header-top-sliding-sidebar-4":"","top-sliding-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","line-height":"","letter-spacing":"","color":""},"top-sliding-background":{"color":"","alpha":"","rgba":""},"top-sliding-link-color":{"regular":"","hover":"","active":""},"top-sliding-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"top-sliding-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"search-toggle-form":"1","header-topbar-height":{"height":"65px","units":"px"},"header-topbar-sticky-height":{"height":"50px","units":"px"},"header-topbar-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"inherit","text-transform":"","font-size":"16px","letter-spacing":"","color":"#bab9c0"},"header-topbar-background":{"color":"#18152c","alpha":"1","rgba":"rgba(24,21,44,1)"},"header-topbar-link-color":{"regular":"#9a98a2","hover":"#eb2f5b","active":"#eb2f5b"},"header-topbar-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"solid","border-color":"#ececec"},"header-topbar-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"header-topbar-text-1":"<div class=\"welcome-txt\">Providing awesome since 2001 years<\/div>","header-topbar-text-2":"<div class=\"header-phone\"><a href=\"tel:8801912704287\"><span class=\"flaticon-telephone theme-color\"><\/span>  88 01912704287<\/a><\/div>","header-topbar-date":"l, F j, Y","header-topbar-ads-list":"","header-topbar-items":{"disabled":{"placebo":"placebo","header-topbar-ads-list":"Ads","header-topbar-date":"Date","header-phone":"Phone Number","header-address":"Address Text","header-topbar-text-1":"Custom Text 1","header-topbar-social":"Social","header-email":"Email","header-topbar-search":"Search"},"Left":{"placebo":"placebo","header-topbar-text-2":"Custom Text 2"},"Center":{"placebo":"placebo"},"Right":{"placebo":"placebo","header-topbar-menu":"Top Bar Menu"}},"header-logobar-height":{"height":"100px","units":"px"},"header-logobar-sticky-height":{"height":"80px","units":"px"},"header-logobar-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","letter-spacing":"","color":"#272727"},"header-logobar-background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"header-logobar-link-color":{"regular":"","hover":"#eb2f5b","active":"#eb2f5b"},"header-logobar-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"header-logobar-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"sticky-header-logobar-color":"","sticky-header-logobar-background":{"color":"","alpha":"","rgba":""},"sticky-header-logobar-link-color":{"regular":"","hover":"","active":""},"sticky-header-logobar-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"sticky-header-logobar-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"header-logobar-text-1":"<ul class=\"nav header-info\"> <li class=\"nav-item\"><div class=\"media\"><i class=\"ti-map-alt\"><\/i><div class=\"media-body\"><h6 class=\"mt-0\">Main Office<\/h6> 236 advice the good, CA<\/div><\/div><\/li>  <li class=\"nav-item\"><div class=\"media\"><i class=\"ti-face-smile\"><\/i><div class=\"media-body\"><h6 class=\"mt-0\"> Trusted By<\/h6>200000  User<\/div><\/div><\/li>  <li class=\"nav-item\"><div class=\"media\"><i class=\"ti-email\"><\/i><div class=\"media-body\"><h6 class=\"mt-0\"> Email<\/h6><a href=\"mailto:infous@gmail.com\">infous@gmail.com<\/a><\/div><\/div><\/li>  <\/ul>","header-logobar-text-2":"<div class=\"header-button\"><a href=\"http:\/\/demo.zozothemes.com\/fahbiz\/contact-us\/\" class=\"btn btn-md\">Get a Quote<\/a><\/div>","header-logobar-ads-list":"","header-logobar-items":{"disabled":{"placebo":"placebo","header-logobar-social":"Social","header-logobar-text-2":"Custom Text 2","header-address":"Address Text","header-phone":"Phone Number","header-logobar-menu":"Main Menu","header-logobar-ads-list":"Ads","header-logobar-search":"Search","header-logobar-search-toggle":"Search Toggle","header-logobar-secondary-toggle":"Secondary Toggle","header-email":"Email"},"Left":{"placebo":"placebo","header-logobar-logo":"Logo","header-logobar-sticky-logo":"Sticky Logo"},"Center":{"placebo":"placebo"},"Right":{"placebo":"placebo","header-logobar-text-1":"Custom Text 1"}},"header-navbar-float":"0","header-navbar-height":{"height":"100px","units":"px"},"header-navbar-sticky-height":{"height":"90px","units":"px"},"header-navbar-typography":{"font-family":"Poppins","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"","text-align":"inherit","text-transform":"","font-size":"15px","letter-spacing":"","color":"#18152c"},"header-navbar-background":{"color":"#ffffff","alpha":"0","rgba":"rgba(255,255,255,0)"},"header-navbar-link-color":{"regular":"#18152c","hover":"#eb2f5b","active":"#eb2f5b"},"header-navbar-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"solid","border-color":""},"header-navbar-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"sticky-header-navbar-color":"","sticky-header-navbar-background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"sticky-header-navbar-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"sticky-header-navbar-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"sticky-header-navbar-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"header-navbar-text-1":"","header-navbar-text-2":"","header-navbar-ads-list":"","header-navbar-items":{"disabled":{"placebo":"placebo","header-navbar-text-2":"Custom Text 2","header-navbar-secondary-toggle":"Secondary Toggle","header-navbar-ads-list":"Ads","header-phone":"Phone Number","header-address":"Address Text","header-navbar-social":"Social","header-navbar-search":"Search","header-email":"Email","header-navbar-text-1":"Custom Text 1","header-cart":"Cart"},"Left":{"placebo":"placebo","header-navbar-logo":"Logo","header-navbar-sticky-logo":"Sticky Logo"},"Center":{"placebo":"placebo"},"Right":{"placebo":"placebo","header-navbar-menu":"Main Menu","header-navbar-search-toggle":"Search Toggle"}},"header-fixed-width":{"width":"350px","units":"px"},"header-fixed-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","letter-spacing":"","color":""},"header-fixed-link-color":{"regular":"","hover":"#eb2f5b","active":"#eb2f5b"},"header-fixed-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"header-fixed-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"header-fixed-background":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"header-fixed-text-1":"","header-fixed-text-2":"","header-fixed-items":{"disabled":{"placebo":"placebo","header-fixed-text-1":"Custom Text 1","header-fixed-social":"Social","header-fixed-text-2":"Custom Text 2","header-fixed-search":"Search Form"},"Top":{"placebo":"placebo","header-fixed-logo":"Logo"},"Middle":{"placebo":"placebo","header-fixed-menu":"Menu"},"Bottom":{"placebo":"placebo"}},"mobile-header-from":"tab-land","mobile-header-height":{"height":"80px","units":"px"},"mobile-header-background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"mobile-header-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"mobile-header-sticky":"0","mobile-header-sticky-scrollup":"0","mobile-header-sticky-height":{"height":"60px","units":"px"},"mobile-header-sticky-background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"mobile-header-sticky-link-color":{"regular":"#11caff","hover":"#11caff","active":"#11caff"},"mobile-header-items":{"disabled":{"placebo":"placebo","mobile-header-search":"Search Icon","mobile-header-cart":"Cart Icon"},"Left":{"placebo":"placebo","mobile-header-logo":"Logo"},"Center":{"placebo":"placebo"},"Right":{"placebo":"placebo","mobile-header-menu":"Menu Icon"}},"mobile-menu-max-width":{"width":"","units":"px"},"mobile-menu-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"inherit","text-transform":"","font-size":"16px","letter-spacing":"","color":"#000000"},"mobile-menu-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"mobile-menu-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"mobile-menu-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"mobile-menu-background":{"background-color":"#ffffff","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"mobile-menu-animate-from":"top","mobile-menu-text-1":"[pixzlo_vc_button extra_class=\"btn-block\" btn_txt=\"Get Quote\" btn_style=\"rounded\" btn_hbg_trans=\"c\" font_color=\"#ffffff\" font_hcolor=\"#ffffff\" btn_hbg_color=\"#eb2f5b\"]","mobile-menu-text-2":"","mobile-menu-items":{"disabled":{"placebo":"placebo","mobile-menu-search":"Search Form","mobile-menu-text-2":"Custom Text 2","mobile-menu-social":"Social"},"Top":{"placebo":"placebo"},"Middle":{"placebo":"placebo","mobile-menu-logo":"Logo","mobile-menu-mainmenu":"Menu","mobile-menu-text-1":"Custom Text 1"},"Bottom":{"placebo":"placebo"}},"footer-layout":"wide","back-to-top":"1","hidden-footer":"0","footer-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","letter-spacing":"","color":""},"footer-link-color":{"regular":"","hover":"","active":""},"footer-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"footer-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"footer-background":{"background-color":"","background-repeat":"","background-size":"cover","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":"http:\/\/localhost\/pixzlo\/wp-content\/uploads\/2018\/11\/footer_bg-80x80.png"}},"footer-background-overlay":{"color":"","alpha":"","rgba":""},"footer-ads-list":"","footer-items":{"Enabled":{"placebo":"placebo","footer-middle":"Footer Middle","footer-bottom":"Footer Bottom"},"disabled":{"placebo":"placebo","footer-top":"Footer Top"}},"footer-top-container":"boxed","footer-top-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"","letter-spacing":"","color":"#ffffff"},"footer-top-background":{"color":"","alpha":"","rgba":""},"footer-top-link-color":{"regular":"#ffffff","hover":"#ffffff","active":"#ffffff"},"footer-top-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"footer-top-padding":{"padding-top":"20px","padding-right":"30px","padding-bottom":"20px","padding-left":"30px","units":"px"},"footer-top-margin":{"margin-top":"","margin-right":"","margin-bottom":"","margin-left":"","units":"px"},"footer-top-title-color":"","footer-top-layout":"4-4-4","footer-top-sidebar-1":"","footer-top-sidebar-2":"","footer-top-sidebar-3":"","footer-top-sidebar-4":"","footer-middle-container":"wide","footer-middle-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"inherit","text-transform":"","font-size":"14px","letter-spacing":"","color":"#000000"},"footer-middle-background":{"color":"","alpha":"","rgba":""},"footer-middle-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"footer-middle-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"footer-middle-padding":{"padding-top":"100px","padding-right":"","padding-bottom":"75px","padding-left":"","units":"px"},"footer-middle-margin":{"margin-top":"","margin-right":"","margin-bottom":"","margin-left":"","units":"px"},"footer-middle-title-color":"#000000","footer-middle-layout":"4-2-2-4","footer-middle-sidebar-1":"sidebar-2","footer-middle-sidebar-2":"sidebar-3","footer-middle-sidebar-3":"sidebar-4","footer-middle-sidebar-4":"","footer-bottom-container":"wide","copyright-text":"Copyright &copy; 2018 <a href=\"#\" class=\"default-color\">Pixzlo<\/a> Template by \r\n <a href=\"http:\/\/zozothemes.com\/\" class=\"default-color\">ZozoThemes<\/a>","footer-bottom-fixed":"0","footer-bottom-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","text-transform":"","font-size":"14px","letter-spacing":"","color":"#9d9d9d"},"footer-bottom-background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"footer-bottom-link-color":{"regular":"#ffffff","hover":"#eb2f5b","active":"#eb2f5b"},"footer-bottom-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"footer-bottom-padding":{"padding-top":"25px","padding-right":"","padding-bottom":"25px","padding-left":"","units":"px"},"footer-bottom-margin":{"margin-top":"","margin-right":"","margin-bottom":"","margin-left":"","units":"px"},"footer-bottom-title-color":"","footer-bottom-widget":"","footer-bottom-items":{"disabled":{"placebo":"placebo","social":"Footer Social Links","menu":"Footer Menu","widget":"Custom Widget"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","copyright":"Copyright Text"},"Right":{"placebo":"placebo"}},"page-page-title-opt":"1","template-page-color":"#000000","template-page-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-page-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-page-padding":{"padding-top":"125px","padding-right":"","padding-bottom":"125px","padding-left":"","units":"px"},"template-page-background-all":{"background-color":"","background-repeat":"no-repeat","background-size":"cover","background-attachment":"inherit","background-position":"center center","background-image":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg","media":{"id":"1937","height":"450","width":"1920","thumbnail":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg"}},"page-page-title-parallax":"0","page-page-title-bg":"0","page-page-title-video":"","page-page-title-overlay":{"color":"","alpha":"","rgba":""},"page-page-desc":"","page-float-video-option":"0","page-float-video":"UWF7dZTLW4c","page-float-video-title":"A good example of a traditional\r\nB2B market is automobile \r\nmanufacturing","template-page-pagetitle-items":{"disabled":{"placebo":"placebo","description":"Description"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","title":"Page Title Text","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"page-page-template":"no-sidebar","page-left-sidebar":"","page-right-sidebar":"sidebar-1","page-sidebar-sticky":"1","page-page-hide-sidebar":"1","theme-templates":["archive","category","tag","search","author"],"theme-categories":"","search-content":"post","single-post-page-title-opt":"1","template-single-post-color":"#ffffff","template-single-post-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-single-post-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-single-post-padding":{"padding-top":"80px","padding-right":"","padding-bottom":"80px","padding-left":"","units":"px"},"template-single-post-background-all":{"background-color":"#f6f6f6","background-repeat":"no-repeat","background-size":"inherit","background-attachment":"","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":"http:\/\/localhost\/pixzlo\/wp-content\/uploads\/2018\/10\/title_bg-1-80x80.png"}},"single-post-page-title-parallax":"0","single-post-page-title-bg":"0","single-post-page-title-video":"","single-post-page-title-overlay":{"color":"","alpha":"","rgba":""},"single-post-float-video-option":"0","single-post-float-video":"UWF7dZTLW4c","single-post-float-video-title":"A good example of a traditional\r\nB2B market is automobile \r\nmanufacturing","template-single-post-pagetitle-items":{"disabled":{"placebo":"placebo","title":"Page Title Text"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"single-post-featured-slider":"0","single-post-article-color":"","single-post-article-link-color":{"regular":"","hover":"","active":""},"single-post-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"single-post-article-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"single-post-article-background":{"color":"","alpha":"","rgba":""},"single-post-article-overlay-color":"","single-post-article-overlay-link-color":{"regular":"","hover":"","active":""},"single-post-article-overlay-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"single-post-article-overlay-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"single-post-article-overlay-margin":{"margin-top":"","margin-right":"","margin-bottom":"","margin-left":"","units":"px"},"single-post-article-overlay-background":{"color":"","alpha":"","rgba":""},"single-post-video-format":"onclick","single-post-quote-format":"featured","single-post-link-format":"featured","single-post-gallery-format":"default","single-post-page-template":"right-sidebar","single-post-left-sidebar":"","single-post-right-sidebar":"sidebar-1","single-post-sidebar-sticky":"0","single-post-page-hide-sidebar":"1","single-post-full-wrap":"0","article-top-ads-list":"","article-inline-ads-list":"","article-bottom-ads-list":"","single-post-topmeta-items":{"Left":{"placebo":"placebo","comments":"Comments","author":"Author"},"Right":{"placebo":"placebo"},"disabled":{"placebo":"placebo","social":"Social Share","category":"Category","date":"Date","views":"Views","tag":"Tags","favourite":"Favourite","likes":"Likes"}},"single-post-bottommeta-items":{"Left":{"placebo":"placebo","tag":"Tags"},"Right":{"placebo":"placebo","category":"Category"},"disabled":{"placebo":"placebo","social":"Social Share","favourite":"Favourite","date":"Date","comments":"Comments","likes":"Likes","author":"Author","views":"Views"}},"single-post-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","content":"Content","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo"}},"single-post-overlay-opt":"0","single-post-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title","top-meta":"Top Meta"},"disabled":{"placebo":"placebo","bottom-meta":"Bottom Meta"}},"single-post-page-items":{"Enabled":{"placebo":"placebo","post-items":"Post Items","post-nav":"Post Navigation","comment":"Comment"},"disabled":{"placebo":"placebo","article-inline-ads-list":"Article Inline Ads","author-info":"Author Info","related-slider":"Related Slider"}},"related-max-posts":"5","related-posts-filter":"category","blog-page-title-opt":"1","template-blog-color":"#000000","template-blog-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-blog-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-blog-padding":{"padding-top":"125px","padding-right":"","padding-bottom":"125px","padding-left":"","units":"px"},"template-blog-background-all":{"background-color":"","background-repeat":"no-repeat","background-size":"cover","background-attachment":"inherit","background-position":"center center","background-image":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg","media":{"id":"1937","height":"450","width":"1920","thumbnail":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg"}},"blog-page-title-parallax":"0","blog-page-title-bg":"0","blog-page-title-video":"","blog-page-title-overlay":{"color":"","alpha":"","rgba":""},"blog-page-title":"Our Blog","blog-page-desc":"","template-blog-pagetitle-items":{"disabled":{"placebo":"placebo"},"Left":{"placebo":"placebo","description":"Description"},"Center":{"placebo":"placebo","title":"Page Title Text","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"blog-featured-slider":"0","blog-article-style":"default","blog-article-color":"","blog-article-link-color":{"regular":"#000000","hover":"","active":""},"blog-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"blog-article-padding":{"padding-top":"","padding-right":"30px","padding-bottom":"30px","padding-left":"30px","units":"px"},"blog-article-background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"blog-video-format":"onclick","blog-quote-format":"featured","blog-link-format":"featured","blog-gallery-format":"default","blog-page-template":"right-sidebar","blog-left-sidebar":"","blog-right-sidebar":"sidebar-1","blog-sidebar-sticky":"0","blog-page-hide-sidebar":"1","blog-post-template":"standard","blog-top-standard-post":"1","blog-grid-cols":"2","blog-grid-gutter":"30","blog-grid-type":"isotope","blog-infinite-scroll":"0","blog-more-text":"Read More","blog-excerpt":"20","blog-article-alignment":"left","blog-topmeta-items":{"Left":{"placebo":"placebo","date":"Date","category":"Category"},"Right":{"placebo":"placebo"},"disabled":{"placebo":"placebo","author":"Author","social":"Social Share","comments":"Comments","likes":"Likes","views":"Views","more":"Read More","favourite":"Favourite"}},"blog-bottommeta-items":{"Left":{"placebo":"placebo","author":"Author"},"Right":{"placebo":"placebo","more":"Read More"},"disabled":{"placebo":"placebo","comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","views":"Views","date":"Date","favourite":"Favourite"}},"blog-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo","content":"Content","more-icon":"Read More Icon"}},"blog-overlay-opt":"0","blog-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title"},"disabled":{"placebo":"placebo","top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"archive-page-title-opt":"1","template-archive-color":"#000000","template-archive-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-archive-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-archive-padding":{"padding-top":"200px","padding-right":"","padding-bottom":"200px","padding-left":"","units":"px"},"template-archive-background-all":{"background-color":"","background-repeat":"","background-size":"cover","background-attachment":"","background-position":"center center","background-image":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg","media":{"id":"1937","height":"450","width":"1920","thumbnail":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg"}},"archive-page-title-parallax":"0","archive-page-title-bg":"0","archive-page-title-video":"","archive-page-title-overlay":{"color":"","alpha":"","rgba":""},"template-archive-pagetitle-items":{"disabled":{"placebo":"placebo"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","title":"Page Title Text","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"archive-featured-slider":"0","archive-article-style":"default","archive-article-color":"","archive-article-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"archive-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"solid","border-color":""},"archive-article-padding":{"padding-top":"","padding-right":"30px","padding-bottom":"30px","padding-left":"30px","units":"px"},"archive-article-background":{"color":"","alpha":"","rgba":""},"archive-video-format":"onclick","archive-quote-format":"featured","archive-link-format":"featured","archive-gallery-format":"default","archive-page-template":"right-sidebar","archive-left-sidebar":"","archive-right-sidebar":"sidebar-1","archive-sidebar-sticky":"1","archive-page-hide-sidebar":"1","archive-post-template":"standard","archive-top-standard-post":"0","archive-grid-cols":"2","archive-grid-gutter":"30","archive-grid-type":"isotope","archive-infinite-scroll":"0","archive-more-text":"Read More","archive-excerpt":"30","archive-article-alignment":"left","archive-topmeta-items":{"Left":{"placebo":"placebo","date":"Date"},"Right":{"placebo":"placebo","category":"Category"},"disabled":{"placebo":"placebo","social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"archive-bottommeta-items":{"Left":{"placebo":"placebo","author":"Author"},"Right":{"placebo":"placebo","more":"Read More"},"disabled":{"placebo":"placebo","comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","views":"Views","date":"Date","favourite":"Favourite"}},"archive-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo","content":"Content","more-icon":"Read More Icon"}},"archive-overlay-opt":"0","archive-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title"},"disabled":{"placebo":"placebo","top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"category-page-title-opt":"1","template-category-color":"#000000","template-category-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-category-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-category-padding":{"padding-top":"125px","padding-right":"","padding-bottom":"125px","padding-left":"","units":"px"},"template-category-background-all":{"background-color":"#ffffff","background-repeat":"","background-size":"cover","background-attachment":"","background-position":"center center","background-image":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg","media":{"id":"1937","height":"450","width":"1920","thumbnail":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg"}},"category-page-title-parallax":"0","category-page-title-bg":"0","category-page-title-video":"","category-page-title-overlay":{"color":"","alpha":"","rgba":""},"template-category-pagetitle-items":{"disabled":{"placebo":"placebo","description":"Category Description"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","title":"Category Title","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"category-featured-slider":"0","category-article-style":"default","category-article-color":"","category-article-link-color":{"regular":"#000000","hover":"","active":""},"category-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"category-article-padding":{"padding-top":"","padding-right":"30px","padding-bottom":"30px","padding-left":"30px","units":"px"},"category-article-background":{"color":"","alpha":"","rgba":""},"category-video-format":"onclick","category-quote-format":"featured","category-link-format":"featured","category-gallery-format":"default","category-page-template":"right-sidebar","category-left-sidebar":"","category-right-sidebar":"sidebar-1","category-sidebar-sticky":"1","category-page-hide-sidebar":"1","category-post-template":"standard","category-top-standard-post":"0","category-grid-cols":"2","category-grid-gutter":"20","category-grid-type":"isotope","category-infinite-scroll":"0","category-more-text":"Read More","category-excerpt":"30","category-article-alignment":"","category-topmeta-items":{"Left":{"placebo":"placebo","date":"Date"},"Right":{"placebo":"placebo","category":"Category"},"disabled":{"placebo":"placebo","social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"category-bottommeta-items":{"Left":{"placebo":"placebo","author":"Author"},"Right":{"placebo":"placebo","more":"Read More"},"disabled":{"placebo":"placebo","comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","views":"Views","date":"Date","favourite":"Favourite"}},"category-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo","content":"Content","more-icon":"Read More Icon"}},"category-overlay-opt":"0","category-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title"},"disabled":{"placebo":"placebo","top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"tag-page-title-opt":"1","template-tag-color":"#000000","template-tag-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-tag-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-tag-padding":{"padding-top":"125px","padding-right":"","padding-bottom":"125px","padding-left":"","units":"px"},"template-tag-background-all":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg","media":{"id":"","height":"","width":"","thumbnail":""}},"tag-page-title-parallax":"0","tag-page-title-bg":"0","tag-page-title-video":"","tag-page-title-overlay":{"color":"","alpha":"","rgba":""},"template-tag-pagetitle-items":{"disabled":{"placebo":"placebo"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","title":"Page Title Text","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"tag-featured-slider":"0","tag-article-style":"default","tag-article-color":"","tag-article-link-color":{"regular":"#000000","hover":"","active":""},"tag-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"tag-article-padding":{"padding-top":"","padding-right":"30px","padding-bottom":"30px","padding-left":"30px","units":"px"},"tag-article-background":{"color":"","alpha":"","rgba":""},"tag-video-format":"onclick","tag-quote-format":"featured","tag-link-format":"featured","tag-gallery-format":"default","tag-page-template":"right-sidebar","tag-left-sidebar":"","tag-right-sidebar":"sidebar-1","tag-sidebar-sticky":"1","tag-page-hide-sidebar":"1","tag-post-template":"standard","tag-top-standard-post":"0","tag-grid-cols":"2","tag-grid-gutter":"20","tag-grid-type":"isotope","tag-infinite-scroll":"0","tag-more-text":"Read More","tag-excerpt":"30","tag-article-alignment":"","tag-topmeta-items":{"Left":{"placebo":"placebo","date":"Date"},"Right":{"placebo":"placebo","category":"Category"},"disabled":{"placebo":"placebo","social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"tag-bottommeta-items":{"Left":{"placebo":"placebo","author":"Author"},"Right":{"placebo":"placebo","more":"Read More"},"disabled":{"placebo":"placebo","comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","views":"Views","date":"Date","favourite":"Favourite"}},"tag-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo","content":"Content","more-icon":"Read More Icon"}},"tag-overlay-opt":"0","tag-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title"},"disabled":{"placebo":"placebo","top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"author-page-title-opt":"1","template-author-color":"#000000","template-author-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-author-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-author-padding":{"padding-top":"","padding-right":"","padding-bottom":"","padding-left":"","units":"px"},"template-author-background-all":{"background-color":"","background-repeat":"","background-size":"","background-attachment":"","background-position":"","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"author-page-title-parallax":"0","author-page-title-bg":"0","author-page-title-video":"","author-page-title-overlay":{"color":"","alpha":"","rgba":""},"template-author-pagetitle-items":{"disabled":{"placebo":"placebo"},"Left":{"placebo":"placebo","author-info":"Author Info"},"Center":{"placebo":"placebo"},"Right":{"placebo":"placebo","breadcrumb":"Breadcrumb"}},"author-featured-slider":"0","author-article-style":"default","author-article-color":"","author-article-link-color":{"regular":"","hover":"#eb2f5b","active":"#eb2f5b"},"author-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"author-article-padding":{"padding-top":"","padding-right":"30px","padding-bottom":"30px","padding-left":"30px","units":"px"},"author-article-background":{"color":"","alpha":"","rgba":""},"author-video-format":"onclick","author-quote-format":"featured","author-link-format":"featured","author-gallery-format":"default","author-page-template":"right-sidebar","author-left-sidebar":"","author-right-sidebar":"sidebar-1","author-sidebar-sticky":"1","author-page-hide-sidebar":"1","author-post-template":"standard","author-top-standard-post":"0","author-grid-cols":"2","author-grid-gutter":"20","author-grid-type":"isotope","author-infinite-scroll":"0","author-more-text":"Read More","author-excerpt":"30","author-article-alignment":"","author-topmeta-items":{"Left":{"placebo":"placebo","date":"Date"},"Right":{"placebo":"placebo","category":"Category"},"disabled":{"placebo":"placebo","social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"author-bottommeta-items":{"Left":{"placebo":"placebo","author":"Author"},"Right":{"placebo":"placebo","more":"Read More"},"disabled":{"placebo":"placebo","comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","views":"Views","date":"Date","favourite":"Favourite"}},"author-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo","content":"Content","more-icon":"Read More Icon"}},"author-overlay-opt":"0","author-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title"},"disabled":{"placebo":"placebo","top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"search-page-title-opt":"1","template-search-color":"#000000","template-search-link-color":{"regular":"#000000","hover":"#eb2f5b","active":"#eb2f5b"},"template-search-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"template-search-padding":{"padding-top":"125px","padding-right":"","padding-bottom":"125px","padding-left":"","units":"px"},"template-search-background-all":{"background-color":"","background-repeat":"","background-size":"cover","background-attachment":"","background-position":"","background-image":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg","media":{"id":"1937","height":"450","width":"1920","thumbnail":"http:\/\/demo.zozothemes.com\/pixzlo\/wp-content\/uploads\/sites\/24\/2018\/11\/title_bg.jpg"}},"search-page-title-parallax":"0","search-page-title-bg":"0","search-page-title-video":"","search-page-title-overlay":{"color":"","alpha":"","rgba":""},"template-search-pagetitle-items":{"disabled":{"placebo":"placebo"},"Left":{"placebo":"placebo"},"Center":{"placebo":"placebo","title":"Page Title Text","breadcrumb":"Breadcrumb"},"Right":{"placebo":"placebo"}},"search-featured-slider":"0","search-article-style":"default","search-article-color":"","search-article-link-color":{"regular":"","hover":"","active":""},"search-article-border":{"border-top":"","border-right":"","border-bottom":"","border-left":"","border-style":"none","border-color":""},"search-article-padding":{"padding-top":"","padding-right":"30px","padding-bottom":"30px","padding-left":"30px","units":"px"},"search-article-background":{"color":"","alpha":"","rgba":""},"search-video-format":"onclick","search-quote-format":"featured","search-link-format":"featured","search-gallery-format":"default","search-page-template":"right-sidebar","search-left-sidebar":"","search-right-sidebar":"sidebar-1","search-sidebar-sticky":"1","search-page-hide-sidebar":"1","search-post-template":"standard","search-top-standard-post":"0","search-grid-cols":"2","search-grid-gutter":"20","search-grid-type":"isotope","search-infinite-scroll":"0","search-more-text":"Read More","search-excerpt":"30","search-article-alignment":"","search-topmeta-items":{"Left":{"placebo":"placebo","date":"Date"},"Right":{"placebo":"placebo","category":"Category"},"disabled":{"placebo":"placebo","social":"Social Share","comments":"Comments","likes":"Likes","author":"Author","views":"Views","more":"Read More","favourite":"Favourite"}},"search-bottommeta-items":{"Left":{"placebo":"placebo","author":"Author"},"Right":{"placebo":"placebo","more":"Read More"},"disabled":{"placebo":"placebo","comments":"Comments","category":"Category","social":"Social Share","likes":"Likes","views":"Views","date":"Date","favourite":"Favourite"}},"search-items":{"Enabled":{"placebo":"placebo","thumb":"Thumbnail","top-meta":"Top Meta","title":"Title","bottom-meta":"Bottom Meta"},"disabled":{"placebo":"placebo","content":"Content","more-icon":"Read More Icon"}},"search-overlay-opt":"0","search-overlay-items":{"Enabled":{"placebo":"placebo","title":"Title"},"disabled":{"placebo":"placebo","top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"featured-slide-items":"3","featured-slide-tab":"1","featured-slide-mobile":"1","featured-slide-scrollby":"1","featured-slide-autoplay":"true","featured-slide-center":"false","featured-slide-duration":"5000","featured-slide-smartspeed":"250","featured-slide-infinite":"false","featured-slide-margin":"0","featured-slide-pagination":"false","featured-slide-navigation":"false","featured-slide-autoheight":"false","related-slide-items":"3","related-slide-tab":"1","related-slide-mobile":"1","related-slide-scrollby":"1","related-slide-autoplay":"true","related-slide-center":"false","related-slide-duration":"5000","related-slide-smartspeed":"250","related-slide-infinite":"false","related-slide-margin":"10","related-slide-pagination":"false","related-slide-navigation":"false","related-slide-autoheight":"false","blog-slide-items":"1","blog-slide-tab":"1","blog-slide-mobile":"1","blog-slide-scrollby":"1","blog-slide-autoplay":"true","blog-slide-center":"false","blog-slide-duration":"5000","blog-slide-smartspeed":"250","blog-slide-infinite":"false","blog-slide-margin":"0","blog-slide-pagination":"false","blog-slide-navigation":"false","blog-slide-autoheight":"false","single-slide-items":"3","single-slide-tab":"1","single-slide-mobile":"1","single-slide-scrollby":"1","single-slide-autoplay":"true","single-slide-center":"false","single-slide-duration":"5000","single-slide-smartspeed":"250","single-slide-infinite":"false","single-slide-margin":"0","single-slide-pagination":"false","single-slide-navigation":"false","single-slide-autoheight":"false","social-icons-type":"transparent","social-icons-type-footer":"circled","social-icons-fore":"white","social-icons-hfore":"h-own","social-icons-bg":"bg-own","social-icons-hbg":"hbg-black","social-fb":"#","social-twitter":"#","social-instagram":"","social-pinterest":"#","social-youtube":"","social-vimeo":"","social-soundcloud":"","social-yahoo":"","social-tumblr":"","social-paypal":"","social-mailto":"","social-flickr":"","social-dribbble":"","social-linkedin":"","social-rss":"","post-social-shares":["fb","twitter","linkedin","pinterest"],"comments-social-shares":"","woo-page-template":"no-sidebar","woo-left-sidebar":"","woo-right-sidebar":"sidebar-1","woo-shop-columns":"4","woo-shop-ppp":"12","woo-single-page-template":"no-sidebar","woo-single-left-sidebar":"","woo-single-right-sidebar":"sidebar-1","woo-related-ppp":"3","wooarchive-page-template":"no-sidebar","wooarchive-left-sidebar":"","wooarchive-right-sidebar":"sidebar-1","woo-shop-archive-columns":"4","woo-related-slide-items":"3","woo-related-slide-tab":"1","woo-related-slide-mobile":"1","woo-related-slide-scrollby":"1","woo-related-slide-autoplay":"true","woo-related-slide-center":"false","woo-related-slide-duration":"5000","woo-related-slide-smartspeed":"250","woo-related-slide-infinite":"false","woo-related-slide-margin":"0","woo-related-slide-pagination":"false","woo-related-slide-navigation":"false","woo-related-slide-autoheight":"false","cpt-opts":["portfolio","team","testimonial","service"],"portfolio-title-opt":"0","cpt-portfolio-slug":"portfolio","cpt-portfolio-category-slug":"portfolio-category","cpt-portfolio-tag-slug":"portfolio-tag","portfolio-meta-items":{"Enabled":{"placebo":"placebo","date":"Date","client":"Client","category":"Category","estimation":"Estimation","url":"URL"},"disabled":{"placebo":"placebo","type":"Type","tag":"Tags","duration":"Duration","share":"Share","place":"Place"}},"portfolio-client-label":"Client","portfolio-type-label":"Portfolio Type","portfolio-date-label":"Date","portfolio-duration-label":"Duration","portfolio-estimation-label":"Value","portfolio-place-label":"Place","portfolio-url-label":"URL","portfolio-category-label":"Category","portfolio-tags-label":"Tags","portfolio-share-label":"Share","portfolio-layout":"2","portfolio-grid-cols":"3","portfolio-grid-gutter":"20","portfolio-grid-type":"isotope","portfolio-related-opt":"0","portfolio-related-slide-items":"3","portfolio-related-slide-tab":"1","portfolio-related-slide-mobile":"1","portfolio-related-slide-scrollby":"1","portfolio-related-slide-autoplay":"true","portfolio-related-slide-center":"false","portfolio-related-slide-duration":"5000","portfolio-related-slide-smartspeed":"250","portfolio-related-slide-infinite":"false","portfolio-related-slide-margin":"0","portfolio-related-slide-pagination":"false","portfolio-related-slide-navigation":"false","portfolio-related-slide-autoheight":"false","portfolio-single-slider-opt":"0","portfolio-single-slide-items":"3","portfolio-single-slide-tab":"1","portfolio-single-slide-mobile":"1","portfolio-single-slide-scrollby":"1","portfolio-single-slide-autoplay":"true","portfolio-single-slide-center":"false","portfolio-single-slide-duration":"5000","portfolio-single-slide-smartspeed":"250","portfolio-single-slide-infinite":"false","portfolio-single-slide-margin":"0","portfolio-single-slide-pagination":"false","portfolio-single-slide-navigation":"false","portfolio-single-slide-autoheight":"false","team-title-opt":"1","cpt-team-slug":"team","testimonial-title-opt":"1","cpt-testimonial-slug":"testimonial","service-title-opt":"1","cpt-service-slug":"service","js-minify":"1","css-minify":"1","maintenance-mode":"0","maintenance-type":"","maintenance-custom":"","maintenance-phone":"","maintenance-email":"","maintenance-address":"","redux-backup":"1"}'; //Here Theme Default Values
	return $theme_opt_def;
}