<?php

// Shortcode to display a single product
$repeater_posts = 'products';
$repeater_post_type = 'product';
$repeater_post_cat = 'product_cat';

$options = array(

'post_options' => require( __DIR__ . '/commons/repeater-posts.php' ),

'filter_posts' => array(
    'type' => 'group',
    'heading' => __( 'فیلتر پست ها' ),
    'conditions' => 'ids === ""',
    'options' => array(
         'orderby' => array(
            'type' => 'select',
            'heading' => __( 'Order By' ),
            'default' => 'normal',
            'options' => array(
                'normal' => 'نرمال',
                'sales' => 'فروش',
                'rand' => 'رندوم',
                'date' => 'تاریخ'
            )
        ),
        'order' => array(
            'type' => 'select',
            'heading' => __( 'ترتیب' ),
            'default' => 'asc',
            'options' => array(
                'asc' => 'صعودی',
                'desc' => 'نزولی',
            )
        ),
        'show' => array(
            'type' => 'select',
            'heading' => __( 'ترتیب' ),
            'default' => '',
            'options' => array(
                '' => 'All',
                'featured' => 'ویژه',
                'onsale' => 'درحال فروش',
            )
        )
    )
)
);

add_ux_builder_shortcode( 'ux_product_flip', array(
    'name' => 'فلیپ',
    'category' => __( 'Shop' ),
    'priority' => 4,
    'thumbnail' =>  flatsome_ux_builder_thumbnail( 'product_flipbook' ),
    'wrap' => false,
   'presets' => array(
        array(
            'name' => __( 'Normal' ),
            'content' => '[ux_product_flip]'
        ),
    ),

    'options' => $options
) );
