<?php

$sizes = array(
	'xxsmall' => 'خیلی خیلی کوچک',
	'xsmall'  => 'خیلی کوچک',
	'smaller' => 'کوچک تر',
	'small'   => 'کوچک',
	''        => 'نرمال',
	'large'   => 'بزرگ',
	'larger'  => 'بزرگتر',
	'xlarge'  => 'خیلی بزرگتر',
	'xxlarge' => 'خیلی خیلی بزرگتر',
);

add_ux_builder_shortcode( 'ux_product_gallery', array(
	'name'      => __( 'گالری محصول' ),
	'category'  => __( 'Product Page' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'overlay'   => true,
	'wrap'      => true,
	'priority'  => 9999,
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'Style',
			'default' => 'normal',
			'options' => array(
				'normal'     => __( 'نرمال', 'flatsome-admin' ),
				'vertical'   => __( 'عمودی', 'flatsome-admin' ),
				'full-width' => __( 'تمام عرض', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_title', array(
	'name'      => __( 'عنوان محصول' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'category'  => __( 'Product Page' ),
	'options'   => array(
		'size'      => array(
			'type'    => 'select',
			'heading' => 'اندازه',
			'default' => '',
			'options' => $sizes,
		),
		'divider'   => array(
			'type'    => 'checkbox',
			'heading' => 'جدا کننده',
			'default' => 'true',
		),
		'uppercase' => array(
			'type'    => 'checkbox',
			'heading' => 'حروف بزرگ',
			'default' => 'false',
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_rating', array(
	'name'      => __( 'امتیاز محصولات' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'wrap'      => false,
	'category'  => __( 'Product Page' ),
	'options'   => array(
		'count'      => array(
			'type'    => 'checkbox',
			'heading' => 'تعداد نظرات',
			'default' => 'false',
		),
		'style'      => array(
			'type'    => 'select',
			'heading' => 'استایل تعداد نظرات',
			'default' => 'inline',
			'options' => array(
				'tooltip' => __( 'تولتیپ', 'flatsome-admin' ),
				'stacked' => __( 'انباشته', 'flatsome-admin' ),
				'inline'  => __( 'درون خطی', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_price', array(
	'name'      => __( 'قیمت محصول' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'wrap'      => false,
	'category'  => __( 'Product Page' ),
	'options'   => array(
		'size' => array(
			'type'    => 'select',
			'heading' => 'اندازه',
			'default' => '',
			'options' => $sizes,
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_excerpt', array(
	'name'      => __( 'توضیحات کوتاه محصول' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'wrap'      => false,
	'category'  => __( 'Product Page' ),
) );

add_ux_builder_shortcode( 'ux_product_add_to_cart', array(
	'name'      => __( 'دکمه اضافه کردن به سبد خرید' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'category'  => __( 'Product Page' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل فرم',
			'default' => 'normal',
			'options' => array(
				'normal' => __( 'نرمال', 'flatsome-admin' ),
				'flat'   => __( 'فلت', 'flatsome-admin' ),
				'minimal'   => __( 'مینیمال', 'flatsome-admin' ),
			),
		),
		'size'  => array(
			'type'    => 'select',
			'heading' => 'اندازه',
			'default' => '',
			'options' => $sizes,
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_meta', array(
	'name'      => __( 'متا محصول' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'category'  => __( 'Product Page' ),
) );

add_ux_builder_shortcode( 'ux_product_upsell', array(
	'name'      => __( 'فروش محصولات' ),
	'category'  => __( 'Product Page' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'sidebar',
			'options' => array(
				'sidebar' => __( 'لیست', 'flatsome-admin' ),
				'grid'    => __( 'گرید', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_tabs', array(
	'name'      => __( 'تب های محصول' ),
	'category'  => __( 'Product Page' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'tabs',
			'options' => array(
				'tabs'          => __( 'تب های خطی', 'flatsome-admin' ),
				'tabs_normal'   => __( 'تب های نرمال', 'flatsome-admin' ),
				'line-grow'     => __( 'تب های خطی - رشدی', 'flatsome-admin' ),
				'tabs_vertical' => __( 'تب های عمودی', 'flatsome-admin' ),
				'tabs_pills'    => __( 'فرص', 'flatsome-admin' ),
				'tabs_outline'  => __( 'خط خارجی', 'flatsome-admin' ),
				'sections'      => __( 'بخش ها', 'flatsome-admin' ),
				'accordian'     => __( 'آکوردئون', 'flatsome-admin' ),
			),
		),
		'align' => array(
			'type'    => 'select',
			'heading' => 'تراز',
			'default' => 'left',
			'options' => array(
				'left'   => __( 'چپ', 'flatsome-admin' ),
				'center' => __( 'میانه', 'flatsome-admin' ),
				'right'  => __( 'راست', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_related', array(
	'name'      => __( 'محصولات مرتبط' ),
	'category'  => __( 'Product Page' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'slider',
			'options' => array(
				'slider' => __( 'اسلایدر', 'flatsome-admin' ),
				'grid'   => __( 'گرید', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_hook', array(
	'name'      => __( 'هوک های محصول' ),
	'category'  => __( 'Product Page' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'options'   => array(
		'hook' => array(
			'type'    => 'select',
			'heading' => 'هوک',
			'default' => 'woocommerce_single_product_summary',
			'options' => apply_filters( 'flatsome_custom_product_single_product_hooks', array(
				'woocommerce_before_single_product_summary' => 'woocommerce_before_single_product_summary',
				'woocommerce_single_product_summary'        => 'woocommerce_single_product_summary',
				'woocommerce_after_single_product_summary'  => 'woocommerce_after_single_product_summary',
				'flatsome_custom_single_product_1'          => 'flatsome_custom_single_product_1',
				'flatsome_custom_single_product_2'          => 'flatsome_custom_single_product_2',
				'flatsome_custom_single_product_3'          => 'flatsome_custom_single_product_3',
			) ),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_breadcrumbs', array(
	'name'      => __( 'ریزآدرس محصولات' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'category'  => __( 'Product Page' ),
	'options'   => array(
		'size' => array(
			'type'    => 'select',
			'heading' => 'اندازه',
			'default' => '',
			'options' => $sizes,
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_next_prev_nav', array(
	'name'      => __( 'Product Next/Prev' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
	'category'  => __( 'Product Page' ),
	'options'   => array(
		'class' => array(
			'type'    => 'textfield',
			'heading' => 'کلاس',
			'default' => '',
		),
	),
) );
