<?php
/**
 * Admin Panel Template
 *
 * @author 		WaspThemes
 * @category 	Template
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/* ---------------------------------------------------- */
/* Adding welcome screen Hook							*/
/* ---------------------------------------------------- */
function welcome_screen_activate() {
  set_transient( '_welcome_screen_activation_redirect', true, 30 );
}

register_activation_hook( WT_PLUGIN_DIR.'yellow-pencil.php', 'welcome_screen_activate' );



/* ---------------------------------------------------- */
/* Automatic redirect after active						*/
/* ---------------------------------------------------- */
function welcome_screen_do_activation_redirect() {
  // Bail if no activation redirect
    if ( ! get_transient( '_welcome_screen_activation_redirect' ) ) {
    return;
  }

  // Delete the redirect transient
  delete_transient( '_welcome_screen_activation_redirect' );

  // Bail if activating from network, or bulk
  if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
    return;
  }

  // Redirect to bbPress about page
  wp_safe_redirect( add_query_arg( array( 'page' => 'yp-welcome-screen' ), admin_url( 'admin.php' ) ) );

}

add_action( 'admin_init', 'welcome_screen_do_activation_redirect' );



/* ---------------------------------------------------- */
/* Welcome Screen Content 								*/
/* ---------------------------------------------------- */
function yp_welcome_screen_content(){
  ?>
  <div class="wrap yp-page-welcome about-wrap">
	<h1>خوش آمدید به مداد زرد <?php echo YP_VERSION; ?></h1>

	<div class="about-text yp-about-text">
		تبریک می گویم! شما در حال استفاده از ابزار قدرتمند طراحی برای وردپرس هستید.</div>
	<div class="wp-badge yp-badge">Version <?php echo YP_VERSION; ?></div>
	<p>
		<a href="<?php echo admin_url('themes.php?page=yellow-pencil'); ?>" class="button button-primary button-large">بیا شروع کنیم!</a>
	</p>
	<h2 class="nav-tab-wrapper">
			<a href="<?php echo admin_url('admin.php?page=yp-welcome-screen'); ?>" class="nav-tab<?php if(!isset($_GET['tab'])){ ?> nav-tab-active<?php } ?>">سلام</a>
			<a href="<?php echo admin_url('admin.php?page=yp-welcome-screen&tab=resources'); ?>" class="nav-tab<?php if(isset($_GET['tab'])){ ?> nav-tab-active<?php } ?>">منابع</a>
	</h2>

	<?php if(!isset($_GET['tab'])){ ?>
	<div class="yp-welcome-tab">

		<img class="yp-featured-img" src="<?php echo WT_PLUGIN_URL; ?>images/promo.png" />

		<div class="yp-right-content">
			<h3>ابزار طراحی جلو برای وردپرس!</h3>
			<p>مداد زرد یک ویرایشگر طراحی بصری افزونه وردپرس است که به شما اجازه می دهد تا وب سایت خود را در زمان واقعی با چند کلیک سفارشی کنید. طراحی وب سایت خود را تحت کنترل با ویرایشگر مداد زرد نگه دارید.</p>

			<h3>یادداشتهای انتشار</h3>
			Check out <a href="https://waspthemes.com/yellow-pencil/release-notes/" target="_blank">یادداشت انتشار</a> برای دیدن جزئیات به روز رسانی.
		</div>
		<div class="clear"></div>

	</div>
	<?php }else{ ?>
	<div class="yp-welcome-tab">

		<div class="yp-resources-left">
			<h3>منابع</h3>
			<p></p>
			<ul>
				<li><a href="https://waspthemes.com/yellow-pencil/documentation/" target="_blank">مستندات</a></li>
				<li><a href="https://waspthemes.com/yellow-pencil/" target="_blank">افزونه وب سایت</a></li>
				<li><a href="https://waspthemes.ticksy.com/" target="_blank">انجمن پشتیبانی رسمی</a></li>
				<li><a href="https://waspthemes.com/yellow-pencil/release-notes/" target="_blank">یادداشتهای انتشار</a></li>
			</ul>
			
		</div>

		<div class="yp-resources-right">

			<h3>نسخه ها</h3>
			<ul>
				<li><a href="https://wordpress.org/plugins/yellow-pencil-visual-theme-customizer/" target="_blank">نسخه حرفه ای رو بگیر</a></li>
				<li><a href="https://codecanyon.net/item/yellow-pencil-visual-customizer-for-wordpress/11322180?ref=WaspThemes" target="_blank">نسخه حرفه ای رو بگیر</a></li>
			</ul>

			<h3>عضویت در انجمن</h3>
			<ul>
				<li><a href="https://www.facebook.com/groups/YellowPencils/" target="_blank">انجمن فیس بوک</a></li>
			</ul>

		</div>
		<div class="clear"></div>

	</div>
	<?php } ?>

	<?php if(!isset($_GET['tab'])){ ?>
	<div class="yp-welcome-feature feature-section">

		<div class="yp-column">
			<img class="yp-img-center" src="<?php echo WT_PLUGIN_URL; ?>images/promo-1.png">
			
			<div class="yp-feature-column">
				<h4>شروع به سفارشی کردن!</h4>
				<p>فونت ها، رنگ ها، اندازه ها و موارد دیگر را فقط با چند کلیک ویرایش کنید. <a href="<?php echo admin_url('themes.php?page=yellow-pencil'); ?>">شروع به سفارشی کردن</a>.</p>
			</div>

		</div>

		<div class="yp-column">
			<img class="yp-img-center" src="<?php echo WT_PLUGIN_URL; ?>images/promo-2.png">
			
			<div class="yp-feature-column">
				<h4>مدیریت تغییرات</h4>
				<p>مدیریت تغییرات در هر زمان از <a href="<?php echo admin_url("admin.php?page=yellow-pencil-changes"); ?>">این صفحه</a>. کنترل کامل بر طراحی وب سایت خود را کنترل کنید.</p>
			</div>

		</div>

		<div class="yp-column">
			<img class="yp-img-center" src="<?php echo WT_PLUGIN_URL; ?>images/promo-3.png">
			
			<div class="yp-feature-column">
				<h4>انجمن و پشتیبانی!</h4>
				<p>به ما ملحق شوید <a target="_blank" href="https://www.facebook.com/groups/YellowPencils/">انجمن فیس بوک</a> و چک کردن <a target="_blank" href="https://waspthemes.com/yellow-pencil/documentation/">مستندات</a>.</p>
			</div>

		</div>

		<div class="clear"></div>

	</div>

	<p class="yp-thank-you">با تشکر از شما برای انتخاب مداد زرد از تم فارس.</p>
	<?php } ?>

</div>
  <?php
}



/* ---------------------------------------------------- */
/* Adding plugin control menu 							*/
/* ---------------------------------------------------- */
function yp_add_setting_menu() {

    add_menu_page (
        'YellowPencil Options',
        'مداد زرد',
        'edit_theme_options',
        'yellow-pencil-changes',
        'yp_option_func',
        'dashicons-admin-customizer'
    );

    add_submenu_page( 'yellow-pencil-changes', "Customizations", "سفارشی کردن", 'edit_theme_options', 'yellow-pencil-changes', 'yp_option_func' );
    add_submenu_page( 'yellow-pencil-changes', "Settings", "تنظیمات", 'edit_theme_options', 'yellow-pencil-settings', 'yp_option_func' );

    $filter_animation_tools = apply_filters( 'yp_animation_tools', TRUE);
    if($filter_animation_tools){
    	add_submenu_page( 'yellow-pencil-changes', "Custom Animations", "انیمیشن های سفارشی", 'edit_theme_options', 'yellow-pencil-animations', 'yp_option_func' );
    }
    
    if(defined("WTFV")){
    	add_submenu_page( 'yellow-pencil-changes', "Product License", "مجوز محصول", 'edit_theme_options', 'yellow-pencil-license', 'yp_option_func');
    }
    
    add_submenu_page( 'yellow-pencil-changes', "Import/Export", "واردات / صادرات", 'edit_theme_options', 'yellow-pencil-export', 'yp_option_func' );

    if(!defined("WTFV")){
    	add_submenu_page( 'yellow-pencil-changes', "Go Pro!", "برو به حرفه ای!", 'edit_theme_options', 'yellow-pencil-license', 'yp_option_func');
    }

    add_submenu_page( 'yellow-pencil-changes', "About", "درباره", 'read', 'yp-welcome-screen', 'yp_welcome_screen_content' );

}

add_action('admin_menu', 'yp_add_setting_menu');


function yp_css_style_li($title, $href, $type, $page_id = null, $page_type = null){

	$key = "";
	$plusTitle = "";

	// Reset links
	if($type == 'single'){

		$key = $page_id;
		$data = get_post_meta($page_id, '_wt_css', true);

		$frontID = get_option('page_on_front');
    	$blogID = get_option('page_for_posts');

		if($page_id == $frontID){
			$plusTitle = " — Front Page";
		}

		if($page_id == $blogID){
			$plusTitle = " — Posts Page";
		}

		$deleteData = "ID|".$page_id;
	}elseif($type == 'template'){
		$data = get_option("wt_".$page_type."_css");
		$key = $page_type;
		$deleteData = "TYPE|".$page_type;
	}elseif($type == 'global'){
		$data = get_option("wt_css");
		$key = "global";
		$deleteData = "GLOBAL|"."global";
	}

	$class = "";
	if(strstr($title, "Inactive")){
		$class = " class='yp-inactive-style'";
	}

	if($title == ""){
		$title = "Unknown";
	}

	?>
	<li<?php echo $class; ?> data-delete-value="<?php echo $deleteData; ?>">

		<span class="yp-edited-page-title"><?php echo $title; echo $plusTitle; ?></span>

		<a class="yp-delete-page-edits" title="Delete"></a>

		<?php if($href != null){ ?>
		<a class="yp-open-in-editor" title="Open With YellowPencil" target="_blank" href="<?php echo admin_url('admin.php?page=yellow-pencil-editor&href='.yp_urlencode(esc_url($href)).''); ?>&#38;yp_page_id=<?php echo $page_id; ?>&#38;yp_page_type=<?php echo $page_type; ?>&#38;yp_mode=<?php echo $type; ?>"></a>
		<?php } ?>
		
		<a class="yp-show-css"></a>

		<span class="yp-clear"></span>

	</li>
	<div id="yp-inline-editor-<?php echo $key; ?>" class='yp-inline-css'><?php echo stripslashes($data); ?></div>
	<?php
}



/* ---------------------------------------------------- */
/* Updating admin footer text 							*/
/* ---------------------------------------------------- */
function yp_admin_footer () {

	// Get screen
	$current_screen = get_current_screen();

	// if is YellowPencil page
	$is_yellow_pencil_screen = ( $current_screen && false !== strpos( $current_screen->base, 'yellow-pencil' ) );

	// if YellowPencil page
	if($is_yellow_pencil_screen){

		if(defined('WTFV')){
			echo 'Enjoyed <strong>YellowPencil</strong>? Please leave us a <a target="_blank" href="https://codecanyon.net/downloads">&#9733;&#9733;&#9733;&#9733;&#9733;</a> rating. We really appreciate your support!';
		}else{
			echo 'Enjoyed <strong>YellowPencil</strong>? Please leave us a <a target="_blank" href="https://wordpress.org/support/plugin/yellow-pencil-visual-theme-customizer/reviews/?filter=5#new-post">&#9733;&#9733;&#9733;&#9733;&#9733;</a> rating. We really appreciate your support';
		}

	}

}

add_filter('admin_footer_text', 'yp_admin_footer');



/* ---------------------------------------------------- */
/* Update changes            							*/
/* ---------------------------------------------------- */
function yp_option_update(){

	// Can?
	if(current_user_can("edit_theme_options") == true){

		// Import the data
		if(isset($_POST['yp_json_import_data'])){

			$data = trim( strip_tags ( $_POST['yp_json_import_data'] ) );

			if(empty($data) == false){

				yp_import_data($data);

				// Get All CSS data as ready-to-use
				$output = yp_get_export_css("create");

				// Update custom.css file
				yp_create_custom_css($output);

			}

		}

		// Update output format.
		if(isset($_POST['yp-output-option'])){

			$value =  sanitize_key($_POST['yp-output-option']);

			if(!update_option('yp-output-option',$value)){
				add_option('yp-output-option',$value);
			}

		}

		// Update output format.
		if(isset($_POST['yp-draft-mode'])){

			$value = sanitize_key($_POST['yp-draft-mode']);

			if(!update_option('yp-draft-mode',$value)){
				add_option('yp-draft-mode',$value);
			}

		}

		

	}

}
add_action("admin_init","yp_option_update");


/* ---------------------------------------------------- */
/* Admin Control Functions  							*/
/* ---------------------------------------------------- */
function yp_option_func() {

		// GEt page, tab.
		$screen = get_current_screen();
		$active_tab = $screen->base;
		$active_tab = str_replace("yellowpencil_page_", "", $active_tab);
		$active_tab = str_replace("toplevel_page_", "", $active_tab);

		// Updated message.
		if(isset($_POST['yp-output-option']) || isset($_POST['yp_json_import_data']) || isset($_POST['yp-draft-mode'])){
			?>
				<div id="message" class="updated">
			        <p><strong>ذخیره تنظیمات.</strong></p>
			    </div>
			<?php
		}


		// Reset message.
		if(isset($_POST['yp_reset'])){
			?>
				<div id="message" class="updated">
			        <p><strong>تعریف شده نظرات CSS و گزینه های افزونه تنظیم مجدد شده اند.</strong></p>
			    </div>
			<?php
		}

        ?>
        <div class="wrap">

            <h2>مداد زرد</h2>

            <h2 class="nav-tab-wrapper yp-tab-wrapper">  
                <a href="?page=yellow-pencil-changes" class="nav-tab <?php echo $active_tab == 'yellow-pencil-changes' ? 'nav-tab-active' : ''; ?>">سفارشی کردن</a>
                <a href="?page=yellow-pencil-settings" class="nav-tab <?php echo $active_tab == 'yellow-pencil-settings' ? 'nav-tab-active' : ''; ?>">تنظیمات</a> 

                <?php

                	// Filter animation Tools
	                $filter_animation_tools = apply_filters( 'yp_animation_tools', TRUE);

	    			if($filter_animation_tools){

    			?>
                	<a href="?page=yellow-pencil-animations" class="nav-tab <?php echo $active_tab == 'yellow-pencil-animations' ? 'nav-tab-active' : ''; ?>">انیمیشن های سفارشی</a>
                <?php
            		}
                ?>

                <?php if(defined('WTFV')){ // this tab available just on pro version ?>
                <a href="?page=yellow-pencil-license" class="nav-tab <?php echo $active_tab == 'yellow-pencil-license' ? 'nav-tab-active' : ''; ?>">مجوز محصول</a>
                <?php } ?>
                <a href="?page=yellow-pencil-export" class="nav-tab <?php echo $active_tab == 'yellow-pencil-export' ? 'nav-tab-active' : ''; ?>">واردات / صادرات</a>
                <?php if(!defined('WTFV')){ // this tab available just on pro version ?>
                <a href="?page=yellow-pencil-license" class="yp-license-tab nav-tab <?php echo $active_tab == 'yellow-pencil-license' ? 'nav-tab-active' : ''; ?>">برو حرفه ای</a>
                <?php } ?>
            </h2>

            <?php

            	// Base directory for Ace Editor
                echo "<script>window.aceEditorBase = '".(plugins_url( 'library/ace/' , __FILE__ ))."';</script>";
            	
            	/* ---------------------------------------------------- */
				/* CSS CHANGES               							*/
				/* ---------------------------------------------------- */
                if( $active_tab == 'yellow-pencil-changes' ) {

                ?>	

                	<div class="yp-no-code">
                		<img src="<?php echo WT_PLUGIN_URL; ?>images/pages.png">
                    	<p>سبک مورد استفاده وجود ندارد. <a href="<?php echo admin_url('themes.php?page=yellow-pencil'); ?>">بیا شروع کنیم!</a></p>
                    </div>

                	<div class="yp-tab-section">

            		<h2>مدیریت سبک ها</h2>
                    <p class="yp-heading-text">تمام تغییراتی که با مداد زرد انجام داده اید در زیر فهرست شده است. شما می توانید آنها را بررسی، ویرایش یا حذف کنید.</p>

					<div class="yp-code-group">

					<div class="yp-global-group">
						<h3>سفارشی عمومی</h3>
						<ul>
						<?php

							$allCount = 0;
							$count = 0;

							// Global
							if(get_option("wt_css") != ''){
								$count++;
								$allCount++;

								$frontpage_id = get_option('page_on_front');
								$frontpage_type = 'home';

								// If no home page id, use only home page editing method.
								if($frontpage_id == 0 || $frontpage_id == null){
									$frontpage_id = 'home';
								}else{
									$frontpage_type = get_post_type($frontpage_id);
								}

								yp_css_style_li("Global", get_home_url().'/', 'global', $frontpage_id, $frontpage_type);

							}

						?>
						</ul>
					</div>
					<?php
						if($count == 0){
							echo "<style>.yp-global-group{display:none;}</style>";
						}
					?>

					<div class="yp-template-group">
						<h3>سفارشی سازی الگو</h3>
						<ul>
						<?php

							$count = 0;

							// Post Types
							$post_types = get_post_types();

							// Using shop post type for WooCommerce shop page.
							array_push($post_types, "shop");

							foreach ($post_types as $post_type){

								if(get_option("wt_".$post_type."_css") != ''){

									$count++;
									$allCount++;

									if($post_type == "shop" && class_exists('WooCommerce')){

										$last_post_id = wc_get_page_id('shop');

										$link = get_the_permalink($last_post_id);

										$title = ucfirst($post_type).' page';

									}else{

										// get last post
										$last_post = wp_get_recent_posts(array("post_status" => "publish","numberposts" => 1, "post_type" => $post_type));

										// checks and get
										if(empty($last_post) == false){
											$last_post_id = $last_post['0']['ID'];
											$link = get_the_permalink($last_post_id);
										}

										// if no id, leave it empty and not show a edit link
										if(isset($last_post_id) == false){
											$last_post_id = 0;
											$link = null;
										}

										$title = ucfirst($post_type).' template';

									}

									yp_css_style_li($title, $link, 'template', $last_post_id, $post_type);
		
								}

							}

							// Search Template
							if(get_option("wt_search_css") != ''){

								$count++;
								$allCount++;

								yp_css_style_li("Search template", get_home_url().'/?s='.yp_getting_last_post_title(), 'template', 'search', 'search');
							
							}

							// Tag Template
							if(get_option("wt_tag_css") != ''){

								$count++;
								$allCount++;

								$tag_id = '';
								$tags = get_tags(array('orderby' => 'count', 'order' => 'DESC','number'=> 1 ));
								if(empty($tags) == false){
									$tag_id = $tags[0];
								}

								yp_css_style_li("Tag template", get_tag_link($tag_id), 'template', 'tag', 'tag');

							}

							// Category Template
							if(get_option("wt_category_css") != ''){

								$count++;
								$allCount++;

								$cat_id = '';
								$cats = get_categories(array('orderby' => 'count', 'order' => 'DESC','number'=> 1 ));
								if(empty($cats) == false){
									$cat_id = $cats[0];
								}

								yp_css_style_li("Category template", get_category_link($cat_id), 'template', 'category', 'category');

							}

							// Archive Template
							if(get_option("wt_archive_css") != ''){

								$count++;
								$allCount++;

								$latest_post = get_posts("post_type=post&numberposts=1");
								$latest_post_id = $latest_post[0]->ID;
								$last_post_date = get_the_date("Y",$latest_post_id);
								$archive_link = get_home_url()."/".$last_post_date;

								yp_css_style_li("Archive template", $archive_link, 'template', 'archive', 'archive');

							}
							
							// Author Template
							if(get_option("wt_author_css") != ''){

								$count++;
								$allCount++;

								yp_css_style_li("Author template", get_author_posts_url(1), 'template', 'author', 'author');

							}

							// 404 Template
							if(get_option("wt_404_css") != ''){

								$count++;
								$allCount++;

								yp_css_style_li("404 error template", get_home_url().'/?p=987654321', 'template', '404', '404');

							}

						?>
						</ul>
					</div>
					<?php
						if($count == 0){
							echo "<style>.yp-template-group{display:none;}</style>";
						}
					?>


					<div class="yp-single-group">
						<h3>Single Customizations</h3>
						<ul>
						<?php

						$count = 0;

						// Homepage
						if(get_option("wt_home_css") != ''){

							$count++;
							$allCount++;

							$frontpage_id = get_option('page_on_front');

							if($frontpage_id == 0 || $frontpage_id == null){
								yp_css_style_li("Non-Static Homepage", get_home_url().'/', 'template', 'home', 'home');
							}else{
								yp_css_style_li("Non-Static Homepage".'<small>(Inactive)</small>', get_home_url().'/', 'template', 'home', 'home');
							}

						}

						// login Template
						if(get_option("wt_login_css") != ''){

							$count++;
							$allCount++;

							yp_css_style_li("WordPress Login", wp_login_url(), 'template', 'login', 'login');

						}

						// register Template
						if(get_option("wt_register_css") != ''){

							$count++;
							$allCount++;

							yp_css_style_li("WordPress Register", wp_registration_url(), 'template', 'register', 'register');

						}

						// lost password Template
						if(get_option("wt_lostpassword_css") != ''){

							$count++;
							$allCount++;

							yp_css_style_li("WordPress Lost Password", wp_registration_url(), 'template', 'lostpassword', 'lostpassword');

						}

						// Unknown Customizations
						global $wpdb;
						$querystr = "SELECT * FROM `$wpdb->postmeta` WHERE `meta_key` LIKE '_wt_css'";
						$pageposts = $wpdb->get_results($querystr, OBJECT);

						if($pageposts):

							global $post;

							foreach ($pageposts as $post):

							$id = $post->post_id;
							$title = ucfirst(get_the_title($id));

							if($title == "''"){
								$title = '(Unknown)';
							}

							if(get_post_meta($id, '_wt_css', true) != ''){

								$count++;
								$allCount++;

								yp_css_style_li($title, get_the_permalink($id), 'single', $id, get_post_type($id));

							}

							endforeach;

						endif;

						wp_reset_query();

						?>
					</ul>
					</div>
					<?php
						if($count == 0){
							echo "<style>.yp-single-group{display:none;}</style>";
						}
					?>

					<!-- Shows download button -->
					<?php if($allCount > 0){ ?>
						<p><a href="<?php echo admin_url("admin.php?page=yellow-pencil-changes&yp_exportCSS=true"); ?>" class="button button-primary">دانلود فایل CSS</a> همه سبک ها آماده استفاده هستند.</p>
					<?php }else{echo "<style>.yp-tab-section{display:none;}.yp-no-code{display:block}</style>";} ?>

					</div>

					</div>

					<?php


				/* ---------------------------------------------------- */
				/* SETTINGS                 							*/
				/* ---------------------------------------------------- */
                } elseif( $active_tab == 'yellow-pencil-settings' )  {

                	?>

                	<div class="yp-tab-section">
روش چاپ CSS</h2>
					<p class="yp-heading-text">CSS خارجی هنوز در آزمایش بتا است، اگر یک مسئله وجود دارد، از CSS پویا استفاده کنید.</p>
					<form method="POST">
						<table class="form-table yp-form-table">
							<tbody>
							<tr>
								<?php

									$a = '';
									$b = '';
									if(get_option('yp-output-option') == 'external'){
										$a = 'checked="checked"';
									}

									if(get_option('yp-output-option') != 'external'){
										$b = 'checked="checked"';
									}

								?>
								<th><label><input name="yp-output-option" value="external" <?php echo $a; ?> type="radio" /> استاتیک خارجی CSS فایل</label></th>
								<td><code><?php echo get_site_url(null,'custom.css'); ?></code></td>
							</tr>
							<tr>
								<th><label><input name="yp-output-option" value="inline" <?php echo $b; ?> type="radio" /> CSS درون خطی پویا</label></th>
								<td><code>&lt;head&gt;&lt;style&gt;.body{color:gray...</code></td>
							</tr>
							</tbody>
						</table>

						<h2 style="padding-top:1em;">تنظیمات</h2>

						<table class="form-table yp-form-table">
							<tbody>
							<tr>
								<?php

									$a = '';
									if(get_option('yp-draft-mode') == '1'){
										$a = 'checked="checked"';
									}

								?>
								<th><input name="yp-draft-mode" value="0" <?php echo $a; ?> type="hidden" /><label><input name="yp-draft-mode" value="1" <?php echo $a; ?> type="checkbox" /> حالت پیش نویس</label></th>
								<td><code>فراموش نکنید که آن را هنگام آماده شدن غیرفعال کنید</code></td>
							</tr>
							</tbody>
						</table>

						<div class="yp-output-css-footer">
							<input type="submit" class="button-primary" value="Save Changes" />
							<a class="button yp-button-reset">تنظیمات مجدد</a>
						</div>
					</form>

					<!-- Virtual Post -->
					<form id="yp-reset-form" method="POST">
						<input type="hidden" value="1" name="yp_reset" />
					</form>

				</div>

                	<?php


                /* ---------------------------------------------------- */
				/* ANIMATIONS               							*/
				/* ---------------------------------------------------- */
                } elseif( $active_tab == 'yellow-pencil-animations' )  {

                    ?>

                    <div class="yp-no-animation">
	                	<img src="<?php echo WT_PLUGIN_URL; ?>images/pages.png">
	                    <p>هیچ انیمیشن تولیدی وجود ندارد. شما می توانید انیمیشن را با استفاده از انیمیشن ژنراتور در ویرایشگر ایجاد کنید.</a></p>
	                </div>

                    <div class="yp-tab-section">

	                    <div class="yp-global-group">

		                    <h2>مدیریت انیمیشن ها</h2>
		                    <p class="yp-heading-text">انیمیشن های تولید شده در زیر لیست شده اند، شما می توانید آنها را بررسی و حذف کنید.</p>

							<div class="yp-code-group">

								<ul>

									<?php

										$countAnim = 0;

										$all_options =  wp_load_alloptions();
										foreach($all_options as $name => $value){
											if(stristr($name, 'yp_anim')){
												$countAnim = $countAnim+1;
												$name = str_replace("yp_anim_", "", $name);
												$deleteData = "yp_anim_".$name;

												$value = stripslashes($value);

												$value = str_replace("{", "{\n\t", $value);
												$value = str_replace("}", "\n}\n", $value);
												$value = str_replace(";", ";\n\t", $value);
												$value = str_replace("\t\n}", "}", $value);

												?>
												<li data-delete-value="<?php echo $deleteData; ?>">

												<span class="yp-edited-page-title"><?php echo ucwords(strtolower($name)); ?></span>

												<a class="yp-delete-page-edits" title="Delete"></a>

												<a class="yp-show-css"></a>

												<span class="yp-clear"></span>

												</li>
												<div id="yp-inline-editor-<?php echo $name; ?>" class='yp-inline-css'><?php echo $value; ?></div>
												<?php
											}
										}

									?>

								</ul>

							</div>

						</div>

						<?php

							if(0 == $countAnim){
								echo '<style>.yp-global-group{display:none;}.yp-no-animation{display:block;}</style>';
							}

						?>

					</div>

                    <?php


                /* ---------------------------------------------------- */
				/* LICENSE               							    */
				/* ---------------------------------------------------- */
                } elseif( $active_tab == 'yellow-pencil-license' )  {

                	// Delete license key
                	if(isset($_GET["yp-disable-license"])){
                		delete_option('yp_purchase_code');
                	}

                	// If isset product license, ie activation success.
                	if(isset($_GET['purchase_code']) == true){

                		// Purchase Code
                		$code = sanitize_key($_GET['purchase_code']);

                		// Adds Product code
                		if(!update_option("yp_purchase_code",$code)){
							add_option("yp_purchase_code",$code);
						}

                	}elseif(defined('WTFV') == false){

                		// Get purchase code from database
                		$purchase_code = get_option("yp_purchase_code");

                		// Has?
                		if($purchase_code){
                			delete_option('yp_purchase_code');
                		}

                	}

                	// Get purchase code from database
                	$purchase_code = get_option("yp_purchase_code");

                	$isActive = false;

                	// Button Text
                	if(isset($_GET['purchase_code']) || $purchase_code){

                		$isActive = true;
                		$activate_btn = "YellowPencil Activated";
                		$aclink = '<a class="button button-primary button-hero yp-product-activation disabled">';
                		$disableLink = '<div><a class="yp-disable-license" href="'.admin_url('admin.php?page=yellow-pencil-license&yp-disable-license=true').'">Disable License!</a></div>';

                	}else{
                		$activate_btn = "Activate YellowPencil Pro";
                		$aclink = '<a class="button button-primary button-hero yp-product-activation" href="https://waspthemes.com/yellow-pencil/auto-update/?client-redirect='.urlencode(admin_url('admin.php?page=yellow-pencil-license')).'">';
                		$disableLink = '';
                	}

                	// Thank you.
                	if(isset($_GET['purchase_code'])){
                		echo '<div class="updated"><p><strong>YellowPencil Pro successfully activated.</strong></p></div>';
                	}

                	// no license founded
                	if(isset($_GET['activation_error'])){
                		echo '<div class="error"><p><strong>No licenses found on your Envato account, <a href="https://waspthemes.com/yellow-pencil/buy/" target="_blank">Get your copy today</a>.</strong></p></div>';
                	}

                	?>

                	<div class="yp-activation-section <?php if(defined('WTFV') == false && $isActive == false){ echo 'yp-go-pro'; } ?>">

                		<?php if($isActive == false){ ?>

                			<?php if(defined('WTFV')){ ?>

                				<h2>کپی خود را فعال کنید!</h2>
	                			<p>شما نیازی به خرید مجوز ندارید و می توانید بروزرسانی ها را از تم فارس دریافت کنید <strong>ویژگی های حق بیمه</strong> و <strong>به روز رسانی مستقیم پلاگین </strong>.</p>

	                		<?php }else{ ?>

	                			<h1>Unlock Premium Features!</h1>
	                			<p>آیا مایل به دسترسی به تمام ویژگی های حق بیمه هستید؟ <strong>خانواده فونت</strong>, <strong>تصویر زمینه</strong>, <strong>انیمیشن</strong> و خیلی بیشتر. برو امروز طرفدار اول، مجوز خرید و سپس آن را فعال کنید.</strong></p>

	                		<?php } ?>

	                	<?php }else{ ?>
	                		<?php if(defined('YP_PRO_DIRECTORY')){ ?>
	                			<h2>به باشگاه طرفدار خوش آمدید!</h2>
	                			<p>شما نسخه مداد زرد را فعال کرده اید که به شما امکان دسترسی به تمام مزایای مشتری را می دهد! هنگامی که بهروزرسانیهای جدید در دسترس هستند مطلع خواهید شد. با تشکر از شما برای انتخاب مداد زرد!</p>
	                			<?php }else{ ?> 
	                			<h2>به باشگاه طرفدار خوش آمدید!</h2>
	                			<p>شما نسخه YellowPencil Pro را فعال کرده اید که به شما امکان دسترسی به تمامی ویژگی ها را می دهد! <strong>فونت فمیلی</strong>, <strong>تصویر زمینه</strong>, و سایر ویژگی های دیگر هم اکنون در دسترس هستند. با تشکر از شما برای انتخاب مداد زرد!</p>
	                		<?php } ?>
	                	<?php } ?>
	                	
	                	<br />

	                    <p style="margin:0px;padding:0px;">

	                    	<?php if(defined('WTFV') == false && $isActive == false){ ?>
	                    	<a target="_blank" class="button button-hero" href="https://waspthemes.com/yellow-pencil/buy/" style="margin-right:20px;position:relative;top:1px;">خرید مجوز</a>
	                    	<?php } ?>

	                    	<?php echo $aclink; ?><?php echo $activate_btn; ?></a>

	                    	<?php echo $disableLink; ?>

	                    </p>

	                    <?php if($isActive == false){ ?>

	                    		<?php if(defined('WTFV')){ ?>
		                    		<p class='description'>هنوز مجوز ندارید؟ <a href='https://waspthemes.com/yellow-pencil/buy/' target='_blank'>مجوز خریداری کنید</a>!</p>
		                    	<?php }else{ ?>
		                    		<p class='description'>تسویه حساب <a href='https://waspthemes.com/yellow-pencil/' target='_blank'>افزونه وب سایت</a> برای اطلاعات بیشتر.</p>
		                    	<?php } ?>

						<?php }else{ ?>

							<p class='description'>نسخه حرفه ای مداد زرد فعال شده است. <a href='<?php echo admin_url('admin.php?page=yp-welcome-screen'); ?>'>Let's Start!</a></p>

						<?php } ?>

					</div>

					<?php


				/* ---------------------------------------------------- */
				/* EXPORT/IMPORT               							*/
				/* ---------------------------------------------------- */
                } elseif( $active_tab == 'yellow-pencil-export' )  {

                    ?>

                    <div class="yp-tab-section">
	                    <h2>برون ریزی پروژه</h2>
						<p class="yp-heading-text">کپی آنچه به نظر می رسد یک رشته تصادفی از کاراکترهای عددی آلفا در منطقه متن زیر است<br />و وارد بخش فیلد در وب سایت دیگری شوید.</p>
						<div class="yp-export-section">
							<textarea rows="6" class="yp-admin-textarea"><?php echo yp_get_export_data(); ?></textarea>
						</div>

						<hr style="margin-top: 50px;margin-bottom: 25px;">

						<h2>درون ریزی پروژه</h2>
						<p class="yp-heading-text">اطلاعات صادر شده را وارد کنید و دکمه "درون ریزی داده " را کلیک کنید.</p>
						<form method="POST">
							<div class="yp-import-section">
								<textarea name="yp_json_import_data" rows="6" class="yp-admin-textarea"></textarea>
							</div>
							<input type="submit" class="button" value="Import Data" />
						</form>
					</div>

                    <?php

                }

            ?>

        </div>

    <?php

}